      SUBROUTINE QUEUE_PLOT(QUEUE,FILE,OPTION,ISTAT1,ISTAT2)
C======================================================================C
C                                                                      C
C  QUEUE_PLOT                                      F.W. Jones, TRIUMF  C
C                                                                      C
C  Queues a plot file (e.g. Printronix, Zeta, HP) for printing on      C
C  the designated queue.  The file is deleted after printing.          C
C  If the job is successfully submitted to the queue, a status         C
C  message for the job will be displayed.  If the job is not           C
C  successfully submitted, an error diagnostic message will be         C
C  displayed.                                                          C
C                                                                      C
C  Plot files are printed with the following qualifiers:               C
C                                                                      C
C    /NOFEED     /DELETE                                               C
C                                                                      C
C                                                                      C
C  Modified Jan 20/86 by F. Jones:                                     C
C    Parameters ISTAT1 and ISTAT2 added, to return the Job Controller  C
C    and IO status codes, so that the caller can check for an error    C
C    condition.  If an error occurred, at least one of ISTAT1 and      C
C    ISTAT2 will be .FALSE..  ISTAT1 and ISTAT2 are optional           C
C    arguments.                                                        C
C                                                                      C
C  Modified Jan 23/86 by F. Jones:                                     C
C    Additional argument OPTION added to specify an additional print   C
C    option, if required.  The option PASSALL is now required          C
C    (VMS 4.2) for 8-bit plot files such as those for the HP Thinkjet  C
C    and HP Laserjet.  In VMS 4.1, PRINT/PASSALL did not work as       C
C    documented, but SET TERMINAL/PASTHRU worked.  In VMS 4.2,         C
C    SET TERMINAL/PASTHRU no longer works but PRINT/PASSALL works.     C
C    To enable, set OPTION='PASSALL'; otherwise set OPTION=' '.        C
C  Modified Oct 3/91 by J. Chuma:                                      C
C    Make only one call to NARGS()                                     C
C  Modified Oct 18/91 by F. Jones:                                     C
C    New option POSTSCRIPT added: generates PRINT/FORM=POST, for use   C
C    with Rick Watson's PS print symbiont from utadnx.cc.utexas.edu    C
C                                                                      C
C======================================================================C
      CHARACTER*(*) QUEUE,FILE,OPTION

      COMMON/PLOT_OUTPUT_UNIT/IOUTS

      INCLUDE '($SJCDEF)'
      INTEGER SYS$SNDJBCW
      INTEGER ITMLST(19)
      INTEGER*2 ITM1(2),ITM2(2),ITM3(2),ITM4(2),ITM5(2),ITM6(2)
      EQUIVALENCE(ITM1,ITMLST(1)),(ITM2,ITMLST(4)),
     #           (ITM3,ITMLST(7)),(ITM4,ITMLST(10)),
     #           (ITM5,ITMLST(13)),(ITM6,ITMLST(16))
      INTEGER IOSB(2)
      CHARACTER*80 MSG
      CHARACTER*80 STATUS_MSG

      NNARG = NARGS()
      MSG=' '
      STATUS_MSG=' '
      ITM1(1)=LEN(QUEUE)                   !ITMLST(1)
      ITM1(2)=SJC$_QUEUE                   !ITMLST(1)
      ITMLST(2)=%LOC(QUEUE)
      ITMLST(3)=0
      ITM2(1)=LEN(FILE)                    !ITMLST(4)
      ITM2(2)=SJC$_FILE_SPECIFICATION      !ITMLST(4)
      ITMLST(5)=%LOC(FILE)
      ITMLST(6)=0
      ITM3(1)=0                            !ITMLST(7)
      ITM3(2)=SJC$_NO_PAGINATE             !ITMLST(7)
      ITMLST(8)=0
      ITMLST(9)=0
      ITM4(1)=0                            !ITMLST(10)
      ITM4(2)=SJC$_DELETE_FILE             !ITMLST(10)
      ITMLST(11)=0
      ITMLST(12)=0
      ITM5(1)=80                           !ITMLST(13)
      ITM5(2)=SJC$_JOB_STATUS_OUTPUT       !ITMLST(13)
      ITMLST(14)=%LOC(STATUS_MSG)
      ITMLST(15)=%LOC(LSMSG)
      ITMLST(16)=0      !terminate item list

C Any option?
      IF(NNARG.LT.3)GO TO 100
      NC=LENSIG(OPTION)
      IF(NC.EQ.0)GO TO 100
      IF(OPTION(1:NC).EQ.'PASSALL')THEN
        ITM6(1)=0                          !ITMLST(16)
        ITM6(2)=SJC$_PASSALL               !ITMLST(16)
        ITMLST(17)=0
        ITMLST(18)=0
        ITMLST(19)=0      !terminate item list
      ELSE IF(OPTION(1:NC).EQ.'POSTSCRIPT')THEN
        ITM6(1)=4                         !ITMLST(16)
        ITM6(2)=SJC$_FORM_NAME             !ITMLST(16)
        ITMLST(17)=%LOC('POST')
        ITMLST(18)=0
        ITMLST(19)=0      !terminate item list
      ENDIF

100   IFUNC=SJC$_ENTER_FILE
      ISTAT=SYS$SNDJBCW(,%VAL(IFUNC),%VAL(0),ITMLST,IOSB,,)
      IF(NNARG.GT.3)ISTAT1=ISTAT      !return status codes...
      IF(NNARG.GT.4)ISTAT2=IOSB(1)    

      CALL TRANSPARENT_MODE(0)
      IF(.NOT.ISTAT)THEN
        WRITE(IOUTS,*)'***Error sending request to Job Controller.'
        IST=LIB$SYS_GETMSG(ISTAT,LMSG,MSG)
        WRITE(IOUTS,*)MSG(1:LMSG)
        MSG=' '
      ENDIF
      IF(.NOT.IOSB(1))THEN
        WRITE(IOUTS,*)'***Error submitting ',FILE,' to queue ',QUEUE
        IST=LIB$SYS_GETMSG(IOSB(1),LMSG,MSG)
        WRITE(IOUTS,*)MSG(1:LMSG)
      ENDIF
      WRITE(IOUTS,*)STATUS_MSG(1:LSMSG)

      RETURN
      END
