      SUBROUTINE WINDOW_CLIP(XP,YP,X,Y,XMIN,XMAX,YMIN,YMAX,
     *                       XDRAW,YDRAW,NDRAW)
C
C  reqd. KOSTL: routines - SEGMENTX
C
C=================================================================
C=================================================================
C==                                                             ==
C==   WINDOW_CLIP: clips the line segment (XP,YP)-->(X,Y), using==
C==        the plot window range:                               ==
C==        XMIN <= x <= XMAX; YMIN <= y <= YMAX.                ==
C==        If the line segment (XP,YP)-->(X,Y) is totally       ==
C==        outside the window then NDRAW is set to 0 and        ==
C==        XDRAW & YDRAW are undefined.                         ==
C==        If (XP,YP) & (X,Y) are both outside the window, but  ==
C==        the segment (XP,YP)-->(X,Y) crosses the window, then ==
C==        NDRAW is set to 2 and the clipped line segment inside==
C==        the window is given by:                              ==
C==        (XDRAW(1),YDRAW(1)-->(XDRAW(2),YDRAW(2)).            ==
C==        If (XP,YP) & (X,Y) are both inside the window, then  ==
C==        there is no clipping and NDRAW is set to 1 and       ==
C==        (XDRAW(1),YDRAW(1)) is set to (X,Y).                 ==
C==        If (XP,YP) is inside and (X,Y) is outside the window ==
C==        then NDRAW is set to 1 and the clipped line segment  ==
C==        inside the window is given by:                       ==
C==        (XP,YP)-->(XDRAW(1),YDRAW(1)).                       ==
C==        If (XP,YP) is outside and (X,Y) is inside the window ==
C==        then NDRAW is set to 2 and the clipped line segment  ==
C==        is given by:                                         ==
C==        (XDRAW(1),YDRAW(1))-->(XDRAW(2),YDRAW(2)), where     ==
C==        (XDRAW(2),YDRAW(2)) equals (X,Y).                    ==
C==                                                             ==
C==   Written by Arthur Haynes, TRIUMF U.B.C., July 6, 1981.    ==
C==                                                             ==
C==   Input  Parameters: XP,YP,X,Y,XMIN,XMAX,YMIN,YMAX (R*4)    ==
C==                                                             ==
C==   Output Parameters: XDRAW(2),YDRAW(2) (R*4); NDRAW (I*4).  ==
C==                                                             ==
C=================================================================
C=================================================================
      REAL*4 XDRAW(2),YDRAW(2),SDRAW(2),XC(4),YC(4),SC(4)
      LOGICAL SEGMENT_CROSS,LCROSS(4), XYOUT, XYPOUT
C
C   XYOUT, XYPOUT calculated differently than before
C   changed by JLC on June29/92 so small values of Y and YMIN, e.g.,
C   do not fail the test of being outside the box
C
      XMINL = MIN(XMIN,XMAX)
      XMAXL = MAX(XMIN,XMAX)
      YMINL = MIN(YMIN,YMAX)
      YMAXL = MAX(YMIN,YMAX)

      XYOUT  = (X .LT.XMINL).OR.(X .GT.XMAXL).OR.(Y .LT.YMINL).OR.
     & (Y .GT.YMAXL)
      XYPOUT = (XP.LT.XMINL).OR.(XP.GT.XMAXL).OR.(YP.LT.YMINL).OR.
     & (YP.GT.YMAXL)
      IF( XYOUT .OR. XYPOUT )GO TO 10

C=================================================================
C==   (X,Y) and (XP,YP) are in the plot window.                 ==
C==   Therefore there is no need for clipping.                  ==
C=================================================================
      NDRAW=1
      XDRAW(1)=X
      YDRAW(1)=Y
      RETURN

C=================================================================
C==   Determine which segments or sides of the window perimeter ==
C==   are crossed by the line segment (XP,YP)-->(X,Y).          ==
C==   LCROSS(I) = .TRUE. if the I'th segment is crossed.        ==
C==   (XC(I),YC(I)) is the point at which the I'th segment is   ==
C==                 crossed.                                    ==
C==   SC(I)         is the relative distance along the segment  ==
C==                 (XP,YP)-->(X,Y) at which the I'th window    ==
C==                 segment crosses it, i.e. the window segment ==
C==                 crosses the segment (XP,YP)-->(X,Y) at the  ==
C==                 point given by: (XC(I),YC(I)) =             ==
C==                 (XP,YP) + SC(I) * (X-XP,Y-YP).              ==
C=================================================================
10    NDRAW=0
C
C  Modified by JLC on June29/92  
C  simple and quick tests to see if both points are on same side of
C  box and outside
C
      IF( X.LT.XMINL .AND. XP.LT.XMINL )RETURN
      IF( Y.LT.YMINL .AND. YP.LT.YMINL )RETURN
      IF( X.GT.XMAXL .AND. XP.GT.XMAXL )RETURN
      IF( Y.GT.YMAXL .AND. YP.GT.YMAXL )RETURN
      LCROSS(1)=SEGMENT_CROSS(XP,YP,X,Y,XMIN,YMIN,XMAX,YMIN,
     *                        XC(1),YC(1),SC(1))
      LCROSS(2)=SEGMENT_CROSS(XP,YP,X,Y,XMAX,YMIN,XMAX,YMAX,
     *                        XC(2),YC(2),SC(2))
      LCROSS(3)=SEGMENT_CROSS(XP,YP,X,Y,XMAX,YMAX,XMIN,YMAX,
     *                        XC(3),YC(3),SC(3))
      LCROSS(4)=SEGMENT_CROSS(XP,YP,X,Y,XMIN,YMAX,XMIN,YMIN,
     *                        XC(4),YC(4),SC(4))
C=================================================================
C==   Store the crossing points in XDRAW and YDRAW.             ==
C=================================================================
      DENOM=ABS(XMAX-XMIN)+ABS(YMAX-YMIN)
      IF(DENOM.EQ.0.)DENOM=1.
      DISTANCE_RATIO=(ABS(X-XP)+ABS(Y-YP))/DENOM
      DO 200 I=1,4
      IF(.NOT.LCROSS(I))GO TO 200
      IF(NDRAW.EQ.0)GO TO 100
      IF(ABS(SDRAW(NDRAW)-SC(I))*DISTANCE_RATIO .LE. 0.0001)GO TO 200
100   NDRAW=NDRAW+1
      XDRAW(NDRAW)=XC(I)
      YDRAW(NDRAW)=YC(I)
      SDRAW(NDRAW)=SC(I)
      IF(NDRAW.EQ.2)GO TO 400
200   CONTINUE
C=================================================================
C==   NDRAW = 0 implies that the line segment (XP,YP)-->(X,Y) is==
C==   totally outside the plot window.                          ==
C=================================================================
      IF(NDRAW.EQ.0)RETURN
      IF(NDRAW.EQ.2)GO TO 400
C=================================================================
C==   NDRAW = 1 implies only one crossing of the line segment.  ==
C=================================================================
      IF(XYOUT.AND.XYPOUT)GO TO 310
C=================================================================
C==   NDRAW = 1, and                                            ==
C==   one of (X,Y) or (XP,YP) is inside the plot window.        ==
C==   If (X,Y) is outside then (XP,YP) is inside; so return.    ==
C=================================================================
      IF(XYOUT)RETURN
C=================================================================
C==   NDRAW = 1, and                                            ==
C==   (X,Y) is inside and (XP,YP) is outside the plot window.   ==
C=================================================================
      NDRAW=2
      XDRAW(2)=X
      YDRAW(2)=Y
      RETURN
C=================================================================
C==   NDRAW = 1:                                                ==
C==   Both (X,Y) and (XP,YP) are outside the window.            ==
C==   Therefore since there is only one crossing point, it must ==
C==   be at a corner of the plot window.                        ==
C=================================================================
310   NDRAW=2
      XDRAW(2)=XDRAW(1)
      YDRAW(2)=YDRAW(1)
      SDRAW(2)=SDRAW(1)
      RETURN
C=================================================================
C==   NDRAW = 2:                                                ==
C==   There are 2 crossing points.                              ==
C=================================================================
400   IF(SDRAW(1).LE.SDRAW(2))GO TO 410
      XD1=XDRAW(1)
      YD1=YDRAW(1)
      XDRAW(1)=XDRAW(2)
      YDRAW(1)=YDRAW(2)
      XDRAW(2)=XD1
      YDRAW(2)=YD1
410   IF(XYPOUT)RETURN
      NDRAW=1
      XDRAW(1)=XDRAW(2)
      YDRAW(1)=YDRAW(2)
      RETURN
      END      
