      SUBROUTINE WRITE_PLOT_POSTSCRIPT(LUNW,LUNP,*)
C======================================================================C
C                                                                      C
C  WRITE_PLOT_POSTSCRIPT                           F.W. Jones, TRIUMF  C
C                                                                      C
C  Makes a PostScript plot file on unit LUNP from a work file          C
C  on unit LUNW.                                                       C
C  Both units are assumed to be correctly opened by the caller.        C
C                                                                      C
C  Modified 29-Aug-91 by FWJ: plot file is no longer closed by this    C
C  routine, allowing multiple plots to be accumulated.                 C
C  Line cap and join changed to round, otherwise dots (degenerate      C
C  path) don't plot on the printer, although they may appear in        C
C  previewers.                                                         C
C                                                                      C
C  Modified 08-OCT-91 by FWJ:                                          C
C    (1) BoundingBox calculation added, to improve compliance with     C
C        Adobe structuring conventions.                                C
C    (2) Plotting of dots is now done with a macro that uses relative  C
C        coordinates, thus reducing the volume of data.                C
C    (3) The number of points in the current path is now limited       C
C        to 500, to avoid limitchecks on some printers.                C
C  Modified 18-NOV-91 by FWJ:                                          C
C    Support for rgb colour added.                                     C
C  Modified 21-JUN-94 by FWJ:                                          C
C    Minor changes to support efficiency improvements in               C
C    POSTSCRIPT_PLOT.F.                                                C
C  Modified 14-MAR-95 by FWJ:                                          C
C    Mapping of colour to grey scale added for PHYSICA.                C
C  Modified 09-MAY-95 by FWJ:                                          C
C    Added HP Designjet 650C PageSize directives to C-E size plots,    C
C    to reduce paper wastage.                                          C
C                                                                      C
C======================================================================C
      COMMON/POSTSCRIPTPLOT/LUNPS,NEW,IXLL,IYLL,IXUR,IYUR,NPATH,IOFF
      LOGICAL NEW  ! modified by J.Chuma, 19Mar97 for g77
      COMMON/POSTSCRIPTCOLOUR/ PSCOLOUR
      LOGICAL PSCOLOUR /.FALSE./
      COMMON/POSTSCRIPTGREY/ PSGREY
      LOGICAL PSGREY /.FALSE./
      COMMON/WRITEBITMAPHPPAINT/TRANSPARENCY
      LOGICAL TRANSPARENCY
      COMMON/PLOTTER_SIZE/PLTR_SIZE
      INTEGER PLTR_SIZE

      CHARACTER*90 BUFF

      REWIND(UNIT=LUNW,ERR=998)

1000  FORMAT(A)
1001  FORMAT(A,4I5)

      WRITE(LUNP,1000,ERR=999)'%!PS-Adobe-2.0 EPSF-2.0'
      WRITE(LUNP,1001,ERR=999)'%%BoundingBox: ',
     &  NINT(0.24*IXLL),NINT(0.24*IYLL),NINT(0.24*IXUR),NINT(0.24*IYUR)
      WRITE(LUNP,1000,ERR=999)'%%Creator: TRIUMF Graphics'
      WRITE(LUNP,1000,ERR=999)'%%EndComments'

C Set page size for HP Designjet
      IF(IOFF.EQ.6600)THEN      !C size 17x22
        WRITE(LUNP,1000,ERR=999)'%%BeginFeature: *PageRegion ISOC'
        WRITE(LUNP,1000,ERR=999)
     &    '<</PageSize [1224 1584] /ImagingBox null>> setpagedevice'
        WRITE(LUNP,1000,ERR=999)'%%EndFeature'
      ELSE IF(IOFF.EQ.10200)THEN      !D size 22x34
        WRITE(LUNP,1000,ERR=999)'%%BeginFeature: *PageRegion ISOD'
        WRITE(LUNP,1000,ERR=999)
     &    '<</PageSize [1584 2448] /ImagingBox null>> setpagedevice'
        WRITE(LUNP,1000,ERR=999)'%%EndFeature'
      ELSE IF(IOFF.EQ.13200)THEN      !E size 34x44
        WRITE(LUNP,1000,ERR=999)'%%BeginFeature: *PageRegion ISOE'
        WRITE(LUNP,1000,ERR=999)
     &    '<</PageSize [2448 3168] /ImagingBox null>> setpagedevice'
        WRITE(LUNP,1000,ERR=999)'%%EndFeature'
      ENDIF

      WRITE(LUNP,1000,ERR=999)'/saveobj save def'

C Define PostScript operators
      WRITE(LUNP,1000,ERR=999)'/s {stroke} bind def'
      WRITE(LUNP,1000,ERR=999)'/m {moveto} bind def'
      WRITE(LUNP,1000,ERR=999)'/l {lineto} bind def'
      WRITE(LUNP,1000,ERR=999)'/d {moveto 0 0 rlineto} bind def'
      IF( PSGREY )THEN
        WRITE(LUNP,1000,ERR=999)'/c00 {1 1 1 setrgbcolor} bind def'
       WRITE(LUNP,1000,ERR=999)'/c01 {.28 .28 .28 setrgbcolor} bind def'
       WRITE(LUNP,1000,ERR=999)'/c02 {.84 .84 .84 setrgbcolor} bind def'
       WRITE(LUNP,1000,ERR=999)'/c03 {.14 .14 .14 setrgbcolor} bind def'
       WRITE(LUNP,1000,ERR=999)'/c04 {.56 .56 .56 setrgbcolor} bind def'
       WRITE(LUNP,1000,ERR=999)'/c05 {.42 .42 .42 setrgbcolor} bind def'
       WRITE(LUNP,1000,ERR=999)'/c06 {.70 .70 .70 setrgbcolor} bind def'
        WRITE(LUNP,1000,ERR=999)'/c07 {0 0 0 setrgbcolor} bind def'
        WRITE(LUNP,1000,ERR=999)'/c08 {0 0 0 setrgbcolor} bind def'
        WRITE(LUNP,1000,ERR=999)'/c09 {0 0 0 setrgbcolor} bind def'
        WRITE(LUNP,1000,ERR=999)'/c10 {0 0 0 setrgbcolor} bind def'
        WRITE(LUNP,1000,ERR=999)'/c11 {0 0 0 setrgbcolor} bind def'
      ELSE IF( PSCOLOUR )THEN
        WRITE(LUNP,1000,ERR=999)'/c00 {1 1 1 setrgbcolor} bind def'
        WRITE(LUNP,1000,ERR=999)'/c01 {1 0 0 setrgbcolor} bind def'
        WRITE(LUNP,1000,ERR=999)'/c02 {0 0 1 setrgbcolor} bind def'
        WRITE(LUNP,1000,ERR=999)'/c03 {1 0 1 setrgbcolor} bind def'
        WRITE(LUNP,1000,ERR=999)'/c04 {0 1 0 setrgbcolor} bind def'
        WRITE(LUNP,1000,ERR=999)'/c05 {1 1 0 setrgbcolor} bind def'
        WRITE(LUNP,1000,ERR=999)'/c06 {0 1 1 setrgbcolor} bind def'
        WRITE(LUNP,1000,ERR=999)'/c07 {0 0 0 setrgbcolor} bind def'
        WRITE(LUNP,1000,ERR=999)'/c08 {1 .5 0 setrgbcolor} bind def'
        WRITE(LUNP,1000,ERR=999)'/c09 {1 0 .5 setrgbcolor} bind def'
        WRITE(LUNP,1000,ERR=999)'/c10 {0 1 .5 setrgbcolor} bind def'
        WRITE(LUNP,1000,ERR=999)'/c11 {0 .5 1 setrgbcolor} bind def'
      END IF

C Set scale from PostScript units (1/72 inch) to Laserwriter dots
      WRITE(LUNP,1000,ERR=999)'0.24 0.24 scale'

C Round linecap
      WRITE(LUNP,1000,ERR=999)'1 setlinecap'
C Round line join
      WRITE(LUNP,1000,ERR=999)'1 setlinejoin'
C Transparency mode for IBM PS 4079
      IF(TRANSPARENCY)
     &  WRITE(LUNP,1000,ERR=999)'statusdict begin 5 setprintmethod end'
C B size paper select for IBM PS 4079
C Disabled: causes automatic scaling
C     IF(PLTR_SIZE.EQ.1)
C    &  WRITE(LUNP,1000,ERR=999)
C    &  'statusdict begin /11x17 true setpapersize end'

C End of prologue
      WRITE(LUNP,1000,ERR=999)'%%EndProlog'

C Copy workfile to plotfile:
20    READ(LUNW,2000,END=99,ERR=998)BUFF
2000  FORMAT(A)
      NC = LENSIG( BUFF )
CC      NC=MIN(NC,90)
      WRITE(LUNP,1000,ERR=999)BUFF(1:NC)
      GO TO 20

C Make sure the last path is finished and print the page
C The moveto ensures that the current point is defined
99    WRITE(LUNP,1000,ERR=999)'0 0 m s'
      WRITE(LUNP,1000,ERR=999)'saveobj restore'
      WRITE(LUNP,1000,ERR=999)'showpage'
      WRITE(LUNP,1000,ERR=999)'%%Trailer'

      RETURN

C Bad work file:
998   WRITE(*,*)'Error reading PostScript work file on unit',LUNW
      CALL PUT_FORMSG
      RETURN 1
C Error writing plot file:
999   WRITE(*,*)'Error writing PostScript plot file on unit',LUNP
      CALL PUT_FORMSG
      RETURN 1
      END
