#ifdef g77
      SUBROUTINE CALCULATOR
      WRITE(*,*)'*** Calculator not available under LINUX'
      RETURN
      END
#elif gfortran
      SUBROUTINE CALCULATOR
      WRITE(*,*)'*** Calculator not available under LINUX'
      RETURN
      END
#else
      SUBROUTINE CALCULATOR
      IMPLICIT REAL*8 (A-H,O-Z)
      BYTE EXPRES(132),ERROR(50,10),NAME(8),LINE(132)
      REAL*8 FUNCTN(78),VARIAB(100),OPERAT(28),RCODE(130)
      REAL*8 VALUE(100)
      INTEGER NARGUM(2,78),NINDEX(100),IPRIOR(2,28)
      INTEGER IERROR(2,10)
      INTEGER*2 ICODE(2,132)
      LOGICAL EQCMP
      BYTE BLANK/' '/,DOLLAR/'$'/
      DATA NEXP/132/,NFUN/78/,NVAR/0/,MCODE/132/
      DATA NOPER/28/,MRCODE/130/,MERROR/10/,MIVAR/0/
      DATA MVAR/100/,MNAME/8/
      CALL EXTABL2(FUNCTN,NARGUM,NFUN)
      CALL EXOPER2(OPERAT,IPRIOR,NOPER)
200   WRITE(6,300)
300   FORMAT('$','?')
      READ(5,305,ERR=200,END=2900)EXPRES
      CALL CONVERTLC_TO_UC(EXPRES,255)
305   FORMAT(132A1)
C
C  Check for blank expression. Return if so.
C
      DO 310 I=1,132
        IF(EXPRES(I).NE. ' ') GO TO 320
310   CONTINUE
      RETURN
320   CALL SETC(8,NAME,' ')
      CALL FINDST(EXPRES,132,'=',1,1,IFIND,*350)
      GO TO 400
350   NAME(1)=DOLLAR
      NNAME=1
      GO TO 500
400   NEXP=IFIND-1
      CALL VARNAM(EXPRES,NEXP,NAME,NNAME,MNAME,ISYNTX,IERR,*405)
      GO TO 500
405   WRITE(6,406)(BLANK,I=1,ISYNTX),DOLLAR
406   FORMAT(1X,A1,132A1)
      GO TO (410,420,430,440),IERR
410   WRITE(6,415)
415   FORMAT('0 ***Error*** No variable on left hand side of the "=".')
      GO TO 200
420   WRITE(6,425)
425   FORMAT('0 ***Error*** Invalid character in variable name.')
      GO TO 200
430   WRITE(6,435)
435   FORMAT('0 ***Error*** Variable must start with an alphabetic',
     *       ' character.')
      GO TO 200
440   WRITE(6,445)
445   FORMAT('0 ***Error*** Variable name is > 8 characters.')
      GO TO 200
500   NEXP=132-IFIND
      CALL EXEVAL2(EXPRES(IFIND+1),NEXP,FUNCTN,NARGUM,NFUN,VARIAB,
     1            NINDEX,NVAR,OPERAT,IPRIOR,NOPER,ICODE,MCODE,NCODE,
     2            RCODE,MRCODE,NRCODE,ERROR,IERROR,MERROR,NERROR,IVAR,
     3            MIVAR,NIVAR,*2100)
      CALL EXCALC2(NFUN,VALUE,NVAR,ICODE,NCODE,RCODE,
     1            NRCODE,CALC,*2200)
1200  IF(NVAR.EQ.0)GO TO 1400
      DO 1300 I=1,NVAR
      IF(EQCMP(8,NAME,VARIAB(I)))GO TO 1700
1300  CONTINUE
1400  IF(NVAR.LT.MVAR)GO TO 1600
      WRITE(6,1500)MVAR
1500  FORMAT('0 ***ERROR*** MAXIMUM NUMBER OF VARIABLES =',I4,
     1       ' HAS BEEN EXCEEDED')
      GO TO 200
1600  NVAR=NVAR+1
      INAME=NVAR
      CALL MOVEC(8,NAME,VARIAB(NVAR))
      GO TO 1800
1700  INAME=I
1800  VALUE(INAME)=CALC
      IF(IFIND.EQ.0)WRITE(6,1900)CALC
1900  FORMAT(1X,G25.16)
      GO TO 200
2100  CALL SETC(132,LINE,' ')
      DO 2102 I=1,NERROR
      LINE(IFIND+IERROR(2,I))=DOLLAR
2102  CONTINUE
      WRITE(6,2105)(LINE(I),I=1,78)
2105  FORMAT(2X,80A1)
      DO 2110 I=1,NERROR
      WRITE(6,2115)(ERROR(J,I),J=1,50)
2115  FORMAT('0 ***Error*** ',50A1)
2110  CONTINUE
      GO TO 200
2200  WRITE(6,2105)
      GO TO 200
2900  RETURN
      END
      SUBROUTINE VARNAM(EXPRES,NEXP,NAME,NNAME,MNAME,ISYNTX,IERROR,*)
      LOGICAL*1 EXPRES(1),NAME(1)
      EXTERNAL CLASS2
      INTEGER*2 STABLE(2,5)/101,-1,102,102,1,2,2,2,103,2/
      INTEGER*2 CTABLE(256)
      LOGICAL NFIRST/.FALSE./,EQUC,SECOND
      DATA IFIRST/1/,NSTATE/2/
      IF(NFIRST)GO TO 10
      NFIRST=.TRUE.
      CALL CTABL3(CTABLE)
10    CALL SCAN2(EXPRES,NEXP,IFIRST,ILAST,ISTATE,CLASS2,CTABLE,
     *          STABLE,NSTATE)
      IF(ISTATE.LT.0)GO TO 20
      IERROR=ISTATE-100
      ISYNTX=ILAST
      RETURN1
20    IERROR=0
      ISYNTX=0
      NNAME=0
      IF(NEXP.LE.0)RETURN
      SECOND=.FALSE.
      DO 30 I=1,NEXP
      IF(EQUC(EXPRES(I),' '))GO TO 30
      NNAME=NNAME+1
      IF(NNAME.GT.MNAME)GO TO 25
      NAME(NNAME)=EXPRES(I)
      GO TO 30
25    IF(SECOND)GO TO 30
      SECOND=.TRUE.
      IERROR=4
      ISYNTX=I
30    CONTINUE
      IF(IERROR.NE.0)RETURN1
      RETURN
      END
      SUBROUTINE CTABL3(CTABLE)
C================================================================
C================================================================
C==                                                            ==
C==   CTABL3: SETS UP THE INTEGER*2 CLASS TABLE "CTABLE(256)"  ==
C==          FOR THE VARIABLE SYNTAX CHECKER LEXICAL SCANNER   ==
C==          TRANSITION TABLE: "STABLE(2,5)".                  ==
C==          IF "CHAR" IS A CHARACTER (1 BYTE) THEN IT HAS A   ==
C==          NUMERIC VALUE "ICHAR" IN THE RANGE                ==
C==          0 <= "ICHAR" <= 255 AND ITS CLASS NUMBER IS GIVEN ==
C==          BY "CTABLE(ICHAR+1)".                             ==
C==                                                            ==
C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., AUGUST 19, 1981.==
C==                                                            ==
C==   INPUT  PARAMETERS: NONE.                                 ==
C==                                                            ==
C==   OUTPUT PARAMETERS: CTABLE(256) (I*2).                    ==
C==                                                            ==
C==   CTABLE: IS SET UP WITH THE FOLLOWING CLASS VALUES:       ==
C==                                                            ==
C==           CLASS   CHARACTERS                               ==
C==                                                            ==
C==             1     END-OF-LINE (ILAST > NINPUT)             ==
C==             2     INVALID CHARACTERS                       ==
C==             3     BLANK                                    ==
C==             4     A-Z,$,a-z,_                              ==
C==             5     0-9                                      ==
C==                                                            ==
C================================================================
C================================================================
      INTEGER*2 CTABLE(256)
      LOGICAL*1 LCHAR(4),ARRAY(27)
      INTEGER   ICHAR/0/
      EQUIVALENCE (LCHAR(1),ICHAR)
C================================================================
C==   INITIALIZE THE CTABLE ARRAY TO CLASS 2 WHICH CORRESPONDS ==
C==   TO OTHER CHARACTERS (INVALID CHARACTERS).                ==
C================================================================
      DO 10 I=1,256
      CTABLE(I)=2
10    CONTINUE
C================================================================
C==   CLASS 3: BLANK                                           ==
C================================================================
      CALL MOVEC(1,' ',LCHAR(1))
      CTABLE(ICHAR+1)=3
C================================================================
C==   CLASS 4: A-Z,$,a-z,_                             ==
C================================================================
      CALL MOVEC(27,'ABCDEFGHIJKLMNOPQRSTUVWXYZ$',ARRAY)
      DO 20 I=1,27
      LCHAR(1)=ARRAY(I)
      CTABLE(ICHAR+1)=4
20    CONTINUE
      CALL MOVEC(27,'abcdefghijklmnopqrstuvwxyz_',ARRAY)
      DO 30 I=1,27
      LCHAR(1)=ARRAY(I)
      CTABLE(ICHAR+1)=4
30    CONTINUE
C================================================================
C==   CLASS 5: 0-9                                             ==
C================================================================
      CALL MOVEC(10,'0123456789',ARRAY)
      DO 50 I=1,10
      LCHAR(1)=ARRAY(I)
      CTABLE(ICHAR+1)=5
50    CONTINUE
      RETURN
      END
      SUBROUTINE EXEVAL2(EXPRES,NEXP,FUNCTN,NARGUM,NFUN,VARIAB,
     * NINDEX,NVAR,OPERAT,IPRIOR,NOPER,ICODE,MCODE,NCODE,
     * RCODE,MRCODE,NRCODE,ERROR,IERROR,MERROR,NERROR,IVAR,
     * MIVAR,NIVAR,*)
C================================================================
C================================================================
C==   EXPRESSION EVALUATOR PACKAGE CONSISTS OF THE FOLLOWING   ==
C==   GENERAL SUBROUTINES: EXEVAL, SCAN, CLASS, CTABL        ; ==
C==   AND THE FOLLOWING SUBROUTINES SPECIFIC TO A STANDARD     ==
C==   MATHEMATICAL AND LOGICAL EXPRESSION CALCULATOR: EXCALC,  ==
C==   EXOPER, EXTABL.                                          ==
C==							       ==
C== reqd. KOSTL: routines - CHREAL,EQCMP,EQUC,FINDC,IGC,MOVEC,SETC ==
C================================================================
C================================================================
C==                                                            ==
C==   EXEVAL: IS AN EXPRESSION EVALUATOR, I.E. IT CONVERTS THE ==
C==   ARITHMETIC EXPRESSION "EXPRES" ("NEXP" CHARACTERS) INTO  ==
C==   AN INTEGERIZED CODE "ICODE" WHICH IS IN REVERSE POLISH   ==
C==   NOTATION.                                                ==
C==   THE EXPRESSION "EXPRES" CONSISTS OF FUNCTIONS, VARIABLES,==
C==   AND BINARY OR UNARY OPERATORS, WHICH ARE DEFINED IN THE  ==
C==   TABLES: "FUNCTN", "VARIAB", AND "OPERAT", RESPECTIVELY.  ==
C==   THE EXPRESSION ALSO CONSISTS OF NUMBERS, PARENTHESES, OR ==
C==   COMMAS. (NOTE: NUMBERS MAY HAVE EXPONENTS DENOTED BY "E" ==
C==   OR "D". PARENTHESES "([{" ARE TREATED AS EQUIVALENT AND  ==
C==   ")]}" ARE TREATED AS EQUIVALENT.)                        ==
C==   THE CODE "ICODE" CAN LATER BE USED BY THE CALLING PROGRAM==
C==   TO CALCULATE THE VALUE OF THE EXPRESSION WITH APPROPRIATE==
C==   VALUES SUBSTITUTED IN FOR THE VARIABLES IN THE EXPRESSION==
C==   (FOR EXAMPLE: SEE "EXCALC").                             ==
C==   "EXEVAL" ALSO HANDLES COMPLETE ERROR CHECKING OF THE     ==
C==   EXPRESSION AND ON AN ERROR IT RETURNS (RETURN1) WITH THE ==
C==   ERROR MESSAGES IN "ERROR".                               ==
C==                                                            ==
C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., JANUARY 3, 1980.==
C==                                                            ==
C==   INPUT  PARAMETERS: EXPRES(NEXP) (L*1); NEXP (I*4);       ==
C==   FUNCTN(NFUN) (R*8); NARGUM(2,NFUN), NFUN (I*4);          ==
C==   VARIAB(NVAR) (R*8); NINDEX(NVAR),NVAR (I*4);             ==
C==   OPERAT(NOPER) (R*8); IPRIOR(2,NOPER),                    ==
C==   NOPER,MCODE,MRCODE,MERROR,MIVAR (I*4).                   ==
C==                                                            ==
C==   OUTPUT PARAMETERS: ICODE(2,NCODE) (I*2); NCODE (I*4);    ==
C==   RCODE(NRCODE) (R*8); NRCODE (I*4); ERROR(50,NERROR) (L*1);=
C==   IERROR(2,NERROR),NERROR,IVAR(NIVAR),NIVAR (I*4).         ==
C==                                                            ==
C==   PARAMETER DEFINITIONS:                                   ==
C==   --------- -----------                                    ==
C==                                                            ==
C==   EXPRES: "NEXP" CHARACTERS WHICH MAKE UP THE ENTIRE       ==
C==           ARITHMETIC EXPRESSION TO BE EVALUATED.           ==
C==           NOTE: "EXPRES" MAY HAVE BLANKS ANYWHERE IN THE   ==
C==           EXPRESSION AND "EXPRES" IS NEVER CHANGED BY      ==
C==           "EXEVAL".                                        ==
C==                                                            ==
C==   NEXP  : NUMBER OF CHARACTERS IN "EXPRES".                ==
C==                                                            ==
C==   FUNCTN: TABLE OF "NFUN" 8-CHARACTER FUNCTION NAMES, WHICH==
C==           CAN APPEAR IN THE EXPRESSION. NOTE: FOR SETTING  ==
C==           UP A TABLE OF THE COMMON ARITHMETIC FUNCTION NAMES=
C==           SEE SUBROUTINE "EXTABL". THE FIRST CHARACTER IN  ==
C==           THE FUNCTION NAMES MUST BE ALPHABETIC            ==
C==           (A-Z,a-z,$,_) AND THE FOLLOWING CHARACTERS MUST  ==
C==           BE ALPHA-NUMERIC (A-Z,a-z,$,_,0-9).              ==
C==           THE FUNCTION NAMES MUST BE LEFT-JUSTIFIED IN THE ==
C==           REAL*8 WORDS WITH NO IMBEDDED BLANKS.            ==
C==                                                            ==
C==   NARGUM: "NARGUM(1,I)" & "NARGUM(2,I)" (I=1,NFUN) ARE THE ==
C==           LOWER & UPPER LIMITS ON THE NUMBER OF ARGUMENTS  ==
C==           THE FUNCTION "FUNCTN(I)" IS ALLOWED TO HAVE.     ==
C==           IN OTHER WORDS THE FUNCTION "FUNCTN(I)" IS ALLOWED=
C==           TO HAVE "NARG" ARGUMENTS WHERE                   ==
C==           "NARGUM(1,I)" <= NARG <= "NARGUM(2,I)".          ==
C==           NOTE: "NARGUM(1,I)" OR "NARGUM(2,I)" MAY ALSO BE ==
C==           ZERO.                                            ==
C==           IF THE NUMBER OF ARGUMENTS THAT THE FUNCTION HAS ==
C==           IN THE EXPRESSION DOESN'T AGREE WITH THE ABOVE   ==
C==           THEN AN ERROR MESSAGE IS RETURNED (RETURN1) IN   ==
C==           ERROR (NERROR.GT.0)                              ==
C==                                                            ==
C==   NFUN  : NUMBER OF FUNCTION NAMES WHICH ARE DEFINED IN THE==
C==           FUNCTION TABLE "FUNCTN" & THE ARRAY "NARGUM".    ==
C==                                                            ==
C==   VARIAB: TABLE OF "NVAR" 8-CHARACTER VARIABLE NAMES WHICH ==
C==           CAN APPEAR IN THE EXPRESSION. NOTE: THE FIRST    ==
C==           CHARACTER IN THE VARIABLE NAMES MUST BE ALPHABETIC=
C==           AND THE FOLLOWING CHARACTERS MUST BE ALPHA-      ==
C==           NUMERIC. VARIABLE NAMES CANNOT BE THE SAME AS    ==
C==           FUNCTION NAMES BECAUSE VARIABLES MAY HAVE INDICES==
C==           WHICH LOOK THE SAME AS FUNCTION ARGUMENTS.       ==
C==           THE VARIABLE NAMES MUST BE LEFT-JUSTIFIED IN THE ==
C==           REAL*8 WORDS WITH NO IMBEDDED BLANKS.            ==
C==                                                            ==
C==   NINDEX: IF "NINDEX(I)" (I=1,NVAR) IS => 0 THEN THE       ==
C==           VARIABLE "VARIAB(I)" MUST HAVE "NINDEX(I)" INDICES=
C==           TO BE VALID.                                     ==
C==           IF "NINDEX(I)" IS < 0 THEN THE VARIABLE          ==
C==           "VARIAB(I)" CAN HAVE EITHER "|NINDEX(I)|" OR 0   ==
C==           INDICES.                                         ==
C==           IF THE NUMBER OF INDICES THAT THE VARIABLE HAS IN==
C==           THE EXPRESSION DOESN'T AGREE WITH THE ABOVE THEN ==
C==           AN ERROR MESSAGE IS RETURNED (RETURN1) IN "ERROR"==
C==           (NERROR.GT.0).                                   ==
C==                                                            ==
C==   NVAR  : NUMBER OF VARIABLE NAMES WHICH ARE DEFINED IN THE==
C==           VARIABLE TABLE "VARIAB" & THE ARRAY "NINDEX".    ==
C==                                                            ==
C==   OPERAT: TABLE OF "NOPER" 8-CHARACTER OPERATOR NAMES WHICH==
C==           CAN APPEAR IN THE EXPRESSION.                    ==
C==           NOTE: THE OPERATOR NAMES MUST BE LEFT-JUSTIFIED  ==
C==           IN THE REAL*8 WORDS WITH NO IMBEDDED BLANKS.     ==
C==           OPERATOR NAMES CAN BE ANY SET OF CHARACTERS      ==
C==           (OTHER THAN QUOTES) DELIMITED BY QUOTES (' OR "),==
C==           OR THEY CAN BE A STRING COMPRISED OF THE FOLLOWING=
C==           OPERATOR CHARACTERS: !#%&*:=~^`@;|\<>?/+-        ==
C==           NOTE: FOR SETTING UP A TABLE OF THE STANDARD     ==
C==           MATHEMATICAL AND LOGICAL OPERATORS SEE SUBROUTINE==
C==           "EXOPER".                                        ==
C==                                                            ==
C==   IPRIOR: TABLE OF "NOPER"*2 OPERATOR PRIORITIES WHICH     ==
C==           GIVE THE PRECEDENCE OF THE OPERATOR, THE TYPE OF ==
C==           THE OPERATOR (UNARY OR BINARY), AND THE          ==
C==           ASSOCIATIVITY OF THE OPERATOR (LEFT OR RIGHT).   ==
C==           IF "IPRIOR(1,I)" IS NON-ZERO THEN THE OPERATOR   ==
C==           "OPERAT(I)" IS UNARY. IF "IPRIOR(2,I)" IS NON-   ==
C==           ZERO THEN THE OPERATOR "OPERAT(I)" IS BINARY. IF ==
C==           BOTH "IPRIOR(1,I)" & "IPRIOR(2,I)" ARE NON-ZERO  ==
C==           THEN THE TYPE OF THE OPERATOR "OPERAT(I)" IS     ==
C==           CHOSEN ACCORDING TO THE POSITION OF THE OPERATOR ==
C==           IN THE EXPRESSION FOR EACH OCCURANCE OF THE      ==
C==           OPERATOR.                                        ==
C==           THE MAGNITUDE OF "IPRIOR(K,I)" (K=1,2), IF NON-  ==
C==           ZERO, IS THE VALUE OF THE PRECEDENCE OF THE K'TH ==
C==           TYPE OF OPERATOR "OPERAT(I)" (WHERE THE 1'ST TYPE==
C==           IS UNARY AND THE 2'ND TYPE IS BINARY). OPERATORS ==
C==           AT THE SAME LEVEL WITHIN PARENTHESES ARE EVALUATED=
C==           IN ORDER OF THEIR PRECEDENCE; THE ONES WITH HIGHER=
C==           PRECEDENCE BEING EVALUATED FIRST.                ==
C==           IF "IPRIOR(K,I)" (K=1 OR 2) IS POSITIVE THEN THE ==
C==           UNARY (IF K=1) OR BINARY FORM (IF K=2) OF THE    ==
C==           OPERATOR "OPERAT(I)" IS LEFT-ASSOCIATIVE.        ==
C==           IF "IPRIOR(K,I)" (K=1 OR 2) IS NEGATIVE THEN THE ==
C==           UNARY (IF K=1) OR BINARY FORM (IF K=2) OF THE    ==
C==           OPERATOR "OPERAT(I)" IS RIGHT-ASSOCIATIVE.       ==
C==           IF A SEQUENCE OF CONSECUTIVE OPERATORS AT THE    ==
C==           SAME LEVEL WITHIN PARENTHESES HAVE THE SAME      ==
C==           PRECEDENCE AND ARE ALL LEFT (RIGHT) ASSOCIATIVE  ==
C==           THEN THEY ARE EVALUATED LEFT TO RIGHT (RIGHT TO  ==
C==           LEFT). EXAMPLE: MULTIPLICATION AND DIVISION:     ==
C==           "*" & "/" ARE USUALLY LEFT-ASSOCIATIVE AND AT THE==
C==           SAME PRECEDENCE, WHILE EXPONENTIATION "**" IS    ==
C==           USUALLY RIGHT-ASSOCIATIVE.                       ==
C==           NOTE: AN AMBIGUITY OCCURS IF 2 OPERATORS HAVE THE==
C==           SAME PRECEDENCE BUT OPPOSITE ASSOCIATIVITIES.    ==
C==           IN THIS CASE "EXEVAL" ALWAYS TREATS THE RIGHT-   ==
C==           ASSOCIATIVE OPERATOR AS HAVING A HIGHER PRECEDENCE=
C==           THEN THE LEFT-ASSOCIATIVE OPERATOR. EXAMPLE:     ==
C==           IF "+" IS LEFT-ASSOCIATIVE AND "-" IS RIGHT-     ==
C==           ASSOCIATIVE AND THEY ARE AT THE SAME PRECEDENCE  ==
C==           THEN THE EXPRESSION "A+B+C-D-E+F-E" IS EVALUATED ==
C==           AS FOLLOWS: "(((A+B)+(C-(D-E)))+(F-E))".         ==
C==                                                            ==
C==   NOPER : NUMBER OF OPERATOR NAMES WHICH ARE DEFINED IN THE==
C==           OPERATOR TABLE "OPERAT" AND THE ARRAY "IPRIOR".  ==
C==                                                            ==
C==   ICODE : ARRAY OF "NCODE"*2 INTEGER*2 CODES WHICH CORRE-  ==
C==           SPOND TO THE REVERSE POLISH FORM OF THE ARITHMETIC=
C==           EXPRESSION "EXPRES". THE CODES ARE AS FOLLOWS,   ==
C==           N=1,NCODE:                                       ==
C==                                                            ==
C==    ICODE(2,N)    ICODE(1,N)      DESCRIPTION               ==
C==                                                            ==
C== 1)    -I          TYPE K         OPERATER: OPERAT(I)       ==
C==     I=1,NOPER     K=1,2          K=1: UNARY, K=2: BINARY   ==
C==                                                            ==
C== 2)     I          NARG           FUNCTION: FUNCTN(I)       ==
C==     I=1,NFUN                     NARG=NUMBER OF ARGUMENTS  ==
C==                                                            ==
C== 3)   I+NFUN       NINDEX         VARIABLE: VARIAB(I)       ==
C==     I=1,NVAR                     NINDEX=NUMBER OF INDICES  ==
C==                                                            ==
C== 4) I+NFUN+NVAR     --            REAL*8 CONSTANT: RCODE(I) ==
C==    I=1,NRCODE                                              ==
C==                                                            ==
C==   MCODE : MAXIMUM NUMBER OF CODES ALLOWED IN "ICODE".      ==
C==           IF "MCODE" = "NEXP" THEN "ICODE" IS ALWAYS LARGE ==
C==           ENOUGH TO EVALUATE "EXPRES".                     ==
C==                                                            ==
C==   NCODE : NUMBER OF CODES RETURNED IN "ICODE". NCODE<=MCODE==
C==                                                            ==
C==   RCODE : ARRAY OF "NRCODE" REAL*8 CONSTANTS WHICH APPEAR  ==
C==           IN THE EXPRESSION. SEE DESCRIPTION TABLE 4) OF   ==
C==           "ICODE".                                         ==
C==                                                            ==
C==   MRCODE: MAXIMUM NUMBER OF REAL*8 CONSTANTS ALLOWED IN    ==
C==           "RCODE". IF "MRCODE" = "NEXP" THEN "RCODE" IS    ==
C==           ALWAYS LARGE ENOUGH TO EVALUATE "EXPRES".        ==
C==                                                            ==
C==   NRCODE: NUMBER OF REAL*8 CONSTANTS RETURNED IN "RCODE".  ==
C==           NRCODE <= MRCODE.                                ==
C==                                                            ==
C==   ERROR : ARRAY OF "NERROR" 50-CHARACTER ERROR MESSAGES.   ==
C==           "ERROR(J,I),J=1,50" IS THE I'TH ERROR MESSAGE.   ==
C==           ON AN ERROR A RETURN1 IS PERFORMED.              ==
C==                                                            ==
C==   IERROR: "IERROR(1,I)", I=1,NERROR IS THE ERROR NUMBER    ==
C==           CORRESPONDING TO THE ERROR MESSAGE IN            ==
C==           "ERROR(J,I)", J=1,50. (SEE BELOW UNDER "ERROR    ==
C==           MESSAGES"). "IERROR(2,I)" IS THE CHARACTER       ==
C==           POSITION IN THE EXPRESSION "EXPRES" AT WHICH THE ==
C==           ERROR OCCURED.                                   ==
C==           NOTE: "IERROR(2,I)",I=1,NERROR IS AN ARRAY WHICH ==
C==           IS ALWAYS IN INCREASING ORDER, SO THAT ONE CAN,  ==
C==           FOR EXAMPLE, WRITE OUT THE EXPRESSION AND PUT "$"==
C==           SIGNS UNDER EACH ERROR AT THE POSITIONS GIVEN BY ==
C==           "IERROR(2,I)",I=1,NERROR, AND THEN WRITE OUT THE ==
C==           ERROR MESSAGES "ERROR(J,I)",J=1,50,I=1,NERROR IN ==
C==           THE RIGHT ORDER UNDERNEATH.                      ==
C==                                                            ==
C==   MERROR: MAXIMUM NUMBER OF 50-CHARACTER ERROR MESSAGES    ==
C==           ALLOWED. IF THIS NUMBER IS EXCEEDED THEN "EXEVAL"==
C==           PERFORMS A "RETURN1" WITH "NERROR"="MERROR"      ==
C==           MESSAGES IN "ERROR".                             ==
C==                                                            ==
C==   NERROR: NUMBER OF ERROR MESSAGES IN "ERROR".             ==
C==                                                            ==
C==   IVAR  : ARRAY OF "NIVAR" INDICES SPECIFYING WHICH        ==
C==           VARIABLES IN THE VARIABLE TABLE "VARIAB" WERE    ==
C==           USED IN THE EXPRESSION. NO INDEX IN "IVAR" APPEARS=
C==           TWICE, I.E. THE VARIABLES SPECIFIED BY THE INDICES=
C==           IN "IVAR" ARE DISTINCT.                          ==
C==                                                            ==
C==   MIVAR : MAXIMUM NUMBER OF INDICES WHICH CAN BE STORED IN ==
C==           THE ARRAY "IVAR", I.E. THE MAXIMUM NUMBER OF     ==
C==           DISTINCT VARIABLES WHICH CAN APPEAR IN THE       ==
C==           EXPRESSION.                                      ==
C==           IF "MIVAR" <= 0 THEN "IVAR" & "NIVAR" ARE IGNORED.=
C==                                                            ==
C==   NIVAR : THE NUMBER OF INDICES RETURNED IN "IVAR".        ==
C==                                                            ==
C==   RETURN CODES:                                            ==
C==   ------ -----                                             ==
C==                                                            ==
C==   RETURN1: OCCURS IF ONE OR MORE ERRORS OCCUR IN THE       ==
C==            EXPRESSION "EXPRES". IN THIS CASE "NERROR" > 0. ==
C==                                                            ==
C==   ERROR MESSAGES:                                          ==
C==   ----- --------                                           ==
C==                                                            ==
C==   ERROR #     ERROR MESSAGE                                ==
C==                                                            ==
C==       1       INVALID CHARACTER                            ==
C==       2       NO CLOSING QUOTE ON OPERATOR                 ==
C==       3       INVALID DECIMAL POINT                        ==
C==       4       INVALID EXPONENT                             ==
C==       5       EXPRESSION TOO LARGE                         ==
C==               (THIS MESSAGE OCCURS WHEN THE "ICODE" ARRAY  ==
C==                IS NOT LARGE ENOUGH TO CONTAIN THE          ==
C==                EXPRESSION).                                ==
C==       6       NAME > 8 CHARACTERS                          ==
C==       7       "NAME" IS AN UNDEFINED FUNCTION              ==
C==               ("NAME" IS 8 CHARACTERS; THIS MESSAGE ONLY   ==
C==                OCCURS IF "NAME" IS FOLLOWED BY "(".)       ==
C==       8       "NAME" IS AN UNDEFINED VARIABLE              ==
C==               ("NAME" IS 8 CHARACTERS; THIS MESSAGE ONLY   ==
C==                OCCURS IF "NAME" IS NOT FOLLOWED BY "(".)   ==
C==       9       TOO MANY VARIABLES                           ==
C==               (THIS MESSAGE OCCURS WHEN THE "IVAR" ARRAY   ==
C==                IS NOT LARGE ENOUGH TO CONTAIN ALL OF THE   ==
C==                DISTINCT VARIABLES IN THE EXPRESSION).      ==
C==      10       INVALID REAL NUMBER                          ==
C==               (THIS ERROR MESSAGE SHOULD NEVER OCCUR).     ==
C==      11       TOO MANY CONSTANTS                           ==
C==               (THIS MESSAGE OCCURS WHEN THE "RCODE" ARRAY  ==
C==                IS NOT LARGE ENOUGH TO CONTAIN ALL OF THE   ==
C==                CONSTANTS IN THE EXPRESSION).               ==
C==      12       OPERATOR > 8 CHARACTERS                      ==
C==      13       UNDEFINED OPERATOR                           ==
C==      14       BLANK EXPRESSION                             ==
C==      15       ")" HAS NO LEADING "("                       ==
C==      16       "(" HAS NO FOLLOWING ")"                     ==
C==      17       OPERATOR STACK OVERFLOW                      ==
C==               (THIS MESSAGE OCCURS IF THE OPERATOR STACK   ==
C==                INTEGER*2 STACK(2,100) OVERFLOWS WHEN       ==
C==                CONVERTING ICODE INTO REVERSE POLISH; STACK ==
C==                CAN CONTAIN A MAXIMUM OF 100 OPERATORS)     ==
C==      18       INVALID COMMA                                ==
C==      19       FUNCTION HAS WRONG NUMBER OF ARGUMENTS       ==
C==      20       VARIABLE HAS WRONG NUMBER OF INDICES         ==
C==                                                            ==
C==   SEQUENCING ERROR MESSAGES:                               ==
C==   ---------- ----- --------                                ==
C==                                                            ==
C==   THE FOLLOWING ERROR MESSAGES RELATE TO THE SEQUENCING OF ==
C==   THE TERMS IN THE EXPRESSION WHERE THE TERMS ARE DEFINED  ==
C==   AS FOLLOWS:                                              ==
C==                                                            ==
C==   TERM 1:  FUNCTION                                        ==
C==   TERM 2:  VARIABLE                                        ==
C==   TERM 3:  CONSTANT                                        ==
C==   TERM 4:  ")", "]", OR "}"                                ==
C==   TERM 5:  "(", "[", OR "{"                                ==
C==   TERM 6:  ","                                             ==
C==   TERM 7:  NULL (WHICH REFERS TO THE BEGINNING OR END OF   ==
C==                  THE EXPRESSION)                           ==
C==   TERM 8:  UNARY  OPERATOR                                 ==
C==   TERM 9:  BINARY OPERATOR                                 ==
C==                                                            ==
C==   IF "TERM I" IS FOLLOWED BY "TERM J" IN THE EXPRESSION AND==
C==   THIS IS NOT ALLOWED, THEN AN ERROR MESSAGE IS RETURNED IN==
C==   ERROR WHICH LOOKS LIKE: "TERM I FOLLOWED BY TERM J", WITH==
C==   "TERM I" AND "TERM J" REPLACED BY THEIR NAMES ABOVE. THE ==
C==   ERROR NUMBER FOR THIS MESSAGE IS: 100+10*I+J.            ==
C==                                                            ==
C==   ERROR #     ERROR MESSAGE                                ==
C==                                                            ==
C==     113       FUNCTION FOLLOWED BY CONSTANT                ==
C==     118       FUNCTION FOLLOWED BY UNARY OPERATOR          ==
C==     123       VARIABLE FOLLOWED BY CONSTANT                ==
C==     128       VARIABLE FOLLOWED BY UNARY OPERATOR          ==
C==     131       CONSTANT FOLLOWED BY FUNCTION                ==
C==     132       CONSTANT FOLLOWED BY VARIABLE                ==
C==     133       CONSTANT FOLLOWED BY CONSTANT                ==
C==     135       CONSTANT FOLLOWED BY "("                     ==
C==     138       CONSTANT FOLLOWED BY UNARY OPERATOR          ==
C==     141       ")" FOLLOWED BY FUNCTION                     ==
C==     142       ")" FOLLOWED BY VARIABLE                     ==
C==     143       ")" FOLLOWED BY CONSTANT                     ==
C==     145       ")" FOLLOWED BY "("                          ==
C==     148       ")" FOLLOWED BY UNARY OPERATOR               ==
C==     154       "(" FOLLOWED BY ")"                          ==
C==     156       "(" FOLLOWED BY ","                          ==
C==     157       "(" FOLLOWED BY NULL                         ==
C==     159       "(" FOLLOWED BY BINARY OPERATOR              ==
C==     164       "," FOLLOWED BY ")"                          ==
C==     166       "," FOLLOWED BY ","                          ==
C==     167       "," FOLLOWED BY NULL                         ==
C==     169       "," FOLLOWED BY BINARY OPERATOR              ==
C==     174       NULL FOLLOWED BY ")"                         ==
C==     176       NULL FOLLOWED BY ","                         ==
C==     179       NULL FOLLOWED BY BINARY OPERATOR             ==
C==     184       UNARY OPERATOR FOLLOWED BY ")"               ==
C==     186       UNARY OPERATOR FOLLOWED BY ","               ==
C==     187       UNARY OPERATOR FOLLOWED BY NULL              ==
C==     188       UNARY OPERATOR FOLLOWED BY UNARY OPERATOR    ==
C==     189       UNARY OPERATOR FOLLOWED BY BINARY OPERATOR   ==
C==     194       BINARY OPERATOR FOLLOWED BY ")"              ==
C==     196       BINARY OPERATOR FOLLOWED BY ","              ==
C==     197       BINARY OPERATOR FOLLOWED BY NULL             ==
C==     198       BINARY OPERATOR FOLLOWED BY UNARY OPERATOR   ==
C==     199       BINARY OPERATOR FOLLOWED BY BINARY OPERATOR  ==
C==                                                            ==
C================================================================
C================================================================
      LOGICAL*1 EXPRES(1),ERROR(50,1)
      REAL*8 FUNCTN(1),VARIAB(1),OPERAT(1),RCODE(1)
      INTEGER NARGUM(2,1),NINDEX(1),IPRIOR(2,1),
     * IERROR(2,1),IVAR(1)
      INTEGER*2 ICODE(2,1),ISTACK(2,100)
      LOGICAL*1 TERM(15,9),NFIRST/.FALSE./,FUNC,NAME(8)
      LOGICAL*1 NFIRS/.FALSE./
      INTEGER LTERM(9)/8,8,8,3,3,3,4,14,15/
      LOGICAL EQUC,EQCMP
      REAL*8 REAL8
      EXTERNAL CLASS2
C================================================================
C==   LEXICAL SCANNER TRANSITION TABLE: STABLE(10,13).         ==
C==   THIS TABLE HAS 10 STATES AND 13 CLASSES OF CHARACTERS.   ==
C==   THE DESCRIPTION OF THE TABLE IS AS FOLLOWS:              ==
C==                                                            ==
C==                                 STATE #                    ==
C==             1    2    3    4    5    6    7    8    9   10 ==
C== CLASS                                                      ==
C== EOL        -7   -1 -102   -8   -3 -103   -3 -104 -104   -3 ==
C== OTHERS    101   -1    3   -8   -3 -103   -3 -104 -104   -3 ==
C== BLANK       1    2    3    4    5    6    7    8    9   10 ==
C== A-C,F-Z     2    2    3   -8   -3 -103   -3 -104 -104   -3 ==
C== E,D         2    2    3   -8    8 -103    8 -104 -104   -3 ==
C== 0-9         5    2    3   -8    5    7    7   10   10   10 ==
C== .           6   -1    3   -8    7 -103   -3 -104 -104   -3 ==
C== )]}        54   -1    3   -8   -3 -103   -3 -104 -104   -3 ==
C== ([{        55   -1    3   -8   -3 -103   -3 -104 -104   -3 ==
C== ,          56   -1    3   -8   -3 -103   -3 -104 -104   -3 ==
C== '"          3   -1   58   -8   -3 -103   -3 -104 -104   -3 ==
C== +-          4   -1    3    4   -3 -103   -3    9 -104   -3 ==
C== OP.CHARS    4   -1    3    4   -3 -103   -3 -104 -104   -3 ==
C==                                                            ==
C==   (OP.CHARS: OPERATOR CHARACTERS).                         ==
C==   (FOR A LEXICAL SCANNER FLOW CHART SEE TRMF:OPDATA NOTES).==
C==                                                            ==
C==   IF 1 <= "STABLE(ISTATE,ICLASS)" <= 10 THEN IT IS A       ==
C==   TRANSITION STATE.                                        ==
C==   IF "STABLE(ISTATE,ICLASS)" < 1 THEN IT IS AN OUTPUT STATE==
C==   AND THE SCAN POINTER IS TO BE SHIFTED BACK BY 1.         ==
C==   IF "STABLE(ISTATE,ICLASS)" > 10 THEN IT IS AN OUTPUT     ==
C==   STATE AND THE SCAN POINTER IS NOT TO BE CHANGED.         ==
C==                                                            ==
C==   OUTPUT STATES:                                           ==
C==                                                            ==
C==   STATE #    DESCRIPTION                                   ==
C==                                                            ==
C==      -1      VARIABLE OR FUNCTION NAME                     ==
C==      -3      CONSTANT NUMBER                               ==
C==      54      RIGHT PARENTHESIS ")"                         ==
C==      55      LEFT  PARENTHESIS "("                         ==
C==      56      COMMA ","                                     ==
C==      -7      END-OF-LINE (NULL)                            ==
C==      58      OPERATOR                                      ==
C==      -8      OPERATOR                                      ==
C==     101      INVALID CHARACTER                             ==
C==    -102      NO CLOSING QUOTE ON OPERATOR                  ==
C==    -103      INVALID DECIMAL POINT                         ==
C==    -104      INVALID EXPONENT                              ==
C==                                                            ==
C================================================================
      INTEGER*2 STABLE(10,13)/
     *  -7,  -1,-102,  -8,  -3,-103,  -3,-104,-104,  -3,
     * 101,  -1,   3,  -8,  -3,-103,  -3,-104,-104,  -3,
     *   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,
     *   2,   2,   3,  -8,  -3,-103,  -3,-104,-104,  -3,
     *   2,   2,   3,  -8,   8,-103,   8,-104,-104,  -3,
     *   5,   2,   3,  -8,   5,   7,   7,  10,  10,  10,
     *   6,  -1,   3,  -8,   7,-103,  -3,-104,-104,  -3,
     *  54,  -1,   3,  -8,  -3,-103,  -3,-104,-104,  -3,
     *  55,  -1,   3,  -8,  -3,-103,  -3,-104,-104,  -3,
     *  56,  -1,   3,  -8,  -3,-103,  -3,-104,-104,  -3,
     *   3,  -1,  58,  -8,  -3,-103,  -3,-104,-104,  -3,
     *   4,  -1,   3,   4,  -3,-103,  -3,   9,-104,  -3,
     *   4,  -1,   3,   4,  -3,-103,  -3,-104,-104,  -3/
      INTEGER*2 CTABLE(256)
C================================================================
C==   DEFINE NFUN2,NVAR2,NOPER2 TO BE => 0.                    ==
C================================================================
      NFUN2=MAX0(NFUN,0)
      NVAR2=MAX0(NVAR,0)
      NOPER2=MAX0(NOPER,0)
C================================================================
C==   INITIALIZE NCODE,NRCODE,NIVAR,NERROR.                    ==
C==   NIVAR IS ONLY INITIALIZED IF THERE ARE 24 PARAMETERS.    ==
C================================================================
      NCODE=0
      NRCODE=0
      NIVAR=0
      NERROR=0
      IF(NFIRS)GO TO 120
C================================================================
C==   FIRST TIME THROUGH SUBROUTINE "EXEVAL".                  ==
C==   CALL "CTABL2" WHICH INITIALIZES THE INTEGER*2 CLASS TABLE =
C==   "CTABLE(256)" WHICH IS USED BY THE EXPRESSION EVALUATOR  ==
C==   LEXICAL SCANNER TRANSITION TABLE "STABLE".               ==
C================================================================
      NFIRS=.TRUE.
      CALL CTABL2(CTABLE)
C================================================================
C==   LOOP FOR SCANNING THE EXPRESSION "EXPRES" FOR TERMS.     ==
C==   "SCAN" IS A SUBROUTINE WHICH PERFORMS A LEXICAL SCAN     ==
C==   USING THE TRANSITION TABLE "STABLE" DESCRIBED ABOVE.     ==
C==   "IFIRST" IS THE "FIRST" POINTER TO THE COLUMN IN "EXPRES"==
C==   AT WHICH THE SCAN IS TO BE STARTED.                      ==
C==   "ILAST" IS THE "LAST" POINTER TO THE COLUMN IN "EXPRES"  ==
C==   AT WHICH THE SCAN IS ENDED.                              ==
C==   "IFIRST" IS INPUT TO SCAN. "ILAST" IS RETURNED BY SCAN.  ==
C==   THE TERM FOUND RESIDES BETWEEN POINTERS "IFIRST" AND     ==
C==   "ILAST".                                                 ==
C==   "ISTATE" IS THE OUTPUT STATE RETURNED BY "SCAN" WHICH    ==
C==   DENOTES WHAT TYPE OF TERM RESIDES BETWEEN POINTERS       ==
C==   "IFIRST" AND "ILAST".                                    ==
C==   "CLASS2" IS THE NAME OF THE EXTERNAL SUBROUTINE WHICH    ==
C==   RETURNS THE CLASS CORRESPONDING TO EACH CHARACTER IN     ==
C==   "EXPRES".                                                ==
C================================================================
120   ILAST=0
1000  IFIRST=ILAST+1
      IF(IFIRST.GT.NEXP)GO TO 3000
      CALL SCAN2(EXPRES,NEXP,IFIRST,ILAST,ISTATE,CLASS2,CTABLE,
     #   STABLE,10)
C================================================================
C==   IF "ISTATE" = -7, I.E. ON AN END-OF-LINE, STOP SCANNING  ==
C==   AND GO TO 3000.                                          ==
C================================================================
      IF(ISTATE.EQ.-7)GO TO 3000
C================================================================
C==   ERROR 5: EXPRESSION TOO LARGE, "NCODE" => "MCODE".       ==
C================================================================
      IERR=5
      IF(NCODE.GE.MCODE)GO TO 2000
      NCODE=NCODE+1
C================================================================
C==   FIND THE FIRST NON-BLANK CHARACTER IN THE TERM FOUND     ==
C==   BETWEEN POINTERS "IFIRST" AND "ILAST" IN "EXPRES" AND SET==
C==   "IFIRST" TO THE COLUMN FOUND.                            ==
C==   SET "ICODE(1,NCODE)" TO "IFIRST". IF THERE IS AN ERROR   ==
C==   ASSOCIATED WITH THIS TERM THEN THIS POINTER WILL BE      ==
C==   RETURNED IN "IERROR(2,I)" TO POINT TO THE COLUMN AT WHICH==
C==   THE ERROR OCCURED.                                       ==
C================================================================
      CALL IGC(EXPRES,ILAST,' ',1,IFIRST,IFIND,*3000,*3000)
      IFIRST=IFIND
      ICODE(1,NCODE)=IFIRST
C================================================================
C==   SET ISTATE = |ISTATE|.                                   ==
C==   ERRORS 1,2,3,4 OCCUR IF ISTATE => 100.                   ==
C==   IF "ISTATE" => 100 THEN AN ERROR HAS OCCURED, I.E. THE   ==
C==   TERM FOUND IS INVALID. SET THE ERROR NUMBER "IERR" TO    ==
C==   ISTATE-100 AND GO TO 2000.                               ==
C==   IF ISTATE => 50 SET ISTATE = ISTATE-50.                  ==
C================================================================
      ISTATE=IABS(ISTATE)
      IF(ISTATE.GE.100)IERR=ISTATE-100
      IF(ISTATE.GE.100)GO TO 2000
      IF(ISTATE.GE.50)ISTATE=ISTATE-50
C================================================================
C==   "ISTATE" IS A VALID OUTPUT STATE. "ISTATE" CORRESPONDS   ==
C==   TO THE TERM NUMBER 1,2,3,4,5,6,7,8, OR 9, DEFINED ABOVE  ==
C==   UNDER "SEQUENCING ERROR MESSAGES".                       ==
C================================================================
      GO TO (1100,1100,1300,1400,1500,1600,3000,1800),ISTATE
C================================================================
C==   TERM 1 OR 2: FUNCTION OR VARIABLE NAME.                  ==
C==   EXTRACT THE "NAME" FROM BETWEEN POINTERS "IFIRST" AND    ==
C==   "ILAST", GETTING RID OF BLANKS.                          ==
C================================================================
1100  NNAME=0
      CALL SETC(8,NAME,' ')
C================================================================
C==   ERROR 6: NAME > 8 CHARACTERS.                            ==
C================================================================
      IERR=6
      DO 1110 I=IFIRST,ILAST
      IF(EQUC(EXPRES(I),' '))GO TO 1110
      IF(NNAME.EQ.8)GO TO 2000
      NNAME=NNAME+1
      NAME(NNAME)=EXPRES(I)
1110  CONTINUE
C================================================================
C==   FIND WHERE THE "NAME" IS, IN THE FUNCTION AND VARIABLE   ==
C==   TABLES: "FUNCTN" AND "VARIAB".                           ==
C================================================================
      ISHIFT=0
      IF(NFUN2.LE.0)GO TO 1130
      FUNC=.TRUE.
      DO 1120 I=1,NFUN2
      IF(EQCMP(8,FUNCTN(I),NAME))GO TO 1160
1120  CONTINUE
1130  ISHIFT=NFUN2
      FUNC=.FALSE.
      IF(NVAR2.LE.0)GO TO 1150
      DO 1140 I=1,NVAR2
      IF(EQCMP(8,VARIAB(I),NAME))GO TO 1160
1140  CONTINUE
C================================================================
C==   ERROR 7: "NAME" IS AN UNDEFINED FUNCTION OF VARIABLE.    ==
C================================================================
1150  IERR=7
      GO TO 2000
C================================================================
C==   STORE THE FUNCTION OR VARIABLE CODE: "I+ISHIFT" IN       ==
C==   "ICODE(2,NCODE)".                                        ==
C==   IF "NAME" IS A FUNCTION, OR "MIVAR" <= 0 THEN GO TO 1000,==
C==   THE BEGINNING OF THE SCAN LOOP.                          ==
C================================================================
1160  ICODE(2,NCODE)=I+ISHIFT
      IF(FUNC)GO TO 1000
      IF(MIVAR.LE.0)GO TO 1000
C================================================================
C==   "NAME" IS A VARIABLE. STORE THE VARIABLE INDEX "I" IN    ==
C==   "IVAR".                                                  ==
C==   CHECK TO SEE IF THE VARIABLE "NAME" IS ALREADY STORED IN ==
C==   VARIABLE INDEX ARRAY "IVAR". IF IT IS GO TO 1000.        ==
C================================================================
      IF(NIVAR.LE.0)GO TO 1180
      DO 1170 J=1,NIVAR
      IF(IVAR(J).EQ.I)GO TO 1000
1170  CONTINUE
C================================================================
C==   ERROR 9: TOO MANY VARIABLES, "NIVAR" => "MIVAR".         ==
C================================================================
1180  IERR=9
      IF(NIVAR.GE.MIVAR)GO TO 2000
C================================================================
C==   STORE THE VARIABLE INDEX "I" IN "IVAR".                  ==
C================================================================
      NIVAR=NIVAR+1
      IVAR(NIVAR)=I
      GO TO 1000
C================================================================
C==   TERM 3: CONSTANT NUMBER.                                 ==
C==   ERROR 10: INVALID REAL NUMBER. THIS ERROR SHOULD NEVER   ==
C==             OCCUR ASSUMING THE LEXICAL SCANNER "SCAN" IS   ==
C==             WORKING PROPERLY.                              ==
C==   CONVERT THE CHARACTER STRING NUMBER BETWEEN POINTERS     ==
C==   "IFIRST" AND "ILAST" IN "EXPRES" TO A REAL*8 NUMBER      ==
C==   "REAL8".                                                 ==
C================================================================
1300  IERR=10
      CALL CHREAL(EXPRES(IFIRST),ILAST-IFIRST+1,REAL8,2,*2000)
C================================================================
C==   ERROR 11: TOO MANY CONSTANTS, "NRCODE" => "MRCODE".      ==
C==   STORE THE NUMBER "REAL8" IN "RCODE(NRCODE)" AND STORE    ==
C==   CONSTANT CODE "NFUN2+NVAR2+NRCODE" IN "ICODE(2,NCODE)".  ==
C================================================================
      IERR=11
      IF(NRCODE.GE.MRCODE)GO TO 2000
      NRCODE=NRCODE+1
      RCODE(NRCODE)=REAL8
      ICODE(2,NCODE)=NFUN2+NVAR2+NRCODE
      GO TO 1000
C================================================================
C==   TERM 4: ")","}", OR "]".                                 ==
C==   STORE THE RIGHT PARENTHESIS CODE "-NOPER2-4" IN          ==
C==   "ICODE(2,NCODE)".                                        ==
C================================================================
1400  ICODE(2,NCODE)=-NOPER2-4
      GO TO 1000
C================================================================
C==   TERM 5: "(","{", OR "[".                                 ==
C==   STORE THE LEFT PARENTHESIS CODE "-NOPER2-5" IN           ==
C==   "ICODE(2,NCODE)".                                        ==
C================================================================
1500  ICODE(2,NCODE)=-NOPER2-5
      GO TO 1000
C================================================================
C==   TERM 6: ",".                                             ==
C==   STORE THE COMMA CODE "-NOPER2-6" IN "ICODE(2,NCODE)".    ==
C================================================================
1600  ICODE(2,NCODE)=-NOPER2-6
      GO TO 1000
C================================================================
C==   TERM 8 OR 9: UNARY OR BINARY OPERATOR NAME.              ==
C==   EXTRACT THE "NAME" FROM BETWEEN POINTERS "IFIRST" AND    ==
C==   "ILAST", GETTING RID OF BLANKS.                          ==
C================================================================
1800  NNAME=0
      CALL SETC(8,NAME,' ')
C================================================================
C==   ERROR 12: OPERATOR > 8 CHARACTERS.                       ==
C================================================================
      IERR=12
      DO 1810 I=IFIRST,ILAST
      IF(EQUC(EXPRES(I),' '))GO TO 1810
      IF(NNAME.EQ.8)GO TO 2000
      NNAME=NNAME+1
      NAME(NNAME)=EXPRES(I)
1810  CONTINUE
C================================================================
C==   ERROR 13: UNDEFINED OPERATOR.                            ==
C================================================================
      IERR=13
      IF(NOPER2.LE.0)GO TO 2000
C================================================================
C==   FIND WHERE THE OPERATOR "NAME" IS, IN THE OPERATOR TABLE ==
C==   "OPERAT".                                                ==
C================================================================
      DO 1820 I=1,NOPER2
      IF(EQCMP(8,OPERAT(I),NAME))GO TO 1830
1820  CONTINUE
      GO TO 2000
C================================================================
C==   OPERATOR "NAME" = OPERAT(I).                             ==
C==   STORE THE OPERATOR CODE "-I" IN "ICODE(2,NCODE)".        ==
C================================================================
1830  ICODE(2,NCODE)=-I
      GO TO 1000
C================================================================
C==   ERROR MESSAGES: 1 - 17.                                  ==
C================================================================
2000  IF(NERROR.GE.MERROR)RETURN1
      NERROR=NERROR+1
C================================================================
C==   INITIALIZE THE ERROR MESSAGE "ERROR(1,NERROR)" TO BLANKS.==
C==   SET IERROR(1,NERROR) = IERR = THE ERROR NUMBER.          ==
C==   SET IERROR(2,NERROR) = IFIRST = THE COLUMN OF THE        ==
C==   EXPRESSION "EXPRES" AT WHICH THE ERROR OCCURS.           ==
C==   THEN GO TO THE NUMBER CORRESPONDING TO "IERR" AND        ==
C==   MOVE THE APPROPRIATE ERROR MESSAGE INTO "ERROR(1,NERROR)".=
C================================================================
      CALL SETC(50,ERROR(1,NERROR),' ')
      IERROR(1,NERROR)=IERR
      IERROR(2,NERROR)=IFIRST
      GO TO (2010,2020,2030,2040,2050,2060,2070,2070,2090,
     *       2100,2110,2120,2130,2140,2150,2160,2170),IERR
2010  CALL MOVEC(17,'INVALID CHARACTER',ERROR(1,NERROR))
      GO TO 2900
2020  CALL MOVEC(28,'NO CLOSING QUOTE ON OPERATOR',ERROR(1,NERROR))
      RETURN1
2030  CALL MOVEC(21,'INVALID DECIMAL POINT',ERROR(1,NERROR))
      GO TO 2900
2040  CALL MOVEC(16,'INVALID EXPONENT',ERROR(1,NERROR))
      CALL FINDC(EXPRES,ILAST,'ED',2,IFIRST,IFIND,IDUM,*2900,*2900)
      IERROR(2,NERROR)=IFIND
      GO TO 2900
2050  CALL MOVEC(20,'EXPRESSION TOO LARGE',ERROR(1,NERROR))
      RETURN1
2060  CALL MOVEC(19,'NAME > 8 CHARACTERS',ERROR(1,NERROR))
      GO TO 2900
2070  CALL MOVEC(8,NAME,ERROR(1,NERROR))
      IF(ILAST.GE.NEXP)GO TO 2080
      IF(.NOT.EQUC(EXPRES(ILAST+1),'('))GO TO 2080
      CALL MOVEC(25,' IS AN UNDEFINED FUNCTION',ERROR(9,NERROR))
      GO TO 2900
2080  IERROR(1,NERROR)=8
      CALL MOVEC(25,' IS AN UNDEFINED VARIABLE',ERROR(9,NERROR))
      GO TO 2900
2090  CALL MOVEC(18,'TOO MANY VARIABLES',ERROR(1,NERROR))
      RETURN1
2100  CALL MOVEC(19,'INVALID REAL NUMBER',ERROR(1,NERROR))
      GO TO 2900
2110  CALL MOVEC(18,'TOO MANY CONSTANTS',ERROR(1,NERROR))
      RETURN1
2120  CALL MOVEC(23,'OPERATOR > 8 CHARACTERS',ERROR(1,NERROR))
      GO TO 2900
2130  CALL MOVEC(18,'UNDEFINED OPERATOR',ERROR(1,NERROR))
      GO TO 2900
2140  CALL MOVEC(16,'BLANK EXPRESSION',ERROR(1,NERROR))
      RETURN1
2150  CALL MOVEC(22,'")" HAS NO LEADING "("',ERROR(1,NERROR))
      RETURN1
2160  CALL MOVEC(24,'"(" HAS NO FOLLOWING ")"',ERROR(1,NERROR))
      RETURN1
2170  CALL MOVEC(23,'OPERATOR STACK OVERFLOW',ERROR(1,NERROR))
      RETURN1
2900  IF(NERROR.GE.MERROR)RETURN1
      GO TO 1000
C================================================================
C==   THE LEXICAL SCAN OF THE EXPRESSION IS FINISHED.          ==
C================================================================
C==   ERROR 14: BLANK EXPRESSION, NCODE <= 0.                  ==
C==   IF THERE ARE ANY ERROR MESSAGES (NERROR > 0) AFTER THE   ==
C==   LEXICAL SCAN OF THE EXPRESSION THEN RETURN1.             ==
C================================================================
3000  IERR=14
      IF(NCODE.LE.0)GO TO 2000
      IF(NERROR.GT.0)RETURN1
C================================================================
C==   CHECK FOR ERRORS WHICH INVOLVE INVALID SEQUENCING OF THE ==
C==   TERMS IN THE EXPRESSION. THE TERMS 1 - 9 ARE DEFINED ABOVE=
C==   UNDER "SEQUENCING ERROR MESSAGES".                       ==
C================================================================
C==   ITERMC: IS THE NUMBER OF THE CURRENT TERM (1 - 9).       ==
C==   ITERMF: IS THE NUMBER OF THE FOLLOWING TERM (1 - 9).     ==
C==   BOTH "ITERMC" & "ITERMF" START OFF AS "7" WHICH IS THE   ==
C==   NUMBER OF THE "NULL" TERM WHICH REFERS TO THE BEGINNING  ==
C==   OR END OF THE EXPRESSION.                                ==
C==   ICOLC : IS THE COLUMN AT WHICH THE CURRENT TERM STARTS IN==
C==           THE EXPRESSION.                                  ==
C==   ICOLF : IS THE COLUMN AT WHICH THE FOLLOWING TERM STARTS ==
C==           IN THE EXPRESSION.                               ==
C================================================================
      ITERMC=7
      ITERMF=7
      ICOLC=1
      ICOLF=1
      NCODE1=NCODE+1
      DO 40 I=1,NCODE1
C================================================================
C==   UPDATE THE CURRENT TERM NUMBER: ITERMC, AND DETERMINE THE==
C==   TERM NUMBER OF THE FOLLOWING TERM.                       ==
C================================================================
      ITERMC=ITERMF
      ICOLC=ICOLF
      IF(I.LE.NCODE)GO TO 3010
C================================================================
C==   THE FOLLOWING TERM IS A "NULL" (END OF THE EXPRESSION)   ==
C==   (ITERMF=7).                                              ==
C================================================================
      ITERMF=7
      GO TO 3500
3010  ICOLF=ICODE(1,I)
      ICODE2=ICODE(2,I)
      IF(ICODE2.GT.0)GO TO 3200
      IOPER=-ICODE2
      IF(IOPER.LE.NOPER2)GO TO 3100
C================================================================
C==   THE FOLLOWING TERM IS A ")" (ITERMF=4), "(" (ITERMF=5),  ==
C==   OR A "," (ITERMF=6).                                     ==
C================================================================
      ITERMF=IOPER-NOPER2
      GO TO 3500
C================================================================
C==   THE FOLLOWING TERM IS AN OPERATOR.                       ==
C==   DETERMINE THE OPERATOR TYPE: IOPTYP=1 (UNARY) OR         ==
C==   IOPTYP=2 (BINARY).                                       ==
C================================================================
3100  IOPTYP=0
      IF(IPRIOR(1,IOPER).EQ.0)IOPTYP=2
      IF(IPRIOR(2,IOPER).EQ.0)IOPTYP=1
      IF(IOPTYP.NE.0)GO TO 3110
C================================================================
C==   HERE THE OPERATOR IS ALLOWED TO BE EITHER UNARY OR       ==
C==   BINARY, I.E. IPRIOR(I,IOPER) .NE. 0, I=1,2. THE OPERATOR ==
C==   TYPE OF THE FOLLOWING TERM IS DETERMINED BY THE CURRENT  ==
C==   TERM NUMBER (ITERMC).                                    ==
C==   IF ITERMC <= 4, I.E. THE CURRENT TERM IS A FUNCTION      ==
C==   VARIABLE, CONSTANT, OR ")", THEN THE OPERATOR IS BINARY  ==
C==   (IOPTYP=2), OTHERWISE IT IS UNARY (IOPTYP=1).            ==
C================================================================
      IOPTYP=1
      IF(ITERMC.LE.4)IOPTYP=2
C================================================================
C==   SET ICODE(1,I) EQUAL TO THE OPERATOR TYPE (1 OR 2, UNARY ==
C==   OR BINARY), AND THE FOLLOWING TERM NUMBER "ITERMF" TO THE==
C==   UNARY OPERATOR CODE 8, OR THE BINARY OPERATOR CODE 9.    ==
C================================================================
3110  ICODE(1,I)=IOPTYP
      ITERMF=IOPTYP+7
      GO TO 3500
3200  IF(ICODE2.GT.NFUN2)GO TO 3300
C================================================================
C==   THE FOLLOWING TERM IS A FUNCTION (ITERMF=1).             ==
C================================================================
      ITERMF=1
      GO TO 3500
C================================================================
C==   THE FOLLOWING TERM IS A VARIABLE (ITERMF=2) OR A CONSTANT==
C==   (ITERMF=3).                                              ==
C================================================================
3300  ITERMF=2
      IF(ICODE2.GT.NFUN2+NVAR2)ITERMF=3
C================================================================
C==   CHECK TO SEE IF "ITERMF" IS ALLOWED TO FOLLOW "ITERMC",  ==
C==   I.E. IF THE FOLLOWING TERM IS ALLOWED TO BE AFTER THE    ==
C==   CURRENT TERM.                                            ==
C==   IF IT IS ALLOWED THEN GO TO 40; OTHERWISE GO TO 30 AND   ==
C==   STORE THE APPROPRIATE ERROR MESSAGE IN "ERROR(1,NERROR)".==
C================================================================
3500  GO TO (11,11,13,13,15,15,15,18,18),ITERMC
11    GO TO (30,30,30,40,40,40,40,30,40),ITERMF
13    GO TO (30,30,30,40,30,40,40,30,40),ITERMF
15    GO TO (40,40,40,30,40,30,30,40,30),ITERMF
18    GO TO (40,40,40,30,40,30,30,30,30),ITERMF
C================================================================
C==   SEQUENCING ERROR MESSAGES: 113 - 199.                    ==
C================================================================
30    IF(NERROR.GE.MERROR)RETURN1
      IF(NFIRST)GO TO 3600
C================================================================
C==   THE FIRST TIME THROUGH, INITIALIZE THE ARRAY OF TERM     ==
C==   NAMES: "TERM(1,I)", I=1,9.                               ==
C================================================================
      CALL MOVEC(LTERM(1),'FUNCTION',TERM(1,1))
      CALL MOVEC(LTERM(2),'VARIABLE',TERM(1,2))
      CALL MOVEC(LTERM(3),'CONSTANT',TERM(1,3))
      CALL MOVEC(LTERM(4),'")"'     ,TERM(1,4))
      CALL MOVEC(LTERM(5),'"("'     ,TERM(1,5))
      CALL MOVEC(LTERM(6),'","'     ,TERM(1,6))
      CALL MOVEC(LTERM(7),'NULL'    ,TERM(1,7))
      CALL MOVEC(LTERM(8),'UNARY OPERATOR' ,TERM(1,8))
      CALL MOVEC(LTERM(9),'BINARY OPERATOR',TERM(1,9))
      NFIRST=.TRUE.
C================================================================
C==   INITIALIZE THE ERROR MESSAGE "ERROR(1,NERROR)" TO BLANKS.==
C==   SET IERROR(1,NERROR) = 100+ITERMC*10+ITERMF = THE ERROR  ==
C==   NUMBER CORRESPONDING TO THE SEQUENCING ERROR WHICH OCCURS==
C==   WHEN TERM "ITERMC" IS FOLLOWED BY TERM "ITERMF".         ==
C==   SET IERROR(2,NERROR) = ICOLC = THE COLUMN OF THE         ==
C==   EXPRESSION "EXPRES" AT WHICH THE ERROR OCCURS.           ==
C==   THEN MOVE THE ERROR MESSAGE: "TERM(1,ITERMC)" FOLLOWED BY==
C==   "TERM(1,ITERMF)", INTO "ERROR(1,NERROR)".                ==
C================================================================
3600  NERROR=NERROR+1
      CALL SETC(50,ERROR(1,NERROR),' ')
      IERROR(1,NERROR)=100+ITERMC*10+ITERMF
      IERROR(2,NERROR)=ICOLC
      CALL MOVEC(LTERM(ITERMC),TERM(1,ITERMC),ERROR(1,NERROR))
      CALL MOVEC(13,' FOLLOWED BY ',ERROR(1+LTERM(ITERMC),NERROR))
      CALL MOVEC(LTERM(ITERMF),TERM(1,ITERMF),
     *           ERROR(14+LTERM(ITERMC),NERROR))
      IF(NERROR.GE.MERROR)RETURN1
40    CONTINUE
C================================================================
C==   THE CHECK FOR SEQUENCING ERRORS OF THE TERMS IN THE      ==
C==   EXPRESSION IS FINISHED.                                  ==
C================================================================
C==   IF THERE ARE ANY ERROR MESSAGES (NERROR > 0) DUE TO      ==
C==   INVALID SEQUENCING OF THE TERMS IN THE EXPRESSION THEN   ==
C==   RETURN1.                                                 ==
C================================================================
      IF(NERROR.GT.0)RETURN1
C================================================================
C==   CHECK FOR MISMATCHING PARENTHESES.                       ==
C==   THE DO 4000 LOOP SEARCHS FORWARD FOR A ")" WITH NO LEADING=
C==   "(". THE DO 4030 LOOP SEARCHS BACKWARDS FOR A "(" WITH NO==
C==   FOLLOWING ")".                                           ==
C================================================================
C==   ILEVEL = THE LEVEL OR DEPTH WITHIN PARENTHESES.          ==
C==   WHEN SEARCHING FORWARD "ILEVEL" STARTS OFF AS ZERO AND   ==
C==   IS INCREMENTED BY 1 FOR EVERY "(" (ICODE2.EQ.5) FOUND,   ==
C==   AND IS DECREMENTED BY 1 FOR EVERY ")" (ICODE2.EQ.4) FOUND.=
C==   IF "ILEVEL" BECOMES NEGATIVE THEN A ")" WITH NO LEADING  ==
C==   "(" HAS BEEN FOUND AND WE GO TO 4010.                    ==
C================================================================
      ILEVEL=0
      DO 4000 I=1,NCODE
      IF(ICODE(2,I).GE.-NOPER2)GO TO 4000
C================================================================
C==   "ICODE(2,I)" CORRESPONDS TO A ")", "(", OR ",".          ==
C==   ICODE2.EQ.6  CORRESPONDS TO A ",".                       ==
C==   ICODE2.EQ.4  CORRESPONDS TO A ")", "}", OR "]".          ==
C==   ICODE2.EQ.5  CORRESPONDS TO A "(", "{", OR "[".          ==
C================================================================
      ICODE2=-ICODE(2,I)-NOPER2
      IF(ICODE2.EQ.6)GO TO 4000
      IF(ICODE2.EQ.4)ILEVEL=ILEVEL-1
      IF(ICODE2.EQ.5)ILEVEL=ILEVEL+1
      IF(ILEVEL.LT.0)GO TO 4010
4000  CONTINUE
C================================================================
C==   IF ILEVEL.EQ.0 THEN THE PARENTHESES IN THE EXPRESSION ARE==
C==   BALANCED. HENCE GO TO 4100.                              ==
C==   OTHERWISE IF ILEVEL.GT.0 THEN GO TO 4020 AND SEARCH THE  ==
C==   EXPRESSION BACKWARDS FOR A "(" WITH NO FOLLOWING ")".    ==
C================================================================
      IF(ILEVEL.EQ.0)GO TO 4100
      GO TO 4020
C================================================================
C==   ILEVEL.LT.0:                                             ==
C==   ERROR 15: ")" HAS NO LEADING "(".                        ==
C================================================================
4010  IFIRST=ICODE(1,I)
      IERR=15
      GO TO 2000
C================================================================
C==   ILEVEL = THE LEVEL OR DEPTH WITHIN PARENTHESES.          ==
C==   WHEN SEARCHING BACKWARDS "ILEVEL" STARTS OFF AS ZERO AND ==
C==   IS INCREMENTED BY 1 FOR EVERY ")" (ICODE2.EQ.4) FOUND,   ==
C==   AND IS DECREMENTED BY 1 FOR EVERY "(" (ICODE2.EQ.5) FOUND.=
C==   IF "ILEVEL" BECOMES NEGATIVE THEN A "(" WITH NO FOLLOWING==
C==   ")" HAS BEEN FOUND AND WE GO TO 4040.                    ==
C================================================================
4020  ILEVEL=0
      DO 4030 I=1,NCODE
      II=NCODE-I+1
      IF(ICODE(2,II).GE.-NOPER2)GO TO 4030
C================================================================
C==   "ICODE(2,II)" CORRESPONDS TO A ")", "(", OR ",".         ==
C==   ICODE2.EQ.6  CORRESPONDS TO A ",".                       ==
C==   ICODE2.EQ.4  CORRESPONDS TO A ")", "}", OR "]".          ==
C==   ICODE2.EQ.5  CORRESPONDS TO A "(", "{", OR "[".          ==
C================================================================
      ICODE2=-ICODE(2,II)-NOPER2
      IF(ICODE2.EQ.6)GO TO 4030
      IF(ICODE2.EQ.4)ILEVEL=ILEVEL+1
      IF(ICODE2.EQ.5)ILEVEL=ILEVEL-1
      IF(ILEVEL.LT.0)GO TO 4040
4030  CONTINUE
      GO TO 4100
C================================================================
C==   ILEVEL.LT.0:                                             ==
C==   ERROR 16: "(" HAS NO FOLLOWING ")".                      ==
C================================================================
4040  IFIRST=ICODE(1,II)
      IERR=16
      GO TO 2000
C================================================================
C==   CHECK FOR INVALID COMMAS, AND                            ==
C==   CHECK THAT ALL OF THE FUNCTIONS HAVE THE CORRECT NUMBER  ==
C==   OF ARGUMENTS "NARGUM(1,I)" <= NARG <= "NARGUM(2,I)", AND ==
C==   CHECK THAT ALL OF THE VARIABLES HAVE THE CORRECT NUMBER  ==
C==   OF INDICES "NINDEX(I)".                                  ==
C================================================================
4100  IST=1
4105  ISTART=IST
      IF(ISTART.GT.NCODE)GO TO 4180
      DO 4110 I=ISTART,NCODE
      ICODE1=ICODE(1,I)
      ICODE2=ICODE(2,I)
      IF(ICODE2.NE.-NOPER2-6)GO TO 4120
C================================================================
C==   ICODE2 = -NOPER2-6: CORRESPONDS TO A COMMA.              ==
C==   IF "ICODE1" HAS BEEN SET NEGATIVE THEN THE COMMA IS VALID==
C==   OTHERWISE IT IS INVALID.                                 ==
C================================================================
      IF(ICODE1.LT.0)GO TO 4120
C================================================================
C==   ERROR 18: INVALID COMMA.                                 ==
C================================================================
      IERR=18
      GO TO 4160
4120  IF(ICODE2.LE.0)GO TO 4110
      IF(ICODE2.GT.NVAR2+NFUN2)GO TO 4110
C================================================================
C==   "ICODE2" CORRESPONDS TO A FUNCTION OR VARIABLE.          ==
C==   COUNT THE NUMBER OF ARGUMENTS "NARG" OF THE FUNCTION OR  ==
C==   VARIABLE.                                                ==
C================================================================
      NARG=0
      IST=I+1
      IF(I.EQ.NCODE)GO TO 4140
      IF(ICODE(2,I+1).NE.-NOPER2-5)GO TO 4140
C================================================================
C==   AN OPEN PARENTHESIS FOLLOWS THE FUNCTION OR VARIABLE NAME.=
C==   ILEVEL = THE LEVEL OR DEPTH OF PARENTHESES FOLLOWING THE ==
C==   FUNCTION OR VARIABLE NAME. THE NUMBER OF ARGUMENTS       ==
C==   FOLLOWING THE FUNCTION OR VARIABLE NAME IS EQUAL TO THE  ==
C==   NUMBER OF COMMAS AT LEVEL "ILEVEL"=1 PLUS ONE.           ==
C==   THE SEARCH FOR FUNCTION OR VARIABLE ARGUMENTS TERMINATES ==
C==   WHEN ILEVEL BECOMES 0 AGAIN.                             ==
C================================================================
      NARG=1
      ILEVEL=0
      DO 4130 J=IST,NCODE
      IF(ICODE(2,J).GE.-NOPER2)GO TO 4130
      ICOD2=-ICODE(2,J)-NOPER2
      IF(ICOD2.NE.6.OR.ILEVEL.NE.1)GO TO 4135
C================================================================
C==   "ICOD2"=6 CORRESPONDS TO A COMMA ON LEVEL "ILEVEL"=1.    ==
C==   INCREMENT "NARG" BY 1.                                   ==
C==   SET "ICODE(1,J)" TO NEGATIVE SO THAT ON A SUBSEQUENT SCAN==
C==   FOR A FUNCTION OR VARIABLE NAME IT WON'T BE TREATED AS AN==
C==   INVALID COMMA.                                           ==
C================================================================
      NARG=NARG+1
      ICOD1=ICODE(1,J)
      ICODE(1,J)=-IABS(ICOD1)
      GO TO 4130
C================================================================
C==   ICOD2.EQ.4 CORRESPONDS TO A ")", "}", OR A "]".          ==
C==   ICOD2.EQ.5 CORRESPONDS TO A "(", "{", OR A "[".          ==
C================================================================
4135  IF(ICOD2.EQ.4)ILEVEL=ILEVEL-1
      IF(ICOD2.EQ.5)ILEVEL=ILEVEL+1
C================================================================
C==   WHEN "ILEVEL" BECOMES 0 TERMINATE THE SEARCH FOR COMMAS  ==
C==   AND FUNCTION OR VARIABLE ARGUMENTS.                      ==
C================================================================
      IF(ILEVEL.LE.0)GO TO 4140
4130  CONTINUE
C================================================================
C==   STORE THE NUMBER OF ARGUMENTS WHICH THE FUNCTION OR      ==
C==   VARIABLE CORRESPONDING TO "ICODE(2,I)" HAS, IN           ==
C==   "ICODE(1,I)".                                            ==
C================================================================
4140  ICODE(1,I)=NARG
      IF(ICODE2.GT.NFUN2)GO TO 4150
C================================================================
C==   "ICODE2" CORRESPONDS TO FUNCTION NAME "FUNCTN(ICODE2)".  ==
C==   CHECK THAT "NARG" LIES IN THE RANGE:                     ==
C==   NARGUM(1,ICODE2) <= NARG <= NARGUM(2,ICODE2).            ==
C================================================================
      IF(NARGUM(1,ICODE2).LE.NARG.AND.NARG.LE.NARGUM(2,ICODE2))
     * GO TO 4105
C================================================================
C==   ERROR 19: FUNCTION HAS WRONG NUMBER OF ARGUMENTS.        ==
C================================================================
      IERR=19
      GO TO 4160
C================================================================
C==   "ICODE2" CORRESPONDS TO VARIABLE NAME "VARIAB(IV)".      ==
C================================================================
4150  IV=ICODE2-NFUN2
C================================================================
C==   ERROR 20: VARIABLE HAS WRONG NUMBER OF INDICES.          ==
C================================================================
      IERR=20
      IF(NINDEX(IV).LT.0)GO TO 4155
C================================================================
C==   NINDEX(IV) => 0: CHECK THAT NARG = NINDEX(IV).           ==
C================================================================
      IF(NARG.EQ.NINDEX(IV))GO TO 4105
      GO TO 4160
C================================================================
C==   NINDEX(IV) <  0: CHECK THAT NARG = 0 OR |NINDEX(IV)|.    ==
C================================================================
4155  IF(NARG.EQ.0.OR.NARG.EQ.IABS(NINDEX(IV)))GO TO 4105
C================================================================
C==   ERROR MESSAGES: 18 - 20.                                 ==
C================================================================
4160  IF(NERROR.GE.MERROR)RETURN1
C================================================================
C==   INITIALIZE THE ERROR MESSAGE "ERROR(1,NERROR)" TO BLANKS.==
C==   SET IERROR(1,NERROR) = IERR = THE ERROR NUMBER.          ==
C==   SET IERROR(2,NERROR) = ICODE1 = THE COLUMN OF THE        ==
C==   EXPRESSION "EXPRES" AT WHICH THE ERROR OCCURS.           ==
C==   THEN GO TO THE NUMBER CORRESPONDING TO "IERR" AND        ==
C==   MOVE THE APPROPRIATE ERROR MESSAGE INTO "ERROR(1,NERROR)".=
C================================================================
      NERROR=NERROR+1
      CALL SETC(50,ERROR(1,NERROR),' ')
      IERROR(1,NERROR)=IERR
      IERROR(2,NERROR)=ICODE1
      IERR=IERR-17
      GO TO (4161,4162,4163),IERR
4161  CALL MOVEC(13,'INVALID COMMA',ERROR(1,NERROR))
      GO TO 4170
4162  CALL MOVEC(38,'FUNCTION HAS WRONG NUMBER OF ARGUMENTS',
     *              ERROR(1,NERROR))
      GO TO 4170
4163  CALL MOVEC(36,'VARIABLE HAS WRONG NUMBER OF INDICES',
     *              ERROR(1,NERROR))
4170  IF(NERROR.GE.MERROR)RETURN1
4110  CONTINUE
C================================================================
C==   THE CHECK FOR INVALID COMMAS, AND INVALID NUMBERS OF     ==
C==   FUNCTION ARGUMENTS OR VARIABLE INDICES IS FINISHED.      ==
C================================================================
C==   IF THERE ARE ANY ERROR MESSAGES AT THIS POINT THEN       ==
C==   RETURN1.                                                 ==
C================================================================
4180  IF(NERROR.GT.0)RETURN1
C================================================================
C==   CONVERT THE "NCODE" CODES IN "ICODE" TO REVERSE POLISH   ==
C==   NOTATION, STORING THE FINAL R.P.N. CODE IN "ICODE".      ==
C==   NOUT = CURRENT NUMBER OF R.P.N. CODES IN "ICODE".        ==
C==   IERR=17 CORRESPONDS TO ERROR 17: OPERATOR STACK OVERFLOW.==
C==   NSTACK = CURRENT NUMBER OF OPERATORS STORED IN THE       ==
C==            OPERATOR STACK: "STACK(2,100)".                 ==
C================================================================
      NOUT=0
      IERR=17
      NSTACK=0
      DO 5000 I=1,NCODE
      ICODE2=ICODE(2,I)
      IF(ICODE2.LE.NFUN2+NVAR2)GO TO 5010
C================================================================
C==   "ICODE2" CORRESPONDS TO A REAL*8 CONSTANT.               ==
C================================================================
C==   STORE "ICODE(K,I)",K=1,2 IN ICODE(K,NOUT).               ==
C================================================================
5005  NOUT=NOUT+1
      ICODE(1,NOUT)=ICODE(1,I)
      ICODE(2,NOUT)=ICODE(2,I)
      GO TO 5000
5010  IF(ICODE2.LE.0)GO TO 5020
C================================================================
C==   "ICODE2" CORRESPONDS TO A FUNCTION OR VARIABLE.          ==
C==   IF ICODE(1,I).LE.0, I.E. THE FUNCTION OR VARIABLE HAS 0  ==
C==   ARGUMENTS THEN GO TO 5005.                               ==
C================================================================
      IF(ICODE(1,I).LE.0)GO TO 5005
C================================================================
C==   ICODE(1,I) > 0, I.E. THE FUNCTION OR VARIABLE HAS A SET  ==
C==   OF ARGUMENTS. STACK THE FUNCTION OR VARIABLE IN THE      ==
C==   OPERATOR STACK.                                          ==
C================================================================
C==   INCREMENT THE NUMBER OF ELEMENTS IN THE STACK "NSTACK" BY==
C==   1 AND CHECK FOR AN OVERFLOW.                             ==
C==   IF NO OVERFLOW THEN STORE "ICODE(K,I)",K=1,2 IN          ==
C==   "STACK(K,I)".                                            ==
C================================================================
5015  NSTACK=NSTACK+1
      IFIRST=1
      IF(NSTACK.GT.100)GO TO 2000
      ISTACK(1,NSTACK)=ICODE(1,I)
      ISTACK(2,NSTACK)=ICODE(2,I)
      GO TO 5000
5020  IF(ICODE2.LT.-NOPER2)GO TO 5100
C================================================================
C==   "ICODE2" CORRESPONDS TO OPERATOR "OPERAT(IOPER)".        ==
C==   "IOPTYP" = 1 OR 2 (BINARY OR UNARY) IS THE OPERATOR TYPE.==
C==   "|IPRIO|" IS THE OPERATOR PRIORITY OR PRECEDENCE AND THE ==
C==   SIGN OF "IPRIO" GIVES THE OPERATOR ASSOCIATIVITY (+ OR - ==
C==   LEFT OR RIGHT ASSOCIATIVITY).                            ==
C================================================================
      IOPER=-ICODE2
      IOPTYP=ICODE(1,I)
      IPRIO=IPRIOR(IOPTYP,IOPER)
      IF(NSTACK.LE.0)GO TO 5015
C================================================================
C==   POP ANY OPERATORS ON THE STACK WHICH HAVE A HIGHER       ==
C==   PRECEDENCE THEN THE PRECEDENCE "IPRIO", UNTIL AN OPERATOR==
C==   WITH LOWER PRECEDENCE OR A "(" OR "," IS ENCOUNTERED.    ==
C================================================================
      DO 5040 J=1,NSTACK
C================================================================
C==   SCAN THE STACK STARTING AT THE TOP BY USING "II".        ==
C================================================================
      II=NSTACK-J+1
      ISTAC2=ISTACK(2,II)
      IF(ISTAC2.LT.0)GO TO 5030
C================================================================
C==   ISTAC2 > 0: CORRESPONDS TO A FUNCTION OR VARIABLE WITH   ==
C==               ARGUMENTS.                                   ==
C================================================================
C==   POP OPERATOR FROM STACK INTO ICODE(K,NOUT),K=1,2.        ==
C================================================================
5025  NOUT=NOUT+1
      ICODE(1,NOUT)=ISTACK(1,II)
      ICODE(2,NOUT)=ISTACK(2,II)
      GO TO 5040
C================================================================
C==   IF ISTAC2 < -NOPER2, I.E. "ISTAC2" CORRESPONDS TO A ","  ==
C==   OR "(", THEN STOP POPPING THE STACK AND GO TO 5050.      ==
C================================================================
5030  IF(ISTAC2.LT.-NOPER2)GO TO 5050
C================================================================
C==   -NOPER2 <= ISTAC2 < 0: CORRESPONDS TO AN OPERATOR.       ==
C================================================================
      IOPER=-ISTAC2
      IOPTYP=ISTACK(1,II)
      IAPRIO=IABS(IPRIOR(IOPTYP,IOPER))
      IF(IPRIO.LT.0)GO TO 5035
C================================================================
C==   IPRIO > 0: THE OPERATOR IS LEFT ASSOCIATIVE.             ==
C==   CHECK TO SEE IF IAPRIO < IPRIO. IF IT IS WE STOP POPPING ==
C==   THE STACK AND GO TO 5050. IF IT ISN'T WE GO TO 5025 AND  ==
C==   POP "ISTACK(K,II)",K=1,2 INTO "ICODE(K,NOUT)",K=1,2.     ==
C================================================================
      IF(IAPRIO.LT.IPRIO)GO TO 5050
      GO TO 5025
C================================================================
C==   IPRIO < 0: THE OPERATOR IS RIGHT ASSOCIATIVE.            ==
C==   CHECK TO SEE IF IAPRIO <= |IPRIO|. IF IT IS WE STOP      ==
C==   POPPING THE STACK AND GO TO 5050. IF IT ISN'T WE GO TO   ==
C==   5025 AND POP "ISTACK(K,II)",K=1,2 INTO "ICODE(K,NOUT)".  ==
C================================================================
5035  IF(IAPRIO.LE.IABS(IPRIO))GO TO 5050
      GO TO 5025
5040  CONTINUE
      II=0
C================================================================
C==   THE NUMBER OF ELEMENTS LEFT IN THE STACK AFTER THE       ==
C==   DO 5040 LOOP IS "NSTACK"="II".                           ==
C==   THEN GO TO 5015 AND STORE THE OPERATOR CORRESPONDING TO  ==
C==   "ISTACK(K,II)",K=1,2 INTO "ICODE(K,II)".                 ==
C================================================================
5050  NSTACK=II
      GO TO 5015
C================================================================
C==   "ICODE2" CORRESPONDS TO A ")","(", OR ",".               ==
C================================================================
5100  ICODE2=-ICODE2-NOPER2
C================================================================
C==   IF "ICODE2"=5, I.E. IF A "(" THEN GO TO 5015 AND PUSH IT ==
C==   ONTO THE STACK.                                          ==
C================================================================
      IF(ICODE2.EQ.5)GO TO 5015
C================================================================
C==   "ICODE2" = 4 OR 6 CORRESPONDS TO A ")" OR A ",".         ==
C==   POP ALL ELEMENTS OF THE STACK UPTO THE "(".              ==
C================================================================
      IF(NSTACK.LE.0)GO TO 5000
      DO 5110 J=1,NSTACK
      II=NSTACK-J+1
C================================================================
C==   IF "ISTACK(2,II)" CORRESPONDS TO A "(" STOP POPPING THE  ==
C==   STACK AND GO TO 5150.                                    ==
C================================================================
      IF(ISTACK(2,II).LT.-NOPER2)GO TO 5150
C================================================================
C==   POP THE STACK.                                           ==
C================================================================
      NOUT=NOUT+1
      ICODE(1,NOUT)=ISTACK(1,II)
      ICODE(2,NOUT)=ISTACK(2,II)
5110  CONTINUE
      NSTACK=0
      GO TO 5000
C================================================================
C==   IF "ISTACK(2,II)"=6 (CORRESPONDS TO A COMMA) THEN        ==
C==   NSTACK=II.                                               ==
C==   IF "ISTACK(2,II)"=4 (CORRESPONDS TO A ")"  ) THEN        ==
C==   NSTACK=II-1.                                             ==
C================================================================
5150  NSTACK=II
      IF(ICODE2.EQ.4)NSTACK=NSTACK-1
5000  CONTINUE
C================================================================
C==   WE HAVE FINISHED SCANNING "ICODE".                       ==
C================================================================
C==   POP THE REMAINING ELEMENTS OF THE STACK.                 ==
C================================================================
      IF(NSTACK.LE.0)GO TO 5250
      DO 5200 J=1,NSTACK
      II=NSTACK-J+1
      NOUT=NOUT+1
      ICODE(1,NOUT)=ISTACK(1,II)
      ICODE(2,NOUT)=ISTACK(2,II)
5200  CONTINUE
C================================================================
C==   THE NUMBER OF CODES, "NCODE", IN THE REVERSE POLISH      ==
C==   NOTATION OF "ICODE" IS "NOUT".                           ==
C================================================================
5250  NCODE=NOUT
      RETURN
C================================================================
C==   THIS IS THE END!!!!!.                                    ==
C================================================================
      END
      SUBROUTINE SCAN2(INPUT,NINPUT,IFIRST,ILAST,ISTATE,
     *                CLASS2,CTABLE,STABLE,NSTATE)
C================================================================
C================================================================
C==                                                            ==
C==   SCAN: PERFORMS A LEXICAL SCAN OF THE "INPUT" ARRAY,      ==
C==         STARTING AT THE "IFIRST" LOCATION IN "INPUT", USING==
C==         THE TRANSITION TABLE "STABLE(NSTATE,NCLASS)".      ==
C==         THE TOKEN WHICH SCAN RETURNS LIES WITHIN THE       ==
C==         LOCATIONS "IFIRST" AND "ILAST" OF "INPUT".         ==
C==                                                            ==
C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., JANUARY 3, 1980.==
C==                                                            ==
C==   INPUT  PARAMETERS: INPUT(NINPUT) (L*1,I*2,I*4,R*4,OR R*8);=
C==                      NINPUT,IFIRST,NSTATE (I*4);           ==
C==                      CLASS2 (EXTERNAL SUBROUTINE);         ==
C==                      CTABLE (USUALLY A 256 I*2 ARRAY);     ==
C==                      STABLE(NSTATE,NCLASS) (I*2).          ==
C==                                                            ==
C==   OUTPUT PARAMETERS: ILAST,ISTATE (I*4).                   ==
C==                                                            ==
C==   PARAMETER DEFINITIONS:                                   ==
C==   --------- -----------                                    ==
C==                                                            ==
C==   INPUT : A L*1,I*2,I*4,R*4, OR R*8 ARRAY OF ELEMENTS TO BE==
C==           SCANNED FOR TOKENS (OR TERMS).                   ==
C==                                                            ==
C==   NINPUT: NUMBER OF ELEMENTS TO BE SCANNED IN "INPUT".     ==
C==                                                            ==
C==   IFIRST: FIRST LOCATION IN "INPUT" AT WHICH THE SCAN IS TO==
C==           START.                                           ==
C==                                                            ==
C==   ILAST : LAST LOCATION IN "INPUT" AT WHICH THE SCAN IS    ==
C==           TERMINATED. THE TOKEN RETURNED BY SCAN LIES      ==
C==           WITHIN THE LOCATIONS "IFIRST" AND "ILAST" OF     ==
C==           "INPUT".                                         ==
C==                                                            ==
C==   ISTATE: OUTPUT STATE RETURNED BY SCAN WHICH CORRESPONDS  ==
C==           TO THE TYPE OF TOKEN RETURNED. SEE "STABLE".     ==
C==                                                            ==
C==   CLASS2 : EXTERNAL CLASS2 SUBROUTINE WHICH TAKES AN ACTION==
C==           ON EACH STATE "ISTATE" ENCOUNTERED DURING THE    ==
C==           LEXICAL SCAN AND WHICH RETURNS THE CLASS "ICLASS"==
C==           OF THE NEXT ELEMENT IN "INPUT". THE SUBROUTINE   ==
C==           CLASS2 HAS THE FOLLOWING ARGUMENTS:              ==
C==                                                            ==
C==           CALL CLASS2(INPUT,NINPUT,ILAST,ISTATE,NSTATE,    ==
C==          * CTABLE,ICLASS,RETURN)                           ==
C==                                                            ==
C==           WHERE "INPUT" AND "NINPUT" ARE INPUT             ==
C==           PARAMETERS DEFINED ABOVE, "ILAST" IS AN          ==
C==           I/O PARAMETER WHICH KEEPS TRACK OF THE CURRENT   ==
C==           ELEMENT IN "INPUT" BEING SCANNED (ON INPUT TO    ==
C==           "CLASS2" "ILAST" IS ASSUMED TO POINT TO THE LAST ==
C==           ELEMENT LOOKED AT BY "CLASS2"; "CLASS2" WILL THEN==
C==           USUALLY INCREMENT "ILAST" BY 1 AND RETURN THE    ==
C==           CLASS "ICLASS" OF THE ELEMENT POINTED TO BY      ==
C==           "ILAST"), "ISTATE" IS AN INPUT PARAMETER WHICH   ==
C==           TELLS "CLASS2" THE CURRENT STATE OF THE SCAN, AND==
C==           ON OCCASION IF "ISTATE" IS AN ACTION STATE ON    ==
C==           INPUT TO "CLASS2" THEN "CLASS2" MAY CHANGE       ==
C==           "ISTATE" AND RETURN IT AS AN OUTPUT PARAMETER,   ==
C==           "NSTATE" AND "CTABLE" ARE INPUT PARAMETERS       ==
C==           DEFINED BELOW,                                   ==
C==           "ICLASS" IS AN OUTPUT PARAMETER WHICH IS THE CLASS=
C==           OF THE NEXT ELEMENT IN "INPUT", AND "RETURN" IS  ==
C==           A L*1 OUTPUT FLAG WHICH TELLS "SCAN" TO RETURN   ==
C==           IF IT IS ".TRUE.".                               ==
C==                                                            ==
C==   CTABLE: IS USUALLY AN INTEGER*2 CLASS TABLE "CTABLE(256)".=
C==           IF "CHAR" IS A CHARACTER (1 BYTE) THEN IT HAS A  ==
C==           NUMERIC VALUE "ICHAR" IN THE RANGE               ==
C==           0 <= "ICHAR" <= 255 AND ITS CLASS NUMBER IS      ==
C==           GIVEN BY "CTABLE(ICHAR+1)".                      ==
C==                                                            ==
C==   STABLE: LEXICAL SCANNER TRANSITION TABLE DIMENSIONED AS: ==
C==           STABLE(NSTATE,NCLASS) WHERE "NSTATE" IS THE NUMBER=
C==           OF TRANSITION STATES AND "NCLASS" IS THE NUMBER  ==
C==           OF "INPUT" ELEMENT CLASSES.                      ==
C==           IF 1 <= "STABLE(ISTATE,ICLASS)" <= NSTATE THEN IT==
C==           IS A TRANSITION STATE.                           ==
C==           IF "STABLE(ISTATE,ICLASS)" < 1 THEN IT IS AN     ==
C==           OUTPUT STATE AND THE SCAN POINTER "ILAST" IS     ==
C==           SHIFTED BY "CLASS2" BACK BY 1.                   ==
C==           IF "STABLE(ISTATE,ICLASS)" > NSTATE THEN IT IS AN==
C==           OUTPUT STATE AND THE SCAN POINTER IS NOT CHANGED.==
C==           THE VALUE OF THE OUTPUT STATE IS RETURNED BY     ==
C==           "SCAN" IN "ISTATE".                              ==
C==                                                            ==
C==   NSTATE: NUMBER OF TRANSITION STATES.                     ==
C==                                                            ==
C==   ALGORITHM USED BY "SCAN":                                ==
C==   --------- ---- -- ------                                 ==
C==                                                            ==
C==   1) ILAST  <-- IFIRST - 1                                 ==
C==                                                            ==
C==   2) ISTATE <-- 1                                          ==
C==                                                            ==
C==   3) IF "ISTATE" IS AN OUTPUT STATE THEN RETURN.           ==
C==      IF "ISTATE" IS AN ACTION STATE THEN PERFORM THE ACTION.=
C==                                                            ==
C==   4) ILAST  <-- ILAST + 1                                  ==
C==                                                            ==
C==   5) ICLASS <-- CLASS2("INPUT(ILAST)")                     ==
C==                                                            ==
C==   6) ISTATE <-- STABLE(ISTATE,ICLASS)                      ==
C==                                                            ==
C==   7) GO TO 3).                                             ==
C==                                                            ==
C================================================================
C================================================================
      INTEGER*2 STABLE(NSTATE,1)
      LOGICAL*1 RETURN
      EXTERNAL CLASS2
      ILAST=IFIRST-1
      ISTATE=1
10    CALL CLASS2(INPUT,NINPUT,ILAST,ISTATE,NSTATE,
     *           CTABLE,ICLASS,RETURN)
      IF(RETURN)RETURN
      ISTATE=STABLE(ISTATE,ICLASS)
      GO TO 10
      END
      SUBROUTINE CLASS2(INPUT,NINPUT,ILAST,ISTATE,
     *                 NSTATE,CTABLE,ICLASS,RETURN)
C================================================================
C================================================================
C==                                                            ==
C==   CLASS2: ROUTINE USED BY "SCAN" WHICH TAKES ACTION ON EACH==
C==          STATE "ISTATE" ENCOUNTERED DURING THE LEXICAL SCAN==
C==          AND WHICH RETURNS THE CLASS "ICLASS" OF THE NEXT  ==
C==          CHARACTER (ILAST+1'TH CHARACTER) IN "INPUT".      ==
C==                                                            ==
C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., JANUARY 3, 1980.==
C==                                                            ==
C==   INPUT  PARAMETERS: INPUT(NINPUT) (L*1); NINPUT,ILAST,    ==
C==                      ISTATE,NSTATE (I*4); CTABLE(256) (I*2).=
C==                                                            ==
C==   OUTPUT PARAMETERS: ILAST,ICLASS (I*4); RETURN (L*1).     ==
C==                                                            ==
C==   PARAMETER DEFINITIONS:                                   ==
C==   --------- -----------                                    ==
C==                                                            ==
C==   INPUT : LOGICAL*1 ARRAY OF CHARACTERS TO BE SCANNED FOR  ==
C==           TOKENS (OR TERMS).                               ==
C==                                                            ==
C==   NINPUT: TOTAL NUMBER OF CHARACTERS IN "INPUT".           ==
C==                                                            ==
C==   ILAST : IS AN I/O PARAMETER WHICH KEEPS TRACK OF THE     ==
C==           CURRENT CHARACTER IN "INPUT" BEING SCANNED. ON   ==
C==           INPUT TO "CLASS2" "ILAST" POINTS TO THE LAST     ==
C==           CHARACTER LOOKED AT BY "CLASS". "CLASS2" WILL THEN=
C==           INCREMENT "ILAST" BY 1.                          ==
C==                                                            ==
C==   ISTATE: IS AN INPUT PARAMETER WHICH TELLS "CLASS2" THE   ==
C==           CURRENT STATE OF THE SCAN.                       ==
C==           IF 1 <= ISTATE <= NSTATE THEN IT IS A TRANSITION ==
C==           STATE AND "CLASS2" INCREMENTS THE SCAN POINTER   ==
C==           "ILAST" BY 1 AND RETURNS THE CLASS "ICLASS" OF   ==
C==           THE NEXT CHARACTER IN "INPUT".                   ==
C==           IF ISTATE < 1 THEN IT IS AN OUTPUT STATE AND THE ==
C==           SCAN POINTER "ILAST" IS SHIFTED BY "CLASS2" BACK ==
C==           BY 1, "ICLASS" IS NOT RETURNED, AND "RETURN" IS  ==
C==           SET ".TRUE.".                                    ==
C==           IF ISTATE > NSTATE THEN IT IS AN OUTPUT STATE AND==
C==           THE SCAN POINTER "ILAST" IS NOT CHANGED, "ICLASS"==
C==           IS NOT RETURNED, AND "RETURN" IS SET ".TRUE.".   ==
C==                                                            ==
C==   NSTATE: NUMBER OF TRANSITION STATES.                     ==
C==                                                            ==
C==   CTABLE: IS AN INTEGER*2 CLASS TABLE "CTABLE(256)".       ==
C==           IF "CHAR" IS A CHARACTER (1 BYTE) THEN IT HAS A  ==
C==           NUMERIC VALUE "ICHAR" IN THE RANGE               ==
C==           0 <= "ICHAR" <= 255 AND ITS CLASS NUMBER IS      ==
C==           GIVEN BY "CTABLE(ICHAR+1)".                      ==
C==                                                            ==
C==   ICLASS: CLASS OF THE NEXT CHARACTER IN "INPUT" RETURNED  ==
C==           BY SUBROUTINE "CLASS2" WHEN 1 <= ISTATE <= NSTATE.=
C==           THE CLASS VALUES ARE GOVERNED BY THE CLASS TABLE ==
C==           "CTABLE(256)". SEE "CTABLE" ABOVE.               ==
C==                                                            ==
C==   RETURN: IS A L*1 FLAG WHICH TELLS THE ROUTINE (SCAN)     ==
C==           CALLING "CLASS2" TO RETURN IF "RETURN"=.TRUE.    ==
C==           "RETURN" IS SET .TRUE. WHEN "ISTATE" IS AN OUTPUT==
C==           STATE, OTHERWISE IT IS SET .FALSE.               ==
C==                                                            ==
C================================================================
C================================================================
      INTEGER*2 CTABLE(256)
      INTEGER   ICHAR/0/
      LOGICAL*1 INPUT(1),LCHAR(4),RETURN
      EQUIVALENCE (ICHAR,LCHAR(1))
      RETURN=.FALSE.
C================================================================
C==   IF "ISTATE" < 1 THEN GO TO 40.                           ==
C==   IF "ISTATE" > NSTATE THEN GO TO 50.                      ==
C================================================================
      IF(ISTATE)40,40,10
10    IF(ISTATE.GT.NSTATE)GO TO 50
C================================================================
C==   1 <= ISTATE <= NSTATE: I.E. ISTATE IS A TRANSITION STATE.==
C==   INCREMENT THE SCAN POINTER "ILAST" BY 1.                 ==
C==   IF WE'VE ENCOUNTERED THE END OF THE INPUT STRING, I.E.   ==
C==   "ILAST" > "NINPUT" THEN GO TO 30.                        ==
C==   OTHERWISE RETURN THE CLASS OF THE CHARACTER "INPUT(ILAST)"=
C==   IN "ICLASS".                                             ==
C==   GIVEN THE 1 BYTE CHARACTER: INPUT(ILAST) WE CAN DETERMINE==
C==   ITS NUMERIC VALUE "ICHAR" WHICH LIES WITHIN THE RANGE:   ==
C==   0 <= ICHAR <= 255. THE CLASS OF THE CHARACTER            ==
C==   "INPUT(ILAST)" IS THEN GIVEN BY "CTABLE(ICHAR+1)".       ==
C================================================================
      ILAST=ILAST+1
      IF(ILAST.GT.NINPUT)GO TO 30
      LCHAR(1)=INPUT(ILAST)
      ICLASS=CTABLE(ICHAR+1)
      RETURN
C================================================================
C==   "ILAST" > "NINPUT".                                      ==
C================================================================
30    ICLASS=1
      RETURN
C================================================================
C==   ISTATE < 1: OUTPUT STATE. DECREMENT "ILAST" BY 1.        ==
C================================================================
40    ILAST=ILAST-1
C================================================================
C==   ISTATE > NSTATE: RETURN.                                 ==
C================================================================
50    RETURN=.TRUE.
      RETURN
      END
      SUBROUTINE CTABL2(CTABLE)
C================================================================
C================================================================
C==                                                            ==
C==   CTABL2: SETS UP THE INTEGER*2 CLASS TABLE "CTABLE(256)" FOR
C==          THE EXPRESSION EVALUATOR LEXICAL SCANNER          ==
C==          TRANSITION TABLE: "STABLE(10,13)".                ==
C==          IF "CHAR" IS A CHARACTER (1 BYTE) THEN IT HAS A   ==
C==          NUMERIC VALUE "ICHAR" IN THE RANGE                ==
C==          0 <= "ICHAR" <= 255 AND ITS CLASS NUMBER IS GIVEN ==
C==          BY "CTABLE(ICHAR+1)".                             ==
C==                                                            ==
C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., JANUARY 3, 1980.==
C==                                                            ==
C==   INPUT  PARAMETERS: NONE.                                 ==
C==                                                            ==
C==   OUTPUT PARAMETERS: CTABLE(256) (I*2).                    ==
C==                                                            ==
C==   CTABLE: IS SET UP WITH THE FOLLOWING CLASS VALUES:       ==
C==                                                            ==
C==           CLASS   CHARACTERS                               ==
C==                                                            ==
C==             1     END-OF-LINE (ILAST > NINPUT)             ==
C==             2     INVALID CHARACTERS                       ==
C==             3     BLANK                                    ==
C==             4     A-C,F-Z,$,a-c,f-z,_                      ==
C==             5     E,D,e,d                                  ==
C==             6     0-9                                      ==
C==             7     .                                        ==
C==             8     )]}                                      ==
C==             9     ([{                                      ==
C==            10     ,                                        ==
C==            11     '"                                       ==
C==            12     +-                                       ==
C==            13     OPERATOR CHARACTERS: !#%&*:=~^`@;|\<>?/  ==
C==                                                            ==
C================================================================
C================================================================
      INTEGER*2 CTABLE(256)
      LOGICAL*1 LCHAR(4),ARRAY(25)
      INTEGER   ICHAR/0/
      EQUIVALENCE (LCHAR(1),ICHAR)
C================================================================
C==   INITIALIZE THE CTABLE ARRAY TO CLASS 2 WHICH CORRESPONDS ==
C==   TO OTHER CHARACTERS (INVALID CHARACTERS).                ==
C================================================================
      DO 10 I=1,256
      CTABLE(I)=2
10    CONTINUE
C================================================================
C==   CLASS 3: BLANK                                           ==
C================================================================
      CALL MOVEC(1,' ',LCHAR(1))
      CTABLE(ICHAR+1)=3
C================================================================
C==   CLASS 4: A-C,F-Z,$,a-c,f-z,_                             ==
C================================================================
      CALL MOVEC(25,'ABCFGHIJKLMNOPQRSTUVWXYZ$',ARRAY)
      DO 20 I=1,25
      LCHAR(1)=ARRAY(I)
      CTABLE(ICHAR+1)=4
20    CONTINUE
      CALL MOVEC(25,'abcfghijklmnopqrstuvwxyz_',ARRAY)
      DO 30 I=1,25
      LCHAR(1)=ARRAY(I)
      CTABLE(ICHAR+1)=4
30    CONTINUE
C================================================================
C==   CLASS 5: E,D,e,d                                         ==
C================================================================
      CALL MOVEC(4,'EDed',ARRAY)
      DO 40 I=1,4
      LCHAR(1)=ARRAY(I)
      CTABLE(ICHAR+1)=5
40    CONTINUE
C================================================================
C==   CLASS 6: 0-9                                             ==
C================================================================
      CALL MOVEC(10,'0123456789',ARRAY)
      DO 50 I=1,10
      LCHAR(1)=ARRAY(I)
      CTABLE(ICHAR+1)=6
50    CONTINUE
C================================================================
C==   CLASS 7: .                                               ==
C================================================================
      CALL MOVEC(1,'.',LCHAR(1))
      CTABLE(ICHAR+1)=7
C================================================================
C==   CLASS 8: )]}                                             ==
C================================================================
      CALL MOVEC(3,')]}',ARRAY)
      DO 60 I=1,3
      LCHAR(1)=ARRAY(I)
      CTABLE(ICHAR+1)=8
60    CONTINUE
C================================================================
C==   CLASS 9: ([{                                             ==
C================================================================
      CALL MOVEC(3,'([{',ARRAY)
      DO 70 I=1,3
      LCHAR(1)=ARRAY(I)
      CTABLE(ICHAR+1)=9
70    CONTINUE
C================================================================
C==   CLASS 10: ,                                              ==
C================================================================
      CALL MOVEC(1,',',LCHAR(1))
      CTABLE(ICHAR+1)=10
C================================================================
C==   CLASS 11: '"                                             ==
C================================================================
      CALL MOVEC(2,'''"',ARRAY)
      DO 80 I=1,2
      LCHAR(1)=ARRAY(I)
      CTABLE(ICHAR+1)=11
80    CONTINUE
C================================================================
C==   CLASS 12: +-                                             ==
C================================================================
      CALL MOVEC(2,'+-',ARRAY)
      DO 90 I=1,2
      LCHAR(1)=ARRAY(I)
      CTABLE(ICHAR+1)=12
90    CONTINUE
C================================================================
C==   CLASS 13: !#%&*:=~^`@;|\<>?/                             ==
C================================================================
      CALL MOVEC(18,'!#%&*:=~^`@;|\<>?/',ARRAY)
      DO 100 I=1,18
      LCHAR(1)=ARRAY(I)
      CTABLE(ICHAR+1)=13
100   CONTINUE
      RETURN
      END
      SUBROUTINE EXTABL2(FUNCTN,NARGUM,NFUN)
C================================================================
C================================================================
C==                                                            ==
C==   EXTABL2: SETS UP A TABLE OF "NFUN"=78 STANDARD MATHEMATICAL
C==           REAL*8 FUNCTIONS.                                ==
C==                                                            ==
C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., JANUARY 3, 1980.==
C==                                                            ==
C==   OUTPUT PARAMETERS: FUNCTN(NFUN) (R*8);                   ==
C==                      NARGUM(2,NFUN),NFUN (I*4).            ==
C==                                                            ==
C==   PARAMETER DEFINITIONS:                                   ==
C==   --------- -----------                                    ==
C==                                                            ==
C==   FUNCTN: TABLE OF "NFUN"=78 8-CHARACTER STANDARD          ==
C==           MATHEMATICAL FUNCTION NAMES.                     ==
C==                                                            ==
C==   NARGUM: "NARGUM(1,I)" & "NARGUM(2,I)" (I=1,NFUN) ARE THE ==
C==           LOWER & UPPER LIMITS ON THE NUMBER OF ARGUMENTS  ==
C==           THE FUNCTION "FUNCTN(I)" IS ALLOWED TO HAVE.     ==
C==                                                            ==
C==   NFUN  : NFUN=78 IS THE NUMBER OF STANDARD MATHEMATICAL   ==
C==           FUNCTIONS RETURNED BY "EXTABL".                  ==
C==                                                            ==
C================================================================
C================================================================
      REAL*8     FUNCTN(NFUN)
      INTEGER    NARGUM(2,1)
      NFUN=78
C================================================================
C==   INITIALIZE THE NUMBER OF FUNCTION ARGUMENTS TO 1.        ==
C================================================================
      DO 10 K=1,NFUN
      NARGUM(1,K)=1
      NARGUM(2,K)=1
10    CONTINUE
      CALL MOVEC(8,'LOG     ',FUNCTN(1))
      CALL MOVEC(8,'log     ',FUNCTN(2))
      CALL MOVEC(8,'LOGE    ',FUNCTN(3))
      CALL MOVEC(8,'loge    ',FUNCTN(4))
      CALL MOVEC(8,'LOG10   ',FUNCTN(5))
      CALL MOVEC(8,'log10   ',FUNCTN(6))
      CALL MOVEC(8,'EXP     ',FUNCTN(7))
      CALL MOVEC(8,'exp     ',FUNCTN(8))
      CALL MOVEC(8,'SQRT    ',FUNCTN(9))
      CALL MOVEC(8,'sqrt    ',FUNCTN(10))
      CALL MOVEC(8,'SIN     ',FUNCTN(11))
      CALL MOVEC(8,'sin     ',FUNCTN(12))
      CALL MOVEC(8,'SINE    ',FUNCTN(13))
      CALL MOVEC(8,'sine    ',FUNCTN(14))
      CALL MOVEC(8,'COS     ',FUNCTN(15))
      CALL MOVEC(8,'cos     ',FUNCTN(16))
      CALL MOVEC(8,'COSINE  ',FUNCTN(17))
      CALL MOVEC(8,'cosine  ',FUNCTN(18))
      CALL MOVEC(8,'TAN     ',FUNCTN(19))
      CALL MOVEC(8,'tan     ',FUNCTN(20))
      CALL MOVEC(8,'TANGENT ',FUNCTN(21))
      CALL MOVEC(8,'tangent ',FUNCTN(22))
      CALL MOVEC(8,'ASIN    ',FUNCTN(23))
      CALL MOVEC(8,'asin    ',FUNCTN(24))
      CALL MOVEC(8,'ARSIN   ',FUNCTN(25))
      CALL MOVEC(8,'arsin   ',FUNCTN(26))
      CALL MOVEC(8,'ARCSINE ',FUNCTN(27))
      CALL MOVEC(8,'arcsine ',FUNCTN(28))
      CALL MOVEC(8,'ACOS    ',FUNCTN(29))
      CALL MOVEC(8,'acos    ',FUNCTN(30))
      CALL MOVEC(8,'ARCOS   ',FUNCTN(31))
      CALL MOVEC(8,'arcos   ',FUNCTN(32))
      CALL MOVEC(8,'ARCOSINE',FUNCTN(33))
      CALL MOVEC(8,'arcosine',FUNCTN(34))
      CALL MOVEC(8,'ATAN    ',FUNCTN(35))
      CALL MOVEC(8,'atan    ',FUNCTN(36))
      CALL MOVEC(8,'ARTAN   ',FUNCTN(37))
      CALL MOVEC(8,'artan   ',FUNCTN(38))
      CALL MOVEC(8,'ARCTAN  ',FUNCTN(39))
      CALL MOVEC(8,'arctan  ',FUNCTN(40))
      CALL MOVEC(8,'ATAN2   ',FUNCTN(41))
      CALL MOVEC(8,'atan2   ',FUNCTN(42))
      CALL MOVEC(8,'ARTAN2  ',FUNCTN(43))
      CALL MOVEC(8,'artan2  ',FUNCTN(44))
      CALL MOVEC(8,'ARCTAN2 ',FUNCTN(45))
      CALL MOVEC(8,'arctan2 ',FUNCTN(46))
      DO 46 I=41,46
      NARGUM(1,I)=2
      NARGUM(2,I)=2
46    CONTINUE
      CALL MOVEC(8,'SINH    ',FUNCTN(47))
      CALL MOVEC(8,'sinh    ',FUNCTN(48))
      CALL MOVEC(8,'COSH    ',FUNCTN(49))
      CALL MOVEC(8,'cosh    ',FUNCTN(50))
      CALL MOVEC(8,'TANH    ',FUNCTN(51))
      CALL MOVEC(8,'tanh    ',FUNCTN(52))
      CALL MOVEC(8,'ABS     ',FUNCTN(53))
      CALL MOVEC(8,'abs     ',FUNCTN(54))
      CALL MOVEC(8,'ABSOLUTE',FUNCTN(55))
      CALL MOVEC(8,'absolute',FUNCTN(56))
      CALL MOVEC(8,'MAX     ',FUNCTN(57))
      CALL MOVEC(8,'max     ',FUNCTN(58))
      CALL MOVEC(8,'MAXIMUM ',FUNCTN(59))
      CALL MOVEC(8,'maximum ',FUNCTN(60))
      CALL MOVEC(8,'MIN     ',FUNCTN(61))
      CALL MOVEC(8,'min     ',FUNCTN(62))
      CALL MOVEC(8,'MINIMUM ',FUNCTN(63))
      CALL MOVEC(8,'minimum ',FUNCTN(64))
      DO 64 I=57,64
      NARGUM(1,I)=2
      NARGUM(2,I)=2
64    CONTINUE
      CALL MOVEC(8,'INT     ',FUNCTN(65))
      CALL MOVEC(8,'int     ',FUNCTN(66))
      CALL MOVEC(8,'INTEGER ',FUNCTN(67))
      CALL MOVEC(8,'integer ',FUNCTN(68))
      CALL MOVEC(8,'IFIX    ',FUNCTN(69))
      CALL MOVEC(8,'ifix    ',FUNCTN(70))
      CALL MOVEC(8,'MOD     ',FUNCTN(71))
      CALL MOVEC(8,'mod     ',FUNCTN(72))
      CALL MOVEC(8,'MODULUS ',FUNCTN(73))
      CALL MOVEC(8,'modulus ',FUNCTN(74))
      CALL MOVEC(8,'SIGN    ',FUNCTN(75))
      CALL MOVEC(8,'sign    ',FUNCTN(76))
      CALL MOVEC(8,'DIM     ',FUNCTN(77))
      CALL MOVEC(8,'dim     ',FUNCTN(78))
      DO 78 I=71,78
      NARGUM(1,I)=2
      NARGUM(2,I)=2
78    CONTINUE
      RETURN
      END
      SUBROUTINE EXOPER2(OPERAT,IPRIOR,NOPER)
C================================================================
C================================================================
C==                                                            ==
C==   EXOPER: SETS UP A TABLE OF THE STANDARD MATHEMATICAL AND ==
C==           LOGICAL OPERATORS IN "OPERAT" & "IPRIOR".        ==
C==                                                            ==
C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., JANUARY 3, 1980.==
C==                                                            ==
C==   OUTPUT PARAMETERS: OPERAT(NOPER) (R*8);                  ==
C==                      IPRIOR(2,NOPER),NOPER (I*4).          ==
C==                                                            ==
C==   PARAMETER DEFINITIONS:                                   ==
C==   --------- -----------                                    ==
C==                                                            ==
C==   OPERAT: TABLE OF "NOPER"=28 8-CHARACTER STANDARD         ==
C==           MATHEMATICAL AND LOGICAL OPERATORS.              ==
C==                                                            ==
C==   IPRIOR: TABLE OF "NOPER"=28 * 2 OPERATOR PRIORITIES WHICH==
C==           GIVE THE PRECEDENCE OF THE OPERATOR, THE TYPE OF ==
C==           THE OPERATOR (UNARY OR BINARY), AND THE          ==
C==           ASSOCIATIVITY OF THE OPERATOR (LEFT OR RIGHT).   ==
C==           SEE SUBROUTINE "EXEVAL" UNDER "IPRIOR" FOR MORE  ==
C==           DETAILS.                                         ==
C==                                                            ==
C==   NOPER : NOPER=28 IS THE NUMBER OF STANDARD MATHEMATICAL  ==
C==           AND LOGICAL OPERATORS RETURNED BY "EXOPER".      ==
C==                                                            ==
C================================================================
C================================================================
      REAL*8 OPERAT(1),OPER(28)
      INTEGER IPRIOR(2,NOPER),IPRIO(2,28)
C================================================================
C==   DEFINE OPERATORS USING DATA STATEMENT.                   ==
C================================================================
      DATA OPER/'"OR"','|','"XOR"','"\"','"AND"','&','"NOT"','~',
     *'"LT"','<','"EQ"','=','"GT"','>','"LE"','<=','~>',
     *'"NE"','~=','<>','"GE"','>=','~<','+','-','*','/',
     *'**'/
      DATA IPRIO/0,1, 0,1, 0,1, 0,1, 0,2, 0,2, 3,0, 3,0,
     *           0,4, 0,4, 0,4, 0,4, 0,4, 0,4, 0,4, 0,4, 0,4,
     *           0,4, 0,4, 0,4, 0,4, 0,4, 0,4, 5,5, 5,5, 0,6, 0,6,
     *           0,-7/
C================================================================
C==   FILL OPERATOR ARRAYS: "OPERAT" AND "IPRIOR".             ==
C================================================================
      NOPER=28
      DO 100 I=1,NOPER
      CALL MOVEC(8,OPER(I),OPERAT(I))
      DO 200 J=1,2
      IPRIOR(J,I)=IPRIO(J,I)
200   CONTINUE
100   CONTINUE
      RETURN
      END
      SUBROUTINE EXCALC2(NFUN,VARIAB,NVAR,ICODE,
     *                  NCODE,RCODE,NRCODE,CALC,*)
C================================================================
C================================================================
C==                                                            ==
C==   EXCALC: USES THE NUMBER OF FUNCTIONS "NFUN",             ==
C==           THE VARIABLES WITH VALUES STORED IN              ==
C==           "VARIAB", THE CONSTANTS STORED IN "RCODE", AND   ==
C==           THE REVERSE POLISH NOTATION INTEGER*2 CODE:      ==
C==           "ICODE(2,NCODE)" TO CALCULATE THE RESULT "CALC". ==
C==           THE CODE "ICODE" WAS GENERATED PREVIOUSLY USING  ==
C==           "EXEVAL" ON THE ARITHMETIC EXPRESSION AND THE    ==
C==           FUNCTION AND OPERATOR TABLES DEFINED BY "EXTABL" ==
C==           AND "EXOPER". VARIABLES CAN'T HAVE ANY INDICES.  ==
C==           "EXCALC" USES AN INTERNAL REAL*8 STACK:          ==
C==           "STACK(100)" TO CALCULATE THE RESULT "CALC".     ==
C==           IF THE STACK OVERFLOWS OR UNDERFLOWS THEN "EXCALC"=
C==           PRINTS OUT AN ERROR MESSAGE ON UNIT 6 AND RETURNS==
C==           VIA RETURN1.                                     ==
C==           IF THE FINAL STACK INDEX "ISTACK" IS NOT EQUAL TO==
C==           1, I.E. THE BOTTOM OF THE STACK, THEN "EXCALC"   ==
C==           PRINTS OUT AN ERROR MESSAGE ON UNIT 6 AND RETURNS==
C==           VIA RETURN1.                                     ==
C==                                                            ==
C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., JANUARY 3, 1980.==
C==                                                            ==
C==   INPUT  PARAMETERS: NFUN (I*4); VARIAB(NVAR) (R*8);       ==
C==                      NVAR (I*4); ICODE(2,NCODE) (I*2);     ==
C==                      NCODE (I*4); RCODE(NRCODE) (R*8);     ==
C==                      NRCODE (I*4).                         ==
C==                                                            ==
C==   OUTPUT PARAMETERS: CALC (R*8).                           ==
C==                                                            ==
C==   PARAMETER DEFINITIONS:                                   ==
C==   --------- -----------                                    ==
C==                                                            ==
C==   NFUN  : NUMBER OF FUNCTIONS.                             ==
C==                                                            ==
C==   VARIAB: ARRAY OF "NVAR" REAL*8 VALUES CORRESPONDING TO   ==
C==           THE TABLE OF "NVAR" 8-CHARACTER VARIABLE NAMES   ==
C==           "VARIAB" PASSED TO "EXEVAL". THIS ARRAY MUST BE  ==
C==           IN PARALLEL WITH THE TABLE OF VARIABLE NAMES.    ==
C==                                                            ==
C==   NVAR  : NUMBER OF REAL*8 VARIABLE VALUES IN "VARIAB".    ==
C==                                                            ==
C==   ICODE : ARRAY OF "NCODE"*2 INTEGER*2 CODES WHICH         ==
C==           CORRESPOND TO THE REVERSE POLISH FORM OF THE     ==
C==           ARITHMETIC EXPRESSION "EXPRES" WHICH IS PASSED TO==
C==           "EXEVAL". "ICODE" IS RETURNED BY "EXEVAL".       ==
C==           FOR MORE INFORMATION ON "ICODE" SEE "EXEVAL".    ==
C==           "EXCALC" ASSUMES THE FOLLOWING CODES FOR THE     ==
C==           OPERATORS AS DEFINED BY "EXOPER":                ==
C==                                                            ==
C==   ICODE(2,N)    ICODE(1,N)    DESCRIPTION                  ==
C==                                                            ==
C==      -1         2 = BINARY    "OR"  (LOGICAL "OR").        ==
C==      -2         2 = BINARY     |    (LOGICAL "OR").        ==
C==      -3         2 = BINARY    "XOR" (LOGICAL EXCLUSIVE OR).==
C==      -4         2 = BINARY     \    (LOGICAL EXCLUSIVE OR).==
C==      -5         2 = BINARY    "AND" (LOGICAL "AND").       ==
C==      -6         2 = BINARY     &    (LOGICAL "AND").       ==
C==      -7         1 = UNARY     "NOT" (LOGICAL "NOT").       ==
C==      -8         1 = UNARY      ~    (LOGICAL "NOT").       ==
C==      -9         2 = BINARY    "LT"  (LOGICAL LESS THAN).   ==
C==     -10         2 = BINARY     <    (LOGICAL LESS THAN).   ==
C==     -11         2 = BINARY    "EQ"  (LOGICAL EQUALS).      ==
C==     -12         2 = BINARY     =    (LOGICAL EQUALS).      ==
C==     -13         2 = BINARY    "GT"  (LOGICAL GREATER THAN).==
C==     -14         2 = BINARY     >    (LOGICAL GREATER THAN).==
C==     -15         2 = BINARY    "LE"  (LESS THAN OR EQUALS). ==
C==     -16         2 = BINARY     <=   (LESS THAN OR EQUALS). ==
C==     -17         2 = BINARY     ~>   (NOT GREATER THAN, OR  ==
C==                                      LESS THAN OR EQUALS). ==
C==     -18         2 = BINARY    "NE"  (LOGICAL NOT EQUALS).  ==
C==     -19         2 = BINARY     ~=   (LOGICAL NOT EQUALS).  ==
C==     -20         2 = BINARY     <>   (LOGICAL NOT EQUALS).  ==
C==     -21         2 = BINARY    "GE"  (GREATER THAN OR EQUALS)=
C==     -22         2 = BINARY     >=   (GREATER THAN OR EQUALS)=
C==     -23         2 = BINARY     ~<   (NOT LESS THAN, OR     ==
C==                                      GREATER THAN OR EQUALS)=
C==     -24         1 = UNARY      +    (PLUS).                ==
C==                 2 = BINARY                                 ==
C==     -25         1 = UNARY      -    (MINUS).               ==
C==                 2 = BINARY                                 ==
C==     -26         2 = BINARY     *    (MULTIPLICATION).      ==
C==     -27         2 = BINARY     /    (DIVISION).            ==
C==     -28         2 = BINARY     **   (EXPONENTIATION).      ==
C==                                                            ==
C==     NOTE: LOGICAL OPERATORS MAY HAVE ARITHMETIC OPERANDS   ==
C==           AS IN "GT" OR THEY MAY HAVE LOGICAL OPERANDS     ==
C==           AS IN "OR". THE RESULT OF A LOGICAL OPERATOR IS  ==
C==           ALWAYS LOGICAL. ALL THE OPERANDS AND RESULTS OF  ==
C==           LOGICAL OPERATORS ARE STORED AS REAL*8 NUMBERS.  ==
C==           WE USE THE FOLLOWING CONVENTION TO INTERPRET     ==
C==           LOGICAL OPERANDS AND TO DEFINE LOGICAL RESULTS:  ==
C==        1) IF A REAL*8 NUMBER "R" IS A LOGICAL OPERAND THEN ==
C==           ITS LOGICAL VALUES ARE ".TRUE." IF "R" IS        ==
C==           NON-ZERO AND ".FALSE." IF R IS ZERO.             ==
C==        2) IF A REAL*8 NUMBER "R" IS A LOGICAL RESULT THEN  ==
C==           IT IS STORED AS "1.D0" IF IT IS ".TRUE.", AND    ==
C==           IT IS STORED AS "0.D0" IF IT IS ".FALSE." .      ==
C==                                                            ==
C==                                                            ==
C==   NCODE : NUMBER OF INTEGER*2 CODES IN "ICODE(2,NCODE)".   ==
C==                                                            ==
C==   RCODE : ARRAY OF "NRCODE" REAL*8 CONSTANTS WHICH APPEAR  ==
C==           IN THE EXPRESSION "EXPRES" PASSED TO "EXEVAL".   ==
C==           SEE "EXEVAL".                                    ==
C==                                                            ==
C==   NRCODE: NUMBER OF REAL*8 CONSTANTS STORED IN "RCODE".    ==
C==                                                            ==
C==   CALC  : REAL*8 VALUE WHICH IS THE FINAL RESULT OF THE    ==
C==           CALCULATION OF THE REVERSE POLISH CODE "ICODE".  ==
C==           IF "NCODE" <= 0 THEN "CALC" IS RETURNED AS 0.D0. ==
C==           IF AN ERROR OCCURS DUE TO AN OVERFLOW, UNDERFLOW,==
C==           OR IF THE FINAL STACK INDEX IS NOT 1, THEN       ==
C==           "CALC" IS RETURNED AS 0.D0.                      ==
C==                                                            ==
C================================================================
C================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER*2 ICODE(2,1)
      REAL*8 VARIAB(1),RCODE(1),STACK(100)
      LOGICAL*1 TRUE
C================================================================
C==   CALC DEFAULTS TO 0.D0                                    ==
C================================================================
      CALC=0.D0
      IF(NCODE.LE.0)RETURN
C================================================================
C==   INITIALIZE THE STACK INDEX "ISTACK" TO 0.                ==
C================================================================
      ISTACK=0
      NFNV=NFUN+NVAR
      DO 1000 I=1,NCODE
      ICODE2=ICODE(2,I)
      IF(ICODE2.GT.0)GO TO 1300
C================================================================
C==   "ICODE2" CORRESPONDS TO OPERATOR "OPERAT(|ICODE2|)".     ==
C==   SEE ABOVE TABLE UNDER "ICODE" PARAMETER DEFINTION.       ==
C==   SAVE "ISTACK" IN "ISTAC1" AND DECREMENT "ISTACK" BY 1.   ==
C==   IF "ICODE1" = 1 THEN THE OPERATOR IS UNARY AND "ISTAC1"  ==
C==                   IS USED. CHECK "ISTAC1" FOR AN UNDERFLOW.==
C==   IF "ICODE1" = 2 THEN THE OPERATOR IS BINARY AND "ISTACK" ==
C==                   IS USED. CHECK "ISTACK" FOR AN UNDERFLOW.==
C================================================================
      ICODE2=-ICODE2
      ISTAC1=ISTACK
      ISTACK=ISTACK-1
      ICODE1=ICODE(1,I)
C================================================================
C==   CHECK FOR AN UNDERFLOW. IF AN UNDERFLOW OCCURS GO TO 2100==
C================================================================
      GO TO (1001,1002),ICODE1
1001  IF(ISTAC1.LE.0)GO TO 2100
      GO TO 1005
1002  IF(ISTACK.LE.0)GO TO 2100
C================================================================
C==   GO TO THE SECTION CORRESPONDING TO THE OPERATOR CODE     ==
C==   "ICODE2".                                                ==
C================================================================
1005  GO TO (1010,1010,1020,1020,1030,1030,1040,1040,1050,1050,
     *       1060,1060,1070,1070,1080,1080,1080,1090,1090,1090,
     *       1100,1100,1100,1110,1120,1130,1140,1150),ICODE2
      GO TO 1000
C================================================================
C==   ICODE2 = -1 OR -2: LOGICAL "OR".                         ==
C================================================================
1010  TRUE=STACK(ISTACK).NE.0.D0 .OR. STACK(ISTAC1).NE.0.D0
      GO TO 1105
C================================================================
C==   ICODE2 = -3 OR -4: LOGICAL EXCLUSIVE OR: "XOR".          ==
C================================================================
1020  TRUE=(STACK(ISTACK).EQ.0.D0.OR.STACK(ISTACK).EQ.0.D0).AND.
     *     (STACK(ISTACK)+STACK(ISTAC1).NE.0.D0)
      GO TO 1105
C================================================================
C==   ICODE2 = -5 OR -6: LOGICAL "AND".                        ==
C================================================================
1030  TRUE=STACK(ISTACK).NE.0.D0 .AND. STACK(ISTAC1).NE.0.D0
      GO TO 1105
C================================================================
C==   ICODE2 = -7 OR -8: LOGICAL "NOT" (UNARY).                ==
C================================================================
1040  ISTACK=ISTAC1
      TRUE=STACK(ISTACK).EQ.0.D0
      GO TO 1105
C================================================================
C==   ICODE2 = -9 OR -10: LOGICAL LESS THAN "LT".              ==
C================================================================
1050  TRUE=STACK(ISTACK).LT.STACK(ISTAC1)
      GO TO 1105
C================================================================
C==   ICODE2 = -11 OR -12: LOGICAL EQUALS "EQ".                ==
C================================================================
1060  TRUE=STACK(ISTACK).EQ.STACK(ISTAC1)
      GO TO 1105
C================================================================
C==   ICODE2 = -13 OR -14: LOGICAL GREATER THAN "GT".          ==
C================================================================
1070  TRUE=STACK(ISTACK).GT.STACK(ISTAC1)
      GO TO 1105
C================================================================
C==   ICODE2 = -15, -16, OR -17: LOGICAL LESS THAN OR EQUALS   ==
C==                              "LE".                         ==
C================================================================
1080  TRUE=STACK(ISTACK).LE.STACK(ISTAC1)
      GO TO 1105
C================================================================
C==   ICODE2 = -18, -19, OR -20: LOGICAL NOT EQUALS "NE".      ==
C================================================================
1090  TRUE=STACK(ISTACK).NE.STACK(ISTAC1)
      GO TO 1105
C================================================================
C==   ICODE2 = -21, -22, OR -23: LOGICAL GREATER THAN OR EQUALS==
C==                              "GE".                         ==
C================================================================
1100  TRUE=STACK(ISTACK).GE.STACK(ISTAC1)
C================================================================
C==   STORE LOGICAL RESULT IN STACK(ISTACK).                   ==
C==   .TRUE. = 1.D0; .FALSE. = 0.D0.                           ==
C================================================================
1105  STACK(ISTACK)=0.D0
      IF(TRUE)STACK(ISTACK)=1.D0
      GO TO 1000
C================================================================
C==   ICODE2 = -24: PLUS, (UNARY OR BINARY).                   ==
C================================================================
1110  GO TO (1111,1112),ICODE1
C================================================================
C==   UNARY PLUS.                                              ==
C================================================================
1111  ISTACK=ISTAC1
      GO TO 1000
C================================================================
C==   BINARY PLUS.                                             ==
C================================================================
1112  STACK(ISTACK)=STACK(ISTACK)+STACK(ISTAC1)
      GO TO 1000
C================================================================
C==   ICODE2 = -25: MINUS, (UNARY OR BINARY).                  ==
C================================================================
1120  GO TO (1121,1122),ICODE1
C================================================================
C==   UNARY MINUS.                                             ==
C================================================================
1121  ISTACK=ISTAC1
      STACK(ISTACK)=-STACK(ISTACK)
      GO TO 1000
C================================================================
C==   BINARY MINUS.                                            ==
C================================================================
1122  STACK(ISTACK)=STACK(ISTACK)-STACK(ISTAC1)
      GO TO 1000
C================================================================
C==   ICODE2 = -26: MULTIPLICATION.                            ==
C================================================================
1130  STACK(ISTACK)=STACK(ISTACK)*STACK(ISTAC1)
      GO TO 1000
C================================================================
C==   ICODE2 = -27: DIVISION.                                  ==
C================================================================
1140  STACK(ISTACK)=STACK(ISTACK)/STACK(ISTAC1)
      GO TO 1000
C================================================================
C==   ICODE2 = -28: EXPONENTIATION.                            ==
C================================================================
1150  STACK1=STACK(ISTAC1)
      IPOWER=STACK1+DSIGN(.5D0,STACK1)
      IF(DABS(STACK1-IPOWER).LE.1.D-14)GO TO 1151
      STACK(ISTACK)=STACK(ISTACK)**STACK1
      GO TO 1000
1151  STACK(ISTACK)=STACK(ISTACK)**IPOWER
      GO TO 1000
1300  IF(ICODE2.GT.NFUN)GO TO 1400
C================================================================
C==   "ICODE2" CORRESPONDS TO THE FUNCTION NUMBER "ICODE2".    ==
C==   NARG = ICODE(1,I) = NUMBER OF FUNCTION ARGUMENTS.        ==
C==   IF "ISTACK" UNDERFLOWS GO TO 2100.                       ==
C================================================================
      NARG=ICODE(1,I)
      ISTACK=ISTACK-NARG+1
      IF(ISTACK.LE.0)GO TO 2100
C================================================================
C==   GO TO THE APPROPRIATE FUNCTION GIVEN BY "ICODE2".        ==
C================================================================
      GO TO
     * ( 1, 1, 1, 1, 5, 5, 7, 7, 9, 9,11,11,11,11,15,15,15,15,19,19,
     *  19,19,23,23,23,23,23,23,29,29,29,29,29,29,35,35,35,35,35,35,
     *  41,41,41,41,41,41,47,47,49,49,51,51,53,53,53,53,57,57,57,57,
     *  61,61,61,61,65,65,65,65,65,65,71,71,71,71,75,75,77,77),ICODE2
      GO TO 1000
1     STACK(ISTACK)=LOG(STACK(ISTACK))
      GO TO 1000
5     STACK(ISTACK)=LOG10(STACK(ISTACK))
      GO TO 1000
7     STACK(ISTACK)=EXP(STACK(ISTACK))
      GO TO 1000
9     STACK(ISTACK)=SQRT(STACK(ISTACK))
      GO TO 1000
11    STACK(ISTACK)=SIN(STACK(ISTACK))
      GO TO 1000
15    STACK(ISTACK)=COS(STACK(ISTACK))
      GO TO 1000
19    STACK(ISTACK)=TAN(STACK(ISTACK))
      GO TO 1000
23    STACK(ISTACK)=ASIN(STACK(ISTACK))
      GO TO 1000
29    STACK(ISTACK)=ACOS(STACK(ISTACK))
      GO TO 1000
35    STACK(ISTACK)=ATAN(STACK(ISTACK))
      GO TO 1000
41    STACK(ISTACK)=ATAN2(STACK(ISTACK),STACK(ISTACK+1))
      GO TO 1000
47    STACK(ISTACK)=SINH(STACK(ISTACK))
      GO TO 1000
49    STACK(ISTACK)=COSH(STACK(ISTACK))
      GO TO 1000
51    STACK(ISTACK)=TANH(STACK(ISTACK))
      GO TO 1000
53    STACK(ISTACK)=ABS(STACK(ISTACK))
      GO TO 1000
57    STACK(ISTACK)=MAX(STACK(ISTACK),STACK(ISTACK+1))
      GO TO 1000
61    STACK(ISTACK)=MIN(STACK(ISTACK),STACK(ISTACK+1))
      GO TO 1000
65    STACK(ISTACK)=AINT(STACK(ISTACK))
      GO TO 1000
71    STACK(ISTACK)=MOD(STACK(ISTACK),STACK(ISTACK+1))
      GO TO 1000
75    STACK(ISTACK)=SIGN(STACK(ISTACK),STACK(ISTACK+1))
      GO TO 1000
77    STACK(ISTACK)=DIM(STACK(ISTACK),STACK(ISTACK+1))
      GO TO 1000
1400  IF(ICODE2.GT.NFNV)GO TO 1500
C================================================================
C==   "ICODE2" CORRESPONDS TO A VARIABLE "VARIAB(ICODE2-NFUN)".==
C==   PUSH "VARIAB(ICODE2-NFUN)" ONTO THE STACK.               ==
C==   IF THE STACK OVERFLOWS GO TO 2000.                       ==
C================================================================
      IF(ISTACK.GE.100)GO TO 2000
      ISTACK=ISTACK+1
      STACK(ISTACK)=VARIAB(ICODE2-NFUN)
      GO TO 1000
C================================================================
C==   "ICODE2" CORRESPONDS TO A REAL*8 CONSTANT                ==
C==   "RCODE(ICODE2-NFNV)". PUSH "RCODE(ICODE2-NFNV)" ONTO THE ==
C==   STACK. IF THE STACK OVERFLOWS GO TO 2000.                ==
C================================================================
1500  IF(ISTACK.GE.100)GO TO 2000
      ISTACK=ISTACK+1
      STACK(ISTACK)=RCODE(ICODE2-NFNV)
1000  CONTINUE
C================================================================
C==   IF THE FINAL STACK INDEX "ISTACK" IS NOT EQUAL TO 1, I.E.==
C==   THE BOTTOM OF THE STACK THEN GO TO 2200.                 ==
C==   OTHERWISE STORE THE RESULT OF THE CALCULATION IN "CALC". ==
C================================================================
      IF(ISTACK.NE.1)GO TO 2200
      CALC=STACK(ISTACK)
      RETURN
C================================================================
C==   ERROR MESSAGES ON UNIT 6.                                ==
C================================================================
2000  WRITE(6,2010)
2010  FORMAT(' ***ERROR*** STACK OVERFLOW IN "EXCALC".')
      RETURN1
2100  WRITE(6,2110)
2110  FORMAT(' ***ERROR*** STACK UNDERFLOW IN "EXCALC".'/
     *       '             THIS MEANS THE REVERSE POLISH CODE "ICODE"',
     *       ' IS INVALID.')
      RETURN1
2200  WRITE(6,2210)ISTACK
2210  FORMAT(' ***ERROR*** FINAL VALUE OF ISTACK =',I3,'IN "EXCALC".',
     *       '             THIS MEANS THE REVERSE POLISH CODE "ICODE"',
     *       ' IS INVALID.')
      RETURN1
      END
#endif
