      FUNCTION CPU_TIME(DUM)
C======================================================================C
C   Returns the absolute CPU time in seconds consumed to date
C   by the process.
C
C    Refer to C.KOST for any problems. JULY 16 1981
C
C    REFERENCE: PAGE 6-10 OF VAX-11 FORTRAN USER'S GUIDE
C    APR/82 EDITION, OR PAGE 3-10 OF SEPT/84 EDITION.
C    & PAGE SYS-192 OF VAX SYSTEM SERVICES REFERENCE MANUAL.
C    SEPT/1984 EDITION.
C
C    Modified 06-NOV-91 by F. Jones:  UNIX support added
C======================================================================C

#ifdef VMS
C   Set up implicit data types so that the data types indicate sizes
      IMPLICIT INTEGER*2 (W), INTEGER*4 (L)
      INCLUDE '($JPIDEF)'
      INTEGER ICPU
C   Initialize all static values in the item list
      DATA W_LEN1,W_LEN2/2*4/
      DATA W_CODE1 /JPI$_CPUTIM/
      DATA W_CODE2 /0/
      DATA L_LENADDR1/0/
      INTEGER*4 LCL_VALUE
C   Place the SYS$GETJPI item list in a COMMON block so as to be
C   contiguous.
      COMMON/ITEMTIM/W_LEN1,W_CODE1,L_ADDR1,L_LENADDR1,
     &                W_LEN2,W_CODE2

C   Item fields requiring addresses must be assigned at run time.
      L_ADDR1=%LOC(LCL_VALUE)
C   Perform the system service call
      CALL SYS$GETJPI(,,,W_LEN1,,,)
      ICPU=LCL_VALUE
      CPU_TIME=0.01*ICPU
#elif unix
#ifdef g77
      CPU_TIME=0.
#elif gfortran
      CPU_TIME=0.
#else
      REAL TARRAY(2)
      CPU_TIME=ETIME(TARRAY)
#endif
#endif
      RETURN
      END
