      SUBROUTINE DITHER(XPOL,YPOL,NVERT,IX,IY,ERASE)
C
C  J.L. Chuma                         November, 1990
C
C  Fills a polygonal area with a "dithering" pattern of dots.
C
C  Input:
C
C  XPOL,YPOL  Arrays containing the X and Y coordinates of the
C             vertices of the polygon in world coordinates
C
C  NVERT      The number of vertices (maximum 1000)
C
C  IX         The dithering number in the horizontal direction (0 to 9)
C  IY         The dithering number in the vertical direction (0 to 9)
C
C  ERASE      If true, erase the dot pattern
C
C      Modified by J. Chuma, March 7, 1997.  Eliminated the "$" from
C      common block and variable names for LINUX g77
C
      REAL*4  XPOL(1), YPOL(1)
      LOGICAL*1 ERASE
C
C Working arrays
C
      REAL*4 XPW(1001), YPW(1001), XINT(1000)
C
      LOGICAL FINT
      LOGICAL SEGMENT_CROSSH
C
      COMMON /PLOT_OUTPUT_UNIT/ IOUTS
      COMMON /PLOTMONITOR/     IMONITOR,  IOUTM
      COMMON /PLOTMONITOR2/    IMONITOR2,  IOUTM2
      COMMON /HARDCOPYRANGE/   XMINHP, XMAXHP, YMINHP, YMAXHP, IORIENTH
C
      LOGICAL WELL, WELL_SAVE
      COMMON /TO_BIT_OR_NOT/ WELL
C
      COMMON /PLOT_LEVEL/ ILEV
C
      LOGICAL CTRLC_CALLED
      COMMON /CTRLC/ CTRLC_CALLED
C                                     
      WELL_SAVE      = WELL
      IMONITOR_SAVE  = IMONITOR
      IMONITOR2_SAVE = IMONITOR2
      IPLEV          = ILEV
C
      IF( NVERT .GT. 1000 )RETURN
C
      IF( IX .GT. 9 )IX = 9
      IF( IX .LE. 0 )IX = 1
      IF( IY .GT. 9 )IY = 9
      IF( IY .LE. 0 )IY = 1
C
C Load the vertices into the working arrays
C
      DO I = 1, NVERT
        XPW(I) = XPOL(I)
        YPW(I) = YPOL(I)
      END DO
      NPT = NVERT
C
C Add closing vertex if needed
C
      IF( (XPW(NPT).NE.XPW(1)) .OR. (YPW(NPT).NE.YPW(1)) )THEN
        NPT = NPT+1
        XPW(NPT) = XPW(1)
        YPW(NPT) = YPW(1)
      END IF
      IF( NPT.LT.3 )RETURN
C
C Find the extent of the polygon
C
      CALL MINMAX(XPW,NPT,XMIN,XMAX)
      CALL MINMAX(YPW,NPT,YMIN,YMAX)
      IF( (XMIN.EQ.XMAX) .OR. (YMIN.EQ.YMAX) )RETURN
      CALL PIXEL_EXTENT(XMIN,XMAX,YMIN,YMAX
     & ,XINC, YINC, NXMIN, NXMAX, NYMIN, NYMAX
     & ,XINCB,YINCB,NXMINB,NXMAXB,NYMINB,NYMAXB)
C
C   First do the screen picture
C
      IF( CTRLC_CALLED )GO TO 1000
C
C  turn off 2nd monitor if it is a pen plotter
C
      IF( (IMONITOR2.EQ. 4) .OR. (IMONITOR2.EQ. 5) .OR.
     &    (IMONITOR2.EQ.11) .OR. (IMONITOR2.EQ.20) )IMONITOR2 = 0
      IF( ERASE )CALL PLOT_DATA_LEVEL(1)
      WELL = .FALSE.
C
C    Initial coordinates of scan line
C
      DDX = (XMAX-XMIN)/2.
      X1 = XMIN-DDX
      X2 = XMAX+DDX
      NY = NYMIN
      YH = YMINHP+(NY-1)*YINC
C
C   Find the intersections of the scan line with the polygon edges
C
20    IF( NY/IY*IY .NE. NY )GO TO 100
      IF( CTRLC_CALLED )GO TO 999
      NINT = 0
      DO 80 I = 1, NPT-1
        IF( (YH-YPW(I))*(YH-YPW(I+1)) .GT. 0. )GO TO 80
        FINT = 
     &   SEGMENT_CROSSH(XPW(I),YPW(I),XPW(I+1),YPW(I+1),X1,X2,YH,XC,YC)
        IF( .NOT.FINT )GO TO 80
C
        IF( (XC.NE.XPW(I)) .OR. (YC.NE.YPW(I)) )GO TO 60
C
C   Scan line intersects beginning point of segment
C    check previous segments to determine configuration
C
        K = I
50      K = K-1
        IF( K.LT.1 )K = K+NPT-1
        TEST = (YH-YPW(K))*(YH-YPW(I+1))
        IF( TEST.LT.0. )GO TO 80
        IF( TEST.GT.0. )GO TO 60
        GO TO 50
C
C   Record the intersection
C
60      NINT = NINT+1
        XINT(NINT) = XC
80    CONTINUE
C
      IF( NINT.EQ.0 )GO TO 100
C
C    Sanity check: NINT should be even
C
      IF( MOD(NINT,2).NE.0 )GO TO 100
C
C    Bubble sort the intersections into ascending order in X
C
      DO IEND = NINT-1, 1, -1
        DO I = 1, IEND
          IF( XINT(I).GT.XINT(I+1) )THEN
            XSAVE = XINT(I+1)
            XINT(I+1) = XINT(I)
            XINT(I) = XSAVE
          END IF
        END DO
      END DO
C
C    Draw portions of scan line that are "inside" the polygon
C
      DO I = 1, NINT-1, 2
        IF( CTRLC_CALLED )GO TO 999
        IF( XINT(I).NE.XINT(I+1) )THEN
          IX1 = MAX(NXMIN,MIN(NXMAX,IFIX((XINT(I)  -XMINHP)/XINC)+2))
          IX2 = MAX(NXMIN,MIN(NXMAX,IFIX((XINT(I+1)-XMINHP)/XINC)+1))
          DO J = IX1, IX2
            IF( J/IX*IX .EQ. J )CALL PLOT_R(XMINHP+(J-1)*XINC,YH,20)
          END DO
        END IF
      END DO
C
C   Get next scan line
C
100   NY = NY+1
      IF( NY .GT. NYMAX )GO TO 200
      YH = YMINHP+(NY-1)*YINC
      GO TO 20
C
C    Now do the bitmap, if the bitmap is on
C
200   CALL FLUSH_PLOT
      WELL = WELL_SAVE
      IF( .NOT.WELL )GO TO 999
C      CALL TRANSPARENT_MODE(0)
C      CALL TRANSPARENT_MODE2(0)
C      WRITE(IOUTS,*)'Making bitmap... Please wait...'
      IMONITOR = 0
      NY = NYMINB
      YH = YMINHP+(NY-1)*YINCB
C
C   Find the intersections of the scan line with the polygon edges
C
220   IF( NY/IY*IY .NE. NY )GO TO 300
      IF( CTRLC_CALLED )GO TO 999
      NINT = 0
      DO 280 I = 1, NPT-1
        IF( (YH-YPW(I))*(YH-YPW(I+1)) .GT. 0. )GO TO 280
        FINT = 
     &   SEGMENT_CROSSH(XPW(I),YPW(I),XPW(I+1),YPW(I+1),X1,X2,YH,XC,YC)
        IF( .NOT.FINT )GO TO 280
C
        IF( (XC.NE.XPW(I)) .OR. (YC.NE.YPW(I)) )GO TO 260
C
C   Scan line intersects beginning point of segment
C    check previous segments to determine configuration
C
        K = I
250     K = K-1
        IF( K.LT.1 )K = K+NPT-1
        TEST = (YH-YPW(K))*(YH-YPW(I+1))
        IF( TEST.LT.0. )GO TO 280
        IF( TEST.GT.0. )GO TO 260
        GO TO 250
C
C   Record the intersection
C
260     NINT = NINT+1
        XINT(NINT) = XC
280   CONTINUE
C
      IF( NINT.EQ.0 )GO TO 300
C
C   Sanity check: NINT should be even
C
      IF( MOD(NINT,2).NE.0 )GO TO 300
C
C   Bubble sort the intersections into ascending order in X
C
      DO IEND = NINT-1, 1, -1
        DO I = 1, IEND
          IF( XINT(I).GT.XINT(I+1) )THEN
            XSAVE = XINT(I+1)
            XINT(I+1) = XINT(I)
            XINT(I) = XSAVE
          END IF
        END DO
      END DO
C
C   Draw portions of scan line that are "inside" the polygon
C
      DO I = 1, NINT-1, 2
        IF( CTRLC_CALLED )GO TO 999
        IF( XINT(I).NE.XINT(I+1) )THEN
          IX1 = MAX(NXMINB,MIN(NXMAXB,IFIX((XINT(I)  -XMINHP)/XINCB)+2))
          IX2 = MAX(NXMINB,MIN(NXMAXB,IFIX((XINT(I+1)-XMINHP)/XINCB)+1))
          DO J = IX1, IX2
            IF( J/IX*IX .EQ. J )CALL PLOT_R(XMINHP+(J-1)*XINCB,YH,20)
          END DO
        END IF
      END DO
C
C   Get next scan line
C
300   NY = NY+1
      IF( NY .GT. NYMAXB )GO TO 999
      YH = YMINHP+(NY-1)*YINCB
      GO TO 220
999   IMONITOR = IMONITOR_SAVE
      IMONITOR2 = IMONITOR2_SAVE
      CALL PLOT_DATA_LEVEL(IPLEV)
1000  RETURN
      END
