      SUBROUTINE ELLCON(ANGLE,A,B,AREA,R12,XINT,YINT,XMAX,YMAX,
     * YATXM,XATYM)
C
C     LIBRARY-ROUTINE
C
C                                                05/AUG/1980
C                                                C.J. KOST SIN
C
C     reqd. routines - NONE
C
C================================================================
C==                                                            ==
C==   ELLCON: CONVERTS THE INPUT ELLIPSE COORDINATES: ANGLE,A,B==
C==           INTO THE OUTPUT QUANTITIES: AREA,R12,XINT,YINT,  ==
C==           XMAX,YMAX,YATXM,XATYM. THESE PARAMETERS ARE      ==
C==           DESCRIBED BELOW:                                 ==
C==                                                            ==
C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., SEPT 1978.      ==
C==                                                            ==
C==   INPUT  PARAMETERS: ANGLE,A,B (R*4).                      ==
C==   OUTPUT PARAMETERS: AREA,R12,XINT,YINT,XMAX,YMAX,YATXM,   ==
C==                      XATYM (R*4).                          ==
C==                                                            ==
C==   ANGLE : ANGLE OF THE ELLIPSE SEMI-MAJOR AXIS A RELATIVE  ==
C==           TO THE POSITIVE X-AXIS IN DEGREES.               ==
C==   A     : SEMI-MAJOR AXIS OF THE ELLIPSE.                  ==
C==   B     : SEMI-MINOR AXIS OF THE ELLIPSE.                  ==
C==           NOTE: B MAY BE GREATER THAN A.                   ==
C==   AREA  : AREA OF THE ELLIPSE = PI*A*B.                    ==
C==                                                            ==
C==   FOR THE FOLLOWING PARAMETERS THE X-AXIS AND Y-AXIS ARE   ==
C==   ASSUMED TO PASS THROUGH THE CENTER OF THE ELLIPSE:       ==
C==                                                            ==
C==   R12   : CORRELATION COEFFICIENT OF THE ELLIPSE.          ==
C==   XINT  : POSITIVE X-INTERCEPT OF THE ELLIPSE.             ==
C==   YINT  : POSITIVE Y-INTERCEPT OF THE ELLIPSE.             ==
C==           NOTE: EQUATION OF ELLIPSE IS:                    ==
C==           X**2/XI**2-2*R12*X*Y/XI/YI+Y**2/YI**2 = 1        ==
C==           WHERE XI = X-INTERCEPT, YI = Y-INTERCEPT.        ==
C==   XMAX  : MAXIMUM X-COORDINATE OF THE ELLIPSE (X 1/2 WIDTH)==
C==   YMAX  : MAXIMUM Y-COORDINATE OF THE ELLIPSE (Y 1/2 WIDTH)==
C==   YATXM : Y COORDINATE OF THE ELLIPSE AT XMAX.             ==
C==   XATYM : X COORDINATE OF THE ELLIPSE AT YMAX.             ==
C==                                                            ==
C==   THE ABOVE PARAMETERS ARE CALCULATED FROM ANGLE,A,B USING ==
C==   THE FOLLOWING FORMULAS:                                  ==
C==                                                            ==
C==   AREA  = PI*A*B.                                          ==
C==   XMAX  = SQRT((A*COS(ANGLE))**2+(B*SIN(ANGLE))**2).       ==
C==   YMAX  = SQRT((A*SIN(ANGLE))**2+(B*COS(ANGLE))**2).       ==
C==   XINT  = (A*B)/YMAX  IF YMAX .NE. 0.                      ==
C==         = 0.          IF YMAX = 0.                         ==
C==   YINT  = (A*B)/XMAX  IF XMAX .NE. 0.                      ==
C==         = 0.          IF XMAX = 0.                         ==
C==   R12   = SIGN*SQRT(1.-(A*B/XMAX/YMAX)**2),                ==
C==           WHERE SIGN = SIGN(1.,SINCOS*(A**2-B**2))         ==
C==                      = +1 OR -1 IF SINCOS*(A**2-B**2) NE 0.==
C==                      =  0       IF SINCOS*(A**2-B**2) =  0.==
C==               SINCOS = SIN(ANGLE) * COS(ANGLE).            ==
C==                                                            ==
C==   YATXM = R12*YMAX.                                        ==
C==   XATYM = R12*XMAX.                                        ==
C==                                                            ==
C================================================================
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL ANGLE,A,B,AREA,R12,XINT,YINT,XMAX,YMAX,YATXM,XATYM
      DATA PI/3.14159265358979323846264D0/
C================================================================
C==   CALCULATE AREA.                                          ==
C================================================================
      AB=ABS(A*B)
      AREA=PI*AB
C================================================================
C==   CALCULATE XMAX AND YMAX.                                 ==
C================================================================
      ANGL=ANGLE*PI/180.D0
      COSA=DCOS(ANGL)
      SINA=DSIN(ANGL)
      SINCOS=SINA*COSA
      ASQ=A*A
      BSQ=B*B
      COSSQ=COSA*COSA
      SINSQ=SINA*SINA
      DXMAX=DSQRT(ASQ*COSSQ+BSQ*SINSQ)
      DYMAX=DSQRT(ASQ*SINSQ+BSQ*COSSQ)
      XMAX=DXMAX
      YMAX=DYMAX
C================================================================
C==   CALCULATE XINT AND YINT.                                 ==
C================================================================
      XINT=0.
      IF(DYMAX.GT.0.D0)XINT=AB/DYMAX
      YINT=0.
      IF(DXMAX.GT.0.D0)YINT=AB/DXMAX
C================================================================
C==   CALCULATE R12.                                           ==
C================================================================
      COEFF=0.D0
      IF(DXMAX*DYMAX.GT.0.D0)COEFF=1.D0-(AB/DXMAX/DYMAX)**2
      IF(COEFF.LT.0.D0)COEFF=0.D0
      SIGNR=SINCOS*(ASQ-BSQ)
      R12=0.
      IF(SIGNR.NE.0.D0)R12=DSQRT(COEFF)*DSIGN(1.D0,SIGNR)
C================================================================
C==   CALCULATE YATXM AND XATYM.                               ==
C================================================================
      YATXM=R12*YMAX
      XATYM=R12*XMAX
      RETURN
      END
