      SUBROUTINE FORMSG
C======================================================================C
C                                                                      C
C  FORMSG                                          F.W. Jones, TRIUMF  C
C                                                                      C
C  Puts out diagnostic messages for the last FORTRAN run-time error.   C
C                                                                      C
C  System messages are written out for each condition or status code   C
C  that resulted from the error.  For example, in the case of an open  C
C  failure on a file, the system messages will usually indicate why    C
C  the file could not be opened.                                       C
C                                                                      C
C  Example:                                                            C
C                                                                      C
C        CHARACTER*10 FOO                                              C
C        FOO=')JUNK'                                                   C
C        OPEN(UNIT=1,FILE=FOO,STATUS='UNKNOWN',IOSTAT=IERR)            C
C        IF(IERR.NE.0)THEN                                             C
C          WRITE(*,*)'Error opening file ',FOO                         C
C          CALL FORMSG                                                 C
C        ENDIF                                                         C
C                                                                      C
C  Produces the following output on SYS$OUTPUT:                        C
C                                                                      C
C    Error opening file )JUNK                                          C
C    %RMS-F-SYN, file specification syntax error                       C
C    %FOR-F-FILNAMSPE, file name specification error                   C
C                                                                      C
C======================================================================C
#ifdef VMS
      CALL ERRSNS(IERR,ISTS,ISTV,IUNIT,ICOND)     !sense the last error
      IF(IERR.EQ.0)RETURN      !no error condition
C Put out the relevant system messages:
      IF(ISTS.NE.0)THEN
        CALL SYSMSG(ISTS)
      ENDIF
      IF(ISTV.NE.0)THEN
        CALL SYSMSG(ISTV)
      ENDIF
      IF(ICOND.NE.0)THEN
        CALL SYSMSG(ICOND)
      ENDIF
#else
      CALL PERROR(' ')
#endif
      RETURN
      END
