      SUBROUTINE GET_HARDTYPE(NAME)
C======================================================================C
C                                                                      C
C  GET_HARDTYPE                                    F.W. Jones, TRIUMF  C
C                                                                      C
C  Returns a name indicating a hardcopy device type.                   C
C  The name is obtained by translating the logical name                C
C    TRIUMF_HARDCOPY_TYPE.                                             C
C                                                                      C
C  Input: none                                                         C
C                                                                      C
C  Output:                                                             C
C                                                                      C
C    NAME   Character string which receives the device name.           C
C           If the hardcopy type is undefined or cannot be obtained,   C
C           NAME will be blank-filled.                                 C
C                                                                      C
C======================================================================C
#ifdef VMS
      INCLUDE '($SSDEF)'
      CHARACTER*(*) NAME
      ISTAT=LIB$SYS_TRNLOG('TRIUMF_HARDCOPY_TYPE',,NAME)
      IF(.NOT.ISTAT.OR.ISTAT.EQ.SS$_NOTRAN)NAME=' '
#else
      CHARACTER*(*) NAME
      CALL GETENV('TRIUMF_HARDCOPY_TYPE',NAME)
      CALL UPRCASE(NAME,NAME)
#endif
      RETURN
      END
