      SUBROUTINE GET_PLOTTERTYPE(NAME)
C======================================================================C
C                                                                      C
C  GET_PLOTTERTYPE                                   J. Chuma, TRIUMF  C
C                                                                      C
C  Returns a device name indicating the process plotter type.          C
C  The name is obtained by translating the logical name                C
C    TRIUMF_PLOTTER_TYPE.                                              C
C  The plotter type can be set using the PLOTTERTYPE DCL procedure.    C
C                                                                      C
C  Input: none                                                         C
C                                                                      C
C  Output:                                                             C
C                                                                      C
C    NAME   Character string which receives the device name.           C
C           If the plotter type is undefined or cannot be obtained,    C
C           NAME will be blank-filled.                                 C
C                                                                      C
C  Example:                                                            C
C                                                                      C
C      CHARACTER*6 NAME                                                C
C      CALL GET_PLOTTERTYPE(NAME)                                      C
C      WRITE(6,*)'NAME=',NAME                                          C
C      IF(NAME.EQ.'HP    ')WRITE(6,*)'HP type recognized by caller'    C
C      END                                                             C
C                                                                      C
C======================================================================C
#ifdef VMS
      INCLUDE '($SSDEF)'
      CHARACTER*(*) NAME
      ISTAT=LIB$SYS_TRNLOG('TRIUMF_PLOTTER_TYPE',,NAME)
      IF(.NOT.ISTAT.OR.ISTAT.EQ.SS$_NOTRAN)NAME=' '
#endif
#ifdef unix
      CHARACTER*(*) NAME
      CHARACTER*20 UPPER_CASE
      CALL GETENV('TRIUMF_PLOTTER_TYPE',NAME)
      NAME=UPPER_CASE(NAME)
#endif
      RETURN
      END
