      SUBROUTINE ATARI_GPLOT_HIST( YDATA, XDATA, NUM_IN
     #                            ,TITLE, AUTO_Y_IN, AUTO_X_IN
     #                            ,XLW, YLW, XUW, YUW)
C
C   Fast ATARI histogram using ST640j
C   
C   YDATA   (REAL*4) array of length NUM_IN (INTEGER*4)
C   XDATA   (REAL*4) array of length NUM_IN
C   TITLE   (CHARACTER*80) goes on top of graph
C   AUTO_Y  (LOGICAL*4) is true autoscale y-axis
C   AUTO_X  (LOGICAL*4) is true autoscale x-axis
C   (XLW,YLW) (REAL*4) coordinate of lower left corner of window
C             (as a percentage of the full screen)
C   (XUW,YUW) (REAL*4) coordinate of the upper right corner of window
C             (as a percentage of the full screen)
C         e.g., XLW=0., YLW=0., XUW=50., YUW=50. is lower left quadrant 
C
      CHARACTER GETLAB*80, XLABEL*80, YLABEL*80, TITLE*80
      REAL      XDATA(NUM_IN), YDATA(NUM_IN)
      LOGICAL   CLR_IT, CLR_ANSI, CLR_WINDOW, GRIDS, YSQRT, YLOG
     #         ,DASHED, AUTO_X_IN, AUTO_Y_IN, AUTO_X, AUTO_Y
C
      COMMON /PLOT_OUTPUT_UNIT/ IOUTS
C
      DATA XMINA /0./, XMAXA /1023./, YMINA /0./, YMAXA /779./
      DATA CLR_ANSI /.TRUE./, CLR_WINDOW /.TRUE./
      DATA YSQRT /.FALSE./, CLR_IT /.FALSE./
C
      IF( NUM_IN .LT. 2 )THEN
        CALL TRANSPARENT_MODE(0)
        CALL TRANSPARENT_MODE2(0)
        WRITE(IOUTS,10)'*** ERROR: in ATARI_GPLOT_HIST'
        WRITE(IOUTS,10)'***        number of points must be > 1'
10      FORMAT(' ',A)
        RETURN
      END IF
      XLABEL = GETLAB('XLABEL')
      YLABEL = GETLAB('YLABEL')
      LXL = MIN(79,LENSIG(XLABEL))
      LYL = MIN(79,LENSIG(YLABEL))
      LTL = MIN(79,LENSIG(TITLE))
      XLABEL(LXL+1:LXL+1) = CHAR(0)
      YLABEL(LYL+1:LYL+1) = CHAR(0)
      TITLE(LTL+1:LTL+1)  = CHAR(0)
C
C   IWXMIN, IWYMIN -  Tektronix screen coords [(0,0) - (1023,779)] of
C                     where you want the lower left corner of the
C                     display window to be.  All elements of the
C                     display, data points, labels, etc will be con-
C                     fined to this window.
C  IWXMAX, IWYMAX  -  Tektronix screen coords of where you want the 
C                     upper right corner of the display window to be
C                     (see notes on display window under IWXMIN, IWXMAX)
C
       WXMIN = XLW / 100. * (XMAXA - XMINA) + XMINA
       WXMAX = XUW / 100. * (XMAXA - XMINA) + XMINA
       WYMIN = YLW / 100. * (YMAXA - YMINA) + YMINA
       WYMAX = YUW / 100. * (YMAXA - YMINA) + YMINA
      IWXMIN = IFIX(WXMIN)
      IWXMAX = IFIX(WXMAX)
      IWYMIN = IFIX(WYMIN)
      IWYMAX = IFIX(WYMAX)
C
      XLAXIS = GETNAM('XLAXIS')
      XUAXIS = GETNAM('XUAXIS')
      YLAXIS = GETNAM('YLAXIS')
      YUAXIS = GETNAM('YUAXIS')
      XLWIND = GETNAM('XLWIND')
      XUWIND = GETNAM('XUWIND')
      YLWIND = GETNAM('YLWIND')
      YUWIND = GETNAM('YUWIND')
      XMING  = GETNAM('XMIN')
      XMAXG  = GETNAM('XMAX')
      AUTO_X = AUTO_X_IN
      IF( XMING .EQ. XMAXG )AUTO_X = .TRUE.
C
      I1   = 1
      I2   = NUM_IN
      IF( AUTO_X )THEN
        XMIN = XDATA(1)
        XMAX = XDATA(NUM_IN)
      ELSE
        XMIN = XMING
        XMAX = XMAXG
        DO I = 1, NUM_IN
          IF( XDATA(I) .GE. XMIN )THEN
            XMIN = XDATA(I)
            I1   = I
            GO TO 20
          END IF
        END DO
20      DO I = NUM_IN, 1, -1
          IF( XDATA(I) .LE. XMAX )THEN
            XMAX = XDATA(I)
            I2   = I
            GO TO 30
          END IF
        END DO
      END IF
30    NUM = I2 - I1 + 1
      IF( NUM .LT. 2 )THEN
        CALL TRANSPARENT_MODE(0)
        CALL TRANSPARENT_MODE2(0)
        WRITE(IOUTS,10)'*** ERROR: in ATARI_GPLOT_HIST'
        WRITE(IOUTS,10)'*** number of points in range is < 2'
        RETURN
      END IF
C
C  IDXMIN, IDYMIN  -  Tektronix screen coords [(0,0) - (1023,779)] of
C                      where you want the lower left corner of the plot
C                      to be.  MUST BE GREATER THAN (15,10)
C IDXMAX, IDYMAX  -  Tektronix screen coords of where you want the upper
C                    right corner of the plot to be.  MUST BE LESS THAN
C                    (1008,769) so tics can be drawn.
C
      IDXMIN = (XLAXIS-XLWIND)/(XUWIND-XLWIND)*(WXMAX-WXMIN) + WXMIN
      IDXMAX = (XUAXIS-XLWIND)/(XUWIND-XLWIND)*(WXMAX-WXMIN) + WXMIN
      IDYMIN = (YLAXIS-YLWIND)/(YUWIND-YLWIND)*(WYMAX-WYMIN) + WYMIN
      IDYMAX = (YUAXIS-YLWIND)/(YUWIND-YLWIND)*(WYMAX-WYMIN) + WYMIN
      XRED   = XDATA(I1+1) - XDATA(I1)
CC       DXINC = (DXMAX - DXMIN) * XRED / (XMAX - XMIN)
CC      IDXMIN = IFIX(DXMIN - 0.5*DXINC)
CC      IDXMAX = IFIX(DXMAX + 0.5*DXINC)
      XMIN = XMIN - 0.5*XRED
      XMAX = XMAX + 0.5*XRED
      CALL SETNAM('XMIN',XMIN)
      CALL SETNAM('XMAX',XMAX)
C
      YMING  = GETNAM('YMIN')
      YMAXG  = GETNAM('YMAX')
      AUTO_Y = AUTO_Y_IN
      IF( YMING .EQ. YMAXG )AUTO_Y = .TRUE.
C
      YBASE = ABS(GETNAM('YLOG'))
      IF( AUTO_Y )THEN
        NYINC = MAX(5,IFIX(GETNAM('NLYINC')))
        YMINS = YDATA(I1)
        YMAXS = YMINS
        DO I = I1, I2
          IF( YMINS .GT. YDATA(I) )YMINS = YDATA(I)
          IF( YMAXS .LT. YDATA(I) )YMAXS = YDATA(I)
        END DO
        IF( YBASE .EQ. 10. )THEN
C
C log scales 
C
          YLOG = .TRUE.
          IF( YMINS .LE. 0. )YMINS = 1.E-9
          IF( YMAXS .LE. 0. )YMAXS = 1.E-9
          YMIN = 10.**IFIX(LOG10(YMINS))
          YMAX = 10.**IFIX(LOG10(YMAXS)+0.999)
          CALL SETNAM('YMIN',LOG10(YMIN))
          CALL SETNAM('YMAX',LOG10(YMAX))
        ELSE 
          CALL SCALE2(YMINS,YMAXS,NYINC,YMIN,YMAX,YINC,DUM,0)
          YLOG = .FALSE.
          CALL SETNAM('YMIN',YMIN)
          CALL SETNAM('YMAX',YMAX)
        END IF
      ELSE IF( .NOT.AUTO_Y )THEN
        YMIN = YMING
        YMAX = YMAXG
        IF( YBASE .EQ. 10. )THEN
C
C log scales 
C
          YLOG = .TRUE.
          YMIN = 10.**IFIX(YMIN)
          YMAX = 10.**IFIX(YMAX)
        ELSE 
          YLOG = .FALSE.
          IF( YBASE .GT. 1. )THEN
            YMIN = YBASE**YMIN
            YMAX = YBASE**YMAX
          END IF
        END IF
      END IF
C
C   CLR_IT     -  if true clear the whole screen
C   CLR_ANSI   -  if true the ANSI screen will also be cleared.
C   CLR_WINDOW -  if TRUE, then the region specified by (IWXMIN,IWYMIN) 
C                 --> (IWXMAX,IWYMAX) will be cleared before the graph
C                 is displayed.
C   GRIDS      -  if TRUE then a grid will be displayed over the
C                 plot.  This grid will appear the the tic marks
C                 selected by ST640 and will be drawn with a dotted line
C   YSQRT      -  if TRUE and YLOG=FALSE then the y-axis will be
C                 the square root of the coordinate.
C   YLOG       -  if TRUE the y-axis will be logrithmic. IMPORTANT:
C                 I only support limits YMIN and YMAX that are 
C                 10**i  where i is some INTEGER!!
C   DASHED     -  if TRUE then the lines making up the histogram
C                 display will be dashed rather than solid.
C
      IF( (GETNAM('NXGRID').NE.0.) .OR. (GETNAM('NYGRID').NE.0.) )THEN
        GRIDS = .TRUE.
      ELSE
        GRIDS = .FALSE.
      END IF
      IF( GETNAM('LINTYP') .EQ. 1. )THEN
        DASHED = .FALSE.
      ELSE
        DASHED = .TRUE.
      END IF
C
      CALL ST1D(IWXMIN, IWYMIN, IWXMAX, IWYMAX
     #         ,IDXMIN, IDYMIN, IDXMAX, IDYMAX
     #         ,YDATA(I1), NUM, XMIN, XRED, YMIN, YMAX
     #         ,CLR_IT, CLR_ANSI, CLR_WINDOW, GRIDS, YSQRT, YLOG, DASHED
     #         ,XLABEL, YLABEL, TITLE )
      RETURN
      END
