      SUBROUTINE ATARI_GPLOT_MATRIX(XDATA,YDATA,ZDATA,NUMX,NUMY,IDIMZ
     #                             ,TITLE,XLW,YLW,XUW,YUW,FMINI,FMAXI)
C
C   Fast ATARI histogram using ST640 terminal emulator
C   
C   XDATA   (REAL*4) vector of length NUMX (INTEGER*4)
C   YDATA   (REAL*4) vector of length NUMY (INTEGER*4)
C   ZDATA   (REAL*4) matrix with dimensions IDIMZ,NUMY (INTEGER*4)
C   TITLE   (CHARACTER*80) goes on top of graph
C   (XLW,YLW) (REAL*4) coordinate of lower left corner of window
C             (as a percentage of the full screen)
C   (XUW,YUW) (REAL*4) coordinate of the upper right corner of window
C             (as a percentage of the full screen)
C         e.g., XLW=0., YLW=0., XUW=50., YUW=50. is lower left quadrant 
C
      CHARACTER GETLAB*80, XLABEL*80, YLABEL*80, TITLE*80
      REAL      XDATA(NUMX), YDATA(NUMY)
     #         ,ZDATA(IDIMZ,NUMY)
      LOGICAL   CLR_IT, CLR_ANSI, CLR_WINDOW, GRIDS
C
      COMMON /PLOT_OUTPUT_UNIT/ IOUTS
C
      DATA XMINA /0./, XMAXA /1023./, YMINA /0./, YMAXA /779./
      DATA CLR_IT /.FALSE./, CLR_ANSI /.TRUE./, CLR_WINDOW /.TRUE./
      DATA IXSTRT /1/, IYSTRT /1/
C
      IF( NARGS(DUM) .EQ. 13 )THEN
        FMIN = FMINI
        FMAX = FMAXI
      ELSE
        FMIN = 0.0
        FMAX = 1.0
      END IF
CC      IF( NUMX .LT. 2 )THEN
CC        CALL TRANSPARENT_MODE(0)
CC        CALL TRANSPARENT_MODE2(0)
CC        WRITE(IOUTS,10)'*** ERROR: in ATARI_GPLOT_MATRIX'
CC        WRITE(IOUTS,10)'***        number of x data points must be > 1'
10      FORMAT(' ',A)
CC        RETURN
CC      END IF
CC      IF( NUMY .LT. 2 )THEN
CC        CALL TRANSPARENT_MODE(0)
CC        CALL TRANSPARENT_MODE2(0)
CC        WRITE(IOUTS,10)'*** ERROR: in ATARI_GPLOT_MATRIX'
CC        WRITE(IOUTS,10)'***        number of y data points must be > 1'
CC        RETURN
CC      END IF
CC      IF( IDIMZ .LT. 2 )THEN
CC        CALL TRANSPARENT_MODE(0)
CC        CALL TRANSPARENT_MODE2(0)
CC        WRITE(IOUTS,10)'*** ERROR: in ATARI_GPLOT_MATRIX'
CC        WRITE(IOUTS,10)'***        matrix dimension must be > 1'
CC        RETURN
CC      END IF
      XLABEL = GETLAB('XLABEL')
      YLABEL = GETLAB('YLABEL')
      LXL = MIN(79,LENSIG(XLABEL))
      LYL = MIN(79,LENSIG(YLABEL))
      LTL = MIN(79,LENSIG(TITLE))
      XLABEL(LXL+1:LXL+1) = CHAR(0)
      YLABEL(LYL+1:LYL+1) = CHAR(0)
      TITLE(LTL+1:LTL+1)  = CHAR(0)
C
C   IWXMIN, IWYMIN -  Tektronix screen coords [(0,0) - (1023,779)] of
C                     where you want the lower left corner of the
C                     display window to be.  All elements of the
C                     display, data points, labels, etc will be con-
C                     fined to this window.
C  IWXMAX, IWYMAX  -  Tektronix screen coords of where you want the 
C                     upper right corner of the display window to be
C                     (see notes on display window under IWXMIN, IWXMAX)
C
      IWXMIN = XLW / 100. * (XMAXA - XMINA) + XMINA
      IWXMAX = XUW / 100. * (XMAXA - XMINA) + XMINA
      IWYMIN = YLW / 100. * (YMAXA - YMINA) + YMINA
      IWYMAX = YUW / 100. * (YMAXA - YMINA) + YMINA
      XLAXIS = GETNAM('XLAXIS')
      XUAXIS = GETNAM('XUAXIS')
      YLAXIS = GETNAM('YLAXIS')
      YUAXIS = GETNAM('YUAXIS')
      XLWIND = GETNAM('XLWIND')
      XUWIND = GETNAM('XUWIND')
      YLWIND = GETNAM('YLWIND')
      YUWIND = GETNAM('YUWIND')
C
C  IDXMIN, IDYMIN  -  Tektronix screen coords [(0,0) - (1023,779)] of
C                      where you want the lower left corner of the plot
C                      to be.  MUST BE GREATER THAN (15,10)
C IDXMAX, IDYMAX  -  Tektronix screen coords of where you want the upper
C                    right corner of the plot to be.  MUST BE LESS THAN
C                    (1008,769) so tics can be drawn.
C
      IDXMIN = (XLAXIS-XLWIND)/(XUWIND-XLWIND)*(IWXMAX-IWXMIN)+IWXMIN
      IDXMAX = (XUAXIS-XLWIND)/(XUWIND-XLWIND)*(IWXMAX-IWXMIN)+IWXMIN
      IDYMIN = (YLAXIS-YLWIND)/(YUWIND-YLWIND)*(IWYMAX-IWYMIN)+IWYMIN
      IDYMAX = (YUAXIS-YLWIND)/(YUWIND-YLWIND)*(IWYMAX-IWYMIN)+IWYMIN
C
      IF( (GETNAM('NXGRID').NE.0.) .OR. (GETNAM('NYGRID').NE.0.) )THEN
        GRIDS = .TRUE.
      ELSE
        GRIDS = .FALSE.
      END IF
C
C   CLR_IT          -  if TRUE then the entire screen will be cleared 
C                      before the histogram is plotted. (see also 
C                      CLR_WINDOW)
C   CLR_ANSI        -  if true the ANSI screen will also be cleared.
C   CLR_WINDOW      -  if TRUE, then the region specified by (IWXMIN,
C                      IWYMIN) -> (IWXMAX,IWYMAX) will be cleared before
C                      the graph is displayed.
C   GRIDS           -  if TRUE then a grid will be displayed over the
C                      plot.  This grid will appear the the tic marks
C                      selected by ST640 and will be drawn with a dotted
C                      line
C
      ZMIN = ZDATA(1,1)
      ZMAX = ZMIN
      DO I = 1, IDIMZ
        DO J = 1, NUMY
          IF( ZMIN .GT. ZDATA(I,J) )ZMIN = ZDATA(I,J)
          IF( ZMAX .LT. ZDATA(I,J) )ZMAX = ZDATA(I,J)
        END DO
      END DO
      Z1   = FMIN*(ZMAX-ZMIN) + ZMIN
      ZMAX = FMAX*(ZMAX-ZMIN) + ZMIN
      ZMIN = Z1
C
      XMIN = XDATA(1)
      XMAX = XDATA(NUMX)
      IF( NUMX .GT. 1 )THEN
        XRED = XDATA(2) - XDATA(1)
      ELSE
        XRED = 1.0
      END IF
CC      IDXINC = (IDXMAX - IDXMIN) * XRED / (XMAX - XMIN)
CC      IDXMIN = IDXMIN - IDXINC/2
CC      IDXMAX = IDXMAX + IDXINC/2
      XMIN = XDATA(1)    - 0.5*XRED
      XMAX = XDATA(NUMX) + 0.5*XRED
      CALL SETNAM('XMIN',XMIN)
      CALL SETNAM('XMAX',XMAX)
C
CC      IDYINC = (IDYMAX - IDYMIN) * YRED / (YMAX - YMIN)
CC      IDYMIN = IDYMIN - IDYINC/2
CC      IDYMAX = IDYMAX + IDYINC/2
      IF( NUMY .GT. 1 )THEN
        YRED = YDATA(2) - YDATA(1)
      ELSE
        YRED = 1.0
      END IF
      YMIN = YDATA(1)    - 0.5*YRED
      YMAX = YDATA(NUMY) + 0.5*YRED
      CALL SETNAM('YMIN',YMIN)
      CALL SETNAM('YMAX',YMAX)
      IXSTOP = IDIMZ
      IYSTOP = NUMY
C
      CALL ST2D(IWXMIN, IWYMIN, IWXMAX, IWYMAX
     #         ,IDXMIN, IDYMIN, IDXMAX, IDYMAX
     #         ,ZDATA, IDIMZ, NUMY
     #         ,IXSTRT, IXSTOP, IYSTRT, IYSTOP
     #         ,XMIN, XRED, YMIN, YRED, ZMIN, ZMAX
     #         ,CLR_IT, CLR_ANSI, CLR_WINDOW, GRIDS
     #         ,XLABEL, YLABEL, TITLE )
      RETURN
      END
