      SUBROUTINE GPLOT_SETUP( FNAME )

C    This routine sets up the world coordinate system of units 
C    and initializes GPLOT.  It then reads a restore file of
C    GPLOT parameters.
C    Modified 10-AUG-94 by FWJ: plotter type POSTSCRIPT (=PSA) added
C    for compatibility with PLOTDATA.

      CHARACTER*(*) FNAME

      CHARACTER*255 STRINGS(3)
      CHARACTER*255 CLINE
      CHARACTER*9   ORIENTATION 
      CHARACTER*2   UNITS

      REAL*4        REALS(3)
      INTEGER*4     ITYPE(3)

      DATA IN1 /5/, IOUT1 /6/, IOUT2 /7/
      DATA UNITS /'CM'/, ORIENTATION /'LANDSCAPE'/, NP /1/

      INTEGER*4 IBIT
      COMMON /BITMAP_DEVICE/ IBIT

      INTEGER*4 IMONITOR2, IOUTM2
      COMMON /PLOTMONITOR2/ IMONITOR2, IOUTM2

      INTEGER*4 PLTRSIZE
      COMMON /PLOTTER_SIZE/ PLTRSIZE

      CHARACTER*11 DEVICES(35)
      CHARACTER*14 DEVICE_NAMES(0:20)
      CHARACTER*21 DEVICE_SIZE(0:4)
      INTEGER*4    NDEVICE(35), DEVSIZE(35)
      DATA DEVICES 
     & / 'NONE       ','VT640      ','TK4010     ','HPA        '
     &  ,'HPB        ','HPC        ','HPD        ','HPE        '
     &  ,'CIT467     ','TK4107     ','VT241      ','PT100G     '
     &  ,'HIA        ','HIB        ','HIC        ','HID        '
     &  ,'HIE        ','SEIKO      ','IMAGEN     ','PSA        '
     &  ,'PSB        ','PSC        ','PSD        ','PSE        '
     &  ,'LN03+      ','GENERIC    ','X          ','GKS        '
     &  ,'RDGLA      ','RDGLB      ','RDGLC      ','RDGLD      '
     &  ,'RDGLE      ','POSTSCRIPT ','DECWINDOWS '/
      DATA NDEVICE
     & /  0,1,2,5, 5,5,5,5, 6,7,8,9, 11,11,11,11, 11,12,13,14,
     &   14,14,14,14, 16,17,18,19, 20,20,20,20, 20, 14, 18 /
      DATA DEVSIZE
     & /  0,0,0,0, 1,2,3,4, 0,0,0,0,  0,1,2,3,     4,0,0,0,
     &    1,2,3,4,     0,0,0,0,     0,1,2,3,     4, 0, 0 /
      DATA DEVICE_NAMES
     & / 'none          ','VT640         ','TK4010        '
     &  ,'              ','              ','HP pen plotter'
     &  ,'CIT467        ','TK4107        ','VT241         '
     &  ,'PT100G        ','              ','Houston Inst. '
     &  ,'Seiko         ','Imagen        ','PostScript    '
     &  ,'              ','LN03+         ','generic       '
     &  ,'X             ','GKS           ','Roland        ' /
      DATA DEVICE_SIZE
     &  / 'A:  19.00 x  25.00 cm','B:  25.40 x  40.64 cm'
     &   ,'C:  40.64 x  53.34 cm','D:  53.34 x  83.82 cm'
     &   ,'E:  83.82 x 109.22 cm' /
CCC
cc      IBIT = 0
      IBIT = 12     ! HP LaserJet 150 dpi

      NFLD = 2
      ITYPE(1) = 0
      CALL GET_TERMTYPE( STRINGS(1) )
      IF( LENSIG(STRINGS(1)) .GT. 0 )ITYPE(1) = 1

      ITYPE(2) = 1
      CALL GET_PLOTTERTYPE( STRINGS(2) )
      IF( LENSIG(STRINGS(2)) .EQ. 0 )STRINGS(2) = 'NONE'

      IF( ITYPE(1) .EQ. 1 )GO TO 32
  10  WRITE(IOUT1,12)'terminal types:'
      WRITE(IOUT1,12)'   NONE VT640 VT241 CIT467 TK4010 TK4107'
      WRITE(IOUT1,12)'   PT100G SEIKO GENERIC X'
      WRITE(IOUT1,12)'plotter types:'
  12  FORMAT(' ',A)
      WRITE(IOUT1,12)'   NONE HPA HPB HPC HPD HPE LN03+'
      WRITE(IOUT1,12)'   HIA HIB HIC HID HIE IMAGEN'
      WRITE(IOUT1,12)'   PSA PSB PSC PSD PSE GKS'
      WRITE(IOUT1,12)'   RDGLA RDGLB RDGLC RDGLD RDGLE'
      WRITE(IOUT1,12)'(defaults) X  NONE'
  20  WRITE(IOUT1,12)'Enter: terminal type  { plotter type } '//
     &   '(type <RETURN> for defaults)'
      READ(IN1,30,END=20,ERR=20)CLINE
  30  FORMAT(A)             ! modified by J.Chuma 21Mar97 for g77
      NLINE = LENSIG(CLINE)
      IF( NLINE .EQ. 0 )THEN
        STRINGS(1) = 'X'
        ITYPE(1) = 1
        NFLD = 1
        GO TO 34
      END IF
      CALL UPRCASE(CLINE(1:NLINE),CLINE(1:NLINE))
      NFLD = 2
      CALL GPLOT_READLINE(CLINE,STRINGS,REALS,ITYPE,NFLD)
  32  IF( NFLD .EQ. 0 )THEN
        STRINGS(1) = 'X'
        ITYPE(1) = 1
        NFLD = 1
      END IF
  34  IF( (ITYPE(1).NE.1) .OR. (ITYPE(2).EQ.2) )GO TO 10
      LS1 = LENSIG(STRINGS(1))
      LS2 = LENSIG(STRINGS(2))
      IMON1 = -1
      DO I = 1, 35
        IF( INDEX(DEVICES(I),STRINGS(1)(1:LS1)) .EQ. 1 )THEN
          IMON1 = NDEVICE(I)
          GO TO 40
        END IF
      END DO
  40  IF( (IMON1.EQ.-1) .OR. (IMON1.EQ.5) .OR. (IMON1.EQ.11) .OR.
     & (IMON1.EQ.13) .OR. (IMON1.EQ.14) .OR. (IMON1.EQ.16) )THEN
        WRITE(IOUT1,12)'invalid terminal type'
        GO TO 10
      END IF
      IMON2 = -1
      DO I = 1, 35
        IF( INDEX(DEVICES(I),STRINGS(2)(1:LS2)) .EQ. 1 )THEN
          IMON2    = NDEVICE(I)
          PLTRSIZE = DEVSIZE(I)
          GO TO 50
        END IF
      END DO
  50  IF( (IMON2.EQ.-1) .OR. (IMON2.EQ.17) .OR. (IMON2.EQ.18) )THEN
        WRITE(IOUT1,12)'invalid plotter type'
        GO TO 10
      END IF
      WRITE(IOUT1,12)'terminal type chosen: '//DEVICE_NAMES(IMON1)//
     & ', plotter type chosen: '//DEVICE_NAMES(IMON2)
      IF( (IMON2.EQ.5) .OR. (IMON2.EQ.11) .OR. (IMON2.EQ.14) .OR.
     & (IMON2.EQ.20) )WRITE(IOUT1,12)
     & 'plotter size: '//DEVICE_SIZE(PLTRSIZE)
      WRITE(IOUT1,12)'bitmap device: none'
cc      WRITE(IOUT1,12)'bitmap device: HPLaserJet @ 150 dpi'

      CALL SET_PLOT_DEVICES(IMON1,IOUT1,IMON2,IOUT2,IBIT,UNITS
     & ,ORIENTATION,NP)
      CALL CLEAR_PLOT
      CALL GPLOTI
      CALL GPLOT_RESTORE_FILE( FNAME )
      RETURN
      END
