      SUBROUTINE HCOPYDEV
C
C   Preliminary version
C
C   This routine should be able to ask the user for a hardcopy device
C   Only the modern hardcopy devices are included
C    ( left out: Imagen, Printronix, LNO3+, etc. )
C   
      IMPLICIT NONE

      INTEGER*4 IMONITOR, IOUTM
      COMMON /PLOTMONITOR/ IMONITOR, IOUTM

      INTEGER*4 IMONITOR2, IOUTM2
      COMMON /PLOTMONITOR2/ IMONITOR2, IOUTM2

      LOGICAL*4 WELL
      COMMON /TO_BIT_OR_NOT/ WELL

      INTEGER*4 PLTRSIZE
      COMMON /PLOTTER_SIZE/ PLTRSIZE

      INTEGER*4 IBIT
      COMMON /BITMAP_DEVICE/ IBIT

      LOGICAL*4 PSCOLOUR
      COMMON /POSTSCRIPTCOLOUR/ PSCOLOUR

      LOGICAL*4 PSGREY
      COMMON /POSTSCRIPTGREY/ PSGREY

      INTEGER*4 IOUTS
      COMMON /PLOT_OUTPUT_UNIT/ IOUTS

C   local variables

      CHARACTER*21  DEVICE_SIZE(0:6)
      CHARACTER*10  BITMAP_DEVICENAME(5), DEVICE_NAMES(0:20)
      CHARACTER*7   SOUT
      CHARACTER*2   UNITS
      CHARACTER*1   MODE
      INTEGER*4     IDEV, IDUM, IBIT1, IBIT2, IPAGES

      DATA BITMAP_DEVICENAME
     &  / 'PRINTRONIX','HPLASERJET','HPTHINKJET'
     &   ,'LA100     ','HPPAINTJET' /
      DATA DEVICE_SIZE
     &  / 'A:  21.59 x  27.64 cm','B:  27.94 x  43.18 cm'
     &   ,'C:  43.18 x  55.88 cm','D:  55.88 x  86.36 cm'
     &   ,'E:  86.36 x 111.76 cm','A3: 20.32 x  26.67 cm'
     &   ,'A4: 19.73 x  28.42 cm' /
      DATA DEVICE_NAMES
     &  / 'none      ','VT640     ','TK4010    ','unused    '
     &   ,'unused    ','HP        ','CIT467    ','TK4107    '
     &   ,'VT241     ','PT100G    ','unused    ','HOUSTON   '
     &   ,'SEIKO     ','IMAGEN    ','POSTSCRIPT','unused    '
     &   ,'LN03      ','generic   ','X         ','GKS       '
     &   ,'RDGL      ' /
      DATA UNITS / 'CM' /, MODE / 'L' /
      DATA IPAGES / 1 /
CCC
      IF( WELL )THEN
        IBIT2 = IBIT/10
        IBIT1 = IBIT - 10*IBIT2
        SOUT  = ' '
        IF( IBIT1 .EQ. 2 )THEN
          IF( IBIT2 .EQ. 0 )SOUT = '100 dpi'
          IF( IBIT2 .EQ. 1 )SOUT = '150 dpi'
          IF( IBIT2 .EQ. 3 )SOUT = '300 dpi'
        END IF
        WRITE(*,*)
     &   'Current device: '//BITMAP_DEVICENAME(IBIT1)//' '//SOUT
      ELSE
        WRITE(*,*)'Current device: '//DEVICE_NAMES(IMONITOR2)
        IF( (IMONITOR2.EQ. 5) .OR. (IMONITOR2.EQ.11) .OR.
     &      (IMONITOR2.EQ.14) .OR. (IMONITOR2.EQ.20) )
     &   WRITE(*,*)'  paper size = '//DEVICE_SIZE(PLTRSIZE)
        IF( IMONITOR2 .EQ. 14 )THEN
          IF( PSGREY )THEN
            WRITE(*,*)'  grey scale'
          ELSE IF( PSCOLOUR )THEN
            WRITE(*,*)'  colour'
          ELSE
            WRITE(*,*)'  no colour'
          END IF
        END IF
      END IF
   10 WRITE(*,*)
     & 'bitmap                               vector'
      WRITE(*,*)
     & 'devices                              plotters'
      WRITE(*,*)
     & '----------------------------------------------'//
     & '------------------'
      WRITE(*,*)'HPLaserJet {100|150|300} 1-3         '//
     & 'HP Pen Plotter {A|B|C|D|E}      5-9'
      WRITE(*,*)'Inkjet                   4           '//
     & 'PostScript {A|B|C|D|E|A4}      10-15'
      WRITE(*,*)' '
      WRITE(*,20)' Enter: number >> '
   20 FORMAT(A,$)
      READ(*,22,ERR=10)IDEV
   22 FORMAT(I2)

      IF( IDEV .EQ. 1 )THEN
        IMONITOR2 = 0
        WELL = .TRUE.
        IBIT = 2
      ELSE IF( IDEV .EQ. 2 )THEN
        IMONITOR2 = 0
        WELL = .TRUE.
        IBIT = 12
      ELSE IF( IDEV .EQ. 3 )THEN
        IMONITOR2 = 0
        WELL = .TRUE.
        IBIT = 32
      ELSE IF( IDEV .EQ. 4 )THEN
        IMONITOR2 = 0
        IBIT = 5
        WELL = .TRUE.
      ELSE IF( IDEV .EQ.  5 )THEN ! HP pen plotter
        WELL = .FALSE.
        IMONITOR2 = 5
        PLTRSIZE = 0
      ELSE IF( IDEV .EQ.  6 )THEN
        WELL = .FALSE.
        IMONITOR2 = 5
        PLTRSIZE = 1
      ELSE IF( IDEV .EQ.  7 )THEN
        WELL = .FALSE.
        IMONITOR2 = 5
        PLTRSIZE = 2
      ELSE IF( IDEV .EQ.  8 )THEN
        WELL = .FALSE.
        IMONITOR2 = 5
        PLTRSIZE = 3
      ELSE IF( IDEV .EQ.  9 )THEN
        WELL = .FALSE.
        IMONITOR2 = 5
        PLTRSIZE = 4
      ELSE IF( IDEV .EQ. 10 )THEN ! PostScript
        WELL = .FALSE.
        IMONITOR2 = 14
        PLTRSIZE = 0
      ELSE IF( IDEV .EQ. 11 )THEN
        WELL = .FALSE.
        IMONITOR2 = 14
        PLTRSIZE = 1
      ELSE IF( IDEV .EQ. 12 )THEN
        WELL = .FALSE.
        IMONITOR2 = 14
        PLTRSIZE = 2
      ELSE IF( IDEV .EQ. 13 )THEN
        WELL = .FALSE.
        IMONITOR2 = 14
        PLTRSIZE = 3
      ELSE IF( IDEV .EQ. 14 )THEN
        WELL = .FALSE.
        IMONITOR2 = 14
        PLTRSIZE = 4
      ELSE IF( IDEV .EQ. 15 )THEN
        WELL = .FALSE.
        IMONITOR2 = 14
        PLTRSIZE = 6
      ELSE
        WRITE(*,*)'ERROR: *** invalid device type number ***'
        GO TO 10
      END IF

      IF( IMONITOR2 .EQ. 14 )THEN ! PostScript
   30   WRITE(*,20)
     &   ' Enter: 0 (no colour), 1 (colour), 2 (grey scales) >> '
        READ(*,32,ERR=30)IDUM
   32   FORMAT(I1)
        IF( IDUM .EQ. 0 )THEN
          PSCOLOUR = .FALSE.
          PSGREY = .FALSE.
        ELSE IF( IDUM .EQ. 1 )THEN
          PSCOLOUR = .TRUE.
          PSGREY = .FALSE.
        ELSE IF( IDUM .EQ. 2 )THEN
          PSCOLOUR = .TRUE.
          PSGREY = .TRUE.
        END IF
      END IF

   40 WRITE(*,20)' Enter mode: L (landscape), P (portrait) >> '
      READ(*,42,ERR=40)MODE
   42 FORMAT(A1)
      CALL UPRCASE( MODE, MODE )
      IF( (MODE.NE.'L') .AND. (MODE.NE.'P') )GO TO 40
        
   50 WRITE(*,20)
     & ' Enter plotting units: CM (centimeters) or IN (inches) >> '
      READ(*,52,ERR=50)UNITS
   52 FORMAT(A2)
      CALL UPRCASE( UNITS, UNITS )
      IF( (UNITS.NE.'CM') .AND. (UNITS.NE.'IN') )GO TO 50

      CALL SET_PLOT_DEVICES(IMONITOR,IOUTM,IMONITOR2,IOUTM2
     & ,IBIT,UNITS,MODE,IPAGES)
      CALL CLEAR_PLOT

      RETURN
      END
