      FUNCTION LIB_GET_VM(NBYTES,IADDR)
      INTEGER LIB_GET_VM

C Note: on OSF/1 this function assumes that the -T and -D loader flags
C have been used to ensure that addresses are in the low 2gb of 
C virtual memory (i.e. 32-bit-addressable).

#ifdef unix
#ifdef __osf__
      INTEGER*8 IADDR8

      IADDR8=MALLOC(NBYTES)
      IADDR=IADDR8
#else
      IADDR=MALLOC(NBYTES)
#endif
      LIB_GET_VM=1
      IF(IADDR.GT.0)RETURN
      LIB_GET_VM=0
#endif
#ifdef VMS
      EXTERNAL SS$_NORMAL,LIB$_INSVIRMEM,LIB$_BADBLOSIZ

      ISTAT=LIB$GET_VM(NBYTES,IADDR)
      LIB_GET_VM=ISTAT
      IF(ISTAT.EQ.%LOC(SS$_NORMAL))RETURN
      IF(ISTAT.EQ.%LOC(LIB$_INSVIRMEM))THEN
          WRITE(6,10)
10        FORMAT('0*** LIB$GET_VM unable to get requested virtual'
     &     ' memory ')
      ELSE IF(ISTAT.EQ.%LOC(LIB$_BADBLOSIZ))THEN
          WRITE(6,20)
20        FORMAT('0*** Error in LIB$GET_VM: invalid block size')
      ELSE
          WRITE(6,30)
30        FORMAT('0*** Error in LIB$GET_VM: who knows?')
      END IF
#endif
      RETURN
      END
