        SUBROUTINE PLOT_COLOR(ICODE,ICODE2)
C======================================================================C
C  PLOT_COLOR                                                          C
C  Sets the plotting color for subsequent graphics.                    C
C                                                                      C
C  INPUTS:                                                             C
C            ICODE = COLOR CODE                                        C
C                    1 TO 8 FOR ZETA PLOTTER                           C
C                    1 OR 2 FOR HP; 0 TO 7 FOR CIT-467                 C
C                    0 TO 15 FOR TEKTRONIX-4107.                       C
C                                                                      C
C  In the absence of a call to PLOT_COLOR, the pen color for the       C
C  ZETA defaults to 1, the HP defaults to 1 and CIT-467 defaults       C
C  to latest setting!.                                                 C
C                                                                      C
C  Colour codes on the TEKTRONIX-4107:                                 C
C  -----------------------------------                                 C
C      0          1     2     3      4    5        6      7       8    C
C  Transparent  White  Red  Green  Blue  Cyan  Magenta  Yellow  Orange C
C      9            10         11          12           13             C
C  Green-Yellow  Green-Cyan  Blue-Cyan  Blue-Magenta  Red-Magenta      C
C     14          15                                                   C
C  Dark-Grey  Light-Grey                                               C
C                                                                      C
C                                                                      C
C  Modified by Alan Carruthers, July 15, 1983                          C
C         -- call to PUT_METAFILE1 added to support metafile           C
C                                                                      C
C  Modified May 8/84 by F. Jones to store current CIT colour           C
C  setting for communication with PLOT_DATA_LEVEL.  Probably           C
C  a temporary modification, until a canonical method of               C
C  colour representation & storage is devised.                         C
C                                                                      C
C  Modified by Bernard Henin, July/84, to include the TEKTRONIX-4107.  C
C                                                                      C
C  Modified by F.W. Jones, August 1984, to include the VT241.          C
C  Modified by F.W. Jones, Sept 27/84, to store the colour code        C
C  for output to EDGR drawing files.                                   C
C  Modified by F.W. Jones, Aug 11/86, to support the Houston           C
C  Instruments plotter.                                                C
C  Modified by F.W. Jones, Mar 20/87, for Seiko GR-1105 terminal       C
C  Modified by J. Chuma, May 11/89, for generic terminal               C
C  Modified by F.W. Jones, Nov 09/89, for GKS Metafile                 C
C  Modified by J. Chuma, Oct 16/90, for RD-GLII plotter                C
C  Modified by F. Jones, Jan 15/91: the maximum colour index for the   C
C    VT241 (REGIS) driver was increased to 15 to accomodate the        C
C    VT340 (or DecWindows emulator) which has 4 bitplanes.             C
C  Modified by F. Jones, 01-May-91: removed Telidon metafile o/p       C
C  Modified by F. Jones, 02-May-91: removed VS11                       C
C  Modified by F. Jones, 18-Nov-91: PostScript colour support added.   C
C  Modified 19-AUG-93 by FWJ: Zeta and UIS support removed             C
C  Modified 23-AUG-93 by FWJ: checks for previous CLEAR_PLOT for X.    C
C  Modified 15-Sep-93 by JLC: PostScript as monitor2 was using ICODE   C
C                             instead of ICODE2                        C
C                                                                      C
C======================================================================C

      COMMON / PLOT_OUTPUT_UNIT /IOUTTY
      COMMON /PLOTMONITOR/ IMONITOR,IOUTM
      COMMON /PLOTMONITOR2/ IMONITOR2,IOUTM2

      COMMON/CIT_COLOUR/ICITCOL1,ICITCOL2
      COMMON/EDGR_ATT_SET/IFONT_SET,ICOL_SET

C   This common block contains the two numbers ICODE1, and ICODE2
C   for use by other routines that need to know the current colour
C   codes, e.g. GPLOT
C
      COMMON /PLOT_COLOURS/ ICOLOUR_1, ICOLOUR_2

      BYTE TEK4107_INDEX (16)
C  Modified by J.Chuma, 23Apr97 for Absoft f77  changed X' to Z'
      DATA TEK4107_INDEX /Z'30', Z'31', Z'32', Z'33', Z'34', Z'35'
     *                   ,Z'36', Z'37', Z'38', Z'39', Z'3A', Z'3B'
     *                   ,Z'3C', Z'3D', Z'3E', Z'3F'/

      COMMON /PLOT_CLEAR/ CLEAR
      LOGICAL CLEAR

      CHARACTER*1 ESC, TMP
CCC
      ESC=CHAR(27)   ! modified by J.Chuma, 19Mar97 for g77
C                       was inside PARAMETER statement

C Make the colour code available for encoding to EDGR drawing files:
      ICOL_SET=MIN(127,ABS(ICODE))

C======================================================================C
C  First monitor
C======================================================================C
C HP plotter:
      IF(IMONITOR.EQ.5)THEN
        IF( .NOT.CLEAR )CALL HP_NEWPEN(ICODE)

C CIT:
      ELSE IF(IMONITOR.EQ.6) THEN
        WRITE(IOUTM,110)ESC,'1'
C FORMAT modified for Unix compatibility 14-NOV-91 by FWJ
C110    FORMAT('+',2A1)
 110    FORMAT(' ',2A1,$)
        CALL FLUSH_PLOT
        IF(ICODE.LT.0.OR.ICODE.GT.7)GO TO 500
C Store colour code:
        ICITCOL1=ICODE
        IF(ICODE.EQ.0) WRITE(IOUTM,110)ESC,'h'   ! BLACK
        IF(ICODE.EQ.1) WRITE(IOUTM,110)ESC,'i'   ! RED
        IF(ICODE.EQ.2) WRITE(IOUTM,110)ESC,'j'   ! BLUE
        IF(ICODE.EQ.3) WRITE(IOUTM,110)ESC,'k'   ! VIOLET
        IF(ICODE.EQ.4) WRITE(IOUTM,110)ESC,'l'   ! GREEN
        IF(ICODE.EQ.5) WRITE(IOUTM,110)ESC,'m'   ! YELLOW
        IF(ICODE.EQ.6) WRITE(IOUTM,110)ESC,'n'   ! CYAN
        IF(ICODE.EQ.7) WRITE(IOUTM,110)ESC,'o'   ! WHITE

C TEKTRONIX-4107:
      ELSE IF (IMONITOR .EQ. 7) THEN
        CALL FLUSH_PLOT
        ICITCOL1=ICODE
        WRITE (IOUTM, 60100) ESC, 'M', 'L', TEK4107_INDEX(ICODE+1)
60100   FORMAT (1X, 4A1)

C VT241:
      ELSE IF(IMONITOR.EQ.8)THEN
        IF(ICODE.LT.0.OR.ICODE.GT.15)GO TO 500
        CALL FLUSH_PLOT
        WRITE(IOUTM,1000)ICODE
1000    FORMAT(' W(I',I2.2,')')

C Houston plotter:
      ELSE IF(IMONITOR.EQ.11)THEN
        IF( .NOT.CLEAR )CALL HOUSTON_NEWPEN(ICODE)

C Seiko GR-1105:
      ELSE IF(IMONITOR.EQ.12)THEN
        IF(ICODE.LT.0.OR.ICODE.GT.7)GO TO 500
        CALL FLUSH_PLOT
        TMP = CHAR( 32+ICODE ) ! modified by J.Chuma, 19Mar97 for g77
        WRITE(IOUTM,2000)ESC,'K ',ESC,'gB',TMP
C        WRITE(IOUTM,2000)ESC,'K ',ESC,'gB',' '+ICODE
C FORMAT modified for Unix compatibility 14-NOV-91 by FWJ
C2000   FORMAT('+',A1,A2,A1,A2,A1,$)
 2000   FORMAT(' ',A1,A2,A1,A2,A1,$)

C PostScript
      ELSE IF(IMONITOR.EQ.14)THEN
        IF(.NOT.CLEAR)CALL POSTSCRIPT_COLOUR(ICODE)

C Generic terminal
      ELSE IF( IMONITOR .EQ. 17 ) THEN
        CALL GENERIC_COLOR( ICODE )
        ICITCOL1 = ICODE

C X Window display
      ELSE IF(IMONITOR.EQ.18)THEN
        IF(CLEAR)THEN
          WRITE(*,*)'PLOT_COLOR called without prior CLEAR_PLOT'
          RETURN
        ENDIF
        CALL XVST_PLOT_FLUSH
        CALL XVST_PLOT_COLOUR(ICODE)
      ENDIF

C======================================================================C
C  Second monitor
C======================================================================C

C HP plotter:
 500  IF(IMONITOR2.EQ.5)THEN
        IF( .NOT.CLEAR )CALL HP_NEWPEN(ICODE2)

C CIT:
      ELSE IF(IMONITOR2.EQ.6) THEN
        WRITE(IOUTM2,110)ESC,'1'
        CALL FLUSH_PLOT
        ICITCOL2=ICODE2
        IF(ICODE2.EQ.0) WRITE(IOUTM2,110)ESC,'h'   
        IF(ICODE2.EQ.1) WRITE(IOUTM2,110)ESC,'i'   
        IF(ICODE2.EQ.2) WRITE(IOUTM2,110)ESC,'j'  
        IF(ICODE2.EQ.3) WRITE(IOUTM2,110)ESC,'k'   
        IF(ICODE2.EQ.4) WRITE(IOUTM2,110)ESC,'l'   
        IF(ICODE2.EQ.5) WRITE(IOUTM2,110)ESC,'m'
        IF(ICODE2.EQ.6) WRITE(IOUTM2,110)ESC,'n'   
        IF(ICODE2.EQ.7) WRITE(IOUTM2,110)ESC,'o'   

C TEKTRONIX-4107:
      ELSE IF (IMONITOR2 .EQ. 7) THEN
        CALL FLUSH_PLOT
        ICITCOL2=ICODE2
        WRITE(IOUTM, 60100) ESC, 'M', 'L', TEK4107_INDEX(ICODE2+1)

C VT241:
      ELSE IF(IMONITOR2.EQ.8)THEN
        IF(ICODE2.LT.0.OR.ICODE2.GT.15)GO TO 999
        CALL FLUSH_PLOT
        WRITE(IOUTM2,1000)ICODE2

C Houston plotter:
      ELSE IF(IMONITOR2.EQ.11)THEN
        IF( .NOT.CLEAR )CALL HOUSTON_NEWPEN(ICODE2)

C Seiko GR-1105:
      ELSE IF(IMONITOR2.EQ.12)THEN
        IF(ICODE2.LT.0.OR.ICODE2.GT.7)GO TO 999
        CALL FLUSH_PLOT
        TMP = CHAR( ICHAR(' ')+ICODE2 ) ! modified by J.Chuma, 19Mar97 for g77
        WRITE(IOUTM2,2000)ESC,'K ',ESC,'gB',TMP
C        WRITE(IOUTM2,2000)ESC,'K ',ESC,'gB',' '+ICODE2

C PostScript
      ELSE IF(IMONITOR2.EQ.14)THEN
        IF(.NOT.CLEAR)CALL POSTSCRIPT_COLOUR(ICODE2)

C GKS Metafile:
      ELSE IF(IMONITOR2.EQ.19)THEN
        CALL GKS_COLOUR(ICODE2)

C RD-GLII:
      ELSE IF(IMONITOR2.EQ.20)THEN
        IF( .NOT.CLEAR )CALL RDGL_NEWPEN(ICODE2)

      ENDIF

999   ICOLOUR_1 = ICODE
      ICOLOUR_2 = ICODE2

      RETURN
      END
