      SUBROUTINE PLOT_DEVICE2(IDEVICE,IOUTM,IOUTM2)
C
C  reqd. KOSTL: routines - HCOPYRANG,MONITRANG,MONIT2RNG
C
C=================================================================
C=================================================================
C==                                                             ==
C==   PLOT_DEVICE2: Sets the plot device to "IDEVICE" and the   ==
C==        screen output unit to "IOUTM".  When IDEVICE < -4 or ==
C==        IDEVICE > 4, a second monitor is activated and plotting
C==        output is also sent to the ZETA plotter via logical  ==
C==        unit IOUTM2.                                         ==
C==                                                             ==
C==   Written by Arthur Haynes, TRIUMF U.B.C., July 8, 1981.    ==
C==                                                             ==
C==   Input  Parameters: IDEVICE,IOUTM,IOUTM2 (I*4).            ==
C==                                                             ==
C==   Parameter Definitions:                                    ==
C==   --------- -----------                                     ==
C==                                                             ==
C==   IDEVICE: Device type. The default device type if          ==
C==            PLOT_DEVICE2 is not called is device 1.          ==
C==                                                             ==
C==            X, Y coordinates are user (= world) coordinates. ==
C==                                                             ==
C==            X is horizontal, Y is vertical on VT640,         ==
C==              Tektronix 4010/12, or VS11.                    ==
C==                                                             ==
C==        |IDEVICE| = 1: VT640 or Tektronix 4010/12 terminals. ==
C==                       0 <= X <= 639; 0 <= Y <= 479.         ==
C==                       On the hardcopy: X is horizontal.     ==
C==        |IDEVICE| = 2: VT640 or Tektronix 4010/12 terminals. ==
C==                       0 <= X <= 1023; 0 <= Y <= 779.        ==
C==                       On the hardcopy: X is vertical.       ==
C==        |IDEVICE| = 3: VT640 or Tektronix 4010/12 terminals. ==
C==                       0 <= X <= 2047; 0 <= Y <= 785.        ==
C==                       On the hardcopy: X is vertical.       ==
C==        |IDEVICE| = 4: VS11 emulating a VT640 or Tek 4010.   ==
C==                       0 <= X <= 639; 0 <= Y <= 479.         ==
C==                       On the hardcopy: X is horizontal.     ==
C==        |IDEVICE| = 5: VT640 or Tektronix 4010/12 terminals. ==
C==                       0 <= X <= 639; 0 <= Y <= 479.         ==
C==                       On the hardcopy: X is horizontal.     ==
C==                       Plus a ZETA plot ***********          ==
C==                       On the Zeta:     X is horizontal.     ==
C==        |IDEVICE| = 6: VT640 or Tektronix 4010/12 terminals. ==
C==                       0 <= X <= 1023; 0 <= Y <= 779.        ==
C==                       On the hardcopy: X is vertical.       ==
C==                       Plus a ZETA plot ***********          ==
C==                       On the Zeta:     X is horizontal.     ==
C==        |IDEVICE| = 7: VT640 or Tektronix 4010/12 terminals. ==
C==                       0 <= X <= 2047; 0 <= Y <= 785.        ==
C==                       On the hardcopy: X is vertical.       ==
C==                       Plus a ZETA plot ***********          ==
C==                       On the Zeta:     X is vertical.       ==
C==        |IDEVICE| = 8: VS11 emulating a VT640 or Tek 4010.   ==
C==                       0 <= X <= 639; 0 <= Y <= 479.         ==
C==                       On the hardcopy: X is horizontal.     ==
C==                       Plus a ZETA plot ***********          ==
C==                       On the Zeta:     X is horizontal.     ==
C==         IDEVICE  = 0: Hardcopy only. X is vertical.         ==
C==                       0 <= X <= 2047; 0 <= Y <= 785.        ==
C==                                                             ==
C==        If IDEVICE is positive then a screen plot is produced==
C==        and a hardcopy which is a bit map image of the screen==
C==        in printronix format (6 bits per byte) is also       ==
C==        produced.                                            ==
C==                                                             ==
C==        If IDEVICE is zero or negative then only the hardcopy==
C==        bit map is produced.                                 ==
C==                                                             ==
C==        When PLOT_DEVICE2 is called, the hardcopy and screen ==
C==        are not immediately cleared for that device, but are ==
C==        cleared the next time PLOT_R is called. After a call ==
C==        to PLOT_DEVICE2 the hardcopy should not be accessed  ==
C==        until a call to PLOT_R is performed.                 ==
C==                                                             ==
C==   IOUTM:  Output unit for the screen plot.                  ==
C==   IOUTM2: Output unit for second device (ZETA plotter).     ==
C==                                                             ==
C==                                                             ==
C==   Defaults:                                                 ==
C==   --------                                                  ==
C==                                                             ==
C==   If PLOT_DEVICE2 is not called, the device type defaults   ==
C==   to 1, and plotting output is sent to logical unit 6.      ==
C==   No output is sent to a second device.                     ==
C=================================================================
C=================================================================
      COMMON /PLOT_CLEAR/ CLEAR
C***********************************************************************
C                                                                      *
C    Common block DEVICE2_TYPE inserted August 2, 1983                 *
C                                   by J. Chuma                        *
C
C    Modified by Alan Carruthers, October 6, 1983
C      If PLOT_DEVICE2 was called with |device type| > 4 then later
C      called with |device type| <= 4, MONITOR2_RANGE was not called
C      to turn off monitor 2.  This has been corrected so that every
C      time DEVICE_TYPE2 is called with |device type| <= 4
C      MONITOR2_RANGE is called to deactivate monitor 2.
C                                                                      *
C***********************************************************************
      COMMON /DEVICE2_TYPE/ IDEVICE2
      LOGICAL CLEAR
      PARAMETER (NDEVICE = 8, NDEVICE1 = 9)
      REAL XMINH(0:NDEVICE)/NDEVICE1*0./,
     &     XMAXH(0:NDEVICE)/2047.,479.,1023.,2047.,479.,
     &                      479.,1023.,2047.,479./
      REAL YMINH(0:NDEVICE)/NDEVICE1*0./,
     &     YMAXH(0:NDEVICE)/785.,639.,779.,785.,639.,
     &                      639.,779.,785.,639./
      REAL XMINHP(0:NDEVICE)/NDEVICE1*0./,
     &     XMAXHP(0:NDEVICE)/2047.,639.,1023.,2047.,639.,
     &                       639.,1023.,2047.,639./
      REAL YMINHP(0:NDEVICE)/NDEVICE1*0./,
     &     YMAXHP(0:NDEVICE)/785.,479.,779.,785.,479.,
     &                       479.,779.,785.,479./
      INTEGER IORIENTH(0:NDEVICE)/1,-1,1,1,-1,-1, 1, 1,-1/
      INTEGER IORIENTM(0:NDEVICE)/1,-1,1,1,-1, 1,-1, 1, 1/
      INTEGER IMONITOR(0:NDEVICE)/0,1,1,1,3,1,1,1,3/
      REAL XMINM(0:NDEVICE)/NDEVICE1*0./,
     &     YMINM(0:NDEVICE)/NDEVICE1*0./
C====================================================================
C==                                                                ==
C== IDEVICE IADEV IMON XMAXH YMAXH XMAXHP YMAXHP XMAXM YMAXM OH OM ==
C==     0      0    0   2047  785   2047   785      0     0   1  1 ==
C== +/- 1      1    1    479  639    639   479    639   479  -1 -1 ==
C== +/- 2      2    1   1023  779   1023   779   1023   779   1  1 ==
C== +/- 3      3    1   2047  785   2047   785    511   479   1  1 ==
C== +/- 4      4    3    479  639    639   479      0     0  -1 -1 ==
C== +/- 5      5    1    479  639    639   479 20.944 27.94  -1  1 ==
C== +/- 6      6    1   1023  779   1023   779 21.276 27.94   1 -1 ==
C== +/- 7      7    1   2047  785   2047   785 43.18  27.94   1  1 ==
C== +/- 8      8    3    479  639    639   479 20.944 27.94  -1  1 ==
C====================================================================
C
C   ZETA plot dimensions:
C      YMINM = 0 cm                                 (devices 5 - 8)
C      XMINM = 0 cm                                 (devices 5 - 8)
C      YMAXM = 11 * 2.54 = 27.94 cm                 (devices 5 - 8)
C      XMAXM = 11 * 2.54 * 479/639 = 20.944 cm      (devices 5, 8)
C      XMAXM = 11 * 2.54 * 779/1023 = 21.276 cm     (device 6)
C      XMAXM = 8.5 * 2.54 * 2 = 43.18 cm            (device 7)
C              Note that for device 7 differential scaling is used
C              for the X and Y axes. (e.g. Circles in world
C              coordinates appear on the ZETA plotter as ellipses.)
C
C
C
      REAL XMAXM(0:NDEVICE)/0.,639.,1023.,511.,0.,
     &                      20.944,21.276,43.18,20.944/,
     &     YMAXM(0:NDEVICE)/0.,479., 779.,479.,0.,
     &                      27.94,27.94,27.94,27.94/
C=================================================================
C==   Check the validity of the plot device number "IDEVICE".   ==
C=================================================================
      IF(IABS(IDEVICE).GT.NDEVICE)THEN
         WRITE(6,10)IDEVICE
10       FORMAT(' ***Error*** in PLOT_DEVICE2:',
     *          ' Invalid device type: ',I5)
         RETURN
      ENDIF
      IDEVICE2 = IDEVICE
      IADEV=IABS(IDEVICE)
C------------------------------------------------------------
C     Inserted by Alan Carruthers, Oct 6, 1983:
      IF(IADEV .LE. 4) THEN
         IMON2 = 0
      ELSE
         IMON2 = 4
      END IF
C------------------------------------------------------------
      IMON=IMONITOR(IADEV)
      IF(IDEVICE.LT.0)IMON=0
      CALL HARDCOPY_RANGE(XMINH(IADEV),XMAXH(IADEV),YMINH(IADEV),
     * YMAXH(IADEV),XMINHP(IADEV),XMAXHP(IADEV),YMINHP(IADEV),
     * YMAXHP(IADEV),IORIENTH(IADEV))
C
C  INITIALIZE THE ZETA PLOTTER IF IADEV>4
C
C     IF(IADEV.GT.4)CALL Z_PLOTS(53,0,IOUTM2)
C
C     IF(IADEV.GT.4)CALL MONITOR2_RANGE(4,IOUTM2,
C     CALL MONITOR2_RANGE(IMON2,IOUTM2,  !inserted by Alan Carruthers
C    *                   XMINH(IADEV),XMAXH(IADEV),
C    *                   YMINH(IADEV),YMAXH(IADEV),
C    *                   XMINM(IADEV),XMAXM(IADEV),
C    *                   YMINM(IADEV),YMAXM(IADEV),
C    *                   IORIENTM(IADEV))
      CALL MONITOR_RANGE(IMON,IOUTM,
     *                   XMINH(IADEV),XMAXH(IADEV),
     *                   YMINH(IADEV),YMAXH(IADEV),
     *                   XMINM(IMON),XMAXM(IMON),
     *                   YMINM(IMON),YMAXM(IMON),
     *                   IORIENTH(IADEV))
C=================================================================
C==   Set the clear flag on so that the next time PLOT_R is     ==
C==   called the screen will be cleared.                        ==
C=================================================================
      CLEAR=.TRUE.
      RETURN
      END
