C======================================================================C
C  RD-GLII plotter subroutines                                         C
C                                                                      C
C  modified HP subroutines by Joe Chuma, October 16, 1990              C
C                                                                      C
C======================================================================C
      SUBROUTINE RDGL_PLOTS(N,M,IUNIT)

C  Initialization

      COMMON /RDGL_UNIT/ IIUNIT
      COMMON /RDGL_PEN/ PX,PY,ICOUNT,PEN_STATE
      CHARACTER*1 PEN_STATE  ! modified by J.Chuma, 19Mar97 for g77
C                               was LOGICAL*1
      PEN_STATE='U'
      PX=-1.
      PY=-1.
      ICOUNT=-1
      IIUNIT = IUNIT
      CALL RDGL_NEWPEN(1)
      RETURN
      END

      SUBROUTINE RDGL_PLOT(DX,DY,IPEN)

C  Call RDGL_PLOT with real values of x and y in the range
C  size A:         0 < x <  24.94 and 0 < y < 16.19 cm 
C  size B:         0 < x <  37.78 and 0 < y < 24.94 cm 
C  size C:         0 < x <  52.88 and 0 < y < 37.78 cm 
C  size D:         0 < x <  83.36 and 0 < y < 50.48 cm 
C  size E:         0 < x < 106.36 and 0 < y < 83.36 cm 
C  The RD-GLII plotter requires ASCII integer strings in the range
C  size A:      -4988 < x <  4988 and  -3238 < y <  3238
C  size B:      -7556 < x <  7556 and  -4988 < y <  4988
C  size C:     -10576 < x < 10576 and  -7556 < y <  7556
C  size D:     -16672 < x < 16672 and -10096 < y < 10096
C  size E:     -21272 < x < 21272 and -16672 < y < 16672
C  when using the ANSI A size paper 
C
C    The RD-GLII plotter has 400 "plotter units" per cm
C
C    Use the orientation of -1 in the call to MONITOR2_RANGE 
C    for an RD-GLII plotter

      COMMON /RDGL_UNIT/ IIUNIT
      CHARACTER*1   PEN
      COMMON /RDGL_PEN/ PX,PY,ICOUNT,PEN_STATE
      CHARACTER*1 PEN_STATE  ! modified by J.Chuma, 19Mar97 for g77
C                               was LOGICAL*1
      CHARACTER*7 CHX,CHY,BUF(12)
      COMMON /RDGLFLUSH/ BUF
      CHARACTER*84 STRING

      INTEGER PLTR_SIZE
      COMMON  /PLOTTER_SIZE/  PLTR_SIZE
      INTEGER*4 IOFFX(0:4), IOFFY(0:4)
      DATA IOFFX /-4988,-7556,-10576,-16672,-21272/
      DATA IOFFY /-3238,-4988,-7556,-10096,-16672/

      PX=DX
      PY=DY
      IX=DX*400.+IOFFX(PLTR_SIZE)
      IY=DY*400.+IOFFY(PLTR_SIZE)
      WRITE(CHX,999)IX
      WRITE(CHY,999)IY
  999 FORMAT(I7)

      PEN = 'D'
      IF (IPEN.GT.2) PEN = 'U'        !select pen UP/DOWN
      IF (PEN.EQ.PEN_STATE) THEN      !same pen state?
C  Forget about old position if pen is still up:
         IF (PEN.EQ.'U'.AND.ICOUNT.GE.1) GOTO 60
         ICOUNT=ICOUNT+2
   60    BUF(ICOUNT)=CHX
         BUF(ICOUNT+1)=CHY
         IF (ICOUNT.LT.11) RETURN
C  write buffer if full
         DO I = 1, ICOUNT+1   ! modified by J.Chuma, 19Mar97 for g77
           STRING(1+7*(I-1):7*I) = BUF(I)
         END DO
         WRITE(IIUNIT,45,ERR=99) PEN,STRING(1:7*(ICOUNT+1))
C         WRITE(IIUNIT,45,ERR=99) PEN,(BUF(I),I=1,12)
         ICOUNT=-1
         RETURN
      ELSE
         IF( ICOUNT .NE. -1 )THEN   ! modified by J.Chuma, 19Mar97 for g77
           DO I = 1, ICOUNT+1
             STRING(1+7*(I-1):7*I) = BUF(I)
           END DO
           WRITE(IIUNIT,45,ERR=99) PEN_STATE,STRING(1:7*(ICOUNT+1))
C           WRITE(IIUNIT,45,ERR=99) PEN_STATE,(BUF(I),I=1,ICOUNT+1)
                                  !flush buffer of previous pen state
                                  !if it is not empty
         END IF
         ICOUNT=1
         PEN_STATE=PEN           !new pen status
         BUF(1)=CHX
         BUF(2)=CHY
      ENDIF
   45 FORMAT('P',A1,A,';')
C   45 FORMAT('P',A1,<ICOUNT+1>A7,';') ! g77 doesn't allow variable formats
      RETURN
99    CALL TRANSPARENT_MODE(0)
      WRITE(*,*)'Error writing to RD-GLII plot file'
      IDUM = NARGSI(0)
      CALL PUT_FORMSG
      RETURN
      END

      SUBROUTINE RDGL_FLUSH
      COMMON /RDGL_UNIT/ IIUNIT
      COMMON /RDGL_PEN/ PX,PY,ICOUNT,PEN_STATE
      CHARACTER*1 PEN_STATE  ! modified by J.Chuma, 19Mar97 for g77
C                               was LOGICAL*1
      CHARACTER*7 BUF(12)
      COMMON /RDGLFLUSH/ BUF
      CHARACTER*84 STRING

      IF( ICOUNT .NE. -1 )THEN
        DO I = 1, ICOUNT+1
          STRING(1+7*(I-1):7*I) = BUF(I)
        END DO
        WRITE(IIUNIT,45,ERR=99) PEN_STATE,STRING(1:7*(ICOUNT+1))
C        WRITE(IIUNIT,45,ERR=99) PEN_STATE,(BUF(I),I=1,ICOUNT+1)
                                  !flush buffer of previous pen state
                                  !if it is not empty
      END IF
   45 FORMAT('P',A1,A,';')
C   45 FORMAT('P',A1,<ICOUNT+1>A7,';')
      ICOUNT=-1
      RETURN
   99 CALL TRANSPARENT_MODE(0)
      WRITE(*,*)'Error writing to RD-GLII plot file'
      IDUM = NARGSI(0)
      CALL PUT_FORMSG
      RETURN
      END

      SUBROUTINE RDGL_NEWPEN(IDUM)

C  Just selects the pen

      COMMON /RDGL_UNIT/ IIUNIT
      COMMON /RDGL_PEN/ PX,PY,ICOUNT,PEN_STATE
      CHARACTER*1 PEN_STATE  ! modified by J.Chuma, 19Mar97 for g77
C                               was LOGICAL*1
C   Flush buffer

      CALL RDGL_FLUSH
      WRITE(IIUNIT,70,ERR=99)
      WRITE(IIUNIT,60,ERR=99)IDUM
      PEN_STATE='U'
      ICOUNT=-1
   60 FORMAT('SP',I1,';')
   70 FORMAT('PU;')
      RETURN
   99 CALL TRANSPARENT_MODE(0)
      WRITE(*,*)'Error writing to RD-GLII plot file'
      IDUM = NARGSI(0)
      CALL PUT_FORMSG
      RETURN
      END

      SUBROUTINE RDGL_SPEED(ISPEED)

C  Changes the plotting speed

      COMMON /RDGL_UNIT/ IIUNIT
      COMMON /RDGL_PEN/ PX,PY,ICOUNT,PEN_STATE
      CHARACTER*1 PEN_STATE  ! modified by J.Chuma, 19Mar97 for g77
C                               was LOGICAL*1
      IF(ISPEED.LT.1.OR.ISPEED.GT.80)RETURN
      CALL RDGL_FLUSH
      WRITE(IIUNIT,1000,ERR=99)ISPEED
 1000 FORMAT('VS',I2,';')      
      RETURN
   99 CALL TRANSPARENT_MODE(0)
      WRITE(*,*)'Error writing to RD-GLII plot file'
      IDUM = NARGSI(0)
      CALL PUT_FORMSG
      RETURN
      END
