      LOGICAL FUNCTION SEGMENT_CROSSH(XI1,YI1,XI2,YI2,X1P,X2P,YP,
     *                                XC,YC)
C
C  reqd. routines - NONE 
C
C=================================================================
C=================================================================
C==                                                             ==
C==   SEGMENT_CROSSH: returns the function value .TRUE./(.FALSE.)=
C==       if the line segment (X1,Y1)-->(X2,Y2) crosses/(does   ==
C==       not cross) the line segment (X1P,YP)-->(X2P,YP). If   ==
C==       the line segments cross then it also returns the point==
C==       (XC,YC) at which they cross, as well calculates the   ==
C==       distance "S" along the segment (X1,Y1)-->(X2,Y2) at   ==
C==       which they cross, i.e.                                ==
C==       (XC,YC) = (X1,Y1) + S * (X2-X1,Y2-Y1).                ==
C==                                                             ==
C==   Written by Arthur Haynes, TRIUMF U.B.C., July 6, 1981.    ==
C==   Modified by J. Chuma, Sept 5/90  to handle horiz. segment ==
C==     crossing, eliminating round-off problems associated with =
C==     direction of test line segment X1,Y1 X2,Y2              ==
C==     used in HATCH                                           ==
C==                                                             ==
C==   Input  Parameters: XI1,YI1,XI2,YI2,X1P,YP,X2P,YP (R*4).   == 
C==                                                             ==
C==   Output Parameters: XC,YC (R*4).                           ==
C==                                                             ==
C=================================================================
C=================================================================
      IF( YI1 .LT. YI2 )THEN
        Y1=YI2
        X1=XI2
        Y2=YI1
        X2=XI1
      ELSE
        X1=XI1
        Y1=YI1
        X2=XI2
        Y2=YI2
      END IF
      DX1=X1-X1P
      DY1=Y1-YP
      A11=X2P-X1P
      A12=X1-X2
      A22=Y1-Y2
      DETA=A11*A22
      SEGMENT_CROSSH=.FALSE.
      IF(ABS(DETA).LE.1.E-10)RETURN
      T=(A22*DX1-A12*DY1)/DETA
      S=DY1/A22
      IF(S.LT.0. .OR. S.GT.1.)RETURN
      IF(T.LT.0. .OR. T.GT.1.)RETURN
      SEGMENT_CROSSH=.TRUE.
      XC=X1+S*(X2-X1)
      YC=Y1+S*(Y2-Y1)
      RETURN
      END
