      SUBROUTINE SET_PLOT_DEVICES(IMON1_IN,IOUT1_IN,IMON2_IN,IOUT2_IN
     &                           ,IBIT,UNITS,MODE,NPAGES,*,*,*,*,*)
C
C    This routine calls HARDCOPY_RANGE, MONITOR_RANGE, and
C    MONITOR2_RANGE setting up the user units for plotting in
C    centimeters or inches.
C
C    Two orientations are allowed: LANDSCAPE and PORTRAIT.
C    The viewport will have the correct aspect ratio (i.e. circles will
C    be circles on the screen, on the pen plotter and on the bitmap
C    hardcopy).
C
C    In LANDSCAPE mode, the world range in  centimeters:
C
C     HPA       0. <= X <= 25.00           0. <= Y <= 19.00 \
C     HPB       0. <= X <= 40.64           0. <= Y <= 25.40 |
C     HPC       0. <= X <= 53.34           0. <= Y <= 40.64 |HP plotters
C     HPD       0. <= X <= 83.82           0. <= Y <= 53.34 |
C     HPE       0. <= X <=109.22           0. <= Y <= 83.82 /
C     HIA       0. <= X <= 25.00           0. <= Y <= 19.00 \
C     HIB       0. <= X <= 40.64           0. <= Y <= 25.40 |
C     HIC       0. <= X <= 53.34           0. <= Y <= 40.64 |Houston
C     HID       0. <= X <= 83.82           0. <= Y <= 53.34 |
C     HIE       0. <= X <=109.22           0. <= Y <= 83.82 /
C    LN03+      0. <= X <= 27.94           0. <= Y <= 21.59
C  IMAGEN       0. <= X <= 27.94           0. <= Y <= 21.59
C  POSTSCRIPT   0. <= X <= 26.67           0. <= Y <= 20.32 size A3
C  POSTSCRIPT   0. <= X <= 28.4226         0. <= Y <= 19.727333 size A4
C GKS MetaFile  0. <= X <= 27.94           0. <= Y <= 21.59
C RDGLIIA       0. <= X <= 24.94           0. <= Y <= 16.19 \
C RDGLIIB       0. <= X <= 37.78           0. <= Y <= 24.94 |
C RDGLIIC       0. <= X <= 52.88           0. <= Y <= 37.78 |RD-GLII 
C RDGLIID       0. <= X <= 83.36           0. <= Y <= 50.48 |plotters
C RDGLIIE       0. <= X <=106.36           0. <= Y <= 83.36 /
C
C      and in inches the range will be:
C
C     HPA       0. <= X <=  9.84           0. <= Y <=  7.48
C     HPB       0. <= X <= 16.00           0. <= Y <= 10.0
C     HPC       0. <= X <= 21.00           0. <= Y <= 16.0
C     HPD       0. <= X <= 33.00           0. <= Y <= 21.0
C     HPE       0. <= X <= 43.00           0. <= Y <= 33.0
C     HIA       0. <= X <=  9.84           0. <= Y <=  7.48
C     HIB       0. <= X <= 16.00           0. <= Y <= 10.0
C     HIC       0. <= X <= 21.00           0. <= Y <= 16.0
C     HID       0. <= X <= 33.00           0. <= Y <= 21.0
C     HIE       0. <= X <= 43.00           0. <= Y <= 33.0
C    LN03+      0. <= X <= 11.00           0. <= Y <=  8.5
C  IMAGEN       0. <= X <= 11.00           0. <= Y <=  8.5
C  POSTSCRIPT   0. <= X <= 10.50           0. <= Y <=  8.0   size A3
C  POSTSCRIPT   0. <= X <= 11.19           0. <= Y <=  7.767 size A4
C GKS Metafile  0. <= X <= 11.00           0. <= Y <=  8.5
C RDGLIIA       0. <= X <=  9.82           0. <= Y <=  6.37
C RDGLIIB       0. <= X <= 14.87           0. <= Y <=  9.82
C RDGLIIC       0. <= X <= 20.82           0. <= Y <= 14.87
C RDGLIID       0. <= X <= 32.82           0. <= Y <= 19.87
C RDGLIIE       0. <= X <= 41.87           0. <= Y <= 32.82
C
C      In PORTRAIT mode, the world units range in centimeters:
C
C     HPA        0. <= X <= 19.00           0. <= Y <= 25.00
C     HPB        0. <= X <= 25.40           0. <= Y <= 40.64
C     HPC        0. <= X <= 40.64           0. <= Y <= 53.34
C     HPD        0. <= X <= 53.34           0. <= Y <= 83.82
C     HPE        0. <= X <= 83.82           0. <= Y <=109.22
C     HIA        0. <= X <= 19.00           0. <= Y <= 25.00
C     HIB        0. <= X <= 25.40           0. <= Y <= 40.64
C     HIC        0. <= X <= 40.64           0. <= Y <= 53.34
C     HID        0. <= X <= 53.34           0. <= Y <= 83.82
C     HIE        0. <= X <= 83.82           0. <= Y <=109.22
C    LN03+       0. <= X <= 21.59           0. <= Y <= 27.94
C   IMAGEN       0. <= X <= 21.59           0. <= Y <= 27.94
C   POSTSCRIPT   0. <= X <= 20.32           0. <= Y <= 26.67     size A3
C   POSTSCRIPT   0. <= X <= 19.727333       0. <= Y <= 28.4226   size A4
C   GKS MetaFile 0. <= X <= 21.59           0. <= Y <= 27.94
C   RDGLIIA      0. <= X <= 16.19           0. <= Y <= 24.94 \
C   RDGLIIB      0. <= X <= 24.94           0. <= Y <= 37.78 |
C   RDGLIIC      0. <= X <= 37.78           0. <= Y <= 52.88 |RD-GLII 
C   RDGLIID      0. <= X <= 50.48           0. <= Y <= 83.36 |plotters
C   RDGLIIE      0. <= X <= 83.36           0. <= Y <=106.36 /
C
C      and in inches the range will be:
C
C     HPA       0. <= X <=  7.48           0. <= Y <=  9.84
C     HPB       0. <= X <= 10.0            0. <= Y <= 16.0
C     HPC       0. <= X <= 16.0            0. <= Y <= 21.0
C     HPD       0. <= X <= 21.0            0. <= Y <= 33.0
C     HPE       0. <= X <= 33.0            0. <= Y <= 43.0
C     HIA       0. <= X <=  7.48           0. <= Y <=  9.84
C     HIB       0. <= X <= 10.0            0. <= Y <= 16.0
C     HIC       0. <= X <= 16.0            0. <= Y <= 21.0
C     HID       0. <= X <= 21.0            0. <= Y <= 33.0
C     HIE       0. <= X <= 33.0            0. <= Y <= 43.0
C    LN03+      0. <= X <=  8.5            0. <= Y <= 11.0
C  IMAGEN       0. <= X <=  8.5            0. <= Y <= 11.0
C  POSTSCRIPT   0. <= X <=  8.0            0. <= Y <= 10.5   size A3
C  POSTSCRIPT   0. <= X <=  7.767          0. <= Y <= 11.19  size A4
C GKS MetaFile  0. <= X <=  8.5            0. <= Y <= 11.0
C RDGLIIA       0. <= X <=  6.37           0. <= Y <=  9.82
C RDGLIIB       0. <= X <=  9.82           0. <= Y <= 14.87
C RDGLIIC       0. <= X <= 14.87           0. <= Y <= 20.82
C RDGLIID       0. <= X <= 19.87           0. <= Y <= 32.82
C RDGLIIE       0. <= X <= 32.82           0. <= Y <= 41.87
C
C     Input:
C
C INTEGER*4     IMON1 = 0: non-graphics monitor ( VT100 )
C                     = 1: VT640
C                     = 2: Tektronix 4010/12
C                     = 3: *** unused ***
C                     = 6: CIT-467
C                     = 7: TEK 4107
C                     = 8: VT241
C                     = 9: PT100G
C                     =12: SEIKO
C                     =15: *** unused ***
C                     =17: generic terminal
C                     =18: X Windows
C    "          IOUT1 = screen output unit (usually 6)
C    "          IMON2 = 0: NO plotter               (21.59 x 27.94 cm)
C                       1: VT640       display file (21.59 x 27.94 cm)
C                       2: TEK 4010/12 display file (21.59 x 27.94 cm)
C    "                  4: *** unused ***
C                       5: HP plotter
C                          PLTR_SIZE = 0  --> size A  see common block
C                          PLTR_SIZE = 1  --> size B   PLOTTER_SIZE
C                          PLTR_SIZE = 2  --> size C
C                          PLTR_SIZE = 3  --> size D
C                          PLTR_SIZE = 4  --> size E
C                       6: CIT-467     display file (21.59 x 27.94 cm)
C                       7: TEK 4107    display file (21.59 x 27.94 cm)
C                       8: VT241       display file (21.59 x 27.94 cm)
C                       9: PT100G      display file (21.59 x 27.94 cm)
C                      10: *** unused ***
C                      11: HOUSTON INSTRUMENTS pen plotter
C                          PLTR_SIZE = 0  --> size A    see common block
C                          PLTR_SIZE = 1  --> size B     PLOTTER_SIZE
C                          PLTR_SIZE = 2  --> size C
C                          PLTR_SIZE = 3  --> size D
C                          PLTR_SIZE = 4  --> size E
C                      12: SEIKO       display file (21.59 x 27.94 cm)
C                      13: Imagen                   (21.59 x 27.94 cm)
C                      14: PostScript               (21.59 x 27.94 cm)
C                          PLTR_SIZE = 0  --> size A3
C                          PLTR_SIZE = 1  --> size A4
C                      16: LN03+                    (21.59 x 27.94 cm)
C                      19: GKS MetaFile             (21.59 x 27.94 cm)
C                      20: RD-GLII pen plotter
C                          PLTR_SIZE = 0  --> size A    see common block
C                          PLTR_SIZE = 1  --> size B     PLOTTER_SIZE
C                          PLTR_SIZE = 2  --> size C
C                          PLTR_SIZE = 3  --> size D
C                          PLTR_SIZE = 4  --> size E
C    "          IOUT2 = second monitor output unit (usually 7)
C    "          IBIT  = 00 ->  400 x  587,          NO bitmap
C    "           "      01 ->  700 x  785,          PRINTRONIX
C                "     002 ->  985 x  749, 100 dpi, HP LaserJet 
C                "     012 -> 1477 x 1123, 150 dpi, HP LaserJet
C                "     022 -> 1477 x 1123, 300 dpi, HP LaserJet
C                "     032 -> 2954 x 2246, 300 dpi, HP LaserJet
C                "     102 ->  985 x  749, 100 dpi, HP LJet compressed
C                "     112 -> 1477 x 1123, 150 dpi, HP LJet compressed
C                "     122 -> 1477 x 1123, 300 dpi, HP LJet compressed
C                "     132 -> 2954 x 2246, 300 dpi, HP LJet compressed
C                "      03 ->  853 x  640, 96 dpi,  HP ThinkJet
C                "      04 -> 1055 x  433,          LA100
C if npages > 1  "      05 -> 1980*NPAGES x 1440,   HP PaintJet 
C if npages = 1  "      05 -> 1890 x 1350,          HP PaintJet 
C
C              NPAGES = number of pages of HP PaintJet output
C                       restricted to be between 1 and 10
C                       if IBIT is not 5, then NPAGES should be 1 (one)
C
C CHARACTER*(*)  MODE = 'LANDSCAPE' or 'PORTRAIT'
C                    only the first character of MODE is tested
C
C CHARACTER*2   UNITS = 'CM' or 'IN'
C
C           RETURN1   if MODE(1:1) is neither 'P' nor 'L'
C           RETURN2   if IMON1 is invalid
C           RETURN3   if IMON2 is invalid
C           RETURN4   if IBIT  is invalid
C           RETURN5   if UNITS is invalid
C
C                                       Joe Chuma
C                                       January, 1986
C
C Revised: August, 1987 to allow for non-commensurate bitmap hardcopy
C Revised: November, 1987 to allow for HP PaintJet bitmap hardcopy
C Revised: March, 1988 to allow for different sizes of pen plotter paper
C          for HP pen plotters and Houston Instruments pen plotters
C Revised: May, 1988 to allow for multiple (up to 10) pages of 
C          HP PaintJet paper output
C Revised: August, 1988 to allow for POSTSCRIPT
C Revised: May 15, 1989 to allow for generic terminal 
C Revised: November 21, 1989 to allow for GKS metafiles and 
C          to clear the display on UIS Workstations
C Revised: December 8, 1989 to allow for 9.85in x 7.49in (full page)
C          300 dpi bitmap on the HP LaserJet
C Revised: May 31, 1990  changed the bitmap size for the HP PAINTJET
C          so it shouldn't page eject after a 1 page plot
C Revised: Oct 16, 1990 to allow for RD-GLII pen plotters e.g. ROLAND
C Revised: May 2, 1991 to take out the VS11 support
C Revised: Sept 8, 1993 to take out the UIS, ZETA and QMS support
CZZZZ
      CHARACTER*(*) MODE
      CHARACTER*2   UNITS, UNITSS, UPPER_CASE
      LOGICAL       OPEND, FIRST
      DATA FIRST /.TRUE./

      LOGICAL WELL
      COMMON /TO_BIT_OR_NOT/ WELL

      COMMON  /BITMAP_DEVICE/ IBIT_COMMON

C   HP, HOUSTON, RD-GLII pen plotters, and PostScript
C   PLTR_SIZE = 0  --> size A         
C   PLTR_SIZE = 1  --> size B
C   PLTR_SIZE = 2  --> size C
C   PLTR_SIZE = 3  --> size D
C   PLTR_SIZE = 4  --> size E
C   PLTR_SIZE = 5  --> size A3 paper ( 8.5 x 11.0 in) PostScript
C   PLTR_SIZE = 6  --> size A4 paper (21.0 x 29.7 cm) PostScript

      INTEGER*4 PLTR_SIZE
      COMMON  /PLOTTER_SIZE/  PLTR_SIZE
      DATA  PLTR_SIZE /0/

      LOGICAL*1 DEVFLIP
      COMMON /DEVICE_FLIP/ DEVFLIP
      DATA DEVFLIP /.FALSE./
CCC
      SAVE

      IMON1 = IMON1_IN
      IOUT1 = IOUT1_IN
      IMON2 = IMON2_IN
      IOUT2 = IOUT2_IN

      INQUIRE(UNIT=IOUT1,OPENED=OPEND)
      IF( (IOUT1 .NE. 6) .AND. .NOT.OPEND )
     &  OPEN(UNIT=IOUT1,FILE='TT:',STATUS='UNKNOWN')

      UNITSS = UPPER_CASE(UNITS)
      IF( UNITSS .EQ. 'CM' )THEN
        UNIT_SCALE = 1.0
      ELSE IF( UNITSS .EQ. 'IN' )THEN
        UNIT_SCALE = 2.54
      ELSE
        WRITE(IOUT1,10)'*** ERROR SET_PLOT_DEVICES: Invalid units'
10      FORMAT(' ',A)
        RETURN 5
      END IF

      IF( IMON2 .EQ. 5 )THEN            ! HP pen plotter
        IOR2   = -1
        IF( PLTR_SIZE .EQ. 0 )THEN           ! HP size A
          XMAX   = 19.00
          YMAXM2 = 19.00
          YMAX   = 25.00
          XMAXM2 = 25.00
        ELSE IF( PLTR_SIZE .EQ. 1 )THEN      ! HP size B
          XMAX   = 25.40
          YMAXM2 = 25.40
          YMAX   = 40.64
          XMAXM2 = 40.64
        ELSE IF( PLTR_SIZE .EQ. 2 )THEN      ! HP size C
          XMAX   = 40.64
          YMAXM2 = 40.64
          YMAX   = 53.34
          XMAXM2 = 53.34
        ELSE IF( PLTR_SIZE .EQ. 3 )THEN      ! HP size D
          XMAX   = 53.34
          YMAXM2 = 53.34
          YMAX   = 83.82
          XMAXM2 = 83.82
        ELSE IF( PLTR_SIZE .EQ. 4 )THEN      ! HP size E
          XMAX   = 83.82
          YMAXM2 = 83.82
          YMAX   =109.22
          XMAXM2 =109.22
        END IF
      ELSE IF( IMON2 .EQ. 11 )THEN        ! HOUSTON INSTRUMENTS
        IOR2   = -1
        IF( PLTR_SIZE .EQ. 0 )THEN           ! HI size A
          XMAX   = 19.00
          YMAXM2 = 19.00
          YMAX   = 25.00
          XMAXM2 = 25.00
        ELSE IF( PLTR_SIZE .EQ. 1 )THEN      ! HI size B
          XMAX   = 25.40
          YMAXM2 = 25.40
          YMAX   = 40.64
          XMAXM2 = 40.64
        ELSE IF( PLTR_SIZE .EQ. 2 )THEN      ! HI size C
          XMAX   = 40.64
          YMAXM2 = 40.64
          YMAX   = 53.34
          XMAXM2 = 53.34
        ELSE IF( PLTR_SIZE .EQ. 3 )THEN      ! HI size D
          XMAX   = 53.34
          YMAXM2 = 53.34
          YMAX   = 83.82
          XMAXM2 = 83.82
        ELSE IF( PLTR_SIZE .EQ. 4 )THEN      ! HI size E
          XMAX   = 83.82
          YMAXM2 = 83.82
          YMAX   =109.22
          XMAXM2 =109.22
        END IF
      ELSE IF( IMON2 .EQ. 13 )THEN         ! IMAGEN vector plotter
        IOR2   = -1
        XMAX   =   21.59
        YMAXM2 = 2560.
        YMAX   =   27.94
        XMAXM2 = 3328.
      ELSE IF( IMON2 .EQ. 14 )THEN         ! POSTSCRIPT
        IOR2   = -1
        IF( PLTR_SIZE .EQ. 0 )THEN           ! size A
          XMAX   = 19.00
          YMAX   = 25.00
          XMAXM2 = 3102.   ! Assume 300dpi    10.84in with 1/2in margins
          YMAXM2 = 2394.   !   "      "        8.48in with 1/2in margins
        ELSE IF( PLTR_SIZE .EQ. 1 )THEN      ! size B
          XMAX   = 25.40
          YMAX   = 40.64
          XMAXM2 = 4950.   ! remember the 150 dot minima
          YMAXM2 = 3150.
        ELSE IF( PLTR_SIZE .EQ. 2 )THEN      ! size C
          XMAX   = 40.64
          YMAX   = 53.34
          XMAXM2 = 6450.
          YMAXM2 = 4950.
        ELSE IF( PLTR_SIZE .EQ. 3 )THEN      ! size D
          XMAX   = 53.34
          YMAX   = 83.82
          XMAXM2 =10050.
          YMAXM2 = 6450.
        ELSE IF( PLTR_SIZE .EQ. 4 )THEN      ! size E
          XMAX   = 83.82
          YMAX   =109.22
          XMAXM2 =13050.
          YMAXM2 =10050.
        ELSE IF( PLTR_SIZE .EQ. 5 )THEN      ! paper size A3  8.5 x 11
          XMAX   = 19.05                     !   7.50 in
          YMAX   = 25.40                     !  10.00 in
C   150 dot minimum for x and y in call to MONITOR2_RANGE below
          XMAXM2 = 3150.   ! Assume 300dpi    with 1/2in margins
          YMAXM2 = 2400.   
        ELSE IF( PLTR_SIZE .EQ. 6 )THEN      ! paper size A4 21 x 29.7cm
          XMAX   = 18.46                     !   7.27 in
          YMAX   = 27.16                     !  10.69 in
          XMAXM2 = 3357.  ! Assume 300dpi     with 1/2 in margins
          YMAXM2 = 2330.  
        END IF
      ELSE IF( IMON2 .EQ. 16 )THEN         ! LN03+ device
        IOR2   = -1
        XMAX   = 21.59
        YMAX   = 27.94
        XMAXM2 = 639.
        YMAXM2 = 479.
      ELSE IF( IMON2 .EQ. 19 )THEN         ! GKS MetaFile
        IOR2   = -1
        XMAX   = 21.59
        YMAX   = 27.94
        XMAXM2 =  1.
        YMAXM2 =  1.
      ELSE IF( IMON2 .EQ. 20 )THEN           ! RD-GLII pen plotter
        IOR2   = -1
        IF( PLTR_SIZE .EQ. 0 )THEN           ! size A
          XMAX   = 16.19
          YMAXM2 = 16.19
          YMAX   = 24.94
          XMAXM2 = 24.94
        ELSE IF( PLTR_SIZE .EQ. 1 )THEN      ! size B
          XMAX   = 24.94
          YMAXM2 = 24.94
          YMAX   = 37.78
          XMAXM2 = 37.78
        ELSE IF( PLTR_SIZE .EQ. 2 )THEN      ! size C
          XMAX   = 37.78
          YMAXM2 = 37.78
          YMAX   = 52.88
          XMAXM2 = 52.88
        ELSE IF( PLTR_SIZE .EQ. 3 )THEN      ! size D
          XMAX   = 50.48
          YMAXM2 = 50.48
          YMAX   = 83.36
          XMAXM2 = 83.36
        ELSE IF( PLTR_SIZE .EQ. 4 )THEN      ! size E
          XMAX   = 83.36
          YMAXM2 = 83.36
          YMAX   =106.36
          XMAXM2 =106.36
        END IF

C  the rest are display files for terminals

      ELSE IF( (IMON2 .EQ. 0) .OR. (IMON2 .EQ.  1) .OR. (IMON2 .EQ.  2)
     &    .OR. (IMON2 .EQ. 6) .OR. (IMON2 .EQ.  7) .OR. (IMON2 .EQ.  8)
     &    .OR. (IMON2 .EQ. 9) .OR. (IMON2 .EQ. 12) )THEN
        IOR2   = +1
        XMAX   = 21.59
        XMAXM2 = 21.59
        YMAX   = 27.94
        YMAXM2 = 27.94
      ELSE
        WRITE(IOUT1,10)
     &  '*** ERROR in SET_PLOT_DEVICES: invalid second monitor'
        RETURN 3
      END IF

      PAGES  = 1.0
      FACTOR = 1.0
      IF( IBIT .NE. IBIT_COMMON )THEN
        IF( FIRST )THEN
          FIRST = .FALSE.
        ELSE
          CALL CLEAR_PLOT
        END IF
      END IF
      IBIT3  = IBIT / 100
      IBIT2  = (IBIT - 100*IBIT3) / 10
      IBIT1  = IBIT - 100*IBIT3 - 10*IBIT2
      WELL   = .TRUE.

      XMINP = 0.
      YMINP = 0.
      XMIN  = 0.
      YMIN  = 0.

      IF( IBIT1 .EQ. 0 )THEN    ! NO bitmap 
        WELL  = .FALSE.
        YMAXP = 587.
        XMAXP = 400.
        IORHC = -1
      ELSE IF( IBIT1 .EQ. 1 )THEN         ! PRINTRONIX
        FACTOR = 1.2
        YMAXP = 784.
        XMAXP = 699.
        IF( MODE(1:1) .EQ. 'L' )THEN
          IORHC  = -1
        ELSE
          IORHC  = +1
        END IF
      ELSE IF( IBIT1 .EQ. 2 )THEN    ! HP Laserjet
        IF( MODE(1:1) .EQ. 'L' )THEN
          IORHC  = +1
        ELSE
          IORHC  = -1
        END IF
        IF( IBIT2 .EQ. 0 )THEN
          YMAXP =  748.
          XMAXP =  984.
          IF( IBIT3 .EQ. 1 )THEN
            CALL HPJETC_DENSITY('100')
          ELSE
            CALL HPJET_DENSITY('100')
          END IF
        ELSE IF( IBIT2 .EQ. 1 )THEN
          YMAXP = 1122.             ! 150 dots/inch * 7.49 inch (19 cm)
          XMAXP = 1476.             ! 150 dots/inch * 9.85 inch (25 cm)
          IF( IBIT3 .EQ. 1 )THEN
            CALL HPJETC_DENSITY('150')
          ELSE
            CALL HPJET_DENSITY('150')
          END IF
        ELSE IF( IBIT2 .EQ. 2 )THEN
          YMAXP = 1122.             ! 300 dots/inch * 3.74 inch (9.51cm)
          XMAXP = 1476.             ! 300 dots/inch * 4.92 in  (12.51cm)
          IF( IBIT3 .EQ. 1 )THEN
            CALL HPJETC_DENSITY('300')
          ELSE
            CALL HPJET_DENSITY('300')
          END IF
        ELSE IF( IBIT2 .EQ. 3 )THEN
          YMAXP = 2246.             ! 300 dots/inch * 7.49 inch (19 cm)
          XMAXP = 2954.             ! 300 dots/inch * 9.85 inch (25 cm)
        ELSE
          WRITE(IOUT1,10)
     &    '*** ERROR SET_PLOT_DEVICES: Invalid bitmap device'
          RETURN 4
        END IF
      ELSE IF(IBIT1 .EQ. 3)THEN    ! HP Thinkjet
        YMAXP = 639.
        XMAXP = 852.
        IF( MODE(1:1) .EQ. 'L' )THEN
          IORHC  = -1
        ELSE
          IORHC  = +1
        END IF
      ELSE IF(IBIT1 .EQ. 4)THEN    ! LA100
        YMAXP = 1055.
        XMAXP = 432.
        IF( MODE(1:1) .EQ. 'L' )THEN
          IORHC  = -1
        ELSE
          IORHC  = +1
        END IF
      ELSE IF( IBIT1 .EQ. 5 )THEN    ! HP PaintJet
        PAGES = FLOAT(MAX(1,MIN(NPAGES,10)))
        IMON2  = 0
        IF( PAGES .GT. 1. )THEN
          XMAX   =  8.0 * 2.54         ! 8 inch * 2.54 cm/inch
          YMAX   = 11.0 * 2.54
        ELSE
          XMIN   =  0.25 * 2.54        !  0.25in margin
          XMAX   =  7.75 * 2.54        !  7.50 width
          YMIN   =  0.25 * 2.54        !  0.25in margin
          YMAX   = 10.75 * 2.54        ! 10.50 width
        END IF
        XMAXM2 = XMAX
        YMAXM2 = YMAX
        IF( MODE(1:1) .EQ. 'L' )THEN
          IORHC  = +1
        ELSE
          IORHC  = -1
        END IF
        IF( PAGES .GT. 1. )THEN
          YMAXP = 180.0* 8.0       - 1.   ! 180dpi *  8in
          XMAXP = 180.0*11.0*PAGES - 1.   ! 180dpi * 11in * no._of_pages
        ELSE
          YMINP = 180.0* 0.25            ! 0.25in margin
          YMAXP = 180.0* 7.75 - 1.       ! 180dpi *  7.5in
          XMINP = 180.0* 0.25            ! 0.25in margin
          XMAXP = 180.0*10.75 - 1.       ! 180dpi * 10.5in
        END IF
      ELSE
        WRITE(IOUT1,10)
     &  '*** ERROR in SET_PLOT_DEVICES: invalid bitmap device'
        RETURN 4
      END IF
      SCALE = XMAX / YMAX
      XMAX  = XMAX / UNIT_SCALE
      YMAX  = YMAX / UNIT_SCALE

      IBIT_COMMON = IBIT
      IF( MODE(1:1) .EQ. 'L' )THEN

C    Set up the correct aspect ratio for the terminal screen and centre
C    the viewport on the screen for the LANDSCAPE mode case

        IF( IMON1 .EQ. 6 )THEN  !  CIT467
          XMN =   0.
          XMX = 571.
          YMN = FLOAT(IFIX((479. - 571. * SCALE / PAGES) / 2.))
          YMX = FLOAT(IFIX((479. + 571. * SCALE / PAGES) / 2.))
       ELSE IF( (IMON1 .EQ. 1) .OR. (IMON1 .EQ. 7) .OR. (IMON1 .EQ. 8)
     &     .OR. (IMON1 .EQ. 9) ) THEN   ! VT640, TK4107, VT241 or PT100G
          IF( PAGES .GT. 1. )THEN
            XMN =   0.
            XMX = 639.
            YMN = FLOAT(IFIX((479. - 639. * SCALE / PAGES) / 2.))
            YMX = FLOAT(IFIX((479. + 639. * SCALE / PAGES) / 2.))
          ELSE
            XMN = FLOAT(IFIX((639. - 479. / SCALE) / 2.))
            XMX = FLOAT(IFIX((639. + 479. / SCALE) / 2.))
            YMN = 0.
            YMX = 479.
          END IF
        ELSE IF( IMON1 .EQ. 12 )THEN  ! SEIKO GR-1105
C                                      -2048 <= X <= 2047
C                                      -1560 <= Y <= 1559
          IF( PAGES .GT. 1. )THEN
            XMN = -2048.
            XMX =  2047.
            YMN = FLOAT(IFIX(-1560.+(3119.-4095.*SCALE/PAGES)/2.))
            YMX = FLOAT(IFIX(-1560.+(3119.+4095.*SCALE/PAGES)/2.))
          ELSE
            XMN = FLOAT(IFIX(-2048.+(4095.-3119./SCALE)/2.))
            XMX = FLOAT(IFIX(-2048.+(4095.+3119./SCALE)/2.))
            YMN = -1560. 
            YMX =  1559.
          END IF
        ELSE IF( IMON1 .EQ. 2 )THEN ! Tektronix 4010/12
          IF( PAGES .GT. 1. )THEN
            XMN =    0.
            XMX = 1023.
            YMN = FLOAT(IFIX((779. - 1023. * SCALE / PAGES) / 2.))
            YMX = FLOAT(IFIX((779. + 1023. * SCALE / PAGES) / 2.))
          ELSE
            XMN = FLOAT(IFIX((1023. - 779. / SCALE) / 2.))
            XMX = FLOAT(IFIX((1023. + 779. / SCALE) / 2.))
            YMN = 0.
            YMX = 779.
          END IF
       ELSE IF( IMON1 .EQ. 18 ) THEN ! XWINDOWS
          XMN =   0.
          XMX =   1.
          YMN = (.75 - 1. * SCALE / PAGES) / 2.
          YMX = (.75 + 1. * SCALE / PAGES) / 2.
       ELSE IF( IMON1 .EQ. 17 ) THEN ! generic terminal 
          CALL GENERIC_TERMINAL_SETUP( *20 )
          CALL GENERIC_TERMINAL_SIZE( XMING, XMAXG, YMING, YMAXG )
          IF( PAGES .GT. 1. )THEN
            XMN = XMING
            XMX = XMAXG
            YMN = 
     &       FLOAT(IFIX(((YMAXG-YMING)-(XMAXG-XMING)*SCALE/PAGES)/2.))
            YMX = 
     &       FLOAT(IFIX(((YMAXG-YMING)+(XMAXG-XMING)*SCALE/PAGES)/2.))
          ELSE
            XMN = FLOAT(IFIX(((XMAXG-XMING)-(YMAXG-YMING)/SCALE)/2.))
            XMX = FLOAT(IFIX(((XMAXG-XMING)+(YMAXG-YMING)/SCALE)/2.))
            YMN = YMING
            YMX = YMAXG
          END IF
        ELSE IF( IMON1 .EQ. 0 )THEN ! non-graphics  ( VT100 )
          XMN = 0.
          XMX = 639.
          YMN = 0.
          YMX = 479.
        ELSE
          WRITE(IOUT1,10)
     &    '*** ERROR in SET_PLOT_DEVICES: invalid first monitor'
          RETURN 2
        END IF
        CALL HARDCOPY_RANGE(XMINP,      XMAXP, YMINP, YMAXP,
     &                       XMIN, PAGES*YMAX,  YMIN,  XMAX, IORHC)
        CALL MONITOR_RANGE(IMON1,IOUT1, XMINP, XMAXP, YMINP, YMAXP,
     &                                 XMN,   XMX,  YMN,   YMX, IORHC)
        IF( (IMON2.EQ. 5) .OR. (IMON2.EQ.11) .OR. (IMON2.EQ.16)
     & .OR. (IMON2.EQ.13) .OR. (IMON2.EQ.19) .OR. (IMON2.EQ.20) )THEN
          XMINM2 = 0.0
          YMINM2 = 0.0
          IF( DEVFLIP )THEN
            XMINM2 = XMAXM2
            XMAXM2 = 0.0
            YMINM2 = YMAXM2
            YMAXM2 = 0.0
          END IF
          IF( IORHC .EQ. +1 )THEN
            CALL MONITOR2_RANGE(IMON2,IOUT2,XMINP,XMAXP,YMINP,YMAXP,
     &                      XMINM2,XMAXM2,YMINM2,YMAXM2,-IOR2)
          ELSE IF( IORHC .EQ. -1 )THEN
            CALL MONITOR2_RANGE(IMON2,IOUT2,XMINP,XMAXP,YMINP,YMAXP,
     &                      XMINM2,XMAXM2,YMINM2,YMAXM2,IOR2)
          END IF
        ELSE IF( IMON2 .EQ. 14 )THEN !  PostScript
          XMINM2 = 150.0
          YMINM2 = 150.0
          IF( DEVFLIP )THEN
            XMINM2 = XMAXM2
            XMAXM2 = 150.0
            YMINM2 = YMAXM2
            YMAXM2 = 150.0
          END IF
          IF( IORHC .EQ. +1 )THEN
            CALL MONITOR2_RANGE(IMON2,IOUT2,XMINP,XMAXP,YMINP,YMAXP,
     &                      XMINM2,XMAXM2,YMINM2,YMAXM2,-IOR2)
          ELSE IF( IORHC .EQ. -1 )THEN
            CALL MONITOR2_RANGE(IMON2,IOUT2,XMINP,XMAXP,YMINP,YMAXP,
     &                      XMINM2,XMAXM2,YMINM2,YMAXM2,IOR2)
          END IF
        ELSE IF( IMON2 .GE. 0 )THEN
          CALL MONITOR2_RANGE(IMON2,IOUT2,XMINP,XMAXP,YMINP,YMAXP,
     &                                 XMN,XMX, YMN,YMX, IORHC)
        END IF
      ELSE IF(MODE(1:1) .EQ. 'P')THEN

C    Set up the correct aspect ratio for the terminal screen and centre
C    the viewport on the screen for the PORTRAIT mode case

        IF( IMON1 .EQ. 6 )THEN !  CIT467
          XMN = FLOAT(IFIX((571. - 479. * SCALE / PAGES) / 2.))
          XMX = FLOAT(IFIX((571. + 479. * SCALE / PAGES) / 2.))
          YMN = 0.
          YMX = 479.
        ELSE IF( (IMON1 .EQ. 1) .OR. (IMON1 .EQ. 7) .OR.
     &           (IMON1 .EQ. 8) .OR. (IMON1 .EQ. 9) ) THEN

C    VT640 or TK4107 or VT241 or PT100G

          XMN = FLOAT(IFIX((639. - 479. * SCALE / PAGES) / 2.))
          XMX = FLOAT(IFIX((639. + 479. * SCALE / PAGES) / 2.))
          YMN = 0.
          YMX = 479.
        ELSE IF( IMON1 .EQ. 12 )THEN

C    SEIKO GR-1105:   -2048 <= XM <= 2047
C                     -1560 <= YM <= 1559

          XMN = FLOAT(IFIX(-2048.+(4095.-3119.*SCALE/PAGES)/2.))
          XMX = FLOAT(IFIX(-2048.+(4095.+3119.*SCALE/PAGES)/2.))
          YMN = -1560.
          YMX =  1559.
        ELSE IF( IMON1 .EQ. 2 )THEN !  Tektronix 4010/12
          XMN = FLOAT(IFIX((1023. - 779. * SCALE / PAGES) / 2.))
          XMX = FLOAT(IFIX((1023. + 779. * SCALE / PAGES) / 2.))
          YMN =   0.
          YMX = 779.
        ELSE IF( IMON1 .EQ. 18 ) THEN !  XWINDOWS
          XMN = (1. - .75 * SCALE / PAGES) / 2.
          XMX = (1. + .75 * SCALE / PAGES) / 2.
          YMN = 0.
          YMX =  .75
       ELSE IF( IMON1 .EQ. 17 ) THEN !  generic terminal 
          CALL GENERIC_TERMINAL_SETUP( *20 )
          CALL GENERIC_TERMINAL_SIZE( XMING, XMAXG, YMING, YMAXG )
          XMN = 
     &     FLOAT(IFIX(((XMAXG-XMING)-(YMAXG-YMING)*SCALE/PAGES)/2.))
          XMX = 
     &     FLOAT(IFIX(((XMAXG-XMING)+(YMAXG-YMING)*SCALE/PAGES)/2.))
          YMN = YMING
          YMX = YMAXG
        ELSE IF( IMON1 .EQ. 0 )THEN !  non-graphics ( VT100 )
          XMN =   0.
          XMX = 639.
          YMN =   0.
          YMX = 479.
        ELSE
          WRITE(IOUT1,10)
     &     '*** ERROR in SET_PLOT_DEVICES: invalid first monitor'
          RETURN 2
        END IF
        CALL HARDCOPY_RANGE(XMINP, XMAXP, YMINP,      YMAXP,
     &                       XMIN,  XMAX,  YMIN, PAGES*YMAX, IORHC)
        CALL MONITOR_RANGE(IMON1,IOUT1,XMINP,XMAXP,YMINP,YMAXP,
     &                       XMN,XMX,YMN,YMX,IORHC)
        IF( (IMON2.EQ. 5) .OR. (IMON2.EQ.11) .OR. (IMON2.EQ.16)
     & .OR. (IMON2.EQ.13) .OR. (IMON2.EQ.19) .OR. (IMON2.EQ.20) )THEN
          XMINM2 = 0.0
          YMINM2 = 0.0
          IF( DEVFLIP )THEN
            XMINM2 = XMAXM2
            XMAXM2 = 0.0
            YMINM2 = YMAXM2
            YMAXM2 = 0.0
          END IF
          IF( IORHC .EQ. -1 )THEN
            CALL MONITOR2_RANGE(IMON2,IOUT2,XMINP,XMAXP,YMINP,YMAXP,
     &                      XMINM2,XMAXM2,YMINM2,YMAXM2,-IOR2)
          ELSE IF( IORHC .EQ. +1 )THEN
            CALL MONITOR2_RANGE(IMON2,IOUT2,XMINP,XMAXP,YMINP,YMAXP,
     &                      XMINM2,XMAXM2,YMINM2,YMAXM2,IOR2)
          END IF
        ELSE IF( IMON2 .EQ. 14 )THEN  ! PostScript
          XMINM2 = 150.0
          YMINM2 = 150.0
          IF( DEVFLIP )THEN
            XMINM2 = XMAXM2
            XMAXM2 = 150.0
            YMINM2 = YMAXM2
            YMAXM2 = 150.0
          END IF
          IF( IORHC .EQ. -1 )THEN
            CALL MONITOR2_RANGE(IMON2,IOUT2,XMINP,XMAXP,YMINP,YMAXP,
     &                      XMINM2,XMAXM2,YMINM2,YMAXM2,-IOR2)
          ELSE IF( IORHC .EQ. +1 )THEN
            CALL MONITOR2_RANGE(IMON2,IOUT2,XMINP,XMAXP,YMINP,YMAXP,
     &                      XMINM2,XMAXM2,YMINM2,YMAXM2,IOR2)
          END IF
        ELSE IF( IMON2 .GE. 0 )THEN
          CALL MONITOR2_RANGE(IMON2,IOUT2,XMINP,XMAXP,YMINP,YMAXP,
     &                       XMN,XMX,YMN,YMX,IORHC)
        END IF
      ELSE
        WRITE(IOUT1,10)'*** ERROR in SET_PLOT_DEVICES: invalid mode'
        RETURN 1
      END IF
      RETURN
20    WRITE(IOUT1,10)'*** ERROR in SET_PLOT_DEVICES: generic terminal'
      RETURN 2
      END
