      SUBROUTINE SIMQ(A,B,N,KS)
C
C     LIBRARY-ROUTINE
C
C                                                29/JULY/1980
C                                                C.J. KOST SIN
C  
C     reqd. routines - NONE
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C    PURPOSE: SOLUTION OF SIMULTANEOUS LINEAR EQUATIONS BY
C             GAUSSIAN ELIMINATION USING LARGEST PIVITAL DIVISORS.
C
C    SUBROUTINE SIMQ(A,B,N,KS)
C
C   DESCIPTION OF PARAMETERS
C    A - MATRIX OF COEFFICIENTS STORED COLUMNWISE. THESE ARE
C        DESTROYED IN THE COMPUTATION. THE SIZE OF MATRIX A IS
C        N BY N.
C    B - VECTOR OF ORIGINAL CONSTRANTS (LENGTH N). THESE ARE
C        REPLACED BY FINAL SOLUTION VALUES, VECTOR X.
C    N - NUMBER OF EQUATIONS AND VARIABLES. N MUST BE .GT. ONE.
C    KS - OUTPUT DIGIT
C         0 FOR A NORMAL SOLUTION
C         1 FOR A SINGULAR SET OF EQUATIONS
C
C    SELF CONTAINED ROUTINE
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      DIMENSION A(1),B(1)
C                                     FORWARD SOLUTION
C                                     SET INITIAL TOLERANCE VALUE TOL
C                                     EQUAL TO ZERO
      TOL=0.0
      KS=0
      JJ=-N
C                                     THE FOLLOWING DO STATEMENT
C                                     DEFINES ONE STAGE OF THE FORWARD
C                                     SOLUTION TO BE EXECUTED N TIMES
      DO 65 J=1,N
      JY=J+1
      JJ=JJ+N+1
      BIGA=0.
      IT=JJ-J
      DO 30 I=J,N
C                                     SEARCH FOR MAXIMUM COEFFICIENT
C                                     IN COLUMN
      IJ=IT+I
      IF(ABS(BIGA)-ABS(A(IJ))) 20,30,30
  20  BIGA=A(IJ)
      IMAX=I
  30  CONTINUE
C                                     TEST FOR SINGULAR MATRIX
C                                     IF NO PIVOT EXCEEDS THE VALUE
C                                     TOL, THE MATRIX IS CONSIDERED
C                                     SINGULAR AND RETURN IS MADE TO
C                                     THE CALLING PROGRAM WITH KS=1
      IF(ABS(BIGA)-TOL) 35,35,40
  35  KS=1
      RETURN
C                                     INTERCHANGE ROWS IF NECESSARY
  40  I1=J+N*(J-2)
      IT=IMAX-J
C                                     THE FOLLOWING DO STATEMENT
C                                     DEFINES THE OPERATION WHICH
C                                     DIVIDES THE EQUATION BY THE
C                                     LEADING COEFFICIENT
      DO 50 K=J,N
      I1=I1+N
      I2=I1+IT
      SAVE=A(I1)
      A(I1)=A(I2)
      A(I2)=SAVE
C                                     DIVIDE EQUATION BY LEADING
C                                     COEFFICIENT
  50  A(I1)=A(I1)/BIGA
      SAVE=B(IMAX)
      B(IMAX)=B(J)
      B(J)=SAVE/BIGA
C                                     ELIMINATE NEXT VARIABLE
C                                     SUCCESSIVE VARIABLES ARE
C                                     ELIMINATED UNTIL NTH EQUATION
C                                     TAKES THE FORM X=CONST
      IF(J-N) 55,70,55
  55  IQS=N*(J-1)
      DO 65 IX=JY,N
      IXJ=IQS+IX
      IT=J-IX
      DO 60 JX=JY,N
      IXJX=N*(JX-1)+IX
      JJX=IXJX+IT
  60  A(IXJX)=A(IXJX)-(A(IXJ)*A(JJX))
  65  B(IX)=B(IX)-(B(J)*A(IXJ))
C                                     BACK SOLUTION
  70  NY=N-1
      IT=N*N
C                                     THE FOLLOWING DO STATEMENT
C                                     DEFINES THE BACK-SUBSTITUTION
C                                     PROCEDURE
      DO 80 J=1,NY
      IA=IT-J
      IB=N-J
      IC=N
      DO 80 K=1,J
      B(IB)=B(IB)-A(IA)*B(IC)
      IA=IA-N
  80  IC=IC-1
C                                     RETURN TO CALLING PROGRAM
      RETURN
      END
