      SUBROUTINE SINTER(YIN,YOUT,XIN,XOUT,NIN,NOUT)
C$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
C  
C     reqd. routines - NONE
C
C     GENERAL LAGRANGE INTERPOLATION  SUBROUTINE TO EVALUATE DATA
C     AT A SET OF CO-ORDS DIFFERING FROM THE ORIGINAL.
C     INPUT ARRAYS ARE YIN,XIN,XOUT. ALSO INPUT NIN,NOUT
C     XIN MUST BE MONOTONICALLY INCREASING !!!!!
C     XOUT CAN BE RANDOM. EXTRAPOLATION ALLOWED.
C     OUTPUT ARRAY FROM CALL IS YOUT
C     YIN IS DATA TO BE INTERPOLATED AT THE CO-ORDS XOUT (BUT SUPPLIED
C     ONLY FOR CO-ORDS XIN)
C
C***  VERSION #2: THIS VERSION OF LINTER WILL ACCEPT INPUT ARRAYS
C***              CONTAINING ANY POSITIVE NUMBER 'NIN' OF POINTS.
C***              THE DEGREE OF INTERPOLATION IS DETERMINED BY NIN:
C***
C***                # POINTS (NIN)          DEGREE OF INTERPOLATING POLY.
C***
C***                    1                                 0
C***                    2                                 1
C***                  3,4                                 2
C***                 > OR =5                              4
C***
C$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
      DIMENSION YIN(1),YOUT(1),XIN(1),XOUT(1)
      NLOW=0
      IF(NIN.LE.2) GOTO 70
      IF(NIN.LE.4) IND=0
      IF(NIN.GE.5) IND=1
      NP=2*IND+3
      RUPR=(XIN(NIN-IND-1)+XIN(NIN-IND))/2.
      RLOW=(XIN(1+IND)+XIN(2+IND))/2. 
C
C== Output points array XOUT need NOT be MONOTONIC
C
      DO 10 I=1,NOUT
      XI=XOUT(I)
      IF(XI.LT.RUPR) GO TO 25
C
C== Upper end extrapolation case
C
      NLOW=NIN-NP
      GO TO 20
   25 IF(XI.GT.RLOW) GO TO 30
C
C== Lower end extrapolation case
C
      NLOW=0
      GO TO 20
   30 I3=NLOW+IND+2
      I4=I3+1
      I2=I3-1
      RBU=(XIN(I3)+XIN(I4))/2.
      RBL=(XIN(I2)+XIN(I3))/2.
      IF(XI.LE.RBU .AND. XI.GE.RBL) GO TO 20
      IF(XI.GT.RBU)NLOW=NLOW+1
      IF(XI.LT.RBL)NLOW=NLOW-1
      GO TO 30
   20 DO 40 J=1,NP
      P=1.
      J1=J+NLOW
      DO 50 L=1,NP
      L1=L+NLOW
      IF(L.NE.J) P=P*(XI-XIN(L1))/(XIN(J1)-XIN(L1))
  50  CONTINUE
      IF(J.EQ.1) YOUT(I)=YIN(J1)*P
      IF(J.NE.1) YOUT(I)=YOUT(I)+YIN(J1)*P
  40  CONTINUE
      IF(XI .LT. XIN(1))YOUT(I)=YIN(1)+(XI-XIN(1))/(XIN(2)-XIN(1))*
     C                  (YIN(2)-YIN(1))
      NIN1=NIN-1
      IF(XI.GT.XIN(NIN)) YOUT(I)=YIN(NIN1)+(XI-XIN(NIN1))/(XIN(NIN)-
     &  XIN(NIN1))*(YIN(NIN)-YIN(NIN1))
  10  CONTINUE
      GOTO 99
   70 IF(NIN.EQ.1) GOTO 80
      DO 75 I=1,NOUT
      XI=XOUT(I)
      YOUT(I)=YIN(1)+(YIN(2)-YIN(1))/(XIN(2)-XIN(1))*(XI-XIN(1))
   75 CONTINUE
      GOTO 99
   80 DO 85 I=1,NOUT
      YOUT(I)=YIN(1)
   85 CONTINUE
   99 RETURN
      END
