      SUBROUTINE SYSMSG(ISTAT)
C======================================================================C
C                                                                      C
C  SYSMSG                                          F.W. Jones, TRIUMF  C
C                                                                      C
C  Puts out the system message for status code ISTAT.                  C
C                                                                      C
C  Input:                                                              C
C                                                                      C
C    ISTAT   System status code (e.g. return value from Run-Time       C
C            Library routine or System Service)                        C
C                                                                      C
C  Example:                                                            C
C                                                                      C
C    CHARACTER*10 FOO                                                  C
C    FOO=')JUNK'                                                       C
C    ISTAT=LOK_IOFAST$OPENR(1,FOO)                                     C
C    IF(.NOT.ISTAT)THEN                                                C
C      WRITE(*,*)'Error opening file ',FOO                             C
C      CALL SYSMSG(ISTAT)                                              C
C    ENDIF                                                             C
C                                                                      C
C  Produces the following output on SYS$OUTPUT:                        C
C                                                                      C
C    Error opening file )JUNK                                          C
C    %RMS-F-SYN, file specification syntax error                       C
C    %FOR-F-FILNAMSPE, file name specification error                   C
C                                                                      C
C======================================================================C
#ifdef VMS
      CHARACTER*80 MSG
C Get the message:
      MSG=' '
      IST=LIB$SYS_GETMSG(ISTAT,L,MSG)
      IF(.NOT.IST)RETURN      !failed to get a message ... do nothing.
C Chop off any (empty) diagnostic fields:
      IEX=INDEX(MSG,'!')
      IF(IEX.GT.0)L=IEX-1
C Write out the message:
      WRITE(*,10)
10    FORMAT(' ')
      WRITE(*,*)MSG(1:L)
#endif
#ifdef unix
      WRITE(6,10)
10    FORMAT(' ')
      CALL PERROR(' ')
#endif
      RETURN
      END
