C
C    25-aug-87  added a flag so that multiple calls to TICTL do
C  not keep assigning system stuff.
C
C  Modified 27-JUL-92 by FWJ: ported to Ultrix.
C  Note: TICURS (crosshair cursor input routine) not ported.
C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
C
C SUBROUTINE TICTL (IFC)
C
C
C SUBROUTINE PERFORMS VARIOUS GRAPHICS DISPLAY FUNCTIONS
C ON THE ATARI ST EMULATING A VT640.  DIFFERS SLIGHTLY
C FROM STRAIGHT 4010 IN THAT SOME CHARACTERS ARE ENCODED
C SEE TISTOR.
C
C
C      IFC SPECIFIES A PLOTTING FUNCTION  1.LE.IFC.LE.5
C
C
C
C      SUBROUTINE "TICTL" IS A FORTRAN CALLABLE SUBROUTINE
C          USED WITH THE TEKTRONIX GRAPHICS DISPLAY TERMINALS.
C          THE SUBROUTINE CAN INITIALIZE THE TERMINAL FOR 
C          GRAPHICS PLOTTING, SET THE TERMINAL TO ALPHA MODE,
C          EMPTY THE OUTPUT BUFFER AND SEND IT TO THE TERMINAL,
C          AND ERASE THE SCREEN.  ONCE THE TERMINAL HAS BEEN
C          INITIALIZED FOR GRAPHICS PLOTTING, USE SUBROUTINE
C          "TI4010" TO DIRECT THE TERMINAL INTO GRAPHICS MODE 
C          AND SEND GRAPHICS COORDINATES FOR PLOTTING.
C
C
C          AN INITIAL CALL TO TICTL(1) IS REQUIRED BEFORE
C          USING ANY OTHER FUNCTIONS OF THE SUBROUTINE OR
C          BEFORE CALLING "TI4010" OR "TICURS".
C
C
C
C
C    IFC = 1   INITIALIZE THE TERMINAL INPUT AND OUTPUT BUFFERS
C              FOR GRAPHICS DISPLAY.  (THE TERMINAL WILL REMAIN
C              IN ALPHA MODE UNTIL A CALL TO TI4010 IS MADE.)
C
C    IFC = 2   EMPTY THE OUTPUT BUFFER AND ERASE THE SCREEN.
C              (ERASING THE SCREEN WILL RETURN THE TERMINAL TO
C              ALPHA MODE.)
C
C    IFC = 3   RESET THE TERMINAL TO ALPHA MODE AND EMPTY
C              THE OUTPUT BUFFER.
C
C    IFC = 4   EMPTY THE OUTPUT BUFFER.
C
C    IFC = 5   RESET THE TERMINAL TO ANSI MODE AND EMPTY THE
C              OUTPUT BUFFER
C
C      TICTL USES LUN 5 FOR THE GRAPHICS TERMINAL GRAPHICS
C      ASSIGNMENTS.
C
C
C
      SUBROUTINE TICTL (IFC)
C
      CHARACTER*5 DELTASECS
      INTEGER*4 SYS$ASSIGN,SYS$BINTIM,SYS$SETIMR,SYS$WAITFR,TT_CHAN
      REAL*8 WAITSEC
      LOGICAL  FIRSTC     ! first call to TICTL(1) ?
#ifdef VMS
      INCLUDE '($IODEF)'
#endif
      BYTE BSTORE,BBUFF
      COMMON /TIXXTI/MODE,BSTORE(4),IPOINT,BBUFF(72),TT_CHAN
      DATA FIRSTC /.TRUE./
C
C
      GOTO (10,20,30,40,50), IFC
C
C
C IFC=1; INITIALIZE  --  GET BUFFER ADDRESS, CLEAR ARRAYS,
C        SET THE POINTERS
C
   10 CONTINUE
      IF ( .NOT. FIRSTC ) GOTO 15
#ifdef VMS
      ISTAT = SYS$ASSIGN ('TT', TT_CHAN,,)
#endif
   12 DO 14 I=1,4
   14   BSTORE(I)='377'O
      IPOINT=0
      FIRSTC = .FALSE.
C
   15 CONTINUE
      MODE=0
      CALL TISTOR( 31 )
      RETURN
C
C
C IFC=2; PUT CHARACTERS TO ERASE THE SCREEN IN THE OUTPUT
C        BUFFER AND SEND THE BUFFER.  WAIT 2 SECONDS FOR
C        SCREEN TO ERASE.
C
   20 CALL TISTOR(27)
      CALL TISTOR(12)
      CALL TIMPTY
CRGJ      DELTASECS='0 ::2'
CRGJ      ISTAT = SYS$BINTIM (%DESCR(DELTASECS),%REF(WAITSECS))
CRGJ      ISTAT = SYS$SETIMR (%VAL(2),%REF(WAITSECS),,)
CRGJ      ISTAT = SYS$WAITFR (%VAL(2))
      GOTO 12
C
C
C IFC=3; SET TERMINAL TO ALPHA MODE, EMPTY THE OUTPUT BUFFER
C
C MODE = 0 FOR ALPHA MODE
C
   30 CALL TISTOR(31)
      CALL TIMPTY
      MODE = 0
      GOTO 12
C
C
C IFC=4; EMPTY THE OUTPUT BUFFER
C
   40 CALL TIMPTY
      RETURN
C
C
C IFC=5; SET TERMINAL TO ANSI MODE, EMPTY THE OUTPUT BUFFER
C
   50 CALL TISTOR(24)
      CALL TIMPTY
      MODE = 0
      RETURN
      END

C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
C
C SUBROUTINE TISTOR (BCHR)
C
C                         I M P O R T A N T
C                         =================
C
C       This routine TRANSLATES the characters ^Q, ^S, and ^C!!!!
C
C
C SUBROUTINE STORES BYTE DATA FOR GRAPHICS TERMINALS INTO
C A BUFFER AND SENDS THE BUFFER TO THE TERMINAL.
C
C TO FORCE THE BUFFER TO BE EMPTIED, CALL THIS ROUTINE WITH 
C THE ENTRY POINT TIMPTY
C     ******************
C
C
C
C     BCHR  = CHARACTER TO BE STORED IN THE OUTPUT BUFFER.
C
C
C      TISTOR STORES THE CHARACTER SENT IN THE ARGUMENT INTO
C         THE OUTPUT BUFFER. THE BUFFER IS SENT TO THE TERMINAL
C         WHEN 70 CHARACTERS HAVE BEEN PUT INTO THE BUFFER OR
C         WHEN TIMPTY IS CALLED
C
C
      SUBROUTINE TISTOR (BCHR)
C
      INTEGER*2 ISTATB(4)
      INTEGER*4 SYS$QIOW,WRITEALL
#ifdef VMS
      INCLUDE '($IODEF)'
#endif
C
C
      BYTE BSTORE,BBUFF,BCHR
      INTEGER*4 TT_CHAN
      COMMON /TIXXTI/MODE,BSTORE(4),IPOINT,BBUFF(72),TT_CHAN
      DATA ICARR/'000'O/
C
C
C ADD BCHR TO BUFFER AND RETURN IF BUFFER IS NOT FULL
C  With the atari we have to be careful about sending control-S and
C  control-Q since these will be intercepted by the RS232 driver. 
C  Therefore, instead of passing this characters I will pass a special
C  flag character, ^C, followed by the character I want to pass ADDED
C  to '@'.  So, to pass a control-S I send ^C'S', to pass a control-Q
C  I send ^C'Q' and to pass a control-C (^C) I send ^C'C'.
C  This will all be transparent to someone sending characters out with
C  the TISTOR routine.
C
      IF ( (BCHR.EQ.17) .OR. (BCHR.EQ.19) .OR. (BCHR.EQ.3) ) THEN
        IPOINT=IPOINT+1
        BBUFF(IPOINT) = 3
        IPOINT=IPOINT+1
        BBUFF(IPOINT) = BCHR + 64
      ELSE
        IPOINT=IPOINT+1
        BBUFF(IPOINT)=BCHR
      ENDIF
      IF(IPOINT.LT.70) RETURN
C
      ENTRY TIMPTY
C
C EMPTY THE BUFFER
C
   10 IF(IPOINT.LT.1) RETURN
#ifdef VMS
      WRITEALL = IO$_WRITEVBLK.OR.IO$M_NOFORMAT
      ISTAT = SYS$QIOW( ,%VAL(TT_CHAN),%VAL(WRITEALL),ISTATB,,,
     $                   %REF(BBUFF),%VAL(IPOINT),,%VAL(ICARR),,)
#else
      CALL TISTOR_PUT(BBUFF,IPOINT)
#endif
C
C
C  RESET POINTER
C
      IPOINT=0
C
C
      RETURN
      END

C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
C
C SUBROUTINE TIPONT (IIX,IIY,LWRITE)
C
C
C VECTOR PLOTTING ON THE TEKTRONIX 4010 OR 4025 GRAPHICS
C DISPLAY TERMINALS WITH INTEGER COORDINATES :
C
C      0.LE.IIX.LE.1023
C      0.LE.IIY.LE.780
C
C
C   SUBROUTINE "TIPONT" DRAWS A DARK VECTOR TO (IIX,IIY) IF LWRITE=
C   .FALSE. OR A LIGHT VECTOR TO (IIX,IIY) IF LWRITE=.TRUE.
C
C
      SUBROUTINE TIPONT (IIX,IIY,LWRITE)
C
      LOGICAL LWRITE
      BYTE BSTORE,BBUFF
      BYTE HIY,LOY,HIX,LOX,HIYSTR,LOYSTR,HIXSTR,LOXSTR
C
C
      INTEGER*4 TT_CHAN
      COMMON /TIXXTI/MODE,BSTORE(4),IPOINT,BBUFF(72),TT_CHAN
C
C
      EQUIVALENCE (HIYSTR,BSTORE(1))
      EQUIVALENCE (LOYSTR,BSTORE(2))
      EQUIVALENCE (HIXSTR,BSTORE(3))
      EQUIVALENCE (LOXSTR,BSTORE(4))
C
C CHECK FOR GRAPHICS MODE:  (LWRITE)=LIGHT VECTOR;
C  (.NOT.LWRITE)=DARK VECTOR
C
C MODE=1 FOR GRAPHICS, MODE=0 FOR ALPHA
C
      IF(.NOT. LWRITE) GOTO 5
      IF(MODE.EQ.1) GOTO 10
    5 CALL TISTOR(29)
      MODE=1
C
C
C CHECK FOR VALID INTEGERS
C
   10 IX=IIX
      IY=IIY
      IF(IX.LT.0) IX=0
      IF(IY.LT.0) IY=0
      IF(IX.GT.1023) IX=1023
      IF(IY.GT.780) IY=779
C
C
C CALCULATE HIGH AND LOW BYTE VALUES --
C
      HIY=((IY/32.AND.'37'O).OR.'40'O)
      LOY=((IY.AND.'37'O).OR.'140'O)
      HIX=((IX/32.AND.'37'O).OR.'40'O)
      LOX=((IX.AND.'37'O).OR.'100'O)
C
C
C COMPARE NEW BYTES WITH STORED BYTES FROM THE PREVIOUS 
C COORDINATES AND SEND THE NECESSARY BYTES FOR NEW DATA.
C
      IF(HIY.NE.HIYSTR) CALL TISTOR(HIY)
      IF(HIX.EQ.HIXSTR) GOTO 20
      CALL TISTOR(LOY)
      CALL TISTOR(HIX)
      GOTO 30
   20 IF (HIY.EQ.HIYSTR.OR.LOY.NE.LOYSTR) CALL TISTOR(LOY)
   30 CALL TISTOR(LOX)
C
C
C PUT NEW BYTES INTO COMMON
C
      HIYSTR=HIY
      LOYSTR=LOY
      HIXSTR=HIX
      LOXSTR=LOX
C
C
      RETURN
      END

#ifdef VMS
C;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
C
C SUBROUTINE TICURS (X,Y,BCHR)
C
C SUBROUTINE DISPLAYS CURSORS ON THE SCREEN AND READS THE
C CHARACTER AND CURSOR COORDINATES WHEN A CHARACTER IS TYPED.
C
C
C          "TICURS" IS A FORTRAN CALLABLE SUBROUTINE WHICH
C      HANDLES THE CURSOR INPUT AND OUTPUT OF A TEKTRONIX
C      4010 OR 4025 GRAPHICS TERMINAL.  THE SUBROUTINE
C      INITIALLY DISPLAYS THE CURSORS ON THE SCREEN.  WHEN
C      THE USER TYPES A CHARACTER AFTER THE CURSORS HAVE BEEN
C      POSITIONED, THE CHARACTER AND THE POINT WHERE THE 
C      CURSORS INTERSECT ARE READ FROM THE TERMINAL.  THE
C      COORDINATES ARE RETURNED FROM "TICURS" AS X AND Y,
C      AND THE CHARACTER TYPED IS RETURNED AS BCHR.
C
C
C
C       X = THE X COORDINATE OF THE POINT ( 0.0 - 1023.0 )
C
C       Y = THE Y COORDINATE OF THE POINT ( 0.0 - 779.0 )
C
C       BCHR = THE CHARACTER TYPED ON THE TERMINAL.
C
C
C
C       "TICURS" USES LUN 5 FOR GRAPHICS TERMINAL ASSIGNMENTS.
C
C
C
C   23-jul-87 (rgj) Got rid of the no_echo option on the read.  With
C             only a single control character in the trailer for the
C             ST640 I was not getting out of the ByPass mode of the
C             VT640 since that control character was not echoed!
C
C   12-aug-87 (rgj) BCHR is now always upper case.
C
      SUBROUTINE TICURS (X,Y,BCHR)
C
      INTEGER*2 ISTATB(4)
      INTEGER*4 SYS$QIOW,PASSALL
      BYTE BSTORE,BBUFF,BCHR
      BYTE HIX,LOX,HIY,LOY,NBYTE
      INCLUDE '($IODEF)'
C
C
      INTEGER*4 TT_CHAN
      COMMON /TIXXTI/MODE,BSTORE(4),IPOINT,BBUFF(72),TT_CHAN
C
      EQUIVALENCE (NBYTE,BBUFF(1))
      EQUIVALENCE (HIX,BBUFF(2))
      EQUIVALENCE (LOX,BBUFF(3))
      EQUIVALENCE (HIY,BBUFF(4))
      EQUIVALENCE (LOY,BBUFF(5))
C
C  SEND THE CURSOR COMMAND SEQUENCE TO DISPLAY CURSORS
C  ON THE SCREEN AND EMPTY THE OUTPUT BUFFER.
C
      CALL TISTOR(27)
      CALL TISTOR(26)
      CALL TIMPTY
      PASSALL = IO$_TTYREADALL 
      ISTAT = SYS$QIOW( ,%VAL(TT_CHAN),%VAL(PASSALL),ISTATB,,,
     $                   %REF(BBUFF),%VAL(6),,,,)
C
C
C  STORE THE FIRST BYTE (THE CHARACTER TYPED)
C
      BCHR=NBYTE.AND.'177'O
      IF ( (BCHR.GE.'a').AND. (BCHR.LE.'z') ) 
     +   BCHR = BCHR - 'a' + 'A'
C
C
C  MASK OFF THE EXTRA BITS OF THE 2ND-5TH BYTES AND CONVERT 
C  TO X & Y COORDINATES.
C
      IX=HIX.AND.'37'O
      IX=IX*32+(LOX.AND.'37'O)
      IY=HIY.AND.'37'O
      IY=IY*32+(LOY.AND.'37'O)
      X=IX
      Y=IY
C
C  CLEAR COMMON
C
      BSTORE(1)='377'O
      BSTORE(2)='377'O
      BSTORE(3)='377'O
      BSTORE(4)='377'O
C
C
      MODE = 0
      RETURN
      END
#else
      SUBROUTINE TICURS
      RETURN
      END
#endif
