        FUNCTION VDT_CURSOR(ACTION,ROW,COLUMN)
C
C                                       Henry Baragar
C                                       TRIUMF, UBC
C                                       June, 1984
C
C  reqd. KOSTL: routines - READKEY, LENSIG
C
C========================================================================
C=                                                                      =
C= VDT_CURSOR                                                           =
C=                                                                      =
C= This routine moves the cursor about on the screen, using the         =
C= terminal hardware to do the moving.                                  =
C=                                                                      =
C= INPUT:                                                               =
C=      ACTION  (Ch*(*)) - a character string indicating how the        =
C=              cursor is to be moved -- more than one action may       =
C=              be specified; the actions are:                          =
C=                      '<'             - move cursor left one space    =
C=                      '>'             - move cursor right one space   =
C=                      '^'             - move cursor up one line       =
C=                      'v'             - move cursor down one line     =
C=                      '^+'            - same as '^' but scroll down   =
C=                                        if at top of screen           =
C=                      'v+'            - same as 'v' but scroll up     =
C=                                        if at bottom of screen        =
C=                      'BOL'           - move cursor to beginning of   =
C=                                        line                          =
C=                      'EOL'           - move cursor to end of line    =
C=                      'HOM'           - move cursor to home position  =
C=                      'MOV'           - move the cursor LINE lines    =
C=                                        & COLUMN columns from its     =
C=                                        current location (-ve means   =
C=                                        move up or to the left)       =
C=                      'POS'           - move cursor to position       =
C=                                        indicated by LINE & COLUMN    =
C=                      'REP'           - report the position of the    =
C=                                        cursor                        =
C=      ROW, COLUMN  (I*4)  [optional] - the row and column that the    =
C=              cursor is to be positioned at if 'POS' is selected in   =
C=              ACTION; or the number of lines and columns that are to  =
C=              move from the current position if 'MOV' is specified.   =
C=                                                                      =
C= OUTPUT:                                                              =
C=      VDT_CURSOR - always returns 0.0.                                =
C=      ROW, COLUMN  (I*4) - are returned with the current position     =
C=              of the cursor if 'REP' is specified in ACTION.          =
C=                                                                      =
C= EXAMPLES:                                                            =
C=      DUMMY = VDT_CURSOR ('^ ^ ^')    !move cursor up 3 lines;        =
C=      CALL VDT_CURSOR ('^;^.^')       !same as previous example;      =
C=      CALL VDT_CURSOR ('HOM v v v')   !move cursor to beginning of    =
C=                                      !...of third line;              =
C=      CALL VDT_CURSOR ('POS',3,1)     !same as previous example;      =
C=                                                                      =
C========================================================================
C  
C  
        IMPLICIT INTEGER (A-Z)
        CHARACTER*1 ESC
        CHARACTER*5 NULL
        CHARACTER*5 SEPS
        PARAMETER (SEPS = ' .,;:')
        PARAMETER (NACTS=12, PREMOV=9, MOV=10, POS=11, REP=12)
        CHARACTER*3 ACTS(NACTS) /
     +          '<  ',   '>  ',   '^  ',   'v  ',   '^+ ',   'v+ ',   
     +          'BOL',   'EOL',   'HOM',   'MOV',   'POS',   'REP'/
        CHARACTER*5 HACTS(PREMOV,1) /
     +          '[1D  ', '[1C  ', '[1A  ', '[1B  ', 'M    ', 'D    ', 
     +          '[132D', '[132C', '[1;1H'/ 
        CHARACTER*(*) ACTION
        INTEGER TERM /1/
        CHARACTER*1 INP_KEY, READ_KEY
CCC
        ESC = CHAR(27)    ! modified by J.Chuma, 19Mar97 for g77
        NULL = CHAR(0)//CHAR(0)//CHAR(0)//CHAR(0)//CHAR(0)
        LENA = LEN(ACTION)
        PTR = 1
        DO WHILE (PTR .LE. LENA)
            DO WHILE (INDEX(SEPS,ACTION(PTR:PTR)).NE.0  .AND.  
     +              PTR.LE.LENA)
                PTR = PTR + 1
            ENDDO
            BOA = PTR
            DO WHILE (INDEX(SEPS,ACTION(PTR:PTR)).EQ.0  .AND.  
     +              PTR.LE.LENA)
                PTR = PTR + 1
            ENDDO
            EOA = PTR - 1
            IACTS = 1
            DOWHILE (ACTION(BOA:EOA).NE.ACTS(IACTS)  .AND.  
     +               IACTS.LE.NACTS)
                IACTS = IACTS + 1
            ENDDO
            IF (IACTS .LT. MOV) THEN
                LENH = LENSIG (HACTS(IACTS,TERM))
                WRITE (6,60) ESC // HACTS(IACTS,TERM) (1:LENH)
   60           FORMAT('+',A,$)
            ELSE IF (IACTS .EQ. MOV) THEN
                GOTO  (110),TERM
  110           IF (ROW .LT. 0) THEN 
                    WRITE (6,116) ESC, MOD(-ROW,100), 'A'
                ELSE IF (ROW .GT. 0) THEN
                    WRITE (6,116) ESC, MOD(ROW,100), 'B'
                ENDIF
                IF (COLUMN .LT. 0) THEN
                    WRITE (6,116) ESC, MOD(-COLUMN,1000), 'D'
                ELSE IF (COLUMN .GT. 0) THEN 
                    WRITE (6,116) ESC, MOD(COLUMN,1000), 'C'
                ENDIF
                GOTO 200
  116           FORMAT('+',A1,'[',I3.3,A1,$)
  200           CONTINUE
            ELSE IF (IACTS .EQ. POS) THEN
                GOTO  (210), TERM
  210           WRITE (6,216) ESC, MOD(ROW,100), MOD(COLUMN,1000)
                GOTO 300
  216           FORMAT('+',A,'[',I2.2,';',I3.3,'H',$)
  300           CONTINUE
            ELSE IF (IACTS .EQ. REP) THEN
                GOTO  (310), TERM
  310           WRITE (6,316) ESC//'[6n'
                INP_KEY = READ_KEY('NOESC',' ',INP_KEY,0)
                INP_KEY = READ_KEY('NOESC',' ',INP_KEY,0)
                INP_KEY = READ_KEY('NOESC',' ',INP_KEY,0)
                ROW = 0
                DO WHILE (INP_KEY .NE. ';')
                    ROW = 10*ROW + ICHAR(INP_KEY) - ICHAR('0')
                    INP_KEY = READ_KEY('NOESC',' ',INP_KEY,0)
                ENDDO
                COLUMN = 0
                INP_KEY = READ_KEY('NOESC',' ',INP_KEY,0)
                DO WHILE (INP_KEY .NE. 'R')
                    COLUMN = 10*COLUMN + ICHAR(INP_KEY) - ICHAR('0')
                    INP_KEY = READ_KEY('NOESC',' ',INP_KEY,0)
                ENDDO
                GOTO 400
  316           FORMAT('+',A,$)
  400           CONTINUE
            ENDIF
        ENDDO
        VDT_CURSOR=0
        RETURN
        END
