      SUBROUTINE ASCEBC(STRIN,STROUT,LEN,*)
C
C     reqd. routines - NONE
C================================================================
C==  ASCEBC: TRANSLATES INPUT ASCII STRING INTO EBCDIC EQUIVALENT==
C==                                                            ==
C==  INPUT PARAMETERS: STRIN, LEN                              ==
C==    STRIN: INPUT ASCII STRING                               ==
C==    LEN  : LENGTH OF INPUT STRING (BYTES)                   ==
C==                                                            ==
C==  OUTPUT PARAMETERS: STROUT				       ==
C==    STROUT: EBCDIC EQUIVALENT OF ASCII INPUT STRING         ==
C==                                                            ==
C==  RETURN CODES:                                             ==
C==   RETURN 0: NORMAL RETURN, SUCCESSFUL TRANSLATION          ==
C==   RETURN 1: INVALID ASCII CHAR. (HEX > 127) IN "STRIN"     ==
C================================================================
      CHARACTER STRIN(1),STROUT(1),LCH(4)
      INTEGER ITAB(128)
      INTEGER NCH,LEN
      EQUIVALENCE (NCH,LCH)
C
C   Changed to new table Jan 4/88 as per UBC Campus Computing Newsletter
C   Vol 2 Num. 2. page 5 by C.J.Kost
C
      DATA ITAB/
     & X'00',X'01',X'02',X'03',X'37',X'2D',X'2E',X'2F',X'16',X'05',
     & X'15',X'0B',X'0C',X'0D',X'0E',X'0F',X'10',X'11',X'12',X'13',
     & X'3C',X'3D',X'32',X'26',X'18',X'19',X'3F',X'27',X'1C',X'1D',
     & X'1E',X'1F',X'40',X'5A',X'7F',X'7B',X'5B',X'6C',X'50',X'7D',
     & X'4D',X'5D',X'5C',X'4E',X'6B',X'60',X'4B',X'61',X'F0',X'F1',
     & X'F2',X'F3',X'F4',X'F5',X'F6',X'F7',X'F8',X'F9',X'7A',X'5E',
     & X'4C',X'7E',X'6E',X'6F',X'7C',X'C1',X'C2',X'C3',X'C4',X'C5',
     & X'C6',X'C7',X'C8',X'C9',X'D1',X'D2',X'D3',X'D4',X'D5',X'D6',
     & X'D7',X'D8',X'D9',X'E2',X'E3',X'E4',X'E5',X'E6',X'E7',X'E8',
     & X'E9',X'BA',X'E0',X'BB',X'B0',X'6D',X'79',X'81',X'82',X'83',
     & X'84',X'85',X'86',X'87',X'88',X'89',X'91',X'92',X'93',X'94',
     & X'95',X'96',X'97',X'98',X'99',X'A2',X'A3',X'A4',X'A5',X'A6',
     & X'A7',X'A8',X'A9',X'C0',X'4F',X'D0',X'A1',X'07'/

C================================================================
C==  NOW TRANSLATE DATA FROM ASCII TO EBCDIC                   ==
C================================================================
      IF( LEN .LE. 0 )RETURN
      DO I = 1, LEN
        NCH = 0
        LCH(1) = STRIN(I)
        IF( NCH .GT. 127 )RETURN 1
        STROUT(I) = CHAR(ITAB(NCH+1))
      ENDDO
      RETURN
      END
