      SUBROUTINE CHECK_BUFFER
C======================================================================C
C                                                                      C
C     CHECK_BUFFER: checks to see if the plot buffer is full.          C
C                   If it isn't full yet, and we are in buffer         C
C                   mode (i.e. IMODE = 1) then return.                 C
C                   If it is full or we are in direct mode (i.e.       C
C                   IMODE = 2), then print the plot buffer to          C
C                   the screen and set up the plot buffer to           C
C                   plot a dark (null) vector at the last point        C
C                   plotted on the screen.                             C
C                                                                      C
C     Written by Arthur Haynes, TRIUMF U.B.C., July 6, 1981.           C
C                                                                      C
C     Modified Oct. 24/83 by F.W. Jones in conjuction with             C
C     modifications to PLOT_MONITOR to speed up display.               C
C     See PLOT_MONITOR source code for details.                        C
C                                                                      C
C     Modified June 25/84 by F.W. Jones:                               C
C     Entry point FLUSH_BUFFER added.  This is used by FLUSH_PLOT.     C
C                                                                      C
C     Modified August/84 by F.W. Jones to include the VT241.           C
C     Modified Oct 4/85 by F.W. Jones to include the Plessey PT100G.   C
C     Modified Nov/88 by J.Chuma to include the LN03+                  C
C     Modified May 16/89 by J.Chuma to include the generic terminal    C
C                                                                      C
C======================================================================C
      COMMON /PLOTMONITOR/ IMONITOR,IOUTM
      COMMON /PLOT_BUFFER/ INDEX,IMODE,BUFFER(78)

C    Modified by J.Chuma, 7Mar97, for LINUX g77
C    changed LOGICAL*1 to BYTE
      BYTE BUFFER

C Previous TEK codes:
      COMMON/TEK_PREVIOUS/IYHIP,IYLOP,IXHIP,IXLOP,IEXTRAP

      IF( (INDEX .LE. 64) .AND. (IMODE .EQ. 1) )RETURN

C INDEX > 64 (buffer is full) or IMODE = 2 (direct mode)...

      ENTRY FLUSH_BUFFER

C VT241:
      IF( IMONITOR .EQ. 8 )THEN
        INDEX_S=INDEX
        CALL PRINT_BUFFER
        IF( INDEX_S .LT. 10 )RETURN
C Penup move to last location plotted:

C    Modified by J.Chuma, 7Mar97, for LINUX g77
C    was BUFFER(1) = 'P', and BUFFER was a LOGICAL*1 array

        BUFFER(1)=ICHAR('P')
        CALL MOVEC(9,BUFFER(INDEX_S-8),BUFFER(2))
        INDEX=10

C Generic terminal
      ELSE IF( IMONITOR .EQ. 17 )THEN
        CALL GENERIC_CHECK_BUFFER

      ELSE
        CALL PACK_BUFFER(31)
        CALL PRINT_BUFFER      ! Print the buffer.

C Move with pen up to the last point plotted on the screen...
C We must pack all the bytes for the first vector as the terminal
C may receive other data before the next buffer is printed:

        CALL PACK_BUFFER(29)   ! GS: Graphics control code.
        CALL PACK_BUFFER(IYHIP)
        IF( (IMONITOR .EQ. 9) .OR. (IMONITOR .EQ. 16) )
     &   CALL PACK_BUFFER(IEXTRAP)
        CALL PACK_BUFFER(IYLOP)
        CALL PACK_BUFFER(IXHIP)
        CALL PACK_BUFFER(IXLOP)
      END IF

      RETURN
      END
