      SUBROUTINE CONVERT_REAL_TO_CHAR(REALIN,MAXLEN,PLUS,SOUT,LENS)
C
C   This subroutine converts a real number, REALIN, to a character
C   string, SOUT, with length LENS.
C   If the number will fit into MAXLEN characters in F format it will
C   do so, otherwise it will appear in E format.  MAXLEN should be
C   in the range:   7 <= MAXLEN <= 15
C   If PLUS is true, then positive numbers will have a plus sign in
C   front, otherwise not.
C   
C   Input:    REALIN     ---   REAL*4
C             MAXLEN   ---   INTEGER*4
C             PLUS     ---   LOGICAL
C
C   Output:   SOUT     ---   CHARACTER*15
C             LENS     ---   INTEGER*4
C
      CHARACTER*15 SOUT
      character*30 SS
      CHARACTER FORCHR(0:8)*9
      LOGICAL   PLUS
      real      realin
C
      DATA FORCHR / '(1PE7.0) ', '(1PE8.1) ', '(1PE9.2) ',
     &              '(1PE10.3)', '(1PE11.4)', '(1PE12.5)',
     &              '(1PE13.6)', '(1PE14.7)', '(1PE15.8)' /
C
      MAXL = MIN( MAX( 7, MAXLEN ), 15 )
      NDEC = MAXL - 7
      SS    = ' '
      SOUT = ' '

      WRITE(SS,FORCHR(NDEC))REALIN

      ISTART = 1
      IF( SS(1:1) .EQ. ' ' )THEN
        IF( PLUS )THEN
          SS(1:1) = '+'
        ELSE
          ISTART = 2
        END IF
      END IF
#ifdef VMS
      CALL CHREAL(%REF(SS(NDEC+5:NDEC+7)),3,POW,1)
#else
      CALL CHREAL(SS(NDEC+5:NDEC+7),3,POW,1)
#endif
      IPOW = IFIX(POW)
      L = NDEC + 3
      DO WHILE ( ( L .GT. 3 ) .AND. ( SS(L:L) .EQ. '0' ) )
        L = L - 1
      END DO
      IF( IPOW .EQ. 0 )THEN
        SOUT(1:) = SS(ISTART:L)
        LENS     = L - ISTART + 1
        IF( SOUT(LENS:LENS) .EQ. '.' )THEN
          SOUT(LENS:LENS) = ' '
          LENS            = LENS - 1
        END IF
      ELSE IF(IPOW .LT. 0)THEN
        IF( (L - IPOW - ISTART + 1) .GT. MAXL )THEN
          SOUT(1:) = SS(ISTART:L)//SS(NDEC+4:NDEC+7)
          LENS     = L - ISTART + 5
        ELSE
          IF( ISTART .EQ. 1 )THEN
            SOUT(1:3) = SS(1:1)//'0.'
            LENS      = 3
          ELSE
            SOUT(1:2) = '0.'
            LENS      = 2
          END IF
          DO I = 1, -IPOW-1
            SOUT(LENS+1:LENS+1) = '0'
            LENS = LENS + 1
          END DO
          SOUT(LENS+1:LENS+1) = SS(2:2)
          LENS = LENS + 1
          DO I = 1, L - 3
            SOUT(LENS+1:LENS+1) = SS(I+3:I+3)
            LENS = LENS + 1
          END DO
        END IF
      ELSE
        IF( (IPOW + MOD(ISTART,2) + 1) .GT. MAXL )THEN
          SOUT(1:) = SS(ISTART:L)//SS(NDEC+4:NDEC+7)
          LENS     = L - ISTART + 5
        ELSE
          LENS = 0
          DO I = ISTART, 2
            SOUT(LENS+1:LENS+1) = SS(I:I)
            LENS = LENS + 1
          END DO
          DO I = 1, L - 3
            SOUT(LENS+1:LENS+1) = SS(I+3:I+3)
            LENS = LENS + 1
          END DO
          DO I = 1, IPOW - (L - 3)
            SOUT(LENS+1:LENS+1) = '0'
            LENS = LENS + 1
          END DO
          II = IPOW + MOD(ISTART,2) + 1
          IF( II .LT. LENS )THEN
            SOUT(1:) = SOUT(1:II)//'.'//SOUT(II+1:LENS)
            LENS = LENS + 1
          END IF
        END IF
      END IF
      RETURN
      END
