      FUNCTION DEXP10(REAL,IPOW)
C
C     LIBRARY-ROUTINE
C
C                                                29/JULY/1980
C                                                C.J. KOST SIN
C
C     reqd. routines - NONE
C
C================================================================
C================================================================
C==                                                            ==
C==   DEXP10 = REAL/10.D0**IPOW.                               ==
C==                                                            ==
C==   DEXP10 MEANS "DIVIDE BY EXPONENTIATION OF BASE 10".      ==
C==                                                            ==
C==   DEXP10 RETURNS A VALUE FOR THOSE CASES WHEN              ==
C==   REAL/10.D0**IPOW IS DEFINED BUT |IPOW| IS TOO LARGE FOR  ==
C==   THE EXPONENT EVALUATION OF 10.D0**IPOW.                  ==
C==                                                            ==
C==   EXAMPLE: IF REAL=1.E-70 AND IPOW=-100 THEN               ==
C==            10.D0**IPOW IS UNDEFINED (UNDERFLOW), BUT       ==
C==            DEXP10(REAL,IPOW) = 1.E-70/10**-100 = 1.E30 IS  ==
C==            WELL DEFINED.                                   ==
C==                                                            ==
C==   NOTE: DEXP10 DOES NOT TAKE SPECIAL NOTE OF THOSE CASES   ==
C==         WHEN REAL/10.D0**IPOW IS UNDEFINED DUE TO AN       ==
C==         UNDERFLOW OR OVERFLOW. THESE CASES ARE HANDLED BY  ==
C==         THE SYSTEM.                                        ==
C==                                                            ==
C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., MARCH 5, 1979.  ==
C==                                                            ==
C==   INPUT  PARAMETERS: REAL (R*8), IPOW (I*4).               ==
C==   OUTPUT PARAMETERS: DEXP10 (R*8 FUNCTION VALUE).          ==
C==                                                            ==
C================================================================
C================================================================
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      IMPLICIT REAL*8 (A-H,O-Z)
      IPOWA=IABS(IPOW)
      IF(IPOWA.GT.70)GO TO 10
C================================================================
C==   SIMPLE CASE: |IPOW| <= 70.                               ==
C================================================================
      DEXP10=REAL/10.D0**IPOW
      RETURN
C================================================================
C==   CASE WHEN |IPOW| > 70.                                   ==
C==   DIVIDE BY REAL BY 10**(ISIGN(1,IPOW)*70) AND SUBTRACT 70 ==
C==   OFF OF |IPOW| UNTIL |IPOW| IS <= 70.                     ==@
C================================================================
10    DEXP10=REAL
      IPOWS=ISIGN(1,IPOW)
      IPS70=IPOWS*70
20    IF(IPOWA.LE.70)GO TO 30
      DEXP10=DEXP10/10.D0**IPS70
      IPOWA=IPOWA-70
      GO TO 20
C================================================================
C==   DIVIDE BY THE REMAINING POWER.                           ==
C================================================================
30    DEXP10=DEXP10/10.D0**(IPOWS*IPOWA)
      RETURN
      END
