      SUBROUTINE DSPLFT( X, Y, DY, S, N, W, * )
C
C  This routine interpolates and/or smooths 1 dimensional array.
C  DSPLFT fits a cubic spline function to a set of data points
C  (X(I),Y(I)), I = 1, N. The routine will try to achieve
C  sum(i=1,N) of (g(X(i))-Y(i))**2/(DY(i)**2) < S where DY(i)>0,
C  i=1,....N AND S >= 0  are given numbers and g is the cubic spline.
C  This routine was taken from U.B.C *NUMLIB
C  For more complete write-up see UBC CURVE p.53-58 (Mar/76)
C
C  Input Parameters
C   X    : REAL*8 monotonically increasing array dimensioned N
C          containing the abscissae of the given data points.
C   Y    : REAL*8 array dimensioned N containing the ordinates
C          of the given data points.
C   DY   : REAL*8 array dimensioned N which controls the
C          amount of smoothing at each abscissa. If possible
C          use the standard deviation of Y(i) for DY(i)
C   S    : REAL*8 variable controlling "tension" of fit
C          If S=0. an interpolating spline results
C   N    : INTEGER*4 variable containing the number of data points  (N>2)
C  Output Parameters
C   W    : REAL*8 array dimensioned 11*N+14 used for scratch
C
C  Originally written by CJ Kost, Aug 5, 1980 (@SIN) 
C  Extensively modified by JL Chuma, March 30, 1994
C
      IMPLICIT NONE

      REAL*8    X(1), Y(1), DY(1), W(1), S
      INTEGER*4 N

C  local variables

      REAL*8    DS, E, EE, F, G, H, P, SS
      INTEGER*4 NCOUNT, I
CCC
      IF( N .LT. 3 )RETURN 1
      NCOUNT = 1
      SS = S
      DS = SS
      EE = DS*0.5D-6
      IF( S .LE. 0.0D0 )THEN
        SS = 1.0D-8 
        EE = 0.5D-6
      END IF

      W(4*N+1) = 0.0D0
      W(4*N+2) = 0.0D0
      W(6*N+3) = 0.0D0
      W(6*N+4) = 0.0D0
      W(7*N+5) = 0.0D0
      W(7*N+6) = 0.0D0
      W(9*N+11) = 0.0D0
      W(9*N+12) = 0.0D0
      W(10*N+11) = 0.0D0
      W(10*N+12) = 0.0D0

      P = 0.0D0

      H = X(2)-X(1)
      IF( H .LE. 0.0D0 )RETURN 1
      F = (Y(2)-Y(1))/H
      DO I = 2, N-1
        G = H
        H = X(I+1)-X(I)
        IF( H .LE. 0.0D0 )RETURN 1
        E = F
        F = (Y(I+1)-Y(I))/H
        W(I) = F-E
        W(7*N+7+I) = .66666666666667D0*(G+H)
        W(8*N+9+I) = .33333333333333D0*H
        W(6*N+5+I) = DY(I-1)/G
        W(4*N+I+1) = DY(I+1)/H
        W(5*N+3+I) = -DY(I)/G-DY(I)/H
      END DO

      DO I = 2, N-1
        W(N+I) = W(4*N+I+1)*W(4*N+I+1)+W(5*N+3+I)*W(5*N+3+I)
     &   +W(6*N+5+I)*W(6*N+5+I)
        W(2*N+I) = W(4*N+I+1)*W(5*N+4+I)+W(5*N+3+I)*W(6*N+6+I)
        W(3*N+I) = W(4*N+I+1)*W(6*N+7+I)
      END DO

C  LDU decompositon

    3 DO I = 2, N-1
        W(5*N+2+I) = F*W(4*N+I)
        W(6*N+3+I) = G*W(4*N+I-1)
        W(4*N+I+1) = 1.0D0/(W(N+I)+P*W(7*N+7+I)-F*W(5*N+2+I)-
     &               G*W(6*N+3+I))
        W(9*N+11+I) = W(I)-W(5*N+2+I)*W(9*N+10+I)-W(6*N+3+I)*W(9*N+9+I)
        F = W(2*N+I)+P*W(8*N+9+I)-H*W(5*N+2+I)
        G = H
        H = W(3*N+I)
      END DO

C  back substitution

      DO I = 2, N-1
        W(10*N+12-I) = W(5*N+2-I)*W(10*N+12-I)
     &   -W(6*N+4-I)*W(10*N+13-I)-W(7*N+6-I)*W(10*N+14-I)
      END DO
      E = 0.0D0
      H = 0.0D0

      DO I = 1, N-1
        G = H
        H = (W(9*N+12+I)-W(9*N+11+I))/(X(I+1)-X(I))
        W(10*N+13+I) = (H-G)*DY(I)*DY(I)
        E = E+W(10*N+13+I)*(H-G)
      END DO
      G = -H*DY(N)*DY(N)
      W(11*N+13) = G
      E = E-G*H
      IF( E.GT.DS .AND. ABS(E-DS).GT.EE )THEN
        F = 0.0D0
        G = 0.0D0
        DO I = 2, N-1
          H = W(9*N+10+I)*W(8*N+8+I)+W(9*N+11+I)*W(7*N+7+I)
     &     +W(9*N+12+I)*W(8*N+9+I)
          F = F+W(9*N+11+I)*H
          H = H-W(5*N+2+I)*W(4*N+I)-W(6*N+3+I)*W(4*N+I-1)
          G = G+H*W(4*N+I+1)*H
          W(4*N+I+1) = H
        END DO
        H = F-P*G
        IF( H .GT. 0.0D0 )THEN
          NCOUNT = NCOUNT+1
          IF( NCOUNT .GT. 100 )RETURN 1
          P = P+SQRT(E/SS)*(E-SQRT(DS*E))/H
          GO TO 3
        END IF
      END IF
      DO I = 1, N
        W(I) = Y(I)-W(10*N+13+I)
        W(2*N+I) = P*W(9*N+11+I)
      END DO
      DO I = 1, N-1
        H = X(I+1)-X(I)
        W(3*N+I) = (W(2*N+I+1)-W(2*N+I))/(3.0D0*H)
        W(N+I) = (W(I+1)-W(I))/H-(H*W(3*N+I)+W(2*N+I))*H
      END DO
      RETURN
      END
CCC
      SUBROUTINE DSPLN( X, N, W, XX, YY, YY1, YY2, M, * )
C
C  input
C     X: monotonically increasing array dimensioned N
C        containing the abscissae of the given data points.
C     N: number of data points  (N>2)
C     W: array dimensioned 11*N+14 used for scratch
C    XX: array length M containing the abscissae
C        at which the fiited curve is to be evaluated
C        Note: X(1) <= XX(I) <= X(N) for i=1,...M
C     M: number of abscissae  XX(i)
C
C  output
C    YY: array dimensioned N containing the
C        returned ordinates of the function at XX(i)
C   YY1: same as YY but first derivative at  XX(i)
C   YY2: same as YY but second derivative at XX(i)
C
      IMPLICIT NONE

      REAL*8    X(1), W(1), XX(1), YY(1), YY1(1), YY2(1)
      INTEGER*4 N, M

      REAL*8    DIFF
      INTEGER*4 I, J, A, B, C, D
CCC
      IF( M .LE. 0 )RETURN
      J = 1
      A = 1
      B = A+N
      C = B+N
      D = C+N
      DO 15 I = 1, M
   11   IF( XX(I) .LT. X(J) )GO TO 14
        IF( XX(I) .LT. X(J+1) )GO TO 13
        IF( J .LT. N-1 )GO TO 12
        IF( XX(I) .EQ. X(J+1) )GO TO 13
        RETURN 1
   12   J = J+1
        A = J
        B = A+N
        C = B+N
        D = C+N
        GO TO 11
   13   DIFF = XX(I)-X(J)
        YY(I) = W(A)+DIFF*(W(B)+DIFF*(W(C)+DIFF*W(D)))
        YY1(I) = W(B)+DIFF*(2.0D0*W(C)+3.0D0*DIFF*W(D))
        YY2(I) = 2.0D0*W(C)+6.0D0*W(D)*DIFF
        GO TO 15
   14   IF( J .EQ. 1 )RETURN 1
        J = 1
        A = J
        B = A+N
        C = B+N
        D = C+N
        GO TO 11
   15 CONTINUE
      RETURN
      END
