      SUBROUTINE DSPXYS(S,X,Y,DY,N,XX,YY,M,W1,W2,W3,W4,W5,*)
C
C  This routine smoothes a curve through an ordered set of points.
C  It first parameterizes the points in terms of normalized arclength.
C  Normalized length in X is real length divided by the range of X, ie.
C  the maximum X value of input points minus the minimum. Normalized
C  length in Y is real length divided by the range of Y, ie. the maximum
C  Y value of input points minus the minimum.  The arclength at an input
C  point is approximated by the sum of the lengths of straight lines
C  connecting all points up to that input point.  Next, a spline with
C  tension curve is computed for X versus arclength and Y versus arclength.
C  For equally spaced arclength, X and Y values are interpolated separatly
C  and then combined to form output points.
C
C  Note:  The smoothing of the spline with tension for X versus arclength
C         and Y versus arclength is done by subroutine DSPLFT
C
C  on input
C         S: normalized tension factor. It corresponds to the curviness
C            desired.  It is nonzero and its sign is ignored.  If S is
C            close to zero, eg. 0.001, then each interpolated function -
C            X vs arclength and Y vs arclength - are almost cubic splines
C            and the resulting plot is quite curvy.  If S is large, eg.
C            100, then the interpolation between points is almost linear.
C            A standard value for S is 1
C         X: array of the X values of the ordered input points, length N
C         Y: array of the Y values of the ordered input points, length N
C        DY: array controls amount of smoothing at each point, length N
C         N: dimension of X and Y
C         M: the number of output points
C            (approximately spaced by equal arc-length)
C        W1: work array, length N
C        W2: work array, length 11*N+14
C        W3: work array, length M
C        W4: work array, length M
C        W5: work array, length M
C
C  on output
C      XX: array of the X values of the interpolated points, length M
C      YY: array of the Y values of the interpolated points, length M
C
C   Originally written by CJ Kost, July 29, 1980  (@SIN)
C   Extensively modified by JL Chuma, March 30, 1994
C
      IMPLICIT NONE

      REAL*8    S, X(1), Y(1), XX(1), YY(1), DY(1)
     &         ,W1(1), W2(1), W3(1), W4(1), W5(1)
      INTEGER*4 N, M

C  local variables

      INTEGER*4 I
CCC
C   Calculate arclength parameterization for input points

      W1(1) = 0.0D0
      DO I = 2, N
        W1(I) = W1(I-1) + SQRT((X(I)-X(I-1))**2+(Y(I)-Y(I-1))**2)
      END DO

C  Calculate arclengths of output points

      DO I = 1, M-1
        W3(I) = FLOAT(I-1)*W1(N)/FLOAT(M-1)
      END DO
      W3(M) = W1(N)

C  perform spline with tension interpolation for
C  functional values X versus arclength and Y versus arclength

      CALL DSPLFT( W1, X, DY, S, N, W2, *999 )
      CALL DSPLN( W1, N, W2, W3, XX, W4, W5, M, *999 )
      CALL DSPLFT( W1, Y, DY, S, N, W2, *999 )
      CALL DSPLN( W1, N, W2, W3, YY, W4, W5, M, *999 )
      RETURN
  999 RETURN 1
      END
