      SUBROUTINE DWG_NEXT
C======================================================================C
C  Continue with a new frame in a multiframe drawing.
C  Modified 14-FEB-94 by FWJ: improved error handling
C======================================================================C
      COMMON/CDWG/DWGON,DWGTXT,LDWG,LDWT,IRECG,IRECT,STROKE
      LOGICAL DWGON,DWGTXT,STROKE
      COMMON/CDWGNAM/DWGOPEN,DWGNAM
      LOGICAL DWGOPEN
      CHARACTER*80 DWGNAM
      COMMON/DWG_MULTI/NFRAME,IRECI
C Current plot window:
      COMMON/HARDCOPYRANGE/XMINHP2,XMAXHP2,YMINHP2,YMAXHP2,IORIENTH2

      INTEGER*2 IMODE2,NFRAME2
      INTEGER*2 IPEN/99/
      BYTE ICOL/0/,ILIN/0/

      PARAMETER(NFRMAX=500)

      IF(.NOT.DWGOPEN)RETURN

C Don't allow empty frames:
      IF(IRECG.EQ.3)RETURN
      IF(NFRAME.GT.1.AND.IRECG.EQ.IRECI+2)RETURN

      IF(NFRAME.EQ.NFRMAX)THEN
        WRITE(*,*)'DWG_NEXT: too many frames: maximum is',NFRMAX
        RETURN
      ENDIF

C Write IPEN=99 separator record and headers for next frame
      WRITE(LDWG,REC=IRECG,ERR=997)0.,0.,IPEN,ICOL,ILIN
      WRITE(LDWG,REC=IRECG+1,ERR=997)XMINHP2,YMINHP2,0
      WRITE(LDWG,REC=IRECG+2,ERR=997)XMAXHP2,YMAXHP2,0

C Update number of frames and store address
      NFRAME=MAX(NFRAME,1)
      NFRAME=NFRAME+1
      IRECI=IRECG+1
      IRECG=IRECG+3
      READ(LDWG,REC=1,ERR=998)X,Y,IMODE2,NFRAME2
      NFRAME2=NFRAME
      WRITE(LDWG,REC=1,ERR=999)X,Y,IMODE2,NFRAME2

C Reset output switches
      DWGON=.TRUE.
      DWGTXT=.FALSE.
      STROKE=.FALSE.

      RETURN

997   WRITE(*,*)'DWG_NEXT: Error writing new-frame records at',IRECG
      CALL FORMSG
      RETURN
998   WRITE(*,*)'DWG_NEXT: Error reading drawing file header record 1'
      CALL FORMSG
      RETURN
999   WRITE(*,*)'DWG_NEXT: Error writing drawing file header record 1'
      CALL FORMSG
      RETURN

      END
