      SUBROUTINE ELLIPS(A,B,XC,YC,ANG,N,X,Y,NUSE)
C
C     LIBRARY-ROUTINE
C
C                                                05/AUG/1980
C                                                C.J. KOST SIN
C
C    reqd. routines - NONE
C
C======================================================================
C======================================================================
C==                                                                  ==
C==  ELLIPS: RETURNS NUSE POINTS IN (X, Y) WHICH UNIFORMLY POPULATE  ==
C==          THE PERIMETER OF THE ELLIPSE SPECIFIED BY THE MAJOR AND ==
C==          MINOR AXES: A & B (RESPECTIVELY), THE X AND Y COORDINATES=
C==          OF THE CENTER OF THE ELLIPSE: XC AND YC, AND THE ANGLE  ==
C==          OF ORIENTATION (W.R.T. THE X-AXIS): ANG.  N IS THE      ==
C==          NUMBER OF POINTS WHICH ELLIPS TRYS TO PRODUCE, WHILE    ==
C==          NUSE=N/4 * 4 IS THE ACTUAL NUMBER IT RETURNS IN (X,Y).  ==
C==                                                                  ==
C==  INPUT  PARAMETERS: A,B,XC,YC,ANG,N.                             ==
C==                                                                  ==
C==  OUTPUT PARAMETERS: X,Y,NUSE.                                    ==
C==                                                                  ==
C======================================================================
C======================================================================
C==                                                                  ==
C==  SUBROUTINES CALLED:                                             ==
C==                                                                  ==
C==  NAME   TYPE                EXPLANATION                          ==
C==                                                                  ==
C==  COS    R*4         COSINE FUNCTION.                             ==
C==  SIN    R*4         SINE FUNCTION.                               ==
C==                                                                  ==
C======================================================================
C======================================================================
C==                                                                  ==
C==  VARIABLES:                                                      ==
C==                                                                  ==
C==  NAME   TYPE                EXPLANATION                          ==
C==                                                                  ==
C==  A      R*4         SEMI-MAJOR AXIS LENGTH.                      ==
C==  ANG    R*4         ANGLE OF ORIENTATION W.R.T TO THE X-AXIS.    ==
C==                     MEASURED IN DEGREES.                         ==
C==  B      R*4         SEMI-MINOR AXIS LENGTH.                      ==
C==  CANGR  R*4         COSINE OF ANG.                               ==
C==  I      I*4         DO LOOP INDEX.                               ==
C==  N      I*4         NUMBER OF POINTS ELLIPS TRYS TO POPULATE THE ==
C==                     ELLIPSE WITH. ACTUAL NUMBER OF POINTS RETURN-==
C==                     ED IN X,Y IS NUSE=N/4*4.                     ==
C==  ND2M1  I*4         N/2-1.                                       ==
C==  ND4    I*4         N/4.                                         ==
C==  ND4P1  I*4         N/4+1.                                       ==
C==  NUSE   I*4         ACTUAL NUMBER OF POINTS USED TO POPULATE THE ==
C==                     ELLIPSE. NUSE=N/4*4.                         ==
C==  PI     R*4         WELL KNOWN CONSTANT: 3.14159265.             ==
C==  SANGR  R*4         SINE OF ANGLE ANG.                           ==
C==  THINC  R*4         THETA INCREMENT.                             ==
C==  X      R*4(N)      NUSE X-COORDINATES OF THE ELLIPSE.           ==
C==  XC     R*4         X-COORDINATE OF THE CENTER OF THE ELLIPSE.   ==
C==  XX     R*4         X-COORDINATE OF THE ELLIPSE.                 ==
C==  Y      R*4(N)      NUSE Y-COORDINATES OF THE ELLIPSE.           ==
C==  YC     R*4         Y-COORDINATE OF THE CENTER OF THE ELLIPSE.   ==
C==  YY     R*4         Y-COORDINATE OF THE ELLIPSE.                 ==
C==                                                                  ==
C======================================================================
C======================================================================
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      REAL X(N),Y(N)
      PI=3.14159265
      ND4=N/4
      NUSE=4*ND4
      IF(ND4.EQ.0)RETURN
      ND4P1=ND4+1
      THINC=PI/2./ND4
C======================================================================
C==                                                                  ==
C==   POPULATE 1/4 OF THE ELLIPSE WITH N/4 POINTS IN QUADRANT 1 OF   ==
C==   THE STANDARD COORDINATE SYSTEM FOR THE ELLIPSE.                ==
C==                                                                  ==
C======================================================================
      DO 10 I=1,ND4P1
      X(I)=A*COS((I-1)*THINC)
      Y(I)=B*SIN((I-1)*THINC)
10    CONTINUE
C======================================================================
C==                                                                  ==
C==   POPULATE 1/4 OF THE ELLIPSE WITH N/4 POINTS IN QUADRANT 2 OF   ==
C==   THE STANDARD COORDINATE SYSTEM FOR THE ELLIPSE.                ==
C==                                                                  ==
C======================================================================
      DO 20 I=1,ND4
      X(I+ND4P1)=-X(ND4P1-I)
      Y(I+ND4P1)=Y(ND4P1-I)
20    CONTINUE
C======================================================================
C==                                                                  ==
C==   POPULATE THE BOTTOM 1/2 OF THE ELLIPSE WITH N/4*2 POINTS.      ==
C==                                                                  ==
C======================================================================
      ND2M1=2*ND4-1
      DO 30 I=1,ND2M1
      X(I+ND4P1+ND4)=-X(I+1)
      Y(I+ND4P1+ND4)=-Y(I+1)
30    CONTINUE
C======================================================================
C==                                                                  ==
C==   ROTATE THE ELLIPSE SO THAT IT HAS AN ORIENTATION ANGLE OF ANG  ==
C==   DEGREES W.R.T THE X-AXIS OF THE NEW FRAME.                     ==
C==   ALSO SHIFT THE ELLIPSE CENTER TO (XC,YC).                      ==
C==                                                                  ==
C======================================================================
      CANGR=COS(ANG*PI/180.)
      SANGR=SIN(ANG*PI/180.)
      DO 40 I=1,NUSE
      XX=X(I)
      YY=Y(I)
      X(I)=CANGR*XX-SANGR*YY+XC
      Y(I)=SANGR*XX+CANGR*YY+YC
40    CONTINUE
      RETURN
      END
