      SUBROUTINE FOURT(DATA,NTHETA,NODIM,ISIGN,IFORM,A,NWORK,*)
C=======================================================================
C==  DATA  is a REAL*4 array(IFORM=0 or -1) or COMPLEX*8 array (IFORM=1)
C==        On entry, DATA must contain the input data points. If the 
C==        data is real NTHETA must be even. When complex conjugate
C==        data is to be inversely transformed a REAL*4 DATA equivalence
C==        to a COMPLEX*8 array can be used. On exit, DATA will contain
C==        the FFT values. If IFORM=0 or -1 then NTHETA must be even.
C==  NODIM Must be 1 
C==  ISIGN =-1 if discrete Fourier transform (DFT) is required.
C==        =+1 if the Inverse discrete Fourier transform (IDFT) required
C==  IFORM =+1 for complex data. DATA is declared COMPLEX*8 and a DFT
C==            or IDFT may be required.
C==        =0 for real data. DATA is declared REAL*4 and a DFT is wanted
C==        =-1 for conjugate symmetric complex data. DATA is declared
C==            REAL*4 and a IDFT is required. The data which is the
C==            complex conjugate of preceeding data does not have to
C==            be specified. The count od data points specified by 
C==            NTHETA must include the complex conjugate data points.
C==  WORK     is a COMPLEX*8 array with dimension (NTHETA+1)
C==  NWORK    on entry contains the dimension of WORK  
C==
C=======================================================================
C   SIMULATES UBC:FOURT FOR NODIM=1.
C
C   USES CERN:CFT
C
      REAL DATA(NTHETA),A(1)
      IF(IFORM)30,40,50
C
C   IFORM=-1 CONJUGATE SYMMETRIC DATA INPUT
C
  30  NPTS=NTHETA/2+1
      DO 10 I=1,NPTS
      A(I)=DATA(2*I-1)
      A(I+NTHETA)=DATA(I*2)
  10  CONTINUE
      DO 15 I=2,NPTS
      A(NTHETA-I+2)=A(I)
      A(NTHETA-I+2+NTHETA)=-A(I+NTHETA)
  15  CONTINUE
      GO TO 70
C
C   IFORM=0    REAL DATA INPUT
C
  40  DO 41 I=1,NTHETA
      A(I)=DATA(I)
      A(I+NTHETA)=0.
  41  CONTINUE
      GO TO 70
C
C   IFORM=+1   GENERAL COMPLEX DATA INPUT
C
  50  DO 51 I=1,NTHETA
      A(I)=DATA(2*I-1)
      A(I+NTHETA)=DATA(2*I)
  51  CONTINUE
  70  CALL CFT(A,A(1+NTHETA),NTHETA,NTHETA,NTHETA,ISIGN,*999)
      IF(IFORM)80,90,95
C
C  IFORM=-1
C             REAL RETURNED
C
  80  DO 82 I=1,NTHETA
      DATA(I)=A(I)
  82  CONTINUE
      RETURN
  90  NPTS=NTHETA/2+1
C
C   IFORM=0  CONJUGATE SYMMETRIC DATA. NPTS POINTS RETURNED
C
      DO 91 I=1,NPTS
      DATA(2*I-1)=A(I)
      DATA(2*I)=A(I+NTHETA)
  91  CONTINUE
      RETURN
C
C    IFORM=+1  GENERAL COMPLEX DATA RETURNED.
C
  95  DO 96 I=1,NTHETA
      DATA(2*I-1)=A(I)
      DATA(2*I)=A(I+NTHETA)
  96  CONTINUE
      RETURN
 999  RETURN 1
      END
