      SUBROUTINE GET_TERMTYPE(NAME)
C======================================================================C
C                                                                      C
C  GET_TERMTYPE                                    F.W. Jones, TRIUMF  C
C                                                                      C
C  Returns a device name indicating the process terminal type.         C
C  The name is obtained by translating the logical name                C
C    TRIUMF_TERMINAL_TYPE.                                             C
C  The terminal type can be set using the TERMTYPE DCL procedure.      C
C                                                                      C
C  Input: none                                                         C
C                                                                      C
C  Output:                                                             C
C                                                                      C
C    NAME   Character string which receives the device name.           C
C           If the terminal type is undefined or cannot be obtained,   C
C           NAME will be blank-filled.                                 C
C                                                                      C
C  Example:                                                            C
C                                                                      C
C      CHARACTER*10 NAME                                               C
C      CALL GET_TERMTYPE(NAME)                                         C
C      WRITE(6,*)'NAME=',NAME                                          C
C      IF(NAME.EQ.'VT640')WRITE(6,*)'VT640 type recognized by caller'  C
C      END                                                             C
C                                                                      C
C======================================================================C
#ifdef VMS
      INCLUDE '($SSDEF)'
      CHARACTER*(*) NAME
      ISTAT=LIB$SYS_TRNLOG('TRIUMF_TERMINAL_TYPE',,NAME)
      IF(.NOT.ISTAT.OR.ISTAT.EQ.SS$_NOTRAN)NAME=' '
#endif
#ifdef unix
      CHARACTER*(*) NAME
      CHARACTER*20 UPPER_CASE

      CALL GETENV('TRIUMF_TERMINAL_TYPE',NAME)
      NAME=UPPER_CASE(NAME)
cc     WRITE(6,*)'TRIUMF_TERMINAL_TYPE=',NAME
#endif
      RETURN
      END
