C======================================================================C
C                                                                      C
C  GKS_PLOT                                        F.W. Jones, TRIUMF  C
C                                                                      C
C  Interface routines for Triumf Graphics to GKS Metafile,             C
C  to be used at sites where GKS is available.                         C
C  At these sites, the module GKSDUM should be removed from the        C
C  Triumf Library and the local GKS library should be added to the     C
C  linking procedure.                                                  C
C                                                                      C
C======================================================================C

      SUBROUTINE GKS_OPEN(LUNIT)
C======================================================================C
C  Starts a new metafile on unit LUNIT.
C======================================================================C

      COMMON/GKSPLOT/GKSMOPEN
      LOGICAL GKSMOPEN

C GKSGRAAL Metafile Appendix E 2d Output/Input
      INTEGER    MAE2DO
      PARAMETER (MAE2DO=4)
C MGKS Appendex E Metafile
      INTEGER EMOTY
      PARAMETER(EMOTY=300018)
C Clear control flag:  conditionally, always
      INTEGER     GCONDI,    GALWAY
      PARAMETER  (GCONDI=0,  GALWAY=1)
C Local GKS declarations
      INTEGER WKID,ERRFIL
      PARAMETER(WKID=1,ERRFIL=6)

C Line and point buffers
      REAL XL(100),YL(100),XP(100),YP(100)

      LOGICAL FIRST/.TRUE./

C Start GKS
      IF(FIRST)THEN
        CALL GOPKS(ERRFIL,0)      !Open GKS
        FIRST=.FALSE.
      ENDIF

C Open workstation: enable the appropriate statement

CC      CALL GOPWK(WKID,LUNIT,MAE2DO)      !GKSGRAAL
      CALL GOPWK(WKID,LUNIT,EMOTY)      !MGKS

      CALL GACWK(WKID)      !Activate workstation

      GKSMOPEN=.TRUE.
      NL=0      !Clear line buffer
      NP=0      !Clear point buffer

      RETURN


      ENTRY GKS_CLOSE
C======================================================================C
C  Ends the current metafile
C======================================================================C
      IF(.NOT.GKSMOPEN)RETURN       !No current metafile
      CALL GDAWK(WKID)      !Deactivate WS
      CALL GCLWK(WKID)      !Close WS
      GKSMOPEN=.FALSE.
      RETURN


      ENTRY GKS_UPDATE
C======================================================================C
C  Updates the workstation (writes out any pending buffers)
C======================================================================C
      IF(.NOT.GKSMOPEN)RETURN       !No current metafile
      CALL GUWK(WKID,GSUPPD)
      RETURN


      ENTRY GKS_CLEAR
C======================================================================C
C  Clears the workstation (starts new metafile frame)
C======================================================================C
      IF(.NOT.GKSMOPEN)RETURN       !No current metafile
      CALL GCLRWK(WKID,GCONDI)
      NL=0
      NP=0
      RETURN


      ENTRY GKS_PLOT(X,Y,IPEN)
C======================================================================C
C  Executes move (IPEN=3), draw (IPEN=2) and point (IPEN=20)
C======================================================================C
      IF(.NOT.GKSMOPEN)RETURN       !No current metafile
      IF(IPEN.EQ.2)THEN
        IF(NP.GT.0)THEN
          CALL GPM(NP,XP,YP)
          XL(1)=XP(NP)
          YL(1)=YP(NP)
          NP=0
          NL=1
        ENDIF
        IF(NL.EQ.100)THEN
          CALL GPL(NL,XL,YL)
          XL(1)=XL(100)
          YL(1)=YL(100)
          NL=1
        ENDIF
        NL=NL+1
        XL(NL)=X
        YL(NL)=Y
      ELSE IF(IPEN.EQ.3)THEN
        IF(NP.GT.0)THEN
          CALL GPM(NP,XP,YP)
          NP=0
        ENDIF
        IF(NL.GT.1)CALL GPL(NL,XL,YL)
        XL(1)=X
        YL(1)=Y
        NL=1
      ELSE IF(IPEN.EQ.20)THEN
        IF(NL.GT.1)THEN
          CALL GPL(NL,XL,YL)
          NL=0
        ENDIF
        IF(NP.EQ.100)THEN
          CALL GPM(NP,XP,YP)
          NP=0
        ENDIF
        NP=NP+1
        XP(NP)=X
        YP(NP)=Y
      ENDIF
      RETURN


      ENTRY GKS_FLUSH
C======================================================================C
C  Flushes the line and point buffers
C======================================================================C
      IF(.NOT.GKSMOPEN)RETURN       !No current metafile
      IF(NL.GT.1)THEN
        CALL GPL(NL,XL,YL)
        XL(1)=XL(NL)
        YL(1)=YL(NL)
        NL=1
      ELSE IF(NP.GT.0)THEN
        CALL GPM(NP,XP,YP)
        XL(1)=XP(NP)
        YL(1)=YP(NP)
        NP=0
        NL=1
      ENDIF
      RETURN


      ENTRY GKS_COLOUR(ICOL)
C======================================================================C
C  Sets the colour index
C======================================================================C
      IF(.NOT.GKSMOPEN)RETURN       !No current metafile
      CALL GSPLCI(ICOL)
      CALL GSPMCI(ICOL)
      RETURN

      END
