      SUBROUTINE AXLINE( XS0, YS0, SLEN, THETAS, XMIN, XMAX,
     & NLINC, NSINC, TICL, TICS, TICANG, ITYPTC, TICLAB, TICANL,
     & ANGLAB, SIZLAB, NPOS, NDEC, IPOW, ITYPLB, MAX_NLABCH, AXMOD,
     & XOFF, LEADZERO, GRID, XTICARR, YTICARR, NUMTIC, MAXTIC, NXYS,
     & XVMIN, XVMAX, XLAXIS, XUAXIS, XS1, YS1 )
C
C   AXLINE: Plots a general linear axis with equally spaced tic marks.
C           The axis both starts and ends with a large tic mark, i.e.
C           it is subdivided into a whole number of equally spaced
C           large tic marks which are in turn subdivided into a whole
C           number of small tic marks.
C
C   Written by Arthur Haynes, TRIUMF U.B.C., April 22, 1981
C
C   Input  Parameters: XS0,YS0,SLEN,THETAS,XMIN,XMAX (R*4);
C                      NLINC,NSINC (I*4); TICL,TICS,TICANG (R*4);
C                      ITYPTC (I*4); TICLAB,TICANL,ANGLAB,SIZLAB (R*4);
C                      NPOS,NDEC,IPOW,ITYPLB  (I*4)
C
C   Output Parameters: IPOW (If ITYPLB < 0) (I*4)
C
C   Parameter definitions:
C
C   XS0   : screen x-coordinate of the start of the axis
C
C   YS0   : screen y-coordinate of the start of the axis
C
C   SLEN  : length of axis in screen units
C
C   THETAS: angle of the axis in degrees relative to the horizontal
C
C   XMIN  : label value "X" which corresponds to the origin
C           of the axis, i.e. minimum "X" value of the axis
C
C   XMAX  : label value "X" which corresponds to the end of
C           the axis, i.e. maximum "X" value of the axis
C
C   NLINC : number of large increments into which the axis is
C           to be subdivided. The number of large tic marks
C           plotted on the axis which delineate the large
C           increments will be exactly NLINC+1
C
C   NSINC : number of small increments into which each of the
C           large increments will be subdivided. The number
C           of small tic marks plotted between each large
C           increment will be exactly NSINC-1
C
C   TICL  : length of the large tic marks which are used to
C           indicate the large increments
C
C   TICS  : length of the small tic marks which are used to
C           indicate the small increments
C
C   TICANG: angle of the tic marks w.r.t. the axis direction
C
C   ITYPTC: tells "AXCURV" what type of tic mark to plot
C           If ITYPTC = 1 then the tic marks are plotted only
C           on one side of the axis, i.e. that side given by "TICANG"
C           If ITYPTC = 2 then the tic marks are plotted symmetrically
C           on both sides of the axis as straight line segments
C           crossing the axis at an angle of "TICANG" degrees
C
C   TICLAB: length of the virtual pointer (tic mark), which points to
C           the location where the axis label will be centered on its
C           perimeter at the large tic mark locations
C
C   TICANL: angle of the virtual pointer (tic mark), which
C           points to the location where the axis label
C           will be centered on its perimeter at the large
C           tic mark locations. This angle is in degrees
C           relative to the axis direction
C
C           Note: The virtual pointers are vectors whose
C                 starting points are on the axis at the
C                 large tic mark locations and end points
C                 determine the positions of the axis labels
C
C   ANGLAB: angle of the axis labels in degrees, w.r.t. the "horizontal"
C           screen direction if |ITYPLB| = 1, or w.r.t. the axis
C           direction if |ITYPLB| = 2
C
C   SIZLAB: height of the axis label values. If SIZLAB <= 0,
C           then no axis labels will be plotted
C
C   NPOS  : width in characters of the axis label format
C           Maximum value of "NPOS" is 20. If "NPOS" <= 0
C           then no axis labels will be plotted
C
C   NDEC  : number of decimal places in the axis label format
C           If "NDEC" < 0 then the decimal point is suppressed
C
C   IPOW  : If "X" is an axis label value at a large tic mark
C           location then the label plotted will have value
C           "C" with format F(NPOS.NDEC) where "X" = "C" * 10**IPOW
C           If "ITYPLB" => 0 then "IPOW" will be accepted as
C           input to the subroutine
C           If "ITYPLB" < 0 then "IPOW" will be returned as
C           output from the subroutine so that the label
C           values "C" which are plotted will have maximum
C           significance in the format field F(NPOS.NDEC)
C
C   ITYPLB: Denotes the type of label. See ANGLAB and IPOW
C
      REAL*4    XTICARR(1), YTICARR(1), GRID
      INTEGER*4 NUMTIC

      BYTE LABEL(20)   ! modified by J.Chuma, 20Mar97 for g77

      INTEGER*4 NHATCH(2)
      COMMON /PSYM_HATCHING/ NHATCH

      INTEGER*4 NUMBOLD
      COMMON /BOLD_AXIS_NUMBERS/ NUMBOLD

C  Modified by J.L.Chuma, 08-Apr-1997 to elimate SIND, COSD for g77
      REAL*4 DTOR /0.017453292519943/
CCC
      NHATCH(1) = NUMBOLD
      NHATCH(2) = 0

      MAX_NLABCH = 0
      IGRID = IFIX(GRID)

C   Initialize constants needed throughout the subroutine and
C   check the input parameters

      COSTH = COS(THETAS*DTOR)
      SINTH = SIN(THETAS*DTOR)
      IF( ABS(COSTH) .LE. 1.E-7 )COSTH=0.0
      IF( ABS(SINTH) .LE. 1.E-7 )SINTH=0.0
      COSTIC = COS(TICANG*DTOR)
      SINTIC = SIN(TICANG*DTOR)
      ANGLB = ANGLAB
      IF( IABS(ITYPLB) .NE. 2 )ANGLB=ANGLAB-THETAS
      NLINC2 = MAX(NLINC,1)
      NSINC2 = MAX(NSINC,1)
      NPOS2  = MAX(MIN0(NPOS,20),0)

C   If "SIZLAB" <= 0 then no labels are to be plotted.

      IF( SIZLAB .LE. 0 )NPOS2=0
      IF( ITYPLB .LT. 0 )IPOW=0

C   TICSP: is the spacing in "S" between the small tic marks of the axis

      TICSP = SLEN/NLINC2/NSINC2
      XINC  = (XVMAX-XVMIN)/NLINC2/NSINC2
      IF( NPOS2 .NE. 0 )THEN
        IF( ITYPLB .LT. 0 )THEN

C   NPOS2 > 0 and ITYPLB < 0 : labels are to be plotted and
C   "IPOW" will be returned as output from the subroutine.

          CALL REALCH(XVMIN,-1,IPOW1,NPOS2,NDEC,LABEL)
          CALL REALCH(XVMAX,-1,IPOW2,NPOS2,NDEC,LABEL)
          IPOW = MAX0(IPOW1,IPOW2)
        END IF

C   Initialize some more constants to be used by the subroutine. 
C   See "Parameter Definitions".
C   (XTICL,YTICL) are the coordinates of the end of the
C   virtual pointer (tic mark) which points to the location
C   where the axis label will be centered on its perimeter

        COSLAB = COS(ANGLB*DTOR)
        SINLAB = SIN(ANGLB*DTOR)
        XTICL  = COS(TICANL*DTOR)*TICLAB
        YTICL  = SIN(TICANL*DTOR)*TICLAB

C   Set "YLIM" for the call to "LABXY" which determines the label
C   position relative to the axis at each long tic mark. The label is
C   not allowed to cross the line "Y = YLIM", where "YLIM" is set to be
C   the maximum perpendicular distance of the long and short tic marks  
C   from the axis on the labelled side of the axis

        IF( ITYPTC .NE. 2 )THEN

C   ITYPTC = 1 : Tic marks are plotted on one side of the axis

          IF( YTICL .LE. 0. )YLIM=AMIN1(SINTIC*TICL,SINTIC*TICS,0.)
          IF( YTICL .GT. 0. )YLIM=AMAX1(SINTIC*TICL,SINTIC*TICS,0.)
        ELSE

C   ITYPTC = 2 : Tic marks are plotted on both sides of the axis

          YLIM=SIGN(1.,YTICL)*AMAX1(ABS(SINTIC*TICL),ABS(SINTIC*TICS))
          IF(YTICL.EQ.0.)YLIM=0.
        END IF
      END IF
      NTICS  = NLINC2*NSINC2+1
      NUMTIC = 0
      LTIC   = 0

      XFN = XS0+COSTH*(XUAXIS-XLAXIS)
      YFN = YS0+SINTH*(XUAXIS-XLAXIS)
      CALL PLOT_R(XS0,YS0,3)
      CALL PLOT_R(XFN,YFN,2)
      EPS = (XMAX+XMIN)*0.0005
      XS0 = XS0 - XS1*COSTH
      YS0 = YS0 - YS1*SINTH
      DO 100 I = 1, NTICS
        XDUM = XVMIN + (I-1)*XINC
        IF( I .EQ. NTICS )XDUM = XVMAX
        IF( (XDUM .LT. MIN(XMIN,XMAX)) .OR. 
     &      (XDUM .GT. MAX(XMIN,XMAX)) )GO TO 100
        STIC = (I-1)*TICSP
        XS = XS0+COSTH*STIC
        YS = YS0+SINTH*STIC

C   Determine whether the tic length "TICLEN" is long (TICL) or short (TICS)

        MODINC = MOD(I-1,NSINC2)
        IF( MODINC .EQ. 0 )THEN
          LTIC = LTIC + 1
          TICLEN = TICL
          IF( (IGRID .NE. 0) .AND. (NUMTIC .LT. MAXTIC) )THEN
            IF( (IGRID .LT. 0) .OR. 
     &          ((LTIC+1)/IGRID*IGRID-(LTIC+1) .EQ. 0) )THEN
              XTICARR(NUMTIC+1) = XS
              YTICARR(NUMTIC+1) = YS
              NUMTIC = NUMTIC + 1
            END IF
          END IF
        ELSE
          TICLEN = TICS
          IF( (IGRID .LT. 0) .AND. (NUMTIC .LT. MAXTIC) )THEN
            XTICARR(NUMTIC+1) = XS
            YTICARR(NUMTIC+1) = YS
            NUMTIC = NUMTIC + 1
          END IF
        END IF

C   (XT,YT) are the unrotated coordinates of the end of the
C   tic mark relative to the location "STIC"

        XT=COSTIC*TICLEN
        YT=SINTIC*TICLEN

C   (XTS,YTS) are rotated screen coordinates of end of the tic mark

        XTS=XS+COSTH*XT-SINTH*YT
        YTS=YS+SINTH*XT+COSTH*YT

C   Plot the tic mark by moving the pen from the tic mark location
C   (XS,YS) to the end of the tic mark (XTS,YTS) with the pen down

        IF( ITYPTC .EQ. 2 )THEN

C   ITYPTC = 2 : Plot the tic mark symmetrically on both sides of the
C                axis as a straight line segment crossing the axis at
C                an angle of "TICANG" degrees

          XTSN=XS-COSTH*XT+SINTH*YT
          YTSN=YS-SINTH*XT-COSTH*YT
          CALL PLOT_R(XTS,YTS,3)
          CALL PLOT_R(XTSN,YTSN,2)
        ELSE
          CALL PLOT_R(XS,YS,3)
          CALL PLOT_R(XTS,YTS,2)
        END IF

C   Check to see if a label is to be plotted

        IF( (MODINC .NE. 0) .OR. (NPOS2 .EQ. 0) )GO TO 100
        IF( (NXYS.LT.0) .AND. ((I.EQ.1) .OR. (I.EQ.NTICS)) )GO TO 100

C   MODINC = 0 and NPOS2 > 0. Therefore an x-label is to be plotted
C   Store the characters for the real label in "LABEL"
C   NLABCH: is the number of non-blank characters in "LABEL"

        XDUM2 = XDUM
        IF( AXMOD .LT. 0. )THEN
          XDUM2 = MOD(XDUM2,ABS(AXMOD))
        ELSE IF( AXMOD .GT. 0. )THEN
          XDUM2 = MOD(XDUM2,AXMOD)
          IF( XDUM2 .LT. 0. )XDUM2 = XDUM2 + AXMOD
        END IF
        XDUM2 = XDUM2 + XOFF
        CALL REALCH(XDUM2,1,IPOW,NPOS2,NDEC,LABEL)
        IFIND = 1
        DO WHILE ( CHAR(LABEL(IFIND)) .EQ. ' ' )
          IF( IFIND .EQ. NPOS2 )GO TO 100
          IFIND = IFIND+1
        END DO
        NLABCH = NPOS2 - IFIND + 1
        MAX_NLABCH = MAX(MAX_NLABCH,NLABCH)

C   Left-justify the "NLABCH" characters of "LABEL"
C   FLENG : is the length in screen units of the label, as
C           plotted by "PSYM"

        DO IJK = 1, NLABCH
          LABEL(IJK) = LABEL(IFIND+IJK-1)
        END DO
        IF( LEADZERO .GT. 0 )THEN
          IF( CHAR(LABEL(1)) .EQ. '.' )THEN
            DO IJK = MIN(20,NLABCH), 1, -1
              LABEL(IJK+1) = LABEL(IJK)
            END DO
            LABEL(1)   = ICHAR('0')
            NLABCH     = NLABCH + 1
            MAX_NLABCH = MAX(MAX_NLABCH,NLABCH)
          END IF
        END IF
        IF( CHAR(LABEL(1)) .EQ. '-' )THEN
          IF( CHAR(LABEL(2)) .EQ. '.' )THEN
            DO IJK = MIN(19,NLABCH), 2, -1
              LABEL(IJK+1) = LABEL(IJK)
            END DO
            LABEL(2)   = ICHAR('0')
            NLABCH     = NLABCH + 1
            MAX_NLABCH = MAX(MAX_NLABCH,NLABCH)
          END IF
        END IF
        FLENG = PSMLEN(LABEL,NLABCH,SIZLAB)

C   Determine the lower left hand corner: (XLAB,YLAB) at which the label
C   is to be plotted, relative to the axis direction, and the location
C   "STIC" of the large tic mark on the axis

        CALL LABXY(XTICL,YTICL,ANGLB,COSLAB,SINLAB,SIZLAB,
     &           FLENG,YLIM,XLAB,YLAB)

C   (XLS,YLS) are the rotated screen coordinates at which the label is
C   to be plotted by "PSYM"

        XLS=XS+COSTH*XLAB-SINTH*YLAB
        YLS=YS+SINTH*XLAB+COSTH*YLAB
        IF(XLS.EQ.-0.)XLS=0.
        IF(YLS.EQ.-0.)YLS=0.

C   Plot the label at angle relative to the horizontal of ANGLE degrees

        ANGLE=ANGLB+THETAS
        CALL PSYMBOLD(XLS,YLS,SIZLAB,LABEL,ANGLE,NLABCH)

C   Move with the pen up to the beginning of the tic mark

100   CONTINUE
      NHATCH(1) = 0
      NHATCH(2) = 0
      RETURN
      END
