      SUBROUTINE GPLOT_CONVERT(XIN,YIN,XOUT,YOUT,ICODE)
C
C   If ICODE =  1, convert XIN and YIN from graph units to world units
C                  and get the current values of XMIN, YMIN, etc.
C   If ICODE = -1, convert XIN and YIN from graph units to world units
C                  and use the old values of XMIN, YMIN, etc.
C   If ICODE =  2, convert XIN and YIN from world units to graph units
C                  and get the current values of XMIN, YMIN, etc.
C   If ICODE = -2, convert XIN and YIN from world units to graph units
C                  and use the old values of XMIN, YMIN, etc.
C
C   Input:    XIN,  YIN, ICODE
C   Output:   XOUT, YOUT

C  Modified by J.L.Chuma, 08-Apr-1997 to elimate SIND, COSD for g77
      REAL*4 DTOR /0.017453292519943/
CCC
      IF( ICODE .GT. 0 )THEN
        XMIN = GETNAM('XMIN')
        XMAX = GETNAM('XMAX')
        YMIN = GETNAM('YMIN')
        YMAX = GETNAM('YMAX')
        XLOG = ABS(GETNAM('XLOG'))
        YLOG = ABS(GETNAM('YLOG'))
        IF( XLOG .GT. 1. )ALOGX = ALOG(XLOG)
        IF( YLOG .GT. 1. )ALOGY = ALOG(YLOG)
C
C    This is to handle non-integral log scale limits
C
CC        IF( XLOG .GT. 1. )THEN
CC          IF( XMIN .GE. 0. )THEN
CC            XMIN = FLOAT(IFIX(XMIN))
CC          ELSE
CC            IF( XMIN .NE. FLOAT(IFIX(XMIN)) )XMIN = IFIX(XMIN) - 1.
CC          END IF
CC          IF( XMAX .LE. 0. )THEN
CC            XMAX = FLOAT(IFIX(XMAX))
CC          ELSE
CC            IF( XMAX .NE. FLOAT(IFIX(XMAX)) )XMAX = IFIX(XMAX) + 1.
CC          END IF
CC        END IF
CC        IF( YLOG .GT. 1. )THEN
CC          IF( YMIN .GE. 0. )THEN
CC            YMIN = FLOAT(IFIX(YMIN))
CC          ELSE
CC            IF( YMIN .NE. FLOAT(IFIX(YMIN)) )YMIN = IFIX(YMIN) - 1.
CC          END IF
CC          IF( YMAX .LE. 0. )THEN
CC            YMAX = FLOAT(IFIX(YMAX))
CC          ELSE
CC            IF( YMAX .NE. FLOAT(IFIX(YMAX)) )YMAX = IFIX(YMAX) + 1.
CC          END IF
CC        END IF
        XAXISA = GETNAM('XAXISA')
        YAXISA = GETNAM('YAXISA')
        XLAXIS = GETNAM('XLAXIS')
        YLAXIS = GETNAM('YLAXIS')
        XUAXIS = GETNAM('XUAXIS')
        YUAXIS = GETNAM('YUAXIS')
        COSX   = COS(XAXISA*DTOR)
        SINX   = SIN(XAXISA*DTOR)
        COSY   = COS(YAXISA*DTOR)
        SINY   = SIN(YAXISA*DTOR)
        IF( ABS(COSX) .LE. 1.E-7 )COSX = 0.0
        IF( ABS(SINX) .LE. 1.E-7 )SINX = 0.0
        IF( ABS(COSY) .LE. 1.E-7 )COSY = 0.0
        IF( ABS(SINY) .LE. 1.E-7 )SINY = 0.0
        AX  = (XUAXIS - XLAXIS) / (XMAX - XMIN)
        BX  = -AX * XMIN
        AY  = (YUAXIS - YLAXIS) / (YMAX - YMIN)
        BY  = -AY * YMIN
        AXX = AX * (COSY*SINX - COSX*SINY)
        AYY = AY * (COSY*SINX - COSX*SINY)
      END IF
      X = XIN
      Y = YIN
      IF( ABS(ICODE) .EQ. 1 )THEN
        IF( XLOG .GT. 1. )THEN 
          IF( X .LE. 0. )X = 1.E-36
          X = ALOG(X) / ALOGX
        END IF
        IF( YLOG .GT. 1. )THEN 
          IF( Y .LE. 0. )Y = 1.E-36
          Y = ALOG(Y) / ALOGY
        END IF
        XOUT = XLAXIS + COSX*(AX * X + BX) + COSY*(AY * Y + BY)
        YOUT = YLAXIS + SINX*(AX * X + BX) + SINY*(AY * Y + BY)
      ELSE IF( ABS(ICODE) .EQ. 2 )THEN
        XOUT = XMIN + ( (Y - YLAXIS)*COSY - (X - XLAXIS)*SINY ) / AXX
        YOUT = YMIN + ( (X - XLAXIS)*SINX - (Y - YLAXIS)*COSX ) / AYY
        IF( XLOG .GT. 1. )XOUT = EXP(XOUT*ALOGX)
        IF( YLOG .GT. 1. )YOUT = EXP(YOUT*ALOGY)
      END IF
      RETURN
      END
