      SUBROUTINE GPLT( X, Y, CHAR, NPT, SIZPT, COLPT, ANGPT, * )
C
      REAL*4    X(1), Y(1), SIZPT(1), ANGPT(1)
      INTEGER*4 NPT(2)
      BYTE  CHAR(1), COLPT(1)  ! modified by J.Chuma 21Mar97 for g77

      INTEGER*4 COLOURS(0:11,0:20)
      INTEGER*4 ICOLR
      COMMON /GPLOT_COLOURS/ COLOURS, ICOLR

      INTEGER*4 ICOLR1, ICOLR2
      COMMON /PLOT_COLOURS/ ICOLR1, ICOLR2

      INTEGER*4 IMONITOR, IOUTM
      COMMON /PLOTMONITOR/ IMONITOR,  IOUTM

      INTEGER*4 IMONITOR2, IOUTM2
      COMMON /PLOTMONITOR2/ IMONITOR2, IOUTM2

      LOGICAL*4 CALLED_FROM_GPLOT
      COMMON /GPLOT_CALLED/ CALLED_FROM_GPLOT

      INTEGER*4 IPENP
      REAL*4 XPREV, YPREV
      COMMON /PLOT_PREVIOUS/ XPREV, YPREV, IPENP

      LOGICAL*4 CTRLC_FLAG
      COMMON /CTRLC/ CTRLC_FLAG   ! modified by J.Chuma 21Mar97 for g77

      REAL*4 TABLE(103)
      COMMON /GPLOTC/ TABLE

      PARAMETER (MXPT=2002)
      CHARACTER*255 CHARL, GETLAB 
      REAL*4        XPOL(MXPT), YPOL(MXPT)
      LOGICAL*4     CTRLC_CALLED
      LOGICAL       NO_CONNECT, FILL, DITH, FRSTP
      BYTE          CHARI, ACHARI
      LOGICAL*1     ERASE

      DATA NO_CONNECT /.TRUE./

C  Modified by J.L.Chuma, 08-Apr-1997 to elimate SIND, COSD for g77
      REAL*4 DTOR /0.017453292519943/
CCC
      SAVE

      CALL CTRLC_TRAP( CTRLC_CALLED )

      IF( TABLE(1) .EQ. 0.0 )CALL GPLOTI
      IF( (GETNAM('XAUTO').NE.0.).OR.(GETNAM('YAUTO').NE.0.) )GO TO 900
      CALLED_FROM_GPLOT = .TRUE.

      XMIN = GETNAM('XMIN')
      XMAX = GETNAM('XMAX')
      YMIN = GETNAM('YMIN')
      YMAX = GETNAM('YMAX')
      IF( (XMAX.EQ.XMIN) .OR. (YMAX.EQ.YMIN) )GO TO 900
C
C  The following is used by HISTYP=1 section
C  Modified 28Nov97 by J.Chuma -- to take log scales into account
C
      XLOG = GETNAM('XLOG')
      YLOG = GETNAM('YLOG')
      IF( XLOG .GT. 1.0 )THEN
        XMIN = XLOG**XMIN
        XMAX = XLOG**XMAX
      END IF
      IF( YLOG .GT. 1.0 )THEN
        YMIN = YLOG**YMIN
        YMAX = YLOG**YMAX
      END IF
      DELTAX = ABS(XMAX - XMIN)
      DELTAY = ABS(YMAX - YMIN)
C
      PTYPE  = GETNAM('PTYPE')
      MASK   = GETNAM('MASK')
      PMODE  = GETNAM('PMODE')
      XLAXIS = GETNAM('XLAXIS')
      XUAXIS = GETNAM('XUAXIS')
      XUWIND = GETNAM('XUWIND')
      XLWIND = GETNAM('XLWIND')
      DELX   = ABS(XUWIND - XLWIND)
      YLAXIS = GETNAM('YLAXIS')
      YUAXIS = GETNAM('YUAXIS')
      YUWIND = GETNAM('YUWIND')
      YLWIND = GETNAM('YLWIND')
      DELY   = ABS(YUWIND - YLWIND)
      SYMSIZ = GETNAM('CHARSZ')
      SYMANG = GETNAM('CHARA')
      SYMANG_OLD = SYMANG
      COSANG = COS(SYMANG*DTOR)
      SINANG = SIN(SYMANG*DTOR)
      NFILL  = IFIX( 500 * SYMSIZ / DELY ) + 1
      NFILL  = MAX(10,NFILL)

      IF( GETNAM('ALIAS') .EQ. 0. )THEN          ! Find new XUAXIS and
        NLINC  = GETNAM('NLXINC')                ! ... YUAXIS to accom-
        NSINC  = GETNAM('NSXINC')                ! ... modate unaliased
        NINCS  = NLINC * NSINC                   ! ... axes.
        SLEN   = XUAXIS - XLAXIS
        XUAXIS = XLAXIS + IFIX(SLEN/NINCS) * NINCS
        NLINC  = GETNAM('NLYINC')
        NSINC  = GETNAM('NSYINC')
        NINCS  = NLINC * NSINC
        SLEN   = YUAXIS - YLAXIS
        YUAXIS = YLAXIS + IFIX(SLEN/NINCS) * NINCS
      END IF

      NERROR  = IFIX(GETNAM('ERRBAR'))
      IHISTYP = IFIX(GETNAM('HISTYP'))
      LINTYP  = IFIX(GETNAM('LINTYP'))
      ILNTPA  = ABS(LINTYP)
      FILL    = .FALSE.
      DITH    = .FALSE.
      IF( ILNTPA .GT. 100 )THEN
        IF( ILNTPA .GE. 200 )THEN
          DITH = .TRUE.
          IDITHX = (ILNTPA-200)/10
          IDITHY = (ILNTPA-200) - IDITHX*10
          ERASE = .FALSE.
          IF( LINTYP .LT. 0 )ERASE = .TRUE.
          IF( IDITHX .EQ. 0 )IDITHX = 1
          IF( IDITHY .EQ. 0 )IDITHY = 1
        ELSE
          FILL  = .TRUE.
          IFILL = ILNTPA - 100
        END IF
      END IF
      SIZFAC = 1.
      IHATCH = 0
      II = 0
      IF( IHISTYP .EQ. 1 )THEN ! Horizontal Histogram without tails
C                                profile parallel to x-axis
        IF( MASK .LE. -3 )THEN
          SIZFAC = SIZPT(1)
          ICOLR = COLPT(1)
          ICOLR = MAX( 0, MIN( 11, ICOLR ) )
          IF( PTYPE .NE. 1. )THEN
            IF( (COLOURS(ICOLR,IMONITOR) .NE. ICOLR1) .OR.
     &          (COLOURS(ICOLR,IMONITOR2) .NE. ICOLR2) ) 
     &      CALL PLOT_COLOR(COLOURS(ICOLR,IMONITOR)
     &                     ,COLOURS(ICOLR,IMONITOR2))
          END IF
        ELSE IF( MASK .LE. -2 )THEN
          SIZFAC = SIZPT(1)
        END IF
        Y0 = 0.0
        IF( NPT(1) .EQ. 1 )THEN
          CALL GPLOT_R(X(1),Y0,3)
          CALL GPLOT_R(X(1),Y(1),2)
          GO TO 900
        END IF
        FRSTP = .TRUE.
        X1 = X(1)
        X2 = X(2)
        IF( SIZFAC .LT. 0. )THEN
          DX = 1.0
          SIZFAC = -SIZFAC
        ELSE
          DX = 0.5*(X2-X1)
        END IF
        X0 = X1-DX*SIZFAC
        X1 = X1+DX*SIZFAC
        IF( X0 .GE. XMAX )GO TO 900
        IF( X1 .LE. XMIN )GO TO 10
        IF( X0 .LT. XMIN )X0 = XMIN
        IF( X1 .GT. XMAX )X1 = XMAX
        FRSTP = .FALSE.
        Y1 = Y(1)
        CALL GPLOT_R(X0,Y0,3)
        CALL GPLOT_R(X0,Y1,2)
        CALL GPLOT_R(X1,Y1,2)
        IF( FILL .OR. DITH )THEN
          XPOL(1) = X0
          YPOL(1) = Y0
          CALL GPLOT_R(XPOL(1),YPOL(1),-1)
          XPOL(2) = X0
          YPOL(2) = Y1
          CALL GPLOT_R(XPOL(2),YPOL(2),-1)
          XPOL(3) = X1
          YPOL(3) = Y1
          CALL GPLOT_R(XPOL(3),YPOL(3),-1)
          II = 3
        END IF
   10   X2 = X1
        DO I = 2, NPT(1)-1
          IF( CTRLC_FLAG )GO TO 999
          IF( MASK .LE. -3 )THEN
            SIZFAC = SIZPT(I)
            ICOLR = COLPT(I)
            ICOLR = MAX( 0, MIN( 11, ICOLR ) )
            IF( PTYPE .NE. 1. )THEN
              IF( (COLOURS(ICOLR,IMONITOR) .NE. ICOLR1) .OR.
     &            (COLOURS(ICOLR,IMONITOR2) .NE. ICOLR2) ) 
     &        CALL PLOT_COLOR(COLOURS(ICOLR,IMONITOR)
     &                       ,COLOURS(ICOLR,IMONITOR2))
            END IF
          ELSE IF( MASK .LE. -2 )THEN
            SIZFAC = SIZPT(I)
          END IF
          XIM1 = X(I-1)
          XI = X(I)
          XIP1 = X(I+1)
          IF( SIZFAC .LT. 0. )THEN
            DXL = 1.0
            DXU = 1.0
            SIZFAC = -SIZFAC
          ELSE
            DXL = 0.5*(XI-XIM1)
            DXU = 0.5*(XIP1-XI)
          END IF
          X0 = XI-DXL*SIZFAC
          X1 = XI+DXU*SIZFAC
          YI = Y(I)
          IF( X0 .GE. XMAX )THEN
            CALL GPLOT_R(X2,Y0,2)
            IF( FILL .OR. DITH )THEN
              XPOL(II+1) = X2
              YPOL(II+1) = Y0
              CALL GPLOT_R(XPOL(II+1),YPOL(II+1),-1)
              II = II + 1
              IF( II .EQ. MXPT )THEN
                FILL = .FALSE.
                DITH = .FALSE.
                II = 0
              END IF
            END IF
            GO TO 18
          END IF
          IF( X1 .LE. XMIN )GO TO 12
          IF( X0 .LE. XMIN )THEN
            X0 = XMIN
            IF( FRSTP )THEN
              CALL GPLOT_R(X0,Y0,3)
              IF( FILL .OR. DITH )THEN
                XPOL(II+1) = X0
                YPOL(II+1) = Y0
                CALL GPLOT_R(XPOL(II+1),YPOL(II+1),-1)
                II = II + 1
                IF( II .EQ. MXPT )THEN
                  FILL = .FALSE.
                  DITH = .FALSE.
                  II = 0
                END IF
              END IF
              X2 = X0
            END IF
          END IF
          IF( X1 .GT. XMAX )X1 = XMAX
          FRSTP = .FALSE.
          IF( ABS(X2-X0)/DELTAX .LT. 0.00001 )THEN
            CALL GPLOT_R(X0,YI,2)
          ELSE
            CALL GPLOT_R(X0,YI,3)
          END IF
          IF( FILL .OR. DITH )THEN
            XPOL(II+1) = X0
            YPOL(II+1) = YI
            CALL GPLOT_R(XPOL(II+1),YPOL(II+1),-1)
            II = II + 1
            IF( II .EQ. MXPT )THEN
              FILL = .FALSE.
              DITH = .FALSE.
              II = 0
            END IF
          END IF
          CALL GPLOT_R(X1,YI,2)
          IF( FILL .OR. DITH )THEN
            XPOL(II+1) = X1
            YPOL(II+1) = YI
            CALL GPLOT_R(XPOL(II+1),YPOL(II+1),-1)
            II = II + 1
            IF( II .EQ. MXPT )THEN
              FILL = .FALSE.
              DITH = .FALSE.
              II = 0
            END IF
          END IF
   12     X2 = X1
        END DO
        I = NPT(1)
        IF( MASK .LE. -3 )THEN
          SIZFAC = SIZPT(I)
          ICOLR = COLPT(I)
          ICOLR = MAX( 0, MIN( 11, ICOLR ) )
          IF( PTYPE .NE. 1. )THEN
            IF( (COLOURS(ICOLR,IMONITOR) .NE. ICOLR1) .OR.
     &          (COLOURS(ICOLR,IMONITOR2) .NE. ICOLR2) ) 
     &      CALL PLOT_COLOR(COLOURS(ICOLR,IMONITOR)
     &                     ,COLOURS(ICOLR,IMONITOR2))
          END IF
        ELSE IF( MASK .LE. -2 )THEN
          SIZFAC = SIZPT(I)
        END IF
        XIM1 = X(I-1)
        XI = X(I)
        IF( SIZFAC .LT. 0. )THEN
          DX = 1.0
          SIZFAC = -SIZFAC
        ELSE
          DX = 0.5*(XI-XIM1)
        END IF
        X0 = XI-DX*SIZFAC
        X1 = XI+DX*SIZFAC
        YI = Y(I)
        IF( X0 .GE. XMAX )THEN
          CALL GPLOT_R(X2,Y0,2)
          IF( FILL .OR. DITH )THEN
            XPOL(II+1) = X2
            YPOL(II+1) = Y0
            CALL GPLOT_R(XPOL(II+1),YPOL(II+1),-1)
            II = II + 1
            IF( II .EQ. MXPT )THEN
              FILL = .FALSE.
              DITH = .FALSE.
              II = 0
            END IF
          END IF
          GO TO 18
        END IF
        IF( X1 .LE. XMIN )GO TO 900
        IF( X0 .LE. XMIN )THEN
          X0 = XMIN
          IF( FRSTP )THEN
            CALL GPLOT_R(X0,Y0,3)
            IF( FILL .OR. DITH )THEN
              XPOL(II+1) = X0
              YPOL(II+1) = Y0
              CALL GPLOT_R(XPOL(II+1),YPOL(II+1),-1)
              II = II + 1
              IF( II .EQ. MXPT )THEN
                FILL = .FALSE.
                DITH = .FALSE.
                II = 0
              END IF
            END IF
            X2 = X0
          END IF
        END IF
        IF( X1 .GT. XMAX )X1 = XMAX
        IF( ABS(X2-X0)/DELTAX .LT. 0.00001 )THEN
          CALL GPLOT_R(X0,YI,2)
        ELSE
          CALL GPLOT_R(X0,YI,3)
        END IF
        IF( FILL .OR. DITH )THEN
          XPOL(II+1) = X0
          YPOL(II+1) = YI
          CALL GPLOT_R(XPOL(II+1),YPOL(II+1),-1)
          II = II + 1
          IF( II .EQ. MXPT )THEN
            FILL = .FALSE.
            DITH = .FALSE.
            II = 0
          END IF
        END IF
        CALL GPLOT_R(X1,YI,2)
        IF( FILL .OR. DITH )THEN
          XPOL(II+1) = X1
          YPOL(II+1) = YI
          CALL GPLOT_R(XPOL(II+1),YPOL(II+1),-1)
          II = II + 1
          IF( II .EQ. MXPT )THEN
            FILL = .FALSE.
            DITH = .FALSE.
            II = 0
          END IF
        END IF
        CALL GPLOT_R(X1,Y0,2)
        IF( FILL .OR. DITH )THEN
          XPOL(II+1) = X1
          YPOL(II+1) = Y0
          CALL GPLOT_R(XPOL(II+1),YPOL(II+1),-1)
          II = II + 1
        END IF
   18   IF( II .GT. 0 )THEN
          IF( FILL )CALL HATCH_DRAW(XPOL,YPOL,II,IFILL)
          IF( DITH )CALL DITHER(XPOL,YPOL,II,IDITHX,IDITHY,ERASE)
        END IF
      ELSE IF( IHISTYP .EQ. 2 )THEN ! Horizontal histogram with tails
C                                     profile parallel to x-axis
        DO I = 1, NPT(1)
          IF( CTRLC_FLAG )GO TO 999
          IF( MASK .LE. -3 )THEN
            ICOLR     = COLPT(I)
            ICOLR     = MAX( 0, MIN( 11, ICOLR ) )
            IF( PTYPE .NE. 1. )THEN
              IF( (COLOURS(ICOLR,IMONITOR) .NE. ICOLR1) .OR.
     &            (COLOURS(ICOLR,IMONITOR2) .NE. ICOLR2) ) 
     &        CALL PLOT_COLOR(COLOURS(ICOLR,IMONITOR)
     &                       ,COLOURS(ICOLR,IMONITOR2))
            END IF
            SIZFAC    = SIZPT(I)
            IHATCH    = CHAR(I)
          ELSE IF( MASK .LE. -2 )THEN
            SIZFAC    = SIZPT(I)
            IHATCH    = CHAR(I)
          ELSE IF( MASK .LE. -1 )THEN
            IHATCH    = CHAR(I)
          END IF
          IHA = ABS(IHATCH)
          IF( IHA .GT. 10 )THEN
            FILL = .FALSE.
            DITH = .TRUE.
            IDITHX = IHA/10
            IDITHY = IHA - IDITHX*10
            ERASE = .FALSE.
            IF( IHATCH .LT. 0 )ERASE = .TRUE.
            IF( IDITHX .EQ. 0 )IDITHX = 1
            IF( IDITHY .EQ. 0 )IDITHY = 1
          ELSE
            IF( IHA .GT. 0 )THEN
              FILL  = .TRUE.
              DITH  = .FALSE.
              IFILL = IHA 
            ELSE IF( IHA .EQ. 0 )THEN
              FILL = .FALSE.
              DITH = .FALSE.
              IF( ILNTPA .GT. 100 )THEN
                IF( ILNTPA .GE. 200 )THEN
                  DITH = .TRUE.
                  IDITHX = (ILNTPA-200)/10
                  IDITHY = (ILNTPA-200) - IDITHX*10
                  ERASE = .FALSE.
                  IF( LINTYP .LT. 0 )ERASE = .TRUE.
                  IF( IDITHX .EQ. 0 )IDITHX = 1
                  IF( IDITHY .EQ. 0 )IDITHY = 1
                ELSE
                  FILL  = .TRUE.
                  IFILL = ILNTPA - 100
                END IF
              END IF
            END IF
          END IF
          IF( NPT(1) .EQ. 1 )THEN
            CALL GPLOT_R(X(1),0.0,3)
            CALL GPLOT_R(X(1),Y(1),2)
            GO TO 900
          END IF
          IF( SIZFAC .LT. 0. )THEN
            DXL    = 1.0
            DXU    = 1.0
            SIZFAC = -SIZFAC
          ELSE
            IF( I .EQ. 1 )THEN
              DXU = 0.5 * (X(I+1) - X(I))
              DXL = DXU
            ELSE IF( I .EQ. NPT(1) )THEN
              DXL = 0.5 * (X(I) - X(I-1))
              DXU = DXL
            ELSE
              DXL = 0.5 * (X(I) - X(I-1))
              DXU = 0.5 * (X(I+1) - X(I))
            END IF
          END IF
          XPOL(1) = X(I) - DXL * SIZFAC
          XPOL(2) = X(I) - DXL * SIZFAC
          XPOL(3) = X(I) + DXU * SIZFAC
          XPOL(4) = X(I) + DXU * SIZFAC
          YPOL(1) = 0.0
          YPOL(2) = Y(I)
          YPOL(3) = Y(I)
          YPOL(4) = 0.0
          IF( IHATCH .EQ. 0 )THEN
            CALL GPLOT_R(XPOL(1),YPOL(1),3)
            CALL GPLOT_R(XPOL(2),YPOL(2),2)
            CALL GPLOT_R(XPOL(3),YPOL(3),2)
            CALL GPLOT_R(XPOL(4),YPOL(4),2)
          ELSE IF( IHATCH .GT. 0 )THEN
            CALL GPLOT_R(XPOL(1),YPOL(1),3)
            CALL GPLOT_R(XPOL(2),YPOL(2),2)
            CALL GPLOT_R(XPOL(3),YPOL(3),2)
            CALL GPLOT_R(XPOL(4),YPOL(4),2)
            DO II = 1, 4
              CALL GPLOT_R(XPOL(II),YPOL(II),-1)
              XPOL(II) = MAX(XLAXIS,MIN(XPOL(II),XUAXIS))
              YPOL(II) = MAX(YLAXIS,MIN(YPOL(II),YUAXIS))
            END DO
          ELSE
            DO II = 1, 4
              CALL GPLOT_R(XPOL(II),YPOL(II),-1)
              XPOL(II) = MAX(XLAXIS,MIN(XPOL(II),XUAXIS))
              YPOL(II) = MAX(YLAXIS,MIN(YPOL(II),YUAXIS))
            END DO
          END IF
          IF( Y(I).NE.0.0 )THEN
            IF( DITH )CALL DITHER(XPOL,YPOL,4,IDITHX,IDITHY,ERASE)
            IF( FILL )CALL HATCH_DRAW(XPOL,YPOL,4,IFILL)
          ENDIF
        END DO
      ELSE IF( IHISTYP .EQ. 3 )THEN  ! Vertical Histogram without tails
C                                      profile parallel to y-axis
        IF( MASK .LE. -3 )THEN
          SIZFAC = SIZPT(1)
          ICOLR = COLPT(1)
          ICOLR = MAX( 0, MIN( 11, ICOLR ) )
          IF( PTYPE .NE. 1. )THEN
            IF( (COLOURS(ICOLR,IMONITOR) .NE. ICOLR1) .OR.
     &          (COLOURS(ICOLR,IMONITOR2) .NE. ICOLR2) ) 
     &      CALL PLOT_COLOR(COLOURS(ICOLR,IMONITOR)
     &                     ,COLOURS(ICOLR,IMONITOR2))
          END IF
        ELSE IF( MASK .LE. -2 )THEN
          SIZFAC = SIZPT(1)
        END IF
        X0 = 0.0
        IF( NPT(1) .EQ. 1 )THEN
          CALL GPLOT_R(X0,Y(1),3)
          CALL GPLOT_R(X(1),Y(1),2)
          GO TO 900
        END IF
        FRSTP = .TRUE.
        Y1 = Y(1)
        Y2 = Y(2)
        IF( SIZFAC .LT. 0. )THEN
          DY = 1.0
          SIZFAC = -SIZFAC
        ELSE
          DY = 0.5*(Y2-Y1)
        END IF
        Y0 = Y1-DY*SIZFAC
        Y1 = Y1+DY*SIZFAC
        X1 = X(1)
        IF( Y0 .GE. YMAX )GO TO 900
        IF( Y1 .LT. YMIN )GO TO 30
        IF( Y0 .LT. YMIN )Y0 = YMIN
        IF( Y1 .GT. YMAX )Y1 = YMAX
        FRSTP = .FALSE.
        CALL GPLOT_R(X0,Y0,3)
        CALL GPLOT_R(X1,Y0,2)
        CALL GPLOT_R(X1,Y1,2)
        IF( FILL .OR. DITH )THEN
          XPOL(1) = X0
          YPOL(1) = Y0
          CALL GPLOT_R(XPOL(1),YPOL(1),-1)
          XPOL(2) = X1
          YPOL(2) = Y0
          CALL GPLOT_R(XPOL(2),YPOL(2),-1)
          XPOL(3) = X1
          YPOL(3) = Y1
          CALL GPLOT_R(XPOL(3),YPOL(3),-1)
          II = 3
        END IF
   30   Y2 = Y1
        DO I = 2, NPT(1)-1
          IF( CTRLC_FLAG )GO TO 999
          IF( MASK .LE. -3 )THEN
            SIZFAC = SIZPT(I)
            ICOLR = COLPT(I)
            ICOLR = MAX( 0, MIN( 11, ICOLR ) )
            IF( PTYPE .NE. 1. )THEN
              IF( (COLOURS(ICOLR,IMONITOR) .NE. ICOLR1) .OR.
     &            (COLOURS(ICOLR,IMONITOR2) .NE. ICOLR2) ) 
     &        CALL PLOT_COLOR(COLOURS(ICOLR,IMONITOR)
     &                       ,COLOURS(ICOLR,IMONITOR2))
            END IF
          ELSE IF( MASK .LE. -2 )THEN
            SIZFAC = SIZPT(I)
          END IF
          YIM1 = Y(I-1)
          YI = Y(I)
          YIP1 = Y(I+1)
          IF( SIZFAC .LT. 0. )THEN
            DYL = 1.0
            DYU = 1.0
            SIZFAC = -SIZFAC
          ELSE
            DYL = 0.5*(YI-YIM1)
            DYU = 0.5*(YIP1-YI)
          END IF
          Y0 = YI-DYL*SIZFAC
          Y1 = YI+DYU*SIZFAC
          XI = X(I)
          IF( Y0 .GE. YMAX )THEN
            CALL GPLOT_R(X0,Y2,2)
            IF( FILL .OR. DITH )THEN
              XPOL(II+1) = X0
              YPOL(II+1) = Y2
              CALL GPLOT_R(XPOL(II+1),YPOL(II+1),-1)
              II = II + 1
              IF( II .EQ. MXPT )THEN
                FILL = .FALSE.
                DITH = .FALSE.
                II = 0
              END IF
            END IF
            GO TO 38
          END IF
          IF( Y1 .LE. YMIN )GO TO 32
          IF( Y0 .LE. YMIN )THEN
            Y0 = YMIN
            IF( FRSTP )THEN
              CALL GPLOT_R(X0,Y0,3)
              IF( FILL .OR. DITH )THEN
                XPOL(II+1) = X0
                YPOL(II+1) = Y0
                CALL GPLOT_R(XPOL(II+1),YPOL(II+1),-1)
                II = II + 1
                IF( II .EQ. MXPT )THEN
                  FILL = .FALSE.
                  DITH = .FALSE.
                  II = 0
                END IF
              END IF
            END IF
          END IF
          IF( Y1 .GT. YMAX )Y1 = YMAX
          FRSTP = .FALSE.
          IF( ABS(Y2-Y0)/DELTAY .LT. 0.00001 )THEN
            CALL GPLOT_R(XI,Y0,2)
          ELSE
            CALL GPLOT_R(XI,Y0,3)
          END IF
          IF( FILL .OR. DITH )THEN
            XPOL(II+1) = XI
            YPOL(II+1) = Y0
            CALL GPLOT_R(XPOL(II+1),YPOL(II+1),-1)
            II = II + 1
            IF( II .EQ. MXPT )THEN
              FILL = .FALSE.
              DITH = .FALSE.
              II = 0
            END IF
          END IF
          CALL GPLOT_R(XI,Y1,2)
          IF( FILL .OR. DITH )THEN
            XPOL(II+1) = XI
            YPOL(II+1) = Y1
            CALL GPLOT_R(XPOL(II+1),YPOL(II+1),-1)
            II = II + 1
            IF( II .EQ. MXPT )THEN
              FILL = .FALSE.
              DITH = .FALSE.
              II = 0
            END IF
          END IF
   32     Y2 = Y1
        END DO
        I = NPT(1)
        IF( MASK .LE. -3 )THEN
          SIZFAC = SIZPT(I)
          ICOLR = COLPT(I)
          ICOLR = MAX( 0, MIN( 11, ICOLR ) )
          IF( PTYPE .NE. 1. )THEN
            IF( (COLOURS(ICOLR,IMONITOR) .NE. ICOLR1) .OR.
     &          (COLOURS(ICOLR,IMONITOR2) .NE. ICOLR2) ) 
     &      CALL PLOT_COLOR(COLOURS(ICOLR,IMONITOR)
     &                     ,COLOURS(ICOLR,IMONITOR2))
          END IF
        ELSE IF( MASK .LE. -2 )THEN
          SIZFAC = SIZPT(I)
        END IF
        YIM1 = Y(I-1)
        YI = Y(I)
        IF( SIZFAC .LT. 0. )THEN
          DY = 1.0
          SIZFAC = -SIZFAC
        ELSE
          DY = 0.5*(YI-YIM1)
        END IF
        Y0 = YI-DY*SIZFAC
        Y1 = YI+DY*SIZFAC
        XI = X(I)
        IF( Y0 .GE. YMAX )THEN
          CALL GPLOT_R(X0,Y2,2)
          IF( FILL .OR. DITH )THEN
            XPOL(II+1) = X0
            YPOL(II+1) = Y2
            CALL GPLOT_R(XPOL(II+1),YPOL(II+1),-1)
            II = II + 1
            IF( II .EQ. MXPT )THEN
              FILL = .FALSE.
              DITH = .FALSE.
              II = 0
            END IF
          END IF
          GO TO 38
        END IF
        IF( Y1 .LE. YMIN )GO TO 900
        IF( Y0 .LE. YMIN )THEN
          Y0 = YMIN
          IF( FRSTP )THEN
            CALL GPLOT_R(X0,Y0,3)
            IF( FILL .OR. DITH )THEN
              XPOL(II+1) = X0
              YPOL(II+1) = Y0
              CALL GPLOT_R(XPOL(II+1),YPOL(II+1),-1)
              II = II + 1
              IF( II .EQ. MXPT )THEN
                FILL = .FALSE.
                DITH = .FALSE.
                II = 0
              END IF
            END IF
          END IF
        END IF
        IF( Y1 .GT. YMAX )Y1 = YMAX
        IF( ABS(Y2-Y0)/DELTAY .LT. 0.00001 )THEN
          CALL GPLOT_R(XI,Y0,2)
        ELSE
          CALL GPLOT_R(XI,Y0,3)
        END IF
        IF( FILL .OR. DITH )THEN
          XPOL(II+1) = XI
          YPOL(II+1) = Y0
          CALL GPLOT_R(XPOL(II+1),YPOL(II+1),-1)
          II = II + 1
          IF( II .EQ. MXPT )THEN
            FILL = .FALSE.
            DITH = .FALSE.
            II = 0
          END IF
        END IF
        CALL GPLOT_R(XI,Y1,2)
        IF( FILL .OR. DITH )THEN
          XPOL(II+1) = XI
          YPOL(II+1) = Y1
          CALL GPLOT_R(XPOL(II+1),YPOL(II+1),-1)
          II = II + 1
          IF( II .EQ. MXPT )THEN
            FILL = .FALSE.
            DITH = .FALSE.
            II = 0
          END IF
        END IF
        CALL GPLOT_R(X0,Y1,2)
        IF( FILL .OR. DITH )THEN
          XPOL(II+1) = X0
          YPOL(II+1) = Y1
          CALL GPLOT_R(XPOL(II+1),YPOL(II+1),-1)
          II = II + 1
          IF( II .EQ. MXPT )THEN
            FILL = .FALSE.
            DITH = .FALSE.
            II = 0
          END IF
        END IF
   38   IF( II .GT. 0 )THEN
          IF( DITH )CALL DITHER(XPOL,YPOL,II,IDITHX,IDITHY,ERASE)
          IF( FILL )CALL HATCH_DRAW(XPOL,YPOL,II,IFILL)
        END IF
      ELSE IF( IHISTYP .EQ. 4 )THEN  ! Vertical histogram with tails
C                                      profile parallel to y-axis
        DO I = 1, NPT(1)
          IF( CTRLC_FLAG )GO TO 999
          IF( MASK .LE. -3 )THEN
            ICOLR     = COLPT(I)
            ICOLR     = MAX( 0, MIN( 11, ICOLR ) )
            IF( PTYPE .NE. 1. )THEN
              IF( (COLOURS(ICOLR,IMONITOR) .NE. ICOLR1) .OR.
     &            (COLOURS(ICOLR,IMONITOR2) .NE. ICOLR2) ) 
     &        CALL PLOT_COLOR(COLOURS(ICOLR,IMONITOR)
     &                       ,COLOURS(ICOLR,IMONITOR2))
            END IF
            SIZFAC    = SIZPT(I)
            IHATCH    = CHAR(I)
          ELSE IF( MASK .LE. -2 )THEN
            SIZFAC    = SIZPT(I)
            IHATCH    = CHAR(I)
          ELSE IF( MASK .LE. -1 )THEN
            IHATCH    = CHAR(I)
          END IF
          IHA = ABS(IHATCH)
          IF( IHA .GT. 10 )THEN
            FILL = .FALSE.
            DITH = .TRUE.
            IDITHX = IHA/10
            IDITHY = IHA - IDITHX*10
            ERASE = .FALSE.
            IF( IHATCH .LT. 0 )ERASE = .TRUE.
            IF( IDITHX .EQ. 0 )IDITHX = 1
            IF( IDITHY .EQ. 0 )IDITHY = 1
          ELSE
            IF( IHA .GT. 0 )THEN
              FILL  = .TRUE.
              DITH  = .FALSE.
              IFILL = IHA
            ELSE IF( IHA .EQ. 0 )THEN
              FILL = .FALSE.
              DITH = .FALSE.
              IF( ILNTPA .GT. 100 )THEN
                IF( ILNTPA .GE. 200 )THEN
                  DITH = .TRUE.
                  IDITHX = (ILNTPA-200)/10
                  IDITHY = (ILNTPA-200) - IDITHX*10
                  ERASE = .FALSE.
                  IF( LINTYP .LT. 0 )ERASE = .TRUE.
                  IF( IDITHX .EQ. 0 )IDITHX = 1
                  IF( IDITHY .EQ. 0 )IDITHY = 1
                ELSE
                  FILL  = .TRUE.
                  IFILL = ILNTPA - 100
                END IF
              END IF
            END IF
          END IF
          IF( NPT(1) .EQ. 1 )THEN
            CALL GPLOT_R(0.0,Y(1),3)
            CALL GPLOT_R(X(1),Y(1),2)
            GO TO 900
          END IF
          IF( SIZFAC .LT. 0. )THEN
            DYL    = 1.0
            DYU    = 1.0
            SIZFAC = -SIZFAC
          ELSE
            IF( I .EQ. 1 )THEN
              DYU = 0.5 * (Y(I+1) - Y(I))
              DYL = DYU
            ELSE IF( I .EQ. NPT(1) )THEN
              DYL = 0.5 * (Y(I) - Y(I-1))
              DYU = DYL
            ELSE
              DYL = 0.5 * (Y(I) - Y(I-1))
              DYU = 0.5 * (Y(I+1) - Y(I))
            END IF
          END IF
          XPOL(1) = 0.0
          YPOL(1) = Y(I) - DYL * SIZFAC
          XPOL(2) = X(I)
          YPOL(2) = Y(I) - DYL * SIZFAC
          XPOL(3) = X(I)
          YPOL(3) = Y(I) + DYU * SIZFAC
          XPOL(4) = 0.0
          YPOL(4) = Y(I) + DYU * SIZFAC
          IF( IHATCH .EQ. 0 )THEN
            CALL GPLOT_R(XPOL(1),YPOL(1),3)
            CALL GPLOT_R(XPOL(2),YPOL(2),2)
            CALL GPLOT_R(XPOL(3),YPOL(3),2)
            CALL GPLOT_R(XPOL(4),YPOL(4),2)
          ELSE IF( IHATCH .GT. 0 )THEN
            CALL GPLOT_R(XPOL(1),YPOL(1),3)
            CALL GPLOT_R(XPOL(2),YPOL(2),2)
            CALL GPLOT_R(XPOL(3),YPOL(3),2)
            CALL GPLOT_R(XPOL(4),YPOL(4),2)
            DO II = 1, 4
              CALL GPLOT_R(XPOL(II),YPOL(II),-1)
              XPOL(II) = MAX(XLAXIS,MIN(XPOL(II),XUAXIS))
              YPOL(II) = MAX(YLAXIS,MIN(YPOL(II),YUAXIS))
            END DO
          ELSE
            DO II = 1, 4
              CALL GPLOT_R(XPOL(II),YPOL(II),-1)
              XPOL(II) = MAX(XLAXIS,MIN(XPOL(II),XUAXIS))
              YPOL(II) = MAX(YLAXIS,MIN(YPOL(II),YUAXIS))
            END DO
          END IF
          IF( DITH )CALL DITHER(XPOL,YPOL,4,IDITHX,IDITHY,ERASE)
          IF( FILL )CALL HATCH_DRAW(XPOL,YPOL,4,IFILL)
        END DO
      ELSE                          ! Normal line graph (non-histogram)
        CHARL = GETLAB('CHAR')
        IF( MASK .EQ. 1 )THEN
          CHARI = ICHAR(CHARL(1:1)) * NINT(PMODE)
          IF( CHARI .EQ. -16 )GO TO 70
        END IF
        GO TO 90
70      DO 80 I = 1, NPT(1)
          IF( CTRLC_FLAG )GO TO 999
          CALL GPLT_SUB(X,Y,NPT,I,XI,YI
     &                 ,NERROR,XIEL,XIEU,YIEL,YIEU,CHARI)
          XPLOT = XI
          YPLOT = YI
          CALL GPLOT_R(XPLOT,YPLOT,-1,*80)
          CALL PLOT_R(XPLOT,YPLOT,20)
80      CONTINUE
        GO TO 900
90      NO_CONNECT = .TRUE.
        DO 100 I = 1, NPT(1)
          IF( CTRLC_FLAG )GO TO 999
          IF( MASK .LE. -4 )THEN
            SYMANG = ANGPT(I)
            IF( SYMANG .NE. SYMANG_OLD )THEN
              COSANG     = COS(SYMANG*DTOR)
              SINANG     = SIN(SYMANG*DTOR)
              SYMANG_OLD = SYMANG
            END IF
            SIZFAC = SIZPT(I)
            ICOLR  = COLPT(I)
            ICOLR  = MAX( 0, MIN( 11, ICOLR ) )
            CHARI  = CHAR(I) * NINT(PMODE)
          ELSE IF( MASK .LE. -3 )THEN
            SIZFAC = SIZPT(I)
            ICOLR  = COLPT(I)
            ICOLR  = MAX( 0, MIN( 11, ICOLR ) )
            CHARI  = CHAR(I) * NINT(PMODE)
          ELSE IF( MASK .LE. -2 )THEN
            SIZFAC = SIZPT(I)
            CHARI  = CHAR(I) * NINT(PMODE)
          ELSE IF( MASK .LE. -1 )THEN
            CHARI = CHAR(I) * NINT(PMODE)
          ELSE IF( MASK .EQ. 0 )THEN
            CHARI = 32                   ! blank
          ELSE IF( MASK .GT. 0 )THEN
            CHARI = ICHAR(CHARL(1:1)) * NINT(PMODE)
            IF( (MASK .GT. 1) .AND. (MOD(I,MASK) .EQ. 0) )
     &       CHARI = ICHAR(CHARL(2:2)) * NINT(PMODE)
          END IF
          CALL GPLT_SUB(X,Y,NPT,I,XI,YI
     &                 ,NERROR,XIEL,XIEU,YIEL,YIEU,CHARI)
          ICHARI = CHARI
          ACHARI = ABS(ICHARI)
          IF( (I .EQ. 1) .OR. (ICHARI .LT. 0) .OR. NO_CONNECT )THEN
            CALL GPLOT_R(XI,YI,3)
          ELSE
            IF( I .LT. NPT(1) )THEN
              CALL GPLOT_R(XI,YI,+2)
            ELSE
              CALL GPLOT_R(XI,YI,-2)
            END IF
          END IF
          IF( FILL .OR. DITH )THEN
            IF( I .GT. MXPT )THEN
              FILL = .FALSE.
              DITH = .FALSE.
            ELSE
              XPOL(I) = XI
              YPOL(I) = YI
              CALL GPLOT_R(XPOL(I),YPOL(I),-1)
              XPOL(I) = MAX(XLAXIS,MIN(XPOL(I),XUAXIS))
              YPOL(I) = MAX(YLAXIS,MIN(YPOL(I),YUAXIS))
            END IF
          END IF
          IF( ICHARI .EQ. -32 )THEN
            NO_CONNECT = .TRUE.
          ELSE
            NO_CONNECT = .FALSE.
          END IF
          XPLOT = XI
          YPLOT = YI
          CALL GPLOT_R(XPLOT,YPLOT,-1,*100)
          CHSZ2  = 0.5 * SYMSIZ * SIZFAC
          CHSZ3  = CHSZ2
          IF( (MASK .LE. -3.) .AND. (PTYPE .NE. 1.) .AND.
     &      ( (COLOURS(ICOLR,IMONITOR) .NE. ICOLR1) .OR.
     &        (COLOURS(ICOLR,IMONITOR2) .NE. ICOLR2) ) )
     &      CALL PLOT_COLOR(COLOURS(ICOLR,IMONITOR)
     &                     ,COLOURS(ICOLR,IMONITOR2))
          IF( (ACHARI .EQ. 0) .OR. (ACHARI .EQ. 32) )THEN
            CHSZ3 = 0.0
          ELSE IF( ACHARI .EQ. 16 )THEN
            CALL PLOT_R(XPLOT,YPLOT,20)
          ELSE IF( (ACHARI .LT. 32) .AND. (ACHARI .GT. 0) )THEN
            N = ACHARI
            CALL GPLOT_SYMBOL(XPLOT,YPLOT,SYMSIZ*SIZFAC,COSANG,SINANG,
     &                          NFILL,N)
          ELSE IF( (ACHARI .GT. 32) .AND. (ACHARI .LT. 97) )THEN
            CALL SYMBOL2(XPLOT,YPLOT,SYMSIZ*SIZFAC,ACHARI,SYMANG)
          END IF
          IF( .NOT.NO_CONNECT )THEN ! Draw error bars........
C                                     First the horizontal ones
            IF( (NERROR .EQ. 1) .OR. (NERROR .EQ. 3) .OR.
     &          (NERROR .EQ. 4) .OR. (NERROR .EQ. 6) )THEN
              YTEMP = YI
              CALL GPLOT_R(XIEL,YTEMP,-1)
              YTEMP = YI
              CALL GPLOT_R(XIEU,YTEMP,-1)
              XIEL = MAX(XLAXIS,XIEL)
              XIEU = MIN(XUAXIS,XIEU)
C                                                             Left side
              IF( XIEL .LT. MAX(XLAXIS,XPLOT-CHSZ3) )THEN
                CALL PLOT_R(XIEL,MIN(YUAXIS,YPLOT+CHSZ2),3)
                CALL PLOT_R(XIEL,MAX(YLAXIS,YPLOT-CHSZ2),2)
                CALL PLOT_R(XIEL,YPLOT,3)
                CALL PLOT_R(MAX(XLAXIS,XPLOT-CHSZ3),YPLOT,2)
              END IF
C                                                            Right side
              IF( MIN(XUAXIS,XPLOT+CHSZ3) .LT. XIEU )THEN
                CALL PLOT_R(MIN(XUAXIS,XPLOT+CHSZ3),YPLOT,3)
                CALL PLOT_R(XIEU,YPLOT,2)
                CALL PLOT_R(XIEU,MIN(YUAXIS,YPLOT+CHSZ2),3)
                CALL PLOT_R(XIEU,MAX(YLAXIS,YPLOT-CHSZ2),2)
              END IF
              CALL PLOT_R(XPLOT,YPLOT,3)
            END IF
C                                           Now the vertical error bars
            IF( (NERROR .EQ. 2) .OR. (NERROR .EQ. 3) .OR.
     &          (NERROR .EQ. 5) .OR. (NERROR .EQ. 6) )THEN
              XTEMP = XI
              CALL GPLOT_R(XTEMP,YIEL,-1)
              XTEMP = XI
              CALL GPLOT_R(XTEMP,YIEU,-1)
              YIEL = MAX(YLAXIS,YIEL)
              YIEU = MIN(YUAXIS,YIEU)
C                                                           Bottom half
              IF( YIEL .LT. MAX(YLAXIS,YPLOT-CHSZ3) )THEN
                CALL PLOT_R(MAX(XLAXIS,XPLOT-CHSZ2),YIEL,3)
                CALL PLOT_R(MIN(XUAXIS,XPLOT+CHSZ2),YIEL,2)
                CALL PLOT_R(XPLOT,YIEL,3)
                CALL PLOT_R(XPLOT,MAX(YLAXIS,YPLOT-CHSZ3),2)
              END IF
C                                                              Top half
              IF( MIN(YUAXIS,YPLOT+CHSZ3) .LT. YIEU )THEN
                CALL PLOT_R(XPLOT,MIN(YUAXIS,YPLOT+CHSZ3),3)
                CALL PLOT_R(XPLOT,YIEU,2)
                CALL PLOT_R(MAX(XLAXIS,XPLOT-CHSZ2),YIEU,3)
                CALL PLOT_R(MIN(XUAXIS,XPLOT+CHSZ2),YIEU,2)
              END IF
              CALL PLOT_R(XPLOT,YPLOT,3)
            END IF
          END IF
          IF( ICHARI .NE. -16 )THEN
            IF( (ACHARI .NE. 0) .AND. (ACHARI .NE. 32) )THEN
              IF( (XPREV .NE. XPLOT) .OR. (YPREV .NE. YPLOT) )
     &         CALL PLOT_R(XPLOT,YPLOT,3)
            END IF
          END IF
100     CONTINUE
        IF( FILL )CALL HATCH_DRAW(XPOL,YPOL,NPT(1),IFILL)
        IF( DITH )CALL DITHER(XPOL,YPOL,NPT(1),IDITHX,IDITHY,ERASE)
      END IF
900   CALL SETNAM('ERRBAR',0.)
      CALLED_FROM_GPLOT = .FALSE.
      RETURN
999   CALL SETNAM('ERRBAR',0.)
      CALLED_FROM_GPLOT = .FALSE.
      RETURN 1
      END
C
      SUBROUTINE GPLT_SUB(X,Y,NPT,I,XI,YI,NERROR,XIEL,XIEU,YIEL,YIEU
     &                   ,CHARI)
      INTEGER*4 NPT(2)
      BYTE      CHARI
      REAL*4    Y(1), X(1)
CCC
      IF( I .EQ. 1 )THEN
        PMODE  = GETNAM('PMODE')
        XMIN   = GETNAM('XMIN')
        XMAX   = GETNAM('XMAX')
        YMIN   = GETNAM('YMIN')
        YMAX   = GETNAM('YMAX')
        XLOG   = ABS(GETNAM('XLOG'))
        YLOG   = ABS(GETNAM('YLOG'))
      END IF
      IF( ((YLOG.GT.1.) .AND. (Y(I).LE.0.)) .OR.
     &    ((XLOG.GT.1.) .AND. (X(I).LE.0.))  )CHARI = 32*NINT(PMODE)
      XI = X(I)
      YI = Y(I)
      IF( NERROR .EQ. 0 )RETURN
      IF( (NERROR .EQ. 1) .OR. (NERROR .EQ. 3) )THEN
        IF( XMAX .LT. XMIN )THEN
          XIEL = XI + X(NPT(2)+I)
          XIEU = XI - X(NPT(2)+I)
        ELSE
          XIEL = XI - X(NPT(2)+I)
          XIEU = XI + X(NPT(2)+I)
        END IF
      END IF
      IF( (NERROR .EQ. 4) .OR. (NERROR .EQ. 6) )THEN
        IF( XMAX .LT. XMIN )THEN
          XIEL = XI + X(NPT(2)+I)
          XIEU = XI - X(2*NPT(2)+I)
        ELSE
          XIEL = XI - X(NPT(2)+I)
          XIEU = XI + X(2*NPT(2)+I)
        END IF
      END IF
      IF( (NERROR .EQ. 2) .OR. (NERROR .EQ. 3) )THEN
        IF( YMAX .LT. YMIN )THEN
          YIEL = YI + Y(NPT(2)+I)
          YIEU = YI - Y(NPT(2)+I)
        ELSE
          YIEL = YI - Y(NPT(2)+I)
          YIEU = YI + Y(NPT(2)+I)
        END IF
      END IF
      IF( (NERROR .EQ. 5) .OR. (NERROR .EQ. 6) )THEN
        IF( YMAX .LT. YMIN )THEN
          YIEL = YI + Y(NPT(2)+I)
          YIEU = YI - Y(2*NPT(2)+I)
        ELSE
          YIEL = YI - Y(NPT(2)+I)
          YIEU = YI + Y(2*NPT(2)+I)
        END IF
      END IF
      RETURN
      END
