      SUBROUTINE LEFT_JUSTIFY(STRING)
C======================================================================
C==   Purpose:  Left justify a character string, padding to the      ==
C==             right with blanks.                                   ==
C==								     ==
C==   reqd. routines - NONE 					     ==
C==                                                                  ==
C==   Written by Alan Carruthers, U.B.C. TRIUMF, July 1, 1982        ==
C==                                                                  ==
C==   Input  Parameters:  STRING   (CHARACTER*(*))                   ==
C==                                                                  ==
C==   Output Parameters:  STRING   (CHARACTER*(*))                   ==
C======================================================================
      CHARACTER*(*) STRING
C
      LENGTH = LEN(STRING)
      IF(LENGTH .LE. 0) RETURN   ! return if string is null
C
C======================================================================
C==   Scan for first non-blank character                             ==
C======================================================================
      DO 50 I = 1,LENGTH
         IF(STRING(I:I) .NE. ' ') GO TO 80
 50   CONTINUE
      RETURN   ! string is entirely blank
 80   IF(I .EQ. 1) RETURN   ! return if no leading blanks
C
      I = I - 1   ! I = number of leading blanks
C
C======================================================================
C==   There are I leading blanks.  Shift string left by I spaces.    ==
C======================================================================
      DO 100 J = 1,LENGTH - I
         STRING(J:J) = STRING(J+I:J+I)
 100  CONTINUE
C
C======================================================================
C==   Place I blanks at end of string                                ==
C======================================================================
      DO 120 J = LENGTH-I+1,LENGTH
         STRING(J:J) = ' '
 120  CONTINUE
      RETURN
      END
