      SUBROUTINE PAUSE2(MESS,ILINE,ICOLM,KEYDEC,KEYRET)
C***********************************************************************
C                                                                      *
C    Reqd. [KOST.LIBRARY] Routines - NARGS.MAR, TRANSMODE, READKEY     *
C                                                                      *
C      This routine will pause until a key is typed on the terminal.   *
C    If KEYDEC is included in the call to PAUSE2, then the RETURN is   *
C    taken from PAUSE2 only if the key corresponding to ICHAR(KEYDEC)  *
C    is typed.  No RETURN is necessary.  If KEYDEC is not in the call  *
C    to PAUSE2, then any key will cause a RETURN.                      *
C      Also, if KEYDEC is -1 then any key will cause a RETURN.         *
C    If KEYRET is included in the call, then the key corresponding to  *
C    ICHAR(KEYRET) is the key that was typed.                          *
C      If ICOLM is included in the call, then it is the column number  *
C    at which the prompt is to be displayed.  If it is not included,   *
C    then it defaults to 36.  Similarly, ILINE is the line number at   *
C    which the prompt will be displayed and it will default to 24 if   *
C    not included.                                                     *
C      Finally, if MESS is .NE. ' ', then it is the prompt.  If MESS   *
C    is .EQ. ' ', then prompt defaults to 'Pausing...'.                *
C                                                                      *
C    INPUT:         MESS  CHARACTER*132                                *
C                   ILINE INTEGER*4   0 < ILINE < 25                   *
C                   ICOLM INTEGER*4   0 < ICOLM < 134                  *
C                   KEYDEC INTEGER*4                                   *
C    OUTPUT:        KEYRET INTEGER*4                                   *
C                                                                      *
C    Examples:                                                         *
C     CALL PAUSE2('Pausing (type any key to continue) ...',1,1,-1,IRET)*
C               will cause the message                                 *
C               "Pausing (type any key to continue) ..." to be         *
C               displayed at line 1 and column 1.  Any key will cause  *
C               a RETURN, and the key that was typed will be returned  *
C               in IRET.  The character is CHAR(IRET).                 *
C           CALL PAUSE2('Pausing (type key C to continue) ...',1,1,67) *
C               will cause the message                                 *
C               "Pausing (type key C to continue) ..." to be displayed *
C               at line 1 and column 1.  Only key C will cause a       *
C               RETURN.                                                *
C           CALL PAUSE2('...',4,10)                                    *
C               will cause the message "..." to be displayed at        *
C               line 4 and column 10. Any key that is typed will       *
C               cause a RETURN.                                        *
C           CALL PAUSE2('Message',2)                                   *
C               will cause the message "Message" to be displayed at    *
C               line 2 and column 36.  Any key will cause a RETURN.    *
C           CALL PAUSE2('Message')                                     *
C               will cause the message "Message" to be displayed at    *
C               line 24 and column 36.  Any key will cause a RETURN.   *
C           CALL PAUSE2(' ')                                           *
C               will cause the message "Pausing..." to be displayed at *
C               line 24 and column 36.  Any key will cause a RETURN.   *
C                                                                      *
C                                      Author:  Joe Chuma              *
C                                               June 29, 1984          *
C                                               TRIUMF                 *
C                                                                      *
C  Modified by J.Chuma, 20Mar97 for g77
C    can't have intrinsic functions inside a PARAMETER statement
C    also, can't have variable formats
C
      CHARACTER*(*) MESS
      CHARACTER*1   ALTKEY, READ_KEY, KEY_IN, ESC
      CHARACTER*255 PROMPT

      INTEGER IMONITOR, IOUTM
      COMMON /PLOTMONITOR/ IMONITOR,IOUTM

      INTEGER IOUT_UNIT
      DATA IOUT_UNIT / 6 /
CCC
#ifdef VMS
      ESC = CHAR(27)
      NPARS  = NARGS(DUM)
      PROMPT = ' Pausing...'
      ILIN   = 24
      ICOL   = 36
      KEYD   = -1
      IF( NPARS .GE. 1 )THEN
        LMESS  = LEN(MESS)
        IF( LMESS .NE. 0 )THEN
          IF( MESS(1:LMESS) .NE. ' ' )THEN
            PROMPT = ' '
            PROMPT = ' '//MESS(1:LMESS)
          END IF
        END IF
      END IF
      IF(NPARS .GE. 2)  ILIN = MIN(MAX(1,ILINE),24)
      IF(NPARS .GE. 3)  ICOL = MIN(MAX(1,ICOLM),132)
      IF(NPARS .GE. 4)  KEYD = KEYDEC
      NP = LENSIG(PROMPT)
      IL = IFIX(ALOG10(FLOAT(ILIN))) + 1
      IC = IFIX(ALOG10(FLOAT(ICOL))) + 1
C                                                                      *
C    Position the cursor                                               *
C                                                                      *
      IF(IMONITOR .GT. 0)CALL TRANSPARENT_MODE(0)
 10   WRITE(IOUT_UNIT,20)ESC,ILIN,ICOL
 20   FORMAT('+',A1,'[',I<IL>,';',I<IC>,'f',$)
C                                                                      *
C    Erase that line                                                   *
C                                                                      *
      WRITE(IOUT_UNIT,30)ESC
 30   FORMAT('+',A1,'[2K')

C   Reposition the cursor

      WRITE(IOUT_UNIT,20)ESC,ILIN,ICOL
   40 KEY_IN = READ_KEY('KEYPAD PROMPT',PROMPT(1:NP),ALTKEY,IDUM)
      IF(NPARS .GE. 5)KEYRET = ICHAR(KEY_IN)
      IF( KEYD .GE. 0 )THEN
        IF(ICHAR(KEY_IN) .NE. KEYD)GO TO 10
      END IF
#else
#ifdef g77
      NPARS  = NARGS(DUM)
      PROMPT = ' Pausing...'
      IF( NPARS .GE. 1 )THEN
        LMESS  = LEN(MESS)
        IF( LMESS .NE. 0 )THEN
          IF( MESS(1:LMESS) .NE. ' ' )THEN
            PROMPT = ' '
            PROMPT = ' '//MESS(1:LMESS)
          END IF
        END IF
      END IF
      IF( NPARS .GE. 4 )KEYD = KEYDEC
      NP = LENSIG(PROMPT)
   40 KEY_IN = READ_KEY('KEYPAD PROMPT',PROMPT(1:NP),ALTKEY,IDUM)
      IF(NPARS .GE. 5)KEYRET = ICHAR(KEY_IN)
      IF( KEYD .GE. 0 )THEN
        IF( ICHAR(KEY_IN) .NE. KEYD )GO TO 40
      END IF
      KEY_IN = READ_KEY('RESET',' ',ALTKEY,0)
#elif gfortran
      NPARS  = NARGS(DUM)
      PROMPT = ' Pausing...'
      IF( NPARS .GE. 1 )THEN
        LMESS  = LEN(MESS)
        IF( LMESS .NE. 0 )THEN
          IF( MESS(1:LMESS) .NE. ' ' )THEN
            PROMPT = ' '
            PROMPT = ' '//MESS(1:LMESS)
          END IF
        END IF
      END IF
      IF( NPARS .GE. 4 )KEYD = KEYDEC
      NP = LENSIG(PROMPT)
   40 KEY_IN = READ_KEY('KEYPAD PROMPT',PROMPT(1:NP),ALTKEY,IDUM)
      IF(NPARS .GE. 5)KEYRET = ICHAR(KEY_IN)
      IF( KEYD .GE. 0 )THEN
        IF( ICHAR(KEY_IN) .NE. KEYD )GO TO 40
      END IF
      KEY_IN = READ_KEY('RESET',' ',ALTKEY,0)
#else
      ESC = CHAR(27)
      NPARS  = NARGS(DUM)
      PROMPT = ' Pausing...'
      ILIN   = 24
      ICOL   = 36
      KEYD   = -1
      IF( NPARS .GE. 1 )THEN
        LMESS  = LEN(MESS)
        IF( LMESS .NE. 0 )THEN
          IF( MESS(1:LMESS) .NE. ' ' )THEN
            PROMPT = ' '
            PROMPT = ' '//MESS(1:LMESS)
          END IF
        END IF
      END IF
      IF(NPARS .GE. 2)  ILIN = MIN(MAX(1,ILINE),24)
      IF(NPARS .GE. 3)  ICOL = MIN(MAX(1,ICOLM),132)
      IF(NPARS .GE. 4)  KEYD = KEYDEC
      NP = LENSIG(PROMPT)
      IL = IFIX(ALOG10(FLOAT(ILIN))) + 1
      IC = IFIX(ALOG10(FLOAT(ICOL))) + 1
C                                                                      *
C    Position the cursor                                               *
C                                                                      *
      IF(IMONITOR .GT. 0)CALL TRANSPARENT_MODE(0)
 10   WRITE(IOUT_UNIT,20)ESC,ILIN,ICOL
 20   FORMAT(A1,'[',I<IL>,';',I<IC>,'f',$)
C                                                                      *
C    Erase that line                                                   *
C                                                                      *
      WRITE(IOUT_UNIT,30)ESC
 30   FORMAT(A1,'[2K')

C   Reposition the cursor

      WRITE(IOUT_UNIT,20)ESC,ILIN,ICOL
   40 KEY_IN = READ_KEY('KEYPAD PROMPT',PROMPT(1:NP),ALTKEY,IDUM)
      IF(NPARS .GE. 5)KEYRET = ICHAR(KEY_IN)
      IF( KEYD .GE. 0 )THEN
        IF(ICHAR(KEY_IN) .NE. KEYD)GO TO 10
      END IF
      KEY_IN = READ_KEY('RESET',' ',ALTKEY,0)
#endif
#endif
      RETURN
      END
