      SUBROUTINE PLOT_R(X,Y,IPEN)
C=================================================================
C==                                                             ==
C==   PLOT_R: Plot Driver for various devices defined by the    ==
C==        subroutine PLOT_DEVICE2(IDEVICE,IOUTM,IOUTM2), where ==
C==                                                             ==
C==                                                             ==
C==   IDEVICE: Device type. The default device type if          ==
C==            PLOT_DEVICE2 is not called is device 1.          ==
C==                                                             ==
C==            X, Y coordinates are user (= world) coordinates. ==
C==                                                             ==
C==        |IDEVICE| = 1: VT640 or Tektronix 4010/12 terminals. ==
C==                       0 <= X <= 639; 0 <= Y <= 479.         ==
C==                       On the hardcopy: X is horizontal.     ==
C==        |IDEVICE| = 2: VT640 or Tektronix 4010/12 terminals. ==
C==                       0 <= X <= 1023; 0 <= Y <= 779.        ==
C==                       On the hardcopy: X is vertical.       ==
C==        |IDEVICE| = 3: VT640 or Tektronix 4010/12 terminals. ==
C==                       0 <= X <= 2047; 0 <= Y <= 785.        ==
C==                       On the hardcopy: X is vertical.       ==
C==        |IDEVICE| = 4: VS11 emulating a VT640 or Tek 4010.   ==
C==                       0 <= X <= 639; 0 <= Y <= 479.         ==
C==                       On the hardcopy: X is horizontal.     ==
C==        |IDEVICE| = 5: VT640 or Tektronix 4010/12 terminals. ==
C==                       0 <= X <= 639; 0 <= Y <= 479.         ==
C==                       On the hardcopy: X is horizontal.     ==
C==                       Plus a ZETA plot ***********          ==
C==        |IDEVICE| = 6: VT640 or Tektronix 4010/12 terminals. ==
C==                       0 <= X <= 1023; 0 <= Y <= 779.        ==
C==                       On the hardcopy: X is vertical.       ==
C==                       Plus a ZETA plot ***********          ==
C==        |IDEVICE| = 7: VT640 or Tektronix 4010/12 terminals. ==
C==                       0 <= X <= 2047; 0 <= Y <= 785.        ==
C==                       On the hardcopy: X is vertical.       ==
C==                       Plus a ZETA plot ***********          ==
C==        |IDEVICE| = 8: VS11 emulating a VT640 or Tek 4010.   ==
C==                       0 <= X <= 639; 0 <= Y <= 479.         ==
C==                       On the hardcopy: X is horizontal.     ==
C==                       Plus a ZETA plot ***********          ==
C==         IDEVICE  = 0: Hardcopy only. X is vertical.         ==
C==                       0 <= X <= 2047; 0 <= Y <= 785.        ==
C==                                                             ==
C==        If IDEVICE is positive then a screen plot is produced==
C==        and a hardcopy which is a bit map image of the screen==
C==        in printronix format (6 bits per byte) is also       ==
C==        produced.                                            ==
C==                                                             ==
C==        If IDEVICE is zero or negative then only the hardcopy==
C==        bit map is produced.                                 ==
C==                                                             ==
C==                                                             ==
C==   IOUTM:  Output unit for the screen plot.                  ==
C==   IOUTM2: Output unit for second device (ZETA plotter).     ==
C==                                                             ==
C==                                                             ==
C==   Defaults:                                                 ==
C==   --------                                                  ==
C==                                                             ==
C==   If PLOT_DEVICE2 is not called, the device type defaults   ==
C==   to 1, and plotting output is sent to logical unit 6.      ==
C==   No output is sent to a second device.                     ==
C==                                                             ==
C==                                                             ==
C==        For more general applications, such as defining the  ==
C==        hardcopy viewport anywhere on the printronix page with
C==        arbitrary scaling of the plot coordinates (X,Y) and  ==
C==        the ability to monitor any window of the printronix  ==
C==        page anywhere on the monitor screen, see the         ==
C==        subroutines "HARDCOPY_RANGE", "MONITOR_RANGE" and    ==
C==        "MONITOR_RANGE2" in this plot_driver package.        ==
C==                                                             ==
C==        "PRINT_HARDCOPY(IOUTH)" prints the hardcopy plot in  ==
C==        printronix format on the output unit IOUTH. If IOUTH ==
C==        is negative or equal to 9, then the hardcopy plot is ==
C==        printed immediately on the printronix (LPA0: by default)
C==        via unit "ABS(IOUTH)".                               ==
C==                                                             ==
C==        (X,Y) (R*4) are the plot (user or world) coordinates ==
C==        to which the pen is to be moved either up (IPEN=3) or==
C==        down (IPEN=2). The plot coordinates (X,Y) can        ==
C==        have any value positive or negative, but are clipped ==
C==        outside the plot windows:                            ==
C==        0 <= X <= 2047, 0 <= Y <= 785 for IDEVICE = 0;       ==
C==        0 <= X <=  639, 0 <= Y <= 479 for IDEVICE = 1,4,5,8; ==
C==        0 <= X <= 1023, 0 <= Y <= 779 for IDEVICE = 2,6;     ==
C==        0 <= X <= 2047, 0 <= Y <= 785 for IDEVICE = 3,7;     ==
C==                                                             ==
C==        The values of IPEN (I*4) are defined as follows:     ==
C==                                                             ==
C==        IPEN =   0: Clear the plot.                          ==
C==                                                             ==
C==        IPEN =   1: Use the previous value of IPEN.          ==
C==                                                             ==
C==        IPEN =   2: Plot with the pen down.                  ==
C==                                                             ==
C==        IPEN =   3: Plot with the pen up.                    ==
C==                                                             ==
C==        IPEN =   4: Same as IPEN = 2 (pen down).             ==
C==                                                             ==
C==        IPEN =  20: Point plotting mode. Plot a point at     ==
C==                    (X,Y).                                   ==
C==                                                             ==
C==        IPEN =  99: Ignore (X,Y) and flush out the           ==
C==                    remainder of the plot buffer to the      ==
C==                    terminal screen.                         ==
C==                    This 70 character buffer is used to      ==
C==                    temporarily store the plot characters    ==
C==                    which are sent to the terminal.          ==
C==                    The plot buffer is initialized but the   ==
C==                    plot is not cleared. The next call to    ==
C==                    PLOT_R will then continue the plot.      ==
C==                    This value of IPEN is only applicable if ==
C==                    one is plotting to the screen in buffer  ==
C==                    mode(*). If one is plotting to the screen==
C==                    in direct mode(*) or plotting only to a  ==
C==                    hardcopy (IDEVICE = 0) then this value of==
C==                    IPEN is ignored.                         ==
C==                                                             ==
C==        IPEN = 999: Ignore (X,Y) and end the plot by         ==
C==                    flushing out the remainder of the plot   ==
C==                    buffer (if plotting to the screen in     ==
C==                    buffer mode(*)). The next call to PLOT_R ==
C==                    will then clear the hardcopy and screen  ==
C==                    and initialize the plot buffer, before   ==
C==                    plotting.                                ==
C==                                                             ==
C==   (*) footnote: When plotting on the screen there are two   ==
C==       modes: buffer mode (IMODE = 1) and direct mode        ==
C==       (IMODE = 2). Buffer mode is faster because the plot   ==
C==       characters which are to be printed on the screen are  ==
C==       first accumulated in a buffer array of 70 characters, ==
C==       and then printed whenever the buffer is full. Direct  ==
C==       mode allows one to have the plot characters printed   ==
C==       immediately to the screen as soon as PLOT_R is called,==
C==       but is slower because there is more I/O involved.     ==
C==       To switch between the modes use subroutine:           ==
C==       "PLOT_MODE(IMODE)" for monitor1 and "PLOT_MODE2" for  ==
C==       monitor2. The default mode is buffer mode.            ==
C==                                                             ==
C==   Written by Arthur Haynes, TRIUMF U.B.C., July 6, 1981.    ==
C==                                                             ==
C==   Input  parameters: X,Y (R*4); IPEN (I*4).                 ==
C==                                                             ==
C==   Common Blocks internal to the plot driver package:        ==
C==                                                             ==
C==   /PLOTMONITOR/: IMONITOR,IOUTM (I*4).                      ==
C==    IMONITOR: type of monitor terminal for monitoring the    ==
C==              hardcopy plot. (Default: 1).                   ==
C==              IMONITOR = 0: no monitor terminal.             ==
C==              IMONITOR = 1: VT640 terminal.                  ==
C==              IMONITOR = 2: Tektronix 4010/12 terminals.     ==
C==              IMONITOR = 3: not used                         ==
C==              IMONITOR = 4: ZETA                             ==
C==              IMONITOR = 5: HP                               ==
C==              IMONITOR = 6: CIT-467                          ==
C                IMONITOR = 7: Tektronix 4107
C                IMONITOR = 8: VT241
C==    IOUTM   : output unit for the monitor plot. (Default: 6) ==
C==                                                             ==
C==   /PLOTMONITOR2/  -- for monitor2; analogous to /PLOTMONITOR/ 
C==                                                             ==
C==   /PLOT_CLEAR/: CLEAR (LOGICAL).                            ==
C==    CLEAR : logical flag which if .TRUE. tells PLOT_R to     ==
C==            clear the monitor screen and hardcopy bitmap     ==
C==            before plotting any points. (Initially: .TRUE.)  ==
C==                                                             ==
C==   /HARDCOPY_RANGE/ XMINHP,XMAXHP,YMINHP,YMAXHP,IORIENTH     ==
C==    XMINHP  : minimum x-coordinate of the plot window in     ==
C==              the plot coordinate system. (Default: 0.)      ==
C==    XMAXHP  : maximum x-coordinate of the plot window in     ==
C==              the plot coordinate system. (Default: 639.)    ==
C==    YMINHP  : minimum y-coordinate of the plot window in     ==
C==              the plot coordinate system. (Default: 0.)      ==
C==    YMAXHP  : maximum y-coordinate of the plot window in     ==
C==              the plot coordinate system. (Default: 479.)    ==
C==              Note: there are four coordinate systems in     ==
C==              this package of subroutines:                   ==
C==              1) The plot (user or world) coordinate system: ==
C==                 XMINHP <= X <= XMAXHP; YMINHP <= Y <= YMAXHP==
C==                 This system is what is used in calling      ==
C==                 PLOT_R(X,Y,IPEN).
C==              2) The hardcopy coordinate system:             ==
C==                 0 <= XH <= 2047; 0 <= YH <= 785.            ==
C==              3) The monitor coordinate system:              ==
C==                 0 <= XM <= XMAXMSIZE; 0 <= YM <= YMAXMSIZE. ==
C==              4) The monitor2 coordinate system:             ==
C==                 0 <= XM2 <= XMAXMSIZE2; 0 <= YM2 <= YMAXMSIZE2.
C==                                                             ==
C==    IORIENTH: orientation of the plot coordinate system in   ==
C==              the hardcopy viewport (Default: -1)            ==
C==              IORIENTH =  1: the x-axis runs vertically down ==
C==                             the printronix page and the     ==
C==                             y-axis runs horizontally across ==
C==                             the page.                       ==
C==              IORIENTH =  0: no hardcopy is to be done.      ==
C==              IORIENTH = -1: the x-axis runs horizontally    ==
C==                             across the printronix page and  ==
C==                             the y-axis runs vertically up   ==
C==                             the page.                       ==
C==                                                             ==
C==   /PLOT_PREVIOUS/: XP,YP,IPENP (I*4).                       ==
C==    XP   : x-coordinate of previous point plotted by PLOT_R. ==
C==           (Initially: 0.)                                   ==
C==    YP   : y-coordinate of previous point plotted by PLOT_R. ==
C==           (Initially: 0.)                                   ==
C==    IPENP: pen setting of previous point plotted by PLOT_R.  ==
C==           (Initially: 0)                                    ==
C==           (note the previous point (XP,YP) may be inside    ==
C==           or outside the plot or hardcopy windows.          ==
C==                                                             ==
C==   /PLOT_BUFFER/: INDEX,IMODE (I*4); BUFFER(78) (L*1).       ==
C==    INDEX : number of characters in the plot buffer array.   ==
C==            (Initially: 0).                                  ==
C==    IMODE : plotting mode on the screen (see footnote above).==
C==            (Default: 1).                                    ==
C==    BUFFER: 70 character plot buffer for the screen.         ==
C==                                                             ==
C==   /PLOT_BUFFER2/  -- for monitor2; analogous to /PLOT_BUFFER/
C==                                                             ==
C==   /PLOT_HARDCOPY/: XLAST,YLAST,N1,N2 (I*4);                 ==
C==                    HARDCOPY(131,2048) (L*1).                ==
C==    XLAST: x-coordinate (plot units) of the last pen position==
C==           in the plot window. (Initially: 0.)               ==
C==    YLAST: y-coordinate (plot units) of the last pen position==
C==           in the plot window. (Initially: 0.)               ==
C==           (note: the point (XLAST,YLAST) is always within   ==
C==            the dimensions of the plot window (unlike        ==
C==            the point (XP,YP)).                              ==
C==    N1    : number of horizontal bytes in the hardcopy bit   ==
C==            map, i.e. in the 1'st dimension of the hardcopy  ==
C==            array "HARDCOPY(131,2048)". (N1 = 131)           ==
C==    N2    : number of vertical dot lines in the hardcopy bit ==
C==            map, i.e. in the 2'nd dimension of the hardcopy  ==
C==            array "HARDCOPY(131,2048)". (N2 = 2048)          ==
C==    HARDCOPY: hardcopy bit map which consists of N2 dot lines==
C==              with N1 bytes to a line. The lower 6-bits of   ==
C==              each byte form 6 printronix dots. A dot is     ==
C==              black/white or on/off if a bit is one/zero.    ==
C==              The least significant bit of the first byte of ==
C==              the hardcopy array: HARDCOPY(1,1) is plotted   ==
C==              at the upper left hand corner of the printer   ==
C==              page. The most significant bit of the last byte==
C==              of the hardcopy array: HARDCOPY(N1,N2) is      ==
C==              plotted at the lower right hand corner of the  ==
C==              printer page.                                  ==
C==                                                             ==
C==   /PLOT_INPUT_UNIT/  IINS (I*4).                            ==
C==    IINS:  Input unit for the crosshair coordinates to be    ==
C==           read from the screen.                             ==
C==                                                             ==
C  Modified April 3, 1984 by F.W. Jones to allow output to        C
C  EDGR drawing files.  Modified Sept 27/84 to encode colour      C
C  and line type.                                                 C
C=================================================================C
      COMMON /PLOT_CLEAR/ CLEAR
      LOGICAL CLEAR
      COMMON /PLOT_PREVIOUS/ XP,YP,IPENP
      COMMON /HARDCOPYRANGE/ XMINHP,XMAXHP,YMINHP,YMAXHP,IORIENTH
      COMMON /PLOT_CLEAR_A/ CLEAR1, CLEAR2, CLEARH, CLEARUNC
      LOGICAL CLEAR1, CLEAR2, CLEARH, CLEARUNC
      COMMON /PLOTMONITOR/ IMONITOR, IOUTM
      COMMON /PLOTMONITOR2/ IMONITOR2, IOUTM2
C
C   PL_CLEARER added April 16, 1991
C   Added to CLEAR_PLOT and PLOT_R to tell when CLEAR_PLOT has been
C   called.  Set true in CLEAR_PLOT and false in PLOT_R
C
      COMMON /PLOT_CLEARED/PL_CLEAR_M, PL_CLEAR_M2, PL_CLEARER
      LOGICAL PL_CLEAR_M, PL_CLEAR_M2, PL_CLEARER

C Graphics Editor parameters
      COMMON/CDWG/DWGON,DWGTXT,LDWG,LDWT,IRECG,IRECT,STROKE
      LOGICAL DWGON,DWGTXT,STROKE

      REAL XDRAW(2),YDRAW(2)

      IPENC=IPEN                  ! IPENC is the current pen setting.
      IF(IPENC.EQ.1)IPENC=IPENP   ! IPENP is the previous pen setting.
      IF(IPENC.EQ.4)IPENC=2       ! IPENC = 4 is usually dashed.
                                  ! In this case we treat it as
                                  ! undashed.

      IF(CLEAR)THEN
         CALL CLEAR_PLOT    ! Initialize graphics and clear plot.
      ELSE
         CLEARUNC = .FALSE.  !CLEARUNC is a flag that when .TRUE.
C                             tells CLEAR_PLOT to clear monitors 1 and 2
C                             (if active) and the hardcopy bitmap
C                             (if active) regardless of the values of
C                             CLEAR1, CLEAR2 or CLEARH.
C                             CLEAR1, CLEAR2 and CLEARH are flags that
C                             if .TRUE. indicate that the respective
C                             monitor or hardcopy bitmap has been
C                             cleared since the start of program
C                             execution or since the last plot was
C                             terminated, whichever is more recent.
         IF(((IMONITOR .NE. 0) .AND. (.NOT. CLEAR1)) .OR.
     >      ((IMONITOR2 .NE. 0) .AND. (.NOT. CLEAR2)) .OR.
     >      ((IORIENTH .NE. 0) .AND. (.NOT. CLEARH)))
     >      CALL CLEAR_PLOT
         CLEARUNC = .TRUE.
      END IF
      PL_CLEARER = .FALSE.

      IF(IPENC.NE.3)GO TO 100     ! Check IPENC.
C=================================================================
C==   IPENC = 3: Move with pen up to (X,Y).                     ==
C=================================================================
      IF(DWGON.AND..NOT.DWGTXT)CALL PUT_DWG(X,Y,IPENC,0)
      XP=X ! Set previous coordinates to new coordinates.
      YP=Y
      IPENP=IPENC
      IF((X-XMINHP)*(XMAXHP-X).GE.0..AND.
     *   (Y-YMINHP)*(YMAXHP-Y).GE.0.)
     *   CALL PEN_UP(X,Y) ! If (X,Y) is in the hardcopy window,
                          ! move to it.
      RETURN

100   IF(IPENC.NE.2)GO TO 200 ! Check IPENC.
C=================================================================
C==   IPENC = 2: Move with pen down to (X,Y).                   ==
C==   Window-clip the line segment: (XP,YP)-->(X,Y).            ==
C=================================================================
      IF(DWGON.AND..NOT.DWGTXT)CALL PUT_DWG(X,Y,IPENC,0)
C
C   Modified Apr 24/91 C.J.K
C
      NDRAW=1
      XDRAW(1)=X
      YDRAW(1)=Y
      IF(X  .GE. XMINHP  .AND.
     &   XP .GE. XMINHP  .AND.
     &   X  .LE. XMAXHP  .AND.
     &   XP .LE. XMAXHP  .AND.
     &   Y  .GE. YMINHP  .AND.
     &   YP .GE. YMINHP  .AND.
     &   Y  .LE. YMAXHP  .AND.
     &   YP .LE. YMAXHP      ) GO TO 21
      CALL WINDOW_CLIP(XP,YP,X,Y,XMINHP,XMAXHP,YMINHP,YMAXHP,
     *                 XDRAW,YDRAW,NDRAW)
      IF(NDRAW.NE.1)GO TO 110
C=================================================================
C==   NDRAW = 1: (XP,YP) is in the plot window.                 ==
C=================================================================
  21  XP=X     ! Set previous coordinates to new coordinates.
      YP=Y
      IPENP=IPENC
      CALL PEN_DOWN(XDRAW(1),YDRAW(1)) ! Move pen down to 
                                       ! (XDRAW(1),YDRAW(1)).
      RETURN
C=================================================================
C==   (XP,YP) is outside the plot window.                       ==
C=================================================================
110   XP=X            ! Set previous coordinates to new coordinates.
      YP=Y
      IPENP=IPENC
      IF(NDRAW.LE.0)RETURN !Return if no segment within the window.
      CALL PEN_UP(XDRAW(1),YDRAW(1))   !Pen up to beginning.
      CALL PEN_DOWN(XDRAW(2),YDRAW(2)) !Draw clipped segment.
      RETURN

200   IF(IPENC.NE.20)GO TO 300
C=================================================================
C==   IPENC = 20: Plot a point at (X,Y).                      ==
C=================================================================
      XP=X  ! Set previous coordinates to new coordinates.
      YP=Y
      IPENP=IPENC
C If (X,Y) is in the hardcopy window, plot the point
      IF((X-XMINHP)*(XMAXHP-X).GE.0..AND.
     &    (Y-YMINHP)*(YMAXHP-Y).GE.0.)THEN
        CALL PLOT_POINT(X,Y)
C Otherwise, EDGR records must be encoded here
      ELSE IF(DWGON)THEN
        CALL PUT_DWG(X,Y,3,0)
        CALL PUT_DWG(X,Y,2,0)
      ENDIF
      RETURN

300   IF(IPENC.NE.99)GO TO 400
C=================================================================
C==   IPENC = 99: flush out the plot buffer.                    ==
C=================================================================
      CALL FLUSH_PLOT
      RETURN

400   IF(IPENC.NE.999)GO TO 500 ! Check IPENC.
C=================================================================
C==   IPENC = 999: End the plot, by printing out the            ==
C==                remainder of the plot buffer and setting CLEAR=
C==                to .TRUE..                                   ==
C=================================================================
      CALL END_PLOT ! Terminate the graphics software.
      RETURN

500   IF(IPENC.NE.0)GO TO 1000 ! Check IPENC.
C=================================================================
C==   IPENC = 0: Clear the plot.                                ==
C=================================================================
      CALL CLEAR_PLOT
      RETURN

C=================================================================
C==   Illegal value of IPENC.                                   ==
C=================================================================
1000  WRITE(6,1010)IPEN
1010  FORMAT('***Error*** IPEN =',I5,' is illegal in',
     *       ' call to PLOT_R.')
      RETURN
      END
