      SUBROUTINE PUT_FORMSG(LUN)
C======================================================================C
C                                                                      C
C  PUT_FORMSG                                      F.W. Jones, TRIUMF  C
C                                                                      C
C  Puts out diagnostic messages for the last FORTRAN run-time error.   C
C                                                                      C
C  System messages are written out for each condition or status code   C
C  that resulted from the error.  For example, in the case of an open  C
C  failure on a file, the system messages will usually indicate why    C
C  the file could not be opened.                                       C
C                                                                      C
C  Input:                                                              C
C                                                                      C
C    LUN   Optional argument specifying a logical unit number for      C
C          message output.  If LUN=0 or LUN is omitted, the message    C
C          is put on SYS$OUTPUT.  If LUN>0, the message is put out     C
C          on logical unit LUN.                                        C
C                                                                      C
C  Example:                                                            C
C                                                                      C
C        CHARACTER*10 FOO                                              C
C        FOO=')JUNK'                                                   C
C        OPEN(UNIT=1,FILE=FOO,STATUS='UNKNOWN',IOSTAT=IERR)            C
C        IF(IERR.NE.0)THEN                                             C
C          WRITE(*,*)'Error opening file ',FOO                         C
C          CALL PUT_FORMSG                                             C
C        ENDIF                                                         C
C                                                                      C
C  Produces the following output on SYS$OUTPUT:                        C
C                                                                      C
C    Error opening file )JUNK                                          C
C    %RMS-F-SYN, file specification syntax error                       C
C    %FOR-F-FILNAMSPE, file name specification error                   C
C                                                                      C
C======================================================================C
#ifdef VMS
C Get unit number, if any.
      LUN1=0
      IF(NARGS().GT.0)LUN1=LUN

      CALL ERRSNS(IERR,ISTS,ISTV,IUNIT,ICOND)     !sense the last error
      IF(IERR.EQ.0)RETURN      !no error condition

C Put out the relevant system messages:
      IF(ISTS.NE.0)THEN
        IDUM = NARGSI(2)
        CALL PUT_SYSMSG(ISTS,LUN1)
      ENDIF
      IF(ISTV.NE.0)THEN
        IDUM = NARGSI(2)
        CALL PUT_SYSMSG(ISTV,LUN1)
      ENDIF
      IF(ICOND.NE.0)THEN
        IDUM = NARGSI(2)
        CALL PUT_SYSMSG(ICOND,LUN1)
      ENDIF
#endif
#ifdef unix
      CALL PERROR(' ')
#endif
      RETURN
      END
