      SUBROUTINE READLN(LINE,FIELDS,ITYPE,NFIELD)

C     reqd. KOSTL: routines - CHREAL,FINDC,IGC,MOVEC
C======================================================================
C==   Purpose:  Reads free-formatted fields in LINE and returns with ==
C==             type of each field (integer or floating point, or    ==
C==             character string) and each field's value.            ==
C==                                                                  ==
C==   Input  Parameters:  LINE(132)       (LOGICAL*1)                ==
C==                       NFIELD          (INTEGER*4)                ==
C==                                                                  ==
C==   Output Parameters:  FIELDS(132)     (REAL*4)                   ==
C==                       ITYPE(132)      (INTEGER*4)                ==
C==                       NFIELD          (INTEGER*4)                ==
C==                                                                  ==
C==   Substantially revised by Alan Carruthers, TRIUMF, U.B.C.,      ==
C==   from an earlier anonymous version.                             ==
C==   Revised June 27, 1982.                                         ==
C
C     Modified 21-FEB-95 by FWJ: added %REF's to character literals
C     for Alpha/VMS portability.
C
C==   Parameters:                                                    ==
C==   ----------                                                     ==
C==                                                                  ==
C==   LINE   : Input buffer (length 132) which is scanned for        ==
C==            free-format input fields.  The fields of the input    ==
C==            buffer must be separated by blank(s) or a comma.      ==
C==            Input fields are interpreted as either numeric        ==
C==            (integer or floating point) or character string.      ==
C==            Null fields occur whenever two commas in the input    ==
C==            buffer are adjacent or separated by only blanks.      ==
C==                                                                  ==
C==   NFIELD : On entry, NFIELD specifies the maximum number of      ==
C==            fields to be examined (0 < NFIELD).                   ==
C==            On exit, NFIELD contains the number of fields found   ==
C==            in LINE (this returned value will not exceed the      ==
C==            the value of NFIELD supplied on entry).               ==
C==                                                                  ==
C==            An entirely blank or empty line is interpreted to     ==
C==            have 0 fields.                                        ==
C==                                                                  ==
C==            Note: DO NOT call this routine with the actual        ==
C==                  argument of NFIELD set to an integer constant   ==
C==                  -- use an INTEGER variable for NFIELD!          ==
C==                                                                  ==
C==   ITYPE  : ITYPE(i) indicates the type of the i'th field found   ==
C==            in LINE (for i < = NFIELD).  The field types are      ==
C==            returned as:                                          ==
C==              0  --  null field                                   ==
C==              1  --  character string field                       ==
C==              2  --  integer or floating point field              ==
C==                                                                  ==
C==   FIELDS : FIELD(i) returns the value of the i'th field found    ==
C==            in LINE (for i < = NFIELD).  The value returned       ==
C==            depends on the type of field as follows:              ==
C==                                                                  ==
C==            ITYPE   FIELDS                                        ==
C==            -----   -----------------------------------------     ==
C==              0     returned as 0.0                               ==
C==              1     first four characters of character string     ==
C==                    (if field contains less than four             ==
C==                    characters, string is left justified and      ==
C==                    blank filled on right)                        ==
C==              2     floating point number                         ==
C==            -----   -----------------------------------------     ==
C==                                                                  ==
C==            Note: Since FIELD(i) is a REAL*4 array element,       ==
C==                  a "trick" is needed to interpret it properly    ==
C==                  when ITYPE(i) = 1.  Suppose the actual argument ==
C==                  for FIELDS in the calling routine is array X.   ==
C==                  Then put                                        ==
C==                     REAL*4 X(132)                                ==
C==                     CHARACTER*4 XX(132),STRING                   ==
C==                     EQUIVALENCE (X(1),XX(1))                     ==
C==                     INTEGER*4 arg3(132),arg4                     ==
C==                     LOGICAL*1 arg1(132)                          ==
C==                       .                                          ==
C==                       .                                          ==
C==                       .                                          ==
C==                     CALL READLN(arg1,X,arg3,arg4)                ==
C==                       .                                          ==
C==                       .                                          ==
C==                       .                                          ==
C==                     IF(arg3(i) .EQ. 1) STRING = XX(i)            ==
C==                   where STRING holds the first four characters   ==
C==                   of the i'th field in arg1 (provided arg3(i)    ==
C==                   = 1).                                          ==
C==                                                                  ==
C==   Examples of input line decomposition:                          ==
C==   ------------------------------------                           ==
C==                                                                  ==
C==                          NFIELDS                                 ==
C==   Line                 entry return   ITYPE   FIELDS             ==
C==   ------------------   ----- ------   -----   ----------------   ==
C==   1.3 , 7   asDFty       8     3        2     1.300E00           ==
C==                                         2     7.000E00           ==
C==                                         1     asDF               ==
C==                                                                  ==
C==   GR,T .   ,  , 4       50     5        1     GR                 ==
C==                                         1     T                  ==
C==                                         1     .                  ==
C==                                         0     0.000E00           ==
C==                                         2     4.000E00           ==
C==                                                                  ==
C==       , ,                6     3        0     0.000E00           ==
C==                                         0     0.000E00           ==
C==                                         0     0.000E00           ==
C==                                                                  ==
C==    5.43 E5               5     2        2     5.430E00           ==
C==                                         1     E5                 ==
C==   ------------------   ----- ------   -----   ----------------   ==
C======================================================================
      DIMENSION FIELDS(132)
      BYTE LINE(132)
      BYTE BUFFER(132)
      BYTE LSTR(4)
      EQUIVALENCE (LSTR(1),STRING)
      BYTE BLANK, COMMA     ! modified by J.Chuma, 19Mar97 for g77
      LOGICAL NULL
C      LOGICAL*1 BLANK/' '/, COMMA/','/, NULL
      INTEGER ITYPE(132)

      BLANK = ICHAR(' ')
      COMMA = ICHAR(',')

      IF(NFIELD .LE. 0) RETURN
      NFMAX = NFIELD
      DO 10 I = 1,NFIELD
         FIELDS(I)=0.
         ITYPE(I)=0
 10   CONTINUE
      NFIELD = 0
      IFIND = 0
      NULL = .TRUE.
 20   ISTART = IFIND + 1
      IF(ISTART .GT. 132 )  GO TO 500
C
C======================================================================
C==   Scan line for non-blank character                              ==
C======================================================================
C
#ifdef VMS
      CALL IGC(LINE,132,%REF(' '),1,ISTART,IFIND,*400)
#else
      CALL IGC(LINE,132,' ',1,ISTART,IFIND,*400)
#endif
      IF( LINE(IFIND) .EQ. COMMA )THEN
            IF(NULL) THEN
                  NFIELD = NFIELD + 1
                  ITYPE(NFIELD) = 0
            ELSE
                  NULL = .TRUE.
            END IF
C
      ELSE   ! Field entry found
            NULL = .FALSE.   ! Field is not null
            NFIELD = NFIELD + 1
C
C==         Now scan for delimiter of current field                  ==
#ifdef VMS
            CALL FINDC(LINE,132,%REF(' ,'),2,IFIND,IFIND2,ICH)
#else
            CALL FINDC(LINE,132,' ,',2,IFIND,IFIND2,ICH)
#endif
            IF(IFIND2 .EQ. 0) IFIND2 = 133   ! Entry runs to end of LINE
C
C==         Blank out buffer                                         ==
            DO 50 I = 1,132
               BUFFER(I) = BLANK
 50         CONTINUE
C
C==         Move string in current field into buffer                 ==
            CALL MOVEC(IFIND2-IFIND,LINE(IFIND),BUFFER(1))
C
C======================================================================
C==         Analyze buffer                                           ==
C======================================================================
C
C==         Call CHREAL to try to interpret string as floating-      ==
C==         point number                                             ==
            NREAL = 1
            CALL CHREAL(BUFFER,132,FPOINT,NREAL,*200)
            FIELDS(NFIELD) = FPOINT
            ITYPE(NFIELD) = 2
            GO TO 300
C
C==         Interpret as a string (max 4 characters)                 ==
 200        CONTINUE
C==         Move up to 4 characters into fields                      ==
            NCHAR = IFIND2 - IFIND
            IF(NCHAR .GT. 4) NCHAR = 4
C==         Blank out string                                         ==
            DO 210 I = 1,4
               LSTR(I) = BLANK
 210        CONTINUE
            CALL MOVEC(NCHAR,LINE(IFIND),LSTR)
            FIELDS(NFIELD) = STRING
            ITYPE(NFIELD) = 1
C
 300        IFIND = IFIND2 - 1
      END IF
C
      IF(NFIELD .EQ. NFMAX) RETURN
      GO TO 20
C
C
C======================================================================
C==   No non-blank characters found                                  ==
C======================================================================
 400  IF(ISTART .EQ. 1) RETURN   ! LINE is entirely blank
C
C
C======================================================================
C==   LINE has been completely scanned                               ==
C======================================================================
 500  IF(NULL) THEN
         NFIELD = NFIELD + 1
         ITYPE(NFIELD) = 0
      END IF
      RETURN
      END
