	SUBROUTINE  TERM_WIDTH(IWIDTH,*)
C
C	This subroutine was written to allow the terminal buffer
C	size to be changed while running a fortran program.
C	If the specified buffer width is greater than 80 
C	characters it will set the terminal screen into 132
C	width mode, if the terminal is a VT100. The specified width 
C	must be greater than 10 and less than 255. 
C	From a program all lines greater than 132 characters long 
C	will be truncated on output.
C
C	The alternate return is an error return
C
C       Modified June 17/88 by F. Jones.  Incorrect call to SYS$DASSGN
C       has been corrected and a longword is now used for the channel 
C       number.  Error testing and diagnosis have been added to the
C       system service calls and in the case of errors the alternate 
C       return is taken, except when the channel assign fails.  In this
C       case it is assumed that the calling program is not being run 
C       from a terminal and the normal return is taken.
C
C   Modified by J.Chuma, 20Mar97 for g77
C     basically just reorganizing the lines

#ifdef VMS
	EXTERNAL IO$_SETMODE, IO$_SENSEMODE
C  Modified by J.Chuma, 23Apr97 for Absoft f77 -- change X' to Z'
	CHARACTER*1 ESC /Z'1B'/
	INTEGER*2   ICODE(4)
        INTEGER*4   ICHAN
	INTEGER*4   SYS$ASSIGN, SYS$DASSGN
	INTEGER*4   SYS$QIOW

	IF (IWIDTH .LT. 10) GO TO 1000
	IF (IWIDTH .GE. 255) GO TO 1000

C Assign a channel to the device

	IRET=SYS$ASSIGN( %DESCR('TT:'), ICHAN,,)
        IF(.NOT.IRET) RETURN         ! not a terminal

C Perform sensemode function

	IRET=SYS$QIOW(,%VAL(ICHAN),IO$_SENSEMODE,,,,ICODE,,,,,,)
        IF(.NOT.IRET)THEN
          WRITE(*,*)'TERM_WIDTH: error in sensemode.'
          IDUM = NARGSI(1)
          CALL PUT_SYSMSG(IRET)
          RETURN 1
        ENDIF

C Reassign the terminal width

	ICODE(2) = IWIDTH
	IRET=SYS$QIOW(,%VAL(ICHAN),IO$_SETMODE,,,,ICODE,,,,,,)
        IF(.NOT.IRET)THEN
          WRITE(*,*)'TERM_WIDTH: error in setmode.'
          IDUM = NARGSI(1)
          CALL PUT_SYSMSG(IRET)
          RETURN 1
        ENDIF

	IRET=SYS$DASSGN(%VAL(ICHAN))
        IF(.NOT.IRET)THEN
          WRITE(*,*)'TERM_WIDTH: error deassigning channel',ICHAN
          IDUM = NARGSI(1)
          CALL PUT_SYSMSG(IRET)
          RETURN 1
        ENDIF
#else
      integer iesc /Z'1B'/
      CHARACTER ESC
      equivalence (esc,iesc)
      CHARACTER*20 COMMAND/'stty columns '/

      IF (IWIDTH .LT. 10) GO TO 1000
      IF (IWIDTH .GE. 255) GO TO 1000
      WRITE(COMMAND(15:),100)IWIDTH
  100 FORMAT(I5)
#ifdef g77
      CALL SYSTEM(COMMAND)
#elif gfortran
      CALL SYSTEM(COMMAND)
#else
      ISTAT = SYSTEM(COMMAND)
#endif
#endif

C Do a screen width change if necessary

      IF (IWIDTH .GT. 80) GO TO 155
      PRINT 170, ESC
  170 FORMAT(1X, A1, '[?3l')
      RETURN

  155 PRINT 160, ESC
  160 FORMAT(1X, A1, '[?3h')
      RETURN

 1000 PRINT 180
  180 FORMAT(' ERROR IN LINEWIDTH SPECIFICATION !!')
      RETURN 1
      END
