      SUBROUTINE GROUP_MEM(LGROUP,LMEM)
C
C=====================================================================
C    Returns the GROUP and MEMBER numbers of the user UIC.
C    Refer to P. BENNETT for any problems. NOV 9 1983.
C=====================================================================
C
C    REFERENCE: PAGE 6-10 OF VAX-11 FORTRAN USER'S GUIDE
C    & PAGE 129 OF VAX SYSTEM SERVICES REFERENCE MANUAL.
C  
C    reqd. routines - NONE
C
C    
C   set up implicit data types so that the data types indicate sizes
C
      IMPLICIT INTEGER*2 (W), INTEGER*4 (L)
C
C   Define the symbolic value of the JPI$_GRP and JPI$_MEM identifiers
C
      EXTERNAL JPI$_GRP,JPI$_MEM
C
C   Initialize all static values in the item list
C
      DATA W_LEN1,W_LEN2/4,2/
      DATA W_CODE2 /0/
      DATA L_LENADDR1/0/
C
C   Place the SYS$GETJPI item list in a COMMON block so as to be
C   contiguous.
C
      COMMON/ITEMS03/W_LEN1,W_CODE1,L_ADDR1,L_LENADDR1,
     #                W_LEN2,W_CODE2
C
C   Return the addresses of the various identifiers
C
      W_CODE1= %LOC(JPI$_GRP)
      L_ADDR1= %LOC(LGROUP)
C
C   Perform the system service call
C
      CALL SYS$GETJPI(,,,W_LEN1,,,)
C
C   Get the next address
C
      W_CODE1= %LOC(JPI$_MEM)
      L_ADDR1= %LOC(LMEM)
      CALL SYS$GETJPI(,,,W_LEN1,,,)
      RETURN
      END
