      SUBROUTINE WRITE_PLOT_HOUSTON(LUNW,LUNP,*)
C======================================================================C
C                                                                      C
C  WRITE_PLOT_HOUSTON                              F.W. Jones, TRIUMF  C
C                                                                      C
C  Makes a Houston Instruments plot file on unit LUNP from a work      C
C  file on unit LUNW.                                                  C
C  Both units are assumed to be correctly opened by the caller.        C
C                                                                      C
C======================================================================C
      COMMON/HOUSTONPLOT/HBUFF,NHB,LUNH,AUTOCAD
      CHARACTER*80 HBUFF
      LOGICAL AUTOCAD

      CHARACTER*80 BUFF

      CALL HOUSTON_FLUSH      !flush buffer to work file
      REWIND(UNIT=LUNW,ERR=998)
 
 1000 FORMAT(A)

C Plot file header...

      IF(AUTOCAD)THEN
        WRITE(LUNP,1000,ERR=999)';: EC1  '
        WRITE(LUNP,1000,ERR=999)'U A 8950,6250  '
        WRITE(LUNP,1000,ERR=999)'L0  '
        GO TO 20
      ENDIF

C Reset, select mode 1, home, set origin, unit=0.025mm, pen 1

      WRITE(LUNP,1000,ERR=999)'Z'
      WRITE(LUNP,1000,ERR=999)';:HOAECNP1,'

C Copy workfile to plotfile:

   20 READ(LUNW,2000,END=99)NC,BUFF
 2000 FORMAT(A)         ! modified by J.Chuma, 19Mar97 for g77
      NC = LENSIG( BUFF )
      WRITE(LUNP,1000,ERR=999)BUFF(1:NC)
      GO TO 20

C End of plot file:

   99 IF(AUTOCAD)THEN
        WRITE(LUNP,1000,ERR=999)'U V3  '
        WRITE(LUNP,1000,ERR=999)'A 0,0  '
        RETURN
      ENDIF

C Return pen, home, deselect:

      WRITE(LUNP,1000,ERR=999)'P0,H@'
      RETURN

  998 WRITE(*,*)'Houston plotter work file not found on unit',LUNW
      RETURN 1
  999 WRITE(*,*)'Error writing Houston plot file on unit',LUNP
      IDUM = NARGSI(0)
      CALL PUT_FORMSG
      RETURN 1
      END
