      SUBROUTINE WRITE_HPJET(IOUT,ARRAY,ND1,N1,N2,
     &                       SUPPRESS_NULLS,LASER,*)
C======================================================================C
C                                                                      C
C  WRITE_HPJET                                     F.W. Jones, TRIUMF  C
C                                                                      C
C  Analogue to WRITE_PX.                                               C
C  Writes the Printronix bitmap stored in ARRAY to unit IOUT           C
C  in HP Laserjet or HP Thinkjet format.                               C
C                                                                      C
C  By default, the bitmap is stored in ARRAY in Printronix format,     C
C  with 6 significant bits per byte.  Since the HP printers use        C
C  8 significant bits per byte, each group of 4 bytes from ARRAY       C
C  is compressed into 3 bytes for output to the plot file.             C
C                                                                      C
C  The bitmap in ARRAY consists of N2 lines of N1 bytes, where N1      C
C  is at most 188.  The maximum line length is 188*6=1128 dots.        C
C                                                                      C
C  If SUPPRESS_NULLS is set to .TRUE., any blank dot lines at the      C
C  end of the bitmap will not be sent.                                 C
C                                                                      C
C  Modified June 9/86 by F.W. Jones:  The plot file is now written     C
C  using the IOFAST routines, improving the speed by a factor of 2.    C
C                                                                      C
C  Modified Nov 19/86 by F.W. Jones:  Option added to make bitmap      C
C    file for TeX inclusion, by setting LASER=2.                       C
C  Modified Dec 15/86 by F.W. Jones:  Entry point HPJET_DENSITY added  C
C    to manually set the density (HP Laserjet only).                   C
C  Modified Mar 25/87 by F.W. Jones:  records written to the plot      C
C    file are now variable in length and are automatically truncated   C
C    to remove trailing zeros.  This has been done to reduce the high  C
C    overheads in file space and processing time.  In addition, the    C
C    suppression of trailing blank lines has been made mandatory, and  C
C    the flag SUPPRESS_NULLS is ignored.                               C
C  Modified Jan 19/88 by F. Jones:  This routine has been re-written   C
C    to reflect a change in internal bitmap storage from Printronix    C
C    format (6 significant bits per byte) to HP Laserjet format        C
C    (8 significant bits per byte).                                    C
C  Modified May 15/89 by F.W. Jones:  An additional option LASER=3     C
C    has been added to allow auto-justified TeX output.  Leading       C
C    zeros are suppressed so that the nonzero portion of the image     C
C    starts at the current writing position on the page.  This         C
C    eliminates unwanted margins when placing TeX figures.             C
C                                                                      C
C  Modified 08-MAR-94 by FWJ: removed VMS IOFAST dependency, since     C
C  IOFAST is not available on ALPHA VMS.                               C
C                                                                      C
C  If LASER=0 HP ThinkJet                                              C
C     LASER=1 non-TeX HP LaserJet                                      C
C     LASER=2 TeX inclusion                                            C
C     LASER=3 justified TeX inclusion                                  C
C     LASER=4 non-TeX HP LaserJet appended                             C
C  Modified 1-Feb-95 by J.Chuma:  allow appended plot files            C
C  Modified 11-Apr-1997 by J.Chuma  for g77
C    the bitmap plot file is opened UNFORMATTED since there seem to be
C    linefeeds at the ends of the lines, however, this didn't work
C    to fix the problems, so no other WRITE_xxx.F files were modified
C    the changes were left in, since the preprocessor structure might
C    be useful at a later date.  For now, bitmaps are not useable
C    under g77 linux.
C                                                                      C
C======================================================================C

      BYTE ARRAY(ND1,N2)
      LOGICAL SUPPRESS_NULLS

      COMMON /HARDCOPYRANGE2/ XMINH2,XMAXH2,YMINH2,YMAXH2

      CHARACTER*1 ESC,FF

C Output buffer:

      BYTE LINE(188)
      CHARACTER*188 CLINE
      EQUIVALENCE(LINE,CLINE)

      CHARACTER*3 CNPUT

      LOGICAL AUTO_DENSITY
      CHARACTER*3 DENS
      COMMON /BIT_DENS/ AUTO_DENSITY, DENS
CCC
      ESC=CHAR(27)
      FF=CHAR(12)
      IBITS=INT(YMAXH2)+1  ! Find extent of bitmap data
      JBITS=INT(XMAXH2)+1
      IEND_MAX=IBITS/8
      IF( MOD(IBITS,8).NE.0 )IEND_MAX=IEND_MAX+1
      IEND_MAX=MIN(IEND_MAX,188)      !To avoid buffer overflow
      JEND_MAX=MIN(JBITS,N2)
      DO JEND=JEND_MAX,1,-1
        DO I=1,IEND_MAX
          IF( ARRAY(I,JEND).NE.0 )GO TO 50
        END DO
      END DO
      JEND=1
   50 IBEG=1  ! Normal start of bitmap data
      JBEG=1
      IF( AUTO_DENSITY )THEN
        DENS='100'
        IF( IBITS.GT.750 )DENS='150'
        IF( IBITS.GT.1125 )DENS='300'
      END IF

C Reset, set density, set left margin, start raster graphics

      IF( LASER.EQ.0 )THEN       ! Thinkjet
#ifdef g77
        IF( IBITS.LE.640 )THEN
          WRITE(IOUT,ERR=999)
     &     ESC//'E'//ESC//'*r640S'//ESC//'*rA'
        ELSE
          WRITE(IOUT,ERR=999)
     &     ESC//'E'//ESC//'*r1280S'//ESC//'*rA'
        END IF
#elif gfortran
        IF( IBITS.LE.640 )THEN
          WRITE(IOUT,ERR=999)
     &     ESC//'E'//ESC//'*r640S'//ESC//'*rA'
        ELSE
          WRITE(IOUT,ERR=999)
     &     ESC//'E'//ESC//'*r1280S'//ESC//'*rA'
        END IF
#else
        IF( IBITS.LE.640 )THEN
          WRITE(IOUT,*,ERR=999)
     &     ESC//'E'//ESC//'*r640S'//ESC//'*rA'
        ELSE
          WRITE(IOUT,*,ERR=999)
     &     ESC//'E'//ESC//'*r1280S'//ESC//'*rA'
        END IF
#endif
      ELSE IF( LASER.EQ.1 )THEN  ! non-TeX 
#ifdef g77
        WRITE(IOUT,ERR=999)
     &   ESC//'E'//ESC//'*t'//DENS//'R'//ESC//'&a4C'//ESC//'*r1A'
#elif gfortran
        WRITE(IOUT,ERR=999)
     &   ESC//'E'//ESC//'*t'//DENS//'R'//ESC//'&a4C'//ESC//'*r1A'
#else
        WRITE(IOUT,*,ERR=999)
     &   ESC//'E'//ESC//'*t'//DENS//'R'//ESC//'&a4C'//ESC//'*r1A'
#endif
      ELSE IF( LASER.EQ.2 )THEN  !TeX output -- no reset, no positioning
#ifdef g77
        WRITE(IOUT,ERR=999)ESC//'*t'//DENS//'R'//ESC//'*r1A'
#elif gfortran
        WRITE(IOUT,ERR=999)ESC//'*t'//DENS//'R'//ESC//'*r1A'
#else
        WRITE(IOUT,*,ERR=999)ESC//'*t'//DENS//'R'//ESC//'*r1A'
#endif
      ELSE IF( LASER.EQ.3 )THEN  ! justified TeX output
        IBEG=IEND_MAX            ! Find additional cropping limits
        JBEG=0
        DO 60 J=1,JEND
          DO I=1,IEND_MAX
            IF( ARRAY(I,J).NE.0 )THEN
              IF( JBEG.EQ.0 )JBEG=J
              IBEG=MIN(IBEG,I)
              GO TO 60
            END IF
          END DO
   60   CONTINUE
        IF( JBEG.EQ.0 )JBEG=1
#ifdef g77
        WRITE(IOUT,ERR=999)ESC//'*t'//DENS//'R'//ESC//'*r1A'
#elif gfortran
        WRITE(IOUT,ERR=999)ESC//'*t'//DENS//'R'//ESC//'*r1A'
#else
        WRITE(IOUT,*,ERR=999)ESC//'*t'//DENS//'R'//ESC//'*r1A'
#endif
      ELSE IF( LASER.EQ.4 )THEN       ! non-TeX appended
#ifdef g77
        WRITE(IOUT,ERR=999)
     &   FF//ESC//'*t'//DENS//'R'//ESC//'&a4C'//ESC//'*r1A'
#elif gfortran
        WRITE(IOUT,ERR=999)
     &   FF//ESC//'*t'//DENS//'R'//ESC//'&a4C'//ESC//'*r1A'
#else
        WRITE(IOUT,*,ERR=999)
     &   FF//ESC//'*t'//DENS//'R'//ESC//'&a4C'//ESC//'*r1A'
#endif
      END IF
      DO 100 J=JBEG,JEND
        DO IEND=IEND_MAX,IBEG,-1 ! Find no. bytes from current line
          IF( ARRAY(IEND,J).NE.0 )GO TO 80
        END DO
#ifdef g77
        WRITE(IOUT,ERR=999)ESC//'*b000W'  ! Empty line
#elif gfortran
        WRITE(IOUT,ERR=999)ESC//'*b000W'  ! Empty line
#else
        WRITE(IOUT,*,ERR=999)ESC//'*b000W'  ! Empty line
#endif
        GO TO 100
   80   NPUT=IEND-IBEG+1       ! Fill the output buffer and write it out
        WRITE(CNPUT,85)NPUT    ! For raster data header
   85   FORMAT(I3.3)
        IF( LASER.EQ.3 )THEN
          DO I=1,NPUT
            LINE(I)=ARRAY(IBEG+I-1,J)
          END DO
        ELSE
          DO I=1,NPUT
            LINE(I)=ARRAY(I,J)
          END DO
        END IF
#ifdef g77
        WRITE(IOUT,ERR=999)ESC//'*b'//CNPUT//'W'//CLINE(1:NPUT)
#elif gfortran
        WRITE(IOUT,ERR=999)ESC//'*b'//CNPUT//'W'//CLINE(1:NPUT)
#else
        WRITE(IOUT,*,ERR=999)ESC//'*b'//CNPUT//'W'//CLINE(1:NPUT)
#endif
  100 CONTINUE

C End raster graphics, page eject

#ifdef g77
      WRITE(IOUT,ERR=999)ESC//'*rB'
      IF( (LASER.EQ.2) .OR. (LASER.EQ.3) )
     & WRITE(IOUT,ERR=999)ESC//'*rB' ! fix line-eating bug in DVIHP
#elif gfortran
      WRITE(IOUT,ERR=999)ESC//'*rB'
      IF( (LASER.EQ.2) .OR. (LASER.EQ.3) )
     & WRITE(IOUT,ERR=999)ESC//'*rB' ! fix line-eating bug in DVIHP
#else
      WRITE(IOUT,*,ERR=999)ESC//'*rB'
      IF( (LASER.EQ.2) .OR. (LASER.EQ.3) )
     & WRITE(IOUT,*,ERR=999)ESC//'*rB' ! fix line-eating bug in DVIHP
#endif
      RETURN
  999 WRITE(*,*)'Error writing bitmap file on unit',IOUT
      CALL FORMSG
      RETURN 1
      END

C Entry point to pre-set and inquire about the density

      SUBROUTINE HPJET_DENSITY(DENS_IN)
      CHARACTER*(*) DENS_IN

      LOGICAL AUTO_DENSITY
      CHARACTER*3 DENS
      COMMON /BIT_DENS/ AUTO_DENSITY, DENS

      IF( (DENS_IN.EQ.'100') .OR. (DENS_IN.EQ.'150') .OR.
     &    (DENS_IN.EQ.'300') )THEN
        AUTO_DENSITY=.FALSE.
        DENS=DENS_IN
      ELSE IF( DENS_IN.EQ.'AUT' )THEN
        AUTO_DENSITY=.TRUE.
      ELSE IF( DENS_IN.EQ.'INQ' )THEN      !inquire density
        IF( AUTO_DENSITY )THEN
          DENS_IN='AUT'
        ELSE
          DENS_IN=DENS
        END IF
      END IF
      RETURN
      END
