      SUBROUTINE WRITE_LA100(IOUT,ARRAY,ND1,N1,N2,
     &  SUPPRESS_NULLS,*)
C======================================================================C
C                                                                      C
C  WRITE_LA100                                     F.W. Jones, TRIUMF  C
C                                                                      C
C  *** NOTE: this routine must be compiled with /NOOPTIMIZE ***        C
C                                                                      C
C  Analogue to WRITE_PX.                                               C
C  Writes the Printronix bitmap stored in ARRAY to unit IOUT           C
C  in DEC LA100 graphics format.                                       C
C                                                                      C
C  By default, the bitmap is stored in ARRAY in Printronix format,     C
C  with 6 significant bits per byte.                                   C
C                                                                      C
C  The bitmap in ARRAY consists of N2 lines of N1 bytes, where N1      C
C  is at most 188.  The maximum line length is 188*6=1128 dots.        C
C                                                                      C
C  If SUPPRESS_NULLS is set to .TRUE., any blank dot lines at the      C
C  end of the bitmap will not be sent.                                 C
C                                                                      C
C  132 dots/inch * 8" = 1056 = 176 Printronix bytes                    C
C                       1056 = 132 Laserjet bytes                      C
C                                                                      C
C  Modified Jan 19/88 by F.W. Jones:  this routine has been modified   C
C  to reflect a change in internal bitmap storage from Printronix      C
C  format (6 significant bits per byte) to HP Laserjet format          C
C  (8 significant bits per byte).  Also, trailing lines of zeros are   C
C  now suppressed by default and flag SUPPRESS_NULLS is ignored.       C
C                                                                      C
C======================================================================C
      BYTE ARRAY(ND1,N2)
      LOGICAL SUPPRESS_NULLS
C
      COMMON /HARDCOPYRANGE2/ XMINH2,XMAXH2,YMINH2,YMAXH2
C
      CHARACTER*1 ESC,FF,BACKSLASH
C
C Output buffer:
      BYTE LINE(1056)
CCC
      ESC = CHAR(27)
      FF = CHAR(12)
      BACKSLASH = CHAR(92)

C Find end of data:

      IBITS=INT(YMAXH2)+1
      JBITS=INT(XMAXH2)+1
      IEND=IBITS/8
      IF(MOD(IBITS,8).NE.0)IEND=IEND+1
      IEND=MIN(IEND,132)      !To avoid buffer overflow
C
      JEND_MAX=JBITS
      DO JEND=JEND_MAX,1,-1
        DO I=1,IEND
          IF(ARRAY(I,JEND).NE.0)GO TO 70
        ENDDO
      ENDDO
      JEND=1
C
C Enter LA100 graphics mode:
70    WRITE(IOUT,2000,ERR=999)ESC//'P1q'
2000  FORMAT(1X,A)
C
      NCOL=8*IEND    !# of columns generated
      DO ICOL=1,NCOL
        LINE(ICOL)='77'O      !Offset the line buffer
      ENDDO
C
      IADD=1       !This is 2**wire# for accumulation
      DO J=1,JEND
        DO I=1,IEND
          ITEST=LSWAP(ARRAY(I,J))
          ICOLBASE=1+(I-1)*8      !Base for next 8 columns
          DO IBIT=0,7
            IF(BTEST(ITEST,IBIT))
     &        LINE(ICOLBASE+IBIT)=LINE(ICOLBASE+IBIT)+IADD
          ENDDO
        ENDDO
        IADD=2*IADD
        IF(IADD.EQ.64.OR.J.EQ.JEND)THEN   !Time to write out the buffer
          IADD=1
          WRITE(IOUT,1000,ERR=999)(LINE(ICOL),ICOL=1,NCOL)
          WRITE(IOUT,*,ERR=999)'$-'
          DO ICOL=1,NCOL
            LINE(ICOL)='77'O      !Offset the line buffer
          ENDDO
        ENDIF
      ENDDO
1000  FORMAT(1X,131A1)
C End graphics mode, form feed
      WRITE(IOUT,2000,ERR=999)ESC//BACKSLASH//FF
      RETURN

999   WRITE(*,*)'Error writing LA100 plot file on unit',IOUT
      IDUM=NARGSI(0)
      CALL PUT_FORMSG
      RETURN 1
      END
