      SUBROUTINE WRITE_PT(STRING,LX,LOUT,LECHO)
C=======================================================================
C==   WRITE_PT:  Writes out STRING and beneath it writes a '$' sign   ==
C==              at location LX.                                      ==
C==   LOUT,LECHO: Output units.  If IABS(LOUT)=IABS(LECHO), STRING is ==
C==              written only once.                                   ==
C==              [lunit] < 0 ==> [lunit] is 80-character format       ==
C==              [lunit] > 0 ==> [lunit] is 132-character format      ==
C==              where [lunit] = LOUT, LECHO                          ==
C==                                                                   ==
C==   This routine is to be used in command languages programs when   ==
C==   there is an error somewhere in an input command.  Your program  ==
C==   calculates the position in STRING of the error (LX) and then    ==
C==   calls WRITEPT.                                                  ==
C==                                                                   ==
C==   REQD. KOSTL: ROUTINES - LENSIG                                  ==
C==                                                                   ==
C=======================================================================
      CHARACTER*(*) STRING
      CHARACTER*132 POINTER
      CHARACTER*132 BUFFER
      LOGICAL*1 ALL
      LS=LENSIG(STRING)
      POINTER=' '
      LUNIT=LOUT
      ITIME=1
C=======================================================================
100   ALL=(LX.LE.80).OR.(LX.LE.132.AND.LUNIT.GT.0)
      IUNIT=IABS(LUNIT)
      IF(LX.LE.0.OR.LX.GT.LS+1)THEN
          WRITE(IUNIT,105)LX
105       FORMAT('0WRITE_PT error --- LX =',I6)
          RETURN
      END IF
      MAXLEN=132
      IF(LUNIT.LT.0)MAXLEN=80
      IF(ALL)THEN
         POINTER(LX:LX)='$'
         WRITE(IUNIT,10)STRING(1:MAXLEN)
         WRITE(IUNIT,10)POINTER(1:LX)
      ELSE
C=======================================================================
C==   STRING must be truncated from left                              ==
C=======================================================================
         LSHIFT=LX-MAXLEN+10
         LX2=MAXLEN-5
         BUFFER(1:4)=' ...'
         BUFFER(5:MAXLEN)=STRING(LSHIFT:)
         POINTER(LX2:LX2)='$'
         WRITE(IUNIT,10)BUFFER(1:MAXLEN)
         WRITE(IUNIT,10)POINTER(1:LX2)
      END IF
      ITIME=ITIME+1
      IF(ITIME.GT.2)RETURN
      IF(IABS(LOUT).EQ.IABS(LECHO))RETURN
      LUNIT=LECHO
      GOTO 100
10    FORMAT(' ',A)
      END
